/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.controller;

import cc.lechun.common.AddTypeEnum;
import cc.lechun.common.DistributeTypeEnum;
import cc.lechun.common.PeriodTypeEnum;
import cc.lechun.common.RefTypeEnum;
import cc.lechun.common.UserTypeEnum;
import cc.lechun.common.YesNoEnum;
import cc.lechun.entity.EvalClassEntity;
import cc.lechun.entity.EvalClassUserEntity;
import cc.lechun.entity.EvalClassUserSaveVo;
import cc.lechun.entity.EvalProjectRefEntity;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.login.LoginUtils;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.iservice.EvalClassInterface;
import cc.lechun.iservice.EvalClassUserInterface;
import cc.lechun.iservice.EvalProjectRefInterface;
import cc.lechun.iservice.EvalUserRefInterface;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/eval"})
public class EvalController {
    @Autowired
    private EvalClassInterface evalClassInterface;
    @Autowired
    private EvalClassUserInterface evalClassUserInterface;
    @Autowired
    private EvalProjectRefInterface evalProjectRefInterface;
    @Autowired
    private LoginUtils loginUtils;
    @Autowired
    private EvalUserRefInterface evalUserRefInterface;

    @RequestMapping(value={"/getClassList"})
    public List<EvalClassEntity> getClassList(EvalClassEntity search) {
        if (search.getStatus() == null) {
            search.setStatus(1);
        }
        return this.evalClassInterface.getList(search);
    }

    @RequestMapping(value={"/getClass"})
    public EvalClassEntity getClass(Integer id) {
        if (id == null) {
            return null;
        }
        return (EvalClassEntity)this.evalClassInterface.selectByPrimaryKey(id);
    }

    @RequestMapping(value={"/saveClass"})
    public BaseJsonVo saveClass(EvalClassEntity evalClassEntity) throws AuthorizeException {
        return this.evalClassInterface.saveClass(evalClassEntity);
    }

    @RequestMapping(value={"/deleteClass"})
    public BaseJsonVo deleteClass(Integer id) throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        if (id == null) {
            return BaseJsonVo.success((Object)"\u53c2\u6570\u4e3a\u7a7a");
        }
        EvalClassEntity evalClassEntity = (EvalClassEntity)this.evalClassInterface.selectByPrimaryKey(id);
        if (evalClassEntity == null) {
            return BaseJsonVo.success((Object)"\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        evalClassEntity.setStatus(0);
        evalClassEntity.setUpdateUser(user.getUserId());
        evalClassEntity.setUpdateTime(new Date());
        int i = this.evalClassInterface.updateByPrimaryKeySelective(evalClassEntity);
        if (i == 1) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseJsonVo.success((Object)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/addClassUser"})
    public BaseJsonVo addClassUser(EvalClassUserSaveVo saveVo) throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        if (saveVo == null) {
            return BaseJsonVo.success((Object)"\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.evalClassUserInterface.addUser(saveVo, user.getUserId());
    }

    @RequestMapping(value={"/setClassUserStatus"})
    public BaseJsonVo setClassUserStatus(Integer id, Integer status) throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        return this.evalClassUserInterface.setStatus(id, status, user.getUserId());
    }

    @RequestMapping(value={"/autoAddClassUser"})
    public void autoAddClassUser() {
        this.evalClassUserInterface.autoAddUser();
    }

    @RequestMapping(value={"/getClassUserList"})
    public BaseJsonVo getClassUserList(Integer classId, String userId) {
        EvalClassUserEntity search = new EvalClassUserEntity();
        search.setEvalClassId(classId);
        if (StringUtils.isEmpty((String)userId)) {
            userId = null;
        }
        search.setUserId(userId);
        List lst = this.evalClassUserInterface.getList(search);
        EvalClassUserSaveVo saveVo = new EvalClassUserSaveVo();
        saveVo.setClassId(classId);
        saveVo.setSelectUsers(lst.stream().filter(c -> c.getUserType() == 1).map(EvalClassUserEntity::getUserId).collect(Collectors.toList()));
        saveVo.setSelectDepts(lst.stream().filter(c -> c.getUserType() == 3).map(EvalClassUserEntity::getDeptId).collect(Collectors.toList()));
        return BaseJsonVo.success((Object)saveVo);
    }

    @RequestMapping(value={"/getProjectRefList"})
    public BaseJsonVo getProjectRefList(Integer classId) {
        if (classId == null) {
            throw new RuntimeException("\u53c2\u6570\u4e3a\u7a7a");
        }
        EvalProjectRefEntity search = new EvalProjectRefEntity();
        search.setEvalClassId(classId);
        return BaseJsonVo.success((Object)this.evalProjectRefInterface.getList(search));
    }

    @RequestMapping(value={"/getProjectRef"})
    public BaseJsonVo getProjectRef(Integer id) {
        if (id == null) {
            throw new RuntimeException("\u53c2\u6570\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)this.evalProjectRefInterface.selectByPrimaryKey(id));
    }

    @RequestMapping(value={"/saveProjectRef"})
    public BaseJsonVo saveProjectRef(EvalProjectRefEntity evalProjectRefEntity) throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        if (evalProjectRefEntity.getId() == null) {
            evalProjectRefEntity.setCreateUser(user.getUserId());
            evalProjectRefEntity.setCreateTime(new Date());
        } else {
            evalProjectRefEntity.setUpdateUser(user.getUserId());
            evalProjectRefEntity.setUpdateTime(new Date());
        }
        return this.evalProjectRefInterface.saveProjectRef(evalProjectRefEntity);
    }

    @RequestMapping(value={"/deleteProjectRef"})
    public BaseJsonVo deleteProjectRef(Integer id) throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        if (id == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        this.evalProjectRefInterface.deleteByPrimaryKey(id);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getUserRefUsers"})
    public BaseJsonVo getUserRefUsers(String userId, Integer refType) throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        if (StringUtils.isEmpty((String)userId)) {
            throw new RuntimeException("\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<RefTypeEnum> list = RefTypeEnum.getList();
        if (refType != null && refType != 0) {
            list = list.stream().filter(c -> c.getValue() == refType.intValue()).collect(Collectors.toList());
        }
        for (RefTypeEnum refTypeEnum : list) {
            map.put(refTypeEnum.getName(), this.evalUserRefInterface.getUserRefUsers(userId, refTypeEnum));
        }
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/addUserPeers"})
    public BaseJsonVo addUserPeers(String userId, List<String> refUserIds) throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        if (StringUtils.isEmpty((String)userId)) {
            throw new RuntimeException("\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.evalUserRefInterface.addUserPeers(userId, refUserIds, user.getUserId());
    }

    @RequestMapping(value={"/getEvalDicList"})
    public BaseJsonVo getEvalDicList() {
        HashMap<String, List<Enum>> map = new HashMap<String, List<Enum>>();
        map.put("refType", RefTypeEnum.getList());
        map.put("addType", AddTypeEnum.getList());
        map.put("distributeType", DistributeTypeEnum.getList());
        map.put("periodType", PeriodTypeEnum.getList());
        map.put("userType", UserTypeEnum.getList());
        map.put("yesNoType", YesNoEnum.getList());
        return BaseJsonVo.success(map);
    }
}

