/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.controller;

import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.login.LoginUtils;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.iservice.OaKpiInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="kpi")
public class KpiController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OaKpiInterface kpiInterface;
    @Autowired
    private LoginUtils loginUtils;

    @RequestMapping(value={"myKpi"})
    public BaseJsonVo myKpi() throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        return this.kpiInterface.getMyKpis(user.getUserId());
    }

    @RequestMapping(value={"ensureMyKpi"})
    public BaseJsonVo ensureMyKpi() throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        return this.kpiInterface.getMyKpis(user.getUserId());
    }

    @RequestMapping(value={"subKpis"})
    public BaseJsonVo subKpis() throws AuthorizeException {
        MallUserEntity user = this.loginUtils.getUser();
        return this.kpiInterface.getSubKpis(user.getUserId());
    }

    @RequestMapping(value={"subKpiDetail"})
    public BaseJsonVo subKpiDetail(String userId) {
        return this.kpiInterface.getSubKpis("");
    }

    @RequestMapping(value={"saveKpi"})
    public BaseJsonVo saveKpi(String period, String kpi, String userId) {
        return this.kpiInterface.getSubKpis("");
    }

    @RequestMapping(value={"createEmptyKpi"})
    public BaseJsonVo createEmptyKpi(Integer periodId, String periodName, String userId) {
        return this.kpiInterface.createEmptyKpi(userId, periodId, periodName);
    }
}

