/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.service;

import cc.lechun.dao.EvalClassUserMapper;
import cc.lechun.entity.EvalClassEntity;
import cc.lechun.entity.EvalClassUserEntity;
import cc.lechun.entity.EvalClassUserSaveVo;
import cc.lechun.framework.common.utils.SpringUtil;
import cc.lechun.framework.common.utils.login.LoginUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.iservice.EvalClassInterface;
import cc.lechun.iservice.EvalClassUserInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EvalClassUserService
extends BaseService<EvalClassUserEntity, Integer>
implements EvalClassUserInterface {
    @Resource
    private EvalClassUserMapper evalClassUserMapper;
    @Autowired
    private LoginUtils loginUtils;
    @Autowired
    private EvalClassInterface evalClassInterface;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo addUser(EvalClassUserSaveVo saveVo, String loginUserId) {
        EvalClassUserEntity evalClassUserEntity;
        if (saveVo.getClassId() == null) {
            return BaseJsonVo.error((String)"\u9700\u8981\u9009\u62e9\u5206\u7c7b");
        }
        if (StringUtils.isEmpty((String)loginUserId)) {
            loginUserId = this.loginUtils.getLoginUserId();
        }
        ArrayList<EvalClassUserEntity> lst = new ArrayList<EvalClassUserEntity>();
        if (saveVo.getSelectUsers() != null) {
            for (String string : saveVo.getSelectUsers()) {
                evalClassUserEntity = new EvalClassUserEntity();
                evalClassUserEntity.setEvalClassId(saveVo.getClassId());
                evalClassUserEntity.setStatus(1);
                evalClassUserEntity.setUserType(1);
                evalClassUserEntity.setUserId(string);
                evalClassUserEntity.setCreateUser(loginUserId);
                evalClassUserEntity.setCreateTime(new Date());
                lst.add(evalClassUserEntity);
            }
        }
        if (saveVo.getSelectDepts() != null) {
            for (Integer n : saveVo.getSelectDepts()) {
                evalClassUserEntity = new EvalClassUserEntity();
                evalClassUserEntity.setEvalClassId(saveVo.getClassId());
                evalClassUserEntity.setStatus(1);
                evalClassUserEntity.setUserType(3);
                evalClassUserEntity.setDeptId(n);
                evalClassUserEntity.setCreateUser(loginUserId);
                evalClassUserEntity.setCreateTime(new Date());
                lst.add(evalClassUserEntity);
            }
        }
        EvalClassUserEntity search = new EvalClassUserEntity();
        search.setEvalClassId(saveVo.getClassId());
        this.deleteByEntity(search);
        if (lst.size() > 0) {
            this.batchInsertIgnore(lst);
        }
        return BaseJsonVo.success((Object)"\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    public void autoAddUser() {
        EvalClassEntity search = new EvalClassEntity();
        search.setStatus(1);
        search.setAddType(1);
        List classList = this.evalClassInterface.getList(search);
        for (EvalClassEntity classEntity : classList) {
            ArrayList<String> userIds = new ArrayList<String>();
            EvalClassUserSaveVo saveVo = new EvalClassUserSaveVo();
            saveVo.setClassId(classEntity.getId());
            if (classEntity.getId() == 1) {
                saveVo.setSelectUsers(userIds);
            }
            if (classEntity.getId() == 2) {
                saveVo.setSelectUsers(userIds);
            }
            if (classEntity.getId() == 3) {
                saveVo.setSelectUsers(userIds);
            }
            if (userIds == null || userIds.size() <= 0) continue;
            ((EvalClassUserInterface)SpringUtil.getBean(EvalClassUserInterface.class)).addUser(saveVo, "system");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo setStatus(Integer id, Integer status, String loginUserId) {
        if (id == null) {
            return BaseJsonVo.error((String)"\u9700\u8981\u9009\u62e9\u5206\u7c7b");
        }
        if (status == null) {
            return BaseJsonVo.error((String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EvalClassUserEntity evalClassUserEntity = new EvalClassUserEntity();
        evalClassUserEntity.setId(id);
        evalClassUserEntity.setStatus(status);
        evalClassUserEntity.setUpdateUser(loginUserId);
        evalClassUserEntity.setUpdateTime(new Date());
        this.updateByPrimaryKeySelective(evalClassUserEntity);
        return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @Override
    public List<String> getClassUserList(Integer classId) {
        if (classId == null) {
            return new ArrayList<String>();
        }
        EvalClassUserEntity search = new EvalClassUserEntity();
        search.setEvalClassId(classId);
        search.setStatus(1);
        List lst = this.getList(search);
        List<String> result = lst.stream().filter(c -> c.getUserType() == 1).map(EvalClassUserEntity::getUserId).collect(Collectors.toList());
        for (EvalClassUserEntity entity : lst.stream().filter(c -> c.getUserType() == 3).collect(Collectors.toList())) {
            ArrayList userIds = new ArrayList();
            result.addAll(userIds);
        }
        return result;
    }
}

