/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.service;

import cc.lechun.common.RefTypeEnum;
import cc.lechun.dao.EvalUserRefMapper;
import cc.lechun.entity.EvalUserRefEntity;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.iservice.EvalUserRefInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EvalUserRefService
extends BaseService<EvalUserRefEntity, Integer>
implements EvalUserRefInterface {
    @Resource
    private EvalUserRefMapper evalUserRefMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo addUserPeers(String userId, List<String> refUserIds, String loginUserId) {
        if (StringUtils.isEmpty((String)userId)) {
            return BaseJsonVo.error((String)"user\u53c2\u6570\u4e3a\u7a7a");
        }
        EvalUserRefEntity search = new EvalUserRefEntity();
        search.setUserId(userId);
        search.setRefType(RefTypeEnum.PEERS.getValue());
        this.evalUserRefMapper.deleteByEntity(search);
        if (refUserIds != null && refUserIds.size() > 0) {
            for (String refUserId : refUserIds) {
                EvalUserRefEntity entity = new EvalUserRefEntity();
                entity.setUserId(userId);
                entity.setRefUserId(refUserId);
                entity.setRefType(RefTypeEnum.PEERS.getValue());
                entity.setStatus(1);
                entity.setCreateUser(loginUserId);
                entity.setCreateTime(new Date());
                this.evalUserRefMapper.insert(entity);
            }
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public List<String> getUserRefUsers(String userId, RefTypeEnum refTypeEnum) {
        if (StringUtils.isEmpty((String)userId)) {
            return new ArrayList<String>();
        }
        if (refTypeEnum == null) {
            return new ArrayList<String>();
        }
        if (refTypeEnum == RefTypeEnum.PEERS) {
            EvalUserRefEntity search = new EvalUserRefEntity();
            search.setUserId(userId);
            search.setStatus(1);
            search.setRefType(RefTypeEnum.PEERS.getValue());
            List lst = this.evalUserRefMapper.getList(search);
            return lst.stream().map(EvalUserRefEntity::getRefUserId).collect(Collectors.toList());
        }
        if (refTypeEnum == RefTypeEnum.LEADER) {
            // empty if block
        }
        if (refTypeEnum == RefTypeEnum.SUBORDINATE) {
            // empty if block
        }
        if (refTypeEnum == RefTypeEnum.SELF) {
            ArrayList<String> lst = new ArrayList<String>();
            lst.add(userId);
            return lst;
        }
        return new ArrayList<String>();
    }
}

