/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveQrcodeMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.tempCode.CustomerQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.vo.ActiveQrcodeVo;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.qrcode.QrcodeUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.popular.api.QrcodeAPI;

@Service
public class ActiveQrcodeService
extends BaseService
implements ActiveQrcodeInterface {
    @Autowired
    private ActiveQrcodeMapper activeQrcodeMapper;
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeService;
    @Autowired
    private OssService ossService;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo saveActiveQrcode(ActiveQrcodeEntity activeQrcode) {
        BaseJsonVo result = this.checkeActiveQrCode(activeQrcode);
        ActiveEntity activeEntity = new ActiveEntity();
        if (result.isSuccess()) {
            activeEntity = this.activeService.getActiveEntityByActiveNo(activeQrcode.getActiveNo());
            result = this.activeService.checkActiveEnable(activeEntity);
            if (!result.isSuccess()) {
                return result;
            }
            this.removeCache(activeQrcode, activeEntity);
            if (activeQrcode.getActiveQrcodeId() == null || activeQrcode.getActiveQrcodeId() == 0) {
                activeQrcode.setSceneStr(UUID.randomUUID().toString().replace("-", ""));
                activeQrcode.setCreateTime(DateUtils.now());
                activeQrcode.setBindCode(activeQrcode.getSceneStr());
                if (activeQrcode.getKeywordId() == null) {
                    activeQrcode.setKeywordId(0);
                }
                if (activeQrcode.getShareCount() == null) {
                    activeQrcode.setShareCount(0);
                }
                if (StringUtils.isEmpty((String)activeQrcode.getShareMedia())) {
                    activeQrcode.setShareMedia("");
                }
                if (StringUtils.isEmpty((String)activeQrcode.getUserId())) {
                    activeQrcode.setUserId("");
                }
                String fileName = activeQrcode.getSceneStr() + ".png";
                BaseJsonVo baseJsonVo = new BaseJsonVo();
                switch (activeQrcode.getActiveType()) {
                    case 1: {
                        baseJsonVo = this.generateQrcode4Parameter(activeQrcode, activeEntity);
                        break;
                    }
                    case 2: {
                        baseJsonVo = this.generateQrcode4Normal(activeQrcode, fileName);
                        break;
                    }
                }
                if (!baseJsonVo.isSuccess()) {
                    return baseJsonVo;
                }
                this.activeQrcodeMapper.insert(activeQrcode);
            } else {
                String qrcodeImagUrl = activeQrcode.getQrcodeImageUrl().replace("http://", "").replace("http://", "");
                activeQrcode.setQrcodeImageUrl(activeQrcode.getQrcodeImageUrl().substring(qrcodeImagUrl.indexOf("/")));
                this.activeQrcodeMapper.updateByPrimaryKeySelective(activeQrcode);
            }
        } else {
            return result;
        }
        return result;
    }

    private BaseJsonVo generateQrcode4Normal(ActiveQrcodeEntity activeQrcode, String fileName) {
        String qrcodeImageUrl = AliyunOSSDir.QRCODE_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + fileName;
        activeQrcode.setQrcodeImageUrl(qrcodeImageUrl);
        String web = activeQrcode.getQrcodeUrl();
        if (StringUtils.isEmpty((String)web)) {
            web = "https://wx.lechun.cc";
        }
        String qrCodeUrl = web.indexOf("?") > -1 ? web + "&bindcode=" + activeQrcode.getBindCode() : web + "?bindcode=" + activeQrcode.getBindCode();
        activeQrcode.setQrcodeUrl(qrCodeUrl);
        this.logger.info("\u751f\u6210\u4e8c\u7ef4\u7801\u5f00\u59cb,{}", (Object)activeQrcode.toString());
        try {
            InputStream is = QrcodeUtils.gen((String)qrCodeUrl, (String)activeQrcode.getQrcodeImageUrl(), (int)500, (int)500);
            this.ossService.uploadFile(activeQrcode.getQrcodeImageUrl(), is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u4e8c\u7ef4\u7801\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo generateQrcode4Parameter(ActiveQrcodeEntity activeQrcode, ActiveEntity activeEntity) {
        if (Integer.valueOf(1).equals(activeEntity.getPlatformId())) {
            CustomerQrcodeEntity customerQrcodeEntity = this.customerQrcodeService.getCustomerQrcode4notUsed(293);
            if (customerQrcodeEntity != null) {
                activeQrcode.setSceneStr(customerQrcodeEntity.getSceneStr());
                activeQrcode.setQrcodeImageUrl(customerQrcodeEntity.getQrcodeImageUrl());
                String fileName = activeQrcode.getSceneStr() + ".png";
                String qrCodeUrl = customerQrcodeEntity.getQrcodeUrl();
                String qrcodeImageUrl = AliyunOSSDir.QRCODE_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + fileName;
                activeQrcode.setQrcodeImageUrl(qrcodeImageUrl);
                activeQrcode.setQrcodeUrl(customerQrcodeEntity.getQrcodeUrl());
                try {
                    InputStream is = QrcodeUtils.gen((String)qrCodeUrl, (String)customerQrcodeEntity.getQrcodeUrl(), (int)500, (int)500);
                    this.ossService.uploadFile(activeQrcode.getQrcodeImageUrl(), is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return BaseJsonVo.error((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25");
                }
                this.customerQrcodeService.deleteCustomerQrcodeById(customerQrcodeEntity.getId());
            } else {
                this.logger.info("\u6c38\u4e50\u4e8c\u7ef4\u7801\u5df2\u4f7f\u7528\u5b8c\u6bd5.");
            }
        } else {
            activeQrcode.setSceneStr(activeQrcode.getSceneStr());
            String fileName = activeQrcode.getSceneStr() + ".png";
            String acessToken = this.weiXinBaseService.getWeixinBaseByFlatformId(activeEntity.getPlatformId()).getAccessToken();
            String qrCodeUrl = QrcodeAPI.qrcodeCreateFinal((String)acessToken, (String)activeQrcode.getSceneStr()).getUrl();
            String qrcodeImageUrl = AliyunOSSDir.QRCODE_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + fileName;
            activeQrcode.setQrcodeUrl(qrCodeUrl);
            activeQrcode.setQrcodeImageUrl(qrcodeImageUrl);
            try {
                InputStream is = QrcodeUtils.gen((String)qrCodeUrl, (String)activeQrcode.getQrcodeImageUrl(), (int)500, (int)500);
                this.ossService.uploadFile(activeQrcode.getQrcodeImageUrl(), is);
            }
            catch (Exception e) {
                e.printStackTrace();
                return BaseJsonVo.error((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveQrcodeService.getActiveQrcode")
    public ActiveQrcodeEntity getQrcode(@ParameterValueKeyProvider String bindcode) {
        ActiveQrcodeEntity param = new ActiveQrcodeEntity();
        param.setBindCode(bindcode);
        List list = this.activeQrcodeMapper.getList(param);
        if (list != null && list.size() > 0) {
            return (ActiveQrcodeEntity)list.get(0);
        }
        return null;
    }

    @Override
    public String getDailyCheckInHeadPic(String bindCode) {
        List<MallProductPicEntity> picList = this.picService.getProductPics(bindCode, ProductPicTypeEnum.ACT_HEAD.getValue());
        return picList == null || picList.size() == 0 ? "" : picList.get(0).getFullRelativeUrl();
    }

    @Override
    public String getDailyCheckInPic(String bindCode, int sn) {
        List<MallProductPicEntity> picList = this.picService.getProductPics(bindCode, ProductPicTypeEnum.ACT_DETAILBIG.getValue(), sn);
        return picList == null || picList.size() == 0 ? "" : picList.get(0).getFullRelativeUrl();
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveQrcodeService.getActiveQrcode", expiration=300)
    public ActiveQrcodeEntity getActiveQrcode(@ParameterValueKeyProvider Integer id) {
        return (ActiveQrcodeEntity)this.activeQrcodeMapper.selectByPrimaryKey(id);
    }

    private BaseJsonVo checkeActiveQrCode(ActiveQrcodeEntity activeQrCode) {
        ActiveQrcodeEntity temp;
        if (activeQrCode.getQrcodeName().isEmpty()) {
            return BaseJsonVo.error((String)"\u4e8c\u7ef4\u7801\u540d\u79f0\u4e3a\u7a7a");
        }
        if (activeQrCode.getBindCode() == null || activeQrCode.getActiveQrcodeId() == 0 ? this.checQrcodeName(activeQrCode) : (temp = (ActiveQrcodeEntity)this.activeQrcodeMapper.selectByPrimaryKey(activeQrCode.getActiveQrcodeId())) != null && !activeQrCode.getQrcodeName().equals(temp.getQrcodeName()) && this.checQrcodeName(activeQrCode)) {
            return BaseJsonVo.error((String)"\u4e8c\u7ef4\u7801\u540d\u79f0\u5df2\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)"");
    }

    private boolean checQrcodeName(ActiveQrcodeEntity activeQrCode) {
        ActiveQrcodeEntity temp = new ActiveQrcodeEntity();
        temp.setQrcodeName(activeQrCode.getQrcodeName());
        return this.activeQrcodeMapper.existsByEntity(temp) >= 1;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveQrcodeService.getActiveQrcodeByQrcode")
    public ActiveQrcodeEntity getActiveQrcode(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity activeEntity;
        if (StringUtils.isEmpty((String)bindCode)) {
            this.logger.info("\u67e5\u8be2bindcode\u4e3a\u7a7a");
            return null;
        }
        this.logger.info("bindCode={}", (Object)bindCode);
        if (bindCode.length() < 32 && (activeEntity = this.activeService.getActiveEntityByQrcode(bindCode)) != null) {
            ActiveQrcodeEntity qrcodeEntity = new ActiveQrcodeEntity();
            qrcodeEntity.setActiveNo(activeEntity.getActiveNo());
            qrcodeEntity.setActiveType(1);
            return this.getActiveQrcode(qrcodeEntity);
        }
        return this.activeQrcodeMapper.getActiveQrcodeByQrBindCode(bindCode);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveQrcodeService.getActiveNoQrcode")
    public String getActiveNoQrcode(@ParameterValueKeyProvider String bindCode) {
        ActiveQrcodeEntity activeQrcodeEntity = this.getActiveQrcode(bindCode);
        return activeQrcodeEntity == null ? "" : activeQrcodeEntity.getActiveNo();
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveQrcodeService.getQrcodeList")
    public List<ActiveQrcodeEntity> getQrcodeList(@ParameterValueKeyProvider String bindcode) {
        ArrayList<ActiveQrcodeEntity> list = new ArrayList<ActiveQrcodeEntity>();
        if (StringUtils.isEmpty((String)bindcode)) {
            this.logger.info("\u67e5\u8be2bindcode\u4e3a\u7a7a");
            return list;
        }
        if (bindcode.length() < 32) {
            ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindcode);
            ActiveQrcodeEntity qrcodeEntity = new ActiveQrcodeEntity();
            qrcodeEntity.setActiveNo(activeEntity.getActiveNo());
            return this.activeQrcodeMapper.getList(qrcodeEntity);
        }
        return this.activeQrcodeMapper.getActiveQrcodeListByCode(bindcode);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveQrcodeService.getQrcodeListByActiveNo")
    public List<ActiveQrcodeEntity> getQrcodeListByActiveNo(@ParameterValueKeyProvider String activeNo) {
        ArrayList<ActiveQrcodeEntity> list = new ArrayList<ActiveQrcodeEntity>();
        if (StringUtils.isEmpty((String)activeNo)) {
            this.logger.info("\u67e5\u8be2activeNo\u4e3a\u7a7a");
            return list;
        }
        ActiveQrcodeEntity qrcodeEntity = new ActiveQrcodeEntity();
        qrcodeEntity.setActiveNo(activeNo);
        return this.activeQrcodeMapper.getList(qrcodeEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveQrcodeService.getActiveQrcodeByQrcode")
    public ActiveQrcodeEntity getActiveQrcode(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer activeType) {
        List<ActiveQrcodeEntity> list = this.getQrcodeList(bindCode);
        return list.stream().filter(q -> q.getActiveType().intValue() == activeType.intValue()).findFirst().get();
    }

    @Override
    public ActiveQrcodeEntity getActiveQrcode(ActiveQrcodeEntity qrcodeEntity) {
        return (ActiveQrcodeEntity)this.activeQrcodeMapper.getSingle(qrcodeEntity);
    }

    @Override
    public PageInfo getActiveQrcodeList(ActiveQrcodeVo qrcodeVo) {
        Page page = PageHelper.startPage((int)qrcodeVo.getCurrentPage(), (int)qrcodeVo.getPageSize());
        ActiveQrcodeEntity activeQrcodeEntity = new ActiveQrcodeEntity();
        if (StringUtils.isNotEmpty((String)qrcodeVo.getActiveNo())) {
            activeQrcodeEntity.setActiveNo(qrcodeVo.getActiveNo());
        }
        List<ActiveQrcodeEntity> list = this.activeQrcodeMapper.getActiveQrcodeList(activeQrcodeEntity);
        list.forEach(q -> q.setQrcodeImageUrl(this.ossService.getImageResoure(q.getQrcodeImageUrl())));
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    private void removeCache(ActiveQrcodeEntity activeQrcodeEntity, ActiveEntity activeEntity) {
        if (activeQrcodeEntity != null) {
            this.memcachedService.delete("ActiveQrcodeService.getQrcode", activeQrcodeEntity.getBindCode());
            this.memcachedService.delete("ActiveQrcodeService.getActiveQrcodeByQrcode", new String[]{activeQrcodeEntity.getBindCode(), activeQrcodeEntity.getActiveType() + ""});
            this.memcachedService.delete("ActiveQrcodeService.getQrcodeList", activeQrcodeEntity.getBindCode());
            this.memcachedService.delete("ActiveQrcodeService.getActiveNoQrcode", activeQrcodeEntity.getBindCode());
            this.memcachedService.delete("ActiveQrcodeService.getActiveQrcodeByQrcode", activeQrcodeEntity.getBindCode());
            this.memcachedService.delete("ActiveQrcodeService.getActiveQrcode", activeQrcodeEntity.getBindCode());
            this.memcachedService.delete("ActiveQrcodeService.getQrcodeListByActiveNo", activeQrcodeEntity.getActiveNo());
            this.memcachedService.delete("ActiveService.getActiveEntityByQrcode", activeQrcodeEntity.getBindCode());
            if (activeEntity != null) {
                this.memcachedService.delete("ActiveQrcodeService.getActiveQrcodeByQrcode", activeEntity.getBindCode());
            }
        }
    }
}

