/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.crowd;

import cc.lechun.active.dao.crowd.CrowdCommonConfigMapper;
import cc.lechun.active.dao.crowd.CrowdFundingMapper;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.entity.crowd.CrowdCommonConfigEntity;
import cc.lechun.active.entity.crowd.CrowdCouponVo;
import cc.lechun.active.entity.crowd.CrowdFundingEntity;
import cc.lechun.active.entity.crowd.CrowdInviteVo;
import cc.lechun.active.entity.crowd.InviteCustomerVo;
import cc.lechun.active.entity.crowd.MallCrowdfundingListVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.active.iservice.crowd.CrowdInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrowdService
extends ActiveBaseService
implements CrowdInterface {
    @Autowired
    private CrowdCommonConfigMapper crowdCommonConfigMapper;
    @Autowired
    private CrowdFundingMapper crowdFundingMapper;
    @Autowired
    private ActiveRuleInterface activeRuleInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;

    @Override
    public BaseJsonVo checkCanJoinCrowdActive(String customerId, String activeNo) {
        return null;
    }

    @Override
    public BaseJsonVo getCrowdInfo() {
        CrowdCommonConfigEntity commonConfigEntity = new CrowdCommonConfigEntity();
        List list = this.crowdCommonConfigMapper.getList(commonConfigEntity);
        return list != null && list.size() >= 1 ? BaseJsonVo.success(this.crowdCommonConfigMapper.getList(commonConfigEntity).get(0)) : BaseJsonVo.error((String)"\u65e0\u6548\u7684\u914d\u7f6e");
    }

    @Override
    public BaseJsonVo getCrowdActiveList(Integer page, Integer pageSize, Integer type) {
        return null;
    }

    @Override
    public PageInfo getCrowdProductList(PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.crowdCommonConfigMapper.getCrowdProductList();
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo saveCrowProduct(CrowdFundingEntity crowdFundingEntity) {
        int temp = 0;
        temp = crowdFundingEntity.getId() == null || crowdFundingEntity.getId() == 0 ? this.crowdFundingMapper.insert(crowdFundingEntity) : this.crowdFundingMapper.updateByPrimaryKeySelective(crowdFundingEntity);
        return temp >= 1 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getSelectCrowdProductCouponList(String proId) {
        List<CrowdCouponVo> list = this.crowdCommonConfigMapper.getSelectCrowdProductCouponList(proId);
        return list != null && list.size() >= 1 ? BaseJsonVo.success(list) : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo getAllCrowdProductCouponList() {
        return BaseJsonVo.success(this.crowdCommonConfigMapper.getAllCrowdProductCouponList());
    }

    @Override
    @Transactional
    public BaseJsonVo saveCrowdCouponConfig(String proId, String activeNo, String listCoupon) throws UnsupportedEncodingException {
        String items = URLDecoder.decode(listCoupon, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List list = JsonUtils.getListByArray(CrowdCouponVo.class, (String)items);
        int k = this.crowdCommonConfigMapper.deleteCrowdCoupon(proId);
        ActiveRuleEntity activeRuleEntity = new ActiveRuleEntity();
        activeRuleEntity.setActiveNo(activeNo);
        activeRuleEntity.setProId(proId);
        activeRuleEntity.setCreateTime(DateUtils.now());
        activeRuleEntity.setBindCode(UUID.randomUUID().toString().replace("-", ""));
        ArrayList<ActiveCashticketEntity> list2 = new ArrayList<ActiveCashticketEntity>();
        list.forEach(c -> {
            ActiveCashticketEntity activeCashticketEntity = new ActiveCashticketEntity();
            activeCashticketEntity.setBindCode(activeRuleEntity.getBindCode());
            activeCashticketEntity.setTicketBatchId(c.getBacthId());
            activeCashticketEntity.setTackType(3);
            activeCashticketEntity.setSource(0);
            activeCashticketEntity.setOnlyNewCashticket(0);
            activeCashticketEntity.setCount(1);
            list2.add(activeCashticketEntity);
        });
        this.activeRuleInterface.saveActiveRule(activeRuleEntity, list2);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo sendMessage() {
        return null;
    }

    @Override
    public BaseJsonVo getCrowdInviteList(Integer crowdId, String customerId) {
        CrowdInviteVo crowdInviteVo = new CrowdInviteVo();
        CrowdFundingEntity crowdFundingEntity = (CrowdFundingEntity)this.crowdFundingMapper.selectByPrimaryKey(crowdId);
        this.logger.info(crowdFundingEntity.toString());
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(crowdFundingEntity.getActiveNo());
        crowdInviteVo.setStatus(1);
        if (activeEntity.getStatus() == 0 || activeEntity.getEndTime().before(DateUtils.now())) {
            crowdInviteVo.setStatus(3);
            if (this.getCrowdNum(crowdFundingEntity.getProId(), crowdFundingEntity.getActiveNo(), crowdFundingEntity.getPeopleCount()) >= crowdFundingEntity.getTargerPeople()) {
                crowdInviteVo.setStatus(2);
            }
        }
        Integer total = 0;
        List<InviteCustomerVo> list = this.crowdCommonConfigMapper.getCrowdInvite(crowdFundingEntity.getProId(), customerId, crowdFundingEntity.getActiveNo());
        if (list != null) {
            crowdInviteVo.setInviteList(list);
            total = list.stream().map(InviteCustomerVo::getCrowdAmout).reduce(0, (a, b) -> a + b);
            BigDecimal inviteTotal = new BigDecimal(total).add(new BigDecimal(crowdFundingEntity.getBaseAmount()));
            if (inviteTotal.compareTo(new BigDecimal(crowdFundingEntity.getMaxAmout())) == 1) {
                inviteTotal = new BigDecimal(crowdFundingEntity.getMaxAmout());
            }
            crowdInviteVo.setTotal(inviteTotal);
        }
        crowdInviteVo.setMaxAmout(crowdFundingEntity.getMaxAmout());
        return BaseJsonVo.success((Object)crowdInviteVo);
    }

    @Override
    public Integer getCrowdNum(String proId, String activeNo) {
        return this.crowdCommonConfigMapper.getCrowdNum(proId, activeNo);
    }

    @Override
    public Integer getCrowdNum(String proId, String activeNo, Integer peopleCount) {
        Integer num = this.getCrowdNum(proId, activeNo);
        return num == null ? (peopleCount == null ? 0 : peopleCount) : num + (peopleCount == null ? 0 : peopleCount);
    }

    @Override
    public PageInfo getMyCrowd(String customerId, Integer currentPage, Integer pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<MallCrowdfundingListVo> list = this.crowdCommonConfigMapper.getMyCrowd(customerId);
        PageInfo pg = page.toPageInfo();
        list.forEach(c -> {
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(c.getActivNo());
            if (activeEntity != null) {
                c.setBeginTime(activeEntity.getBeginTime());
                c.setEndTime(activeEntity.getEndTime());
                List<String> pics = this.picService.getProductPicUrl(c.getProId() == null ? "" : c.getProId(), ProductPicTypeEnum.PRO_SAMLL.getValue());
                c.setSmallImages(pics);
                Integer num = this.getCrowdNum(c.getProId(), c.getActivNo(), c.getPeopleCount());
                double scale = MathUtils.mul((Number)MathUtils.div((Double)((Object)num), (Double)Double.valueOf(c.getTargerProple()), (Integer)4), (Number)100);
                c.setPropleScale(scale);
                if (c.getEndTime().before(DateUtils.now()) || activeEntity.getStatus() == 0) {
                    c.setCrowdStatus(3);
                    if (c.getTargerProple() <= num) {
                        c.setCrowdStatus(2);
                    }
                } else {
                    c.setCrowdStatus(1);
                }
                MallProductEntity product = this.mallProductInterface.getProduct(c.getProId());
                String pro_price = "\u96f6\u552e\u4ef7\u00a5" + c.getProPrice() + "/" + product.getProDw();
                if (product.getProPrice1() != null && !"".equals(product.getProPrice1()) && Double.parseDouble(product.getProPrice1()) > 0.0 && !product.getProPrice1().equals(product.getProPrice())) {
                    pro_price = "\u96f6\u552e\u4ef7\u00a5" + product.getProPrice() + "-" + product.getProPrice1() + "/" + product.getProDw();
                }
                c.setProPriceDesc(pro_price);
                c.setProMemo(product.getMemo());
                int surplus_date = CrowdService.getDateDiff(activeEntity.getEndTime());
                c.setSurplusDate(surplus_date);
                c.setJoinPeople(num);
            }
            c.setCrowdJoinCrowdId(c.getCrowdId());
        });
        return pg;
    }

    @Override
    public List<Map<String, Object>> getCrowdOrderList(Integer orderClass, String activeNo, String bindCode, String date) {
        return this.orderMainInterface.getOrderInfo(orderClass, activeNo, bindCode, date);
    }

    @Override
    public BaseJsonVo deleteCrowdCoupon(String proId) {
        Integer id = this.crowdCommonConfigMapper.getCrowdCoupon(proId);
        if (id != null && id > 0) {
            return this.activeCashticketInterface.deleteCouponConfig(id);
        }
        return BaseJsonVo.success((Object)"");
    }

    private static int getDateDiff(Date sdate) {
        Date now = new Date();
        if (now.after(sdate)) {
            return 0;
        }
        int day = 0;
        try {
            day = (int)((sdate.getTime() - now.getTime()) / 86400000L);
        }
        catch (Exception e) {
            return 0;
        }
        return day > 0 ? day + 1 : 1;
    }
}

