/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.api;

import cc.lechun.cms.api.MallOrdersApi;
import cc.lechun.cms.dto.MallOrderRefundDTO;
import cc.lechun.cms.dto.MallOrderRequestParam;
import cc.lechun.cms.dto.OrderDTO;
import cc.lechun.cms.dto.OrderInfoDTO;
import cc.lechun.cms.dto.OrderProductDTO;
import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallRefundMapper;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MallOrdersApiImpl
extends BaseService
implements MallOrdersApi {
    @Autowired
    MallOrderMainInterface orderMainInterface;
    @Autowired
    MallOrderInterface orderInterface;
    @Autowired
    MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    MallGroupInterface groupInterface;
    @Autowired
    MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    MallProductInterface mallProductInterface;
    @Autowired
    private MallRefundMapper mallRefundMapper;

    @RequestMapping(value={"/order/getMallOrders"})
    public BaseJsonVo<PageInfo<OrderDTO>> getMallOrders(MallOrderRequestParam param) {
        if (param == null) {
            param = new MallOrderRequestParam();
        }
        if (param.getEndCreated() == null) {
            param.setEndCreated(DateUtils.now());
        }
        if (param.getStartCreated() == null) {
            param.setStartCreated(DateUtils.getAddDateByDay((Date)param.getEndCreated(), (int)-30));
        }
        if (param.getStartCreated().compareTo(param.getEndCreated()) > 0) {
            return BaseJsonVo.error((String)("\u5f00\u59cb\u65f6\u95f4[" + DateUtils.formatDate((Date)param.getStartCreated(), (String)"") + "]\u4e0d\u80fd\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4[" + DateUtils.formatDate((Date)param.getStartCreated(), (String)"") + "]"));
        }
        if (param.getPage() == null) {
            param.setPage(Integer.valueOf(0));
        }
        PageInfo<Object> orderMainNos = this.orderMainInterface.findMallOrdersExport(param);
        ArrayList orders = new ArrayList();
        orderMainNos.getList().forEach(orderMainNo -> orders.addAll(this.getOrderInfoDetail((String)orderMainNo)));
        orderMainNos.setList(orders);
        this.logger.info("\u3010\u975e\u589e\u91cf\u83b7\u53d6\u5546\u57ce\u8ba2\u5355\u6570\u636e\u3011" + JsonUtils.toJson(orders, (boolean)false));
        return BaseJsonVo.success(orderMainNos);
    }

    private List<OrderDTO> getOrderInfoDetail(String orderMainNo) {
        ArrayList<OrderDTO> orderVOS = new ArrayList<OrderDTO>();
        try {
            this.logger.info("\u3010\u975e\u589e\u91cf\u83b7\u53d6\u5546\u57ce\u8ba2\u5355\u6570\u636e\u3011\u3010\u5f00\u59cb\u3011[" + orderMainNo + "]");
            MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainNo);
            List<MallOrderPayEntity> payEntities = this.mallOrderPayInterface.getList(orderMainNo);
            HashMap<String, Object> payMap = new HashMap<String, Object>();
            payMap.put("wechatAmount", new BigDecimal(0));
            payMap.put("thirdTradeNo", "");
            payMap.put("alipayAmount", new BigDecimal(0));
            payMap.put("couponAmount", new BigDecimal(0));
            payMap.put("cashticketNo", "");
            payMap.put("unionpayAmount", new BigDecimal(0));
            payMap.put("giftChangeAmount", new BigDecimal(0));
            payMap.put("cashAmount", new BigDecimal(0));
            payMap.put("balanceAmount", new BigDecimal(0));
            payMap.put("balanceChargeAmount", new BigDecimal(0));
            payMap.put("balanceFreeAmount", new BigDecimal(0));
            payMap.put("balanceGiftAmount", new BigDecimal(0));
            for (MallOrderPayEntity pay : payEntities) {
                if (pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()) {
                    payMap.put("wechatAmount", pay.getPayamount());
                    payMap.put("thirdTradeNo", pay.getThirdTradeNo());
                    continue;
                }
                if (pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue()) {
                    payMap.put("alipayAmount", pay.getPayamount());
                    payMap.put("thirdTradeNo", pay.getThirdTradeNo());
                    continue;
                }
                if (pay.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()) {
                    payMap.put("couponAmount", pay.getPayamount());
                    payMap.put("cashticketNo", pay.getCashticketNo());
                    continue;
                }
                if (pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue()) {
                    payMap.put("unionpayAmount", pay.getPayamount());
                    continue;
                }
                if (pay.getPaytypeId().intValue() == PayTypeEnum.GIFT_PAY.getValue()) {
                    payMap.put("giftChangeAmount", pay.getPayamount());
                    continue;
                }
                if (pay.getPaytypeId().intValue() == PayTypeEnum.OFFLINE_PAY.getValue()) {
                    payMap.put("cashAmount", pay.getPayamount());
                    continue;
                }
                if (pay.getPaytypeId().intValue() == PayTypeEnum.MILKBANK_PAY.getValue() || pay.getPaytypeId().intValue() != PayTypeEnum.BALANCE_PAY.getValue()) continue;
                if (pay.getPaySubtypeId() == 0) {
                    payMap.put("balanceAmount", PriceUtils.add((BigDecimal)pay.getPayamount(), (BigDecimal)((BigDecimal)payMap.get("balanceAmount"))));
                    continue;
                }
                if (pay.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_CHARGE_PAY.getValue()) {
                    payMap.put("balanceChargeAmount", pay.getPayamount());
                    payMap.put("balanceAmount", PriceUtils.add((BigDecimal)pay.getPayamount(), (BigDecimal)((BigDecimal)payMap.get("balanceAmount"))));
                    continue;
                }
                if (pay.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_GIVE_PAY.getValue()) {
                    payMap.put("balanceFreeAmount", pay.getPayamount());
                    payMap.put("balanceAmount", PriceUtils.add((BigDecimal)pay.getPayamount(), (BigDecimal)((BigDecimal)payMap.get("balanceAmount"))));
                    continue;
                }
                if (pay.getPaySubtypeId().intValue() != PaySubTypeEnum.BALANCE_SUB_GIFTCARD_PAY.getValue()) continue;
                payMap.put("balanceGiftAmount", pay.getPayamount());
                payMap.put("balanceAmount", PriceUtils.add((BigDecimal)pay.getPayamount(), (BigDecimal)((BigDecimal)payMap.get("balanceAmount"))));
            }
            HashMap<String, BigDecimal> orderPayMap = new HashMap<String, BigDecimal>();
            orderPayMap.put("wechatAmount", new BigDecimal(0));
            orderPayMap.put("alipayAmount", new BigDecimal(0));
            orderPayMap.put("couponAmount", new BigDecimal(0));
            orderPayMap.put("balanceAmount", new BigDecimal(0));
            orderPayMap.put("balanceChargeAmount", new BigDecimal(0));
            orderPayMap.put("balanceFreeAmount", new BigDecimal(0));
            orderPayMap.put("balanceGiftAmount", new BigDecimal(0));
            orderPayMap.put("unionpayAmount", new BigDecimal(0));
            orderPayMap.put("giftChangeAmount", new BigDecimal(0));
            orderPayMap.put("cashAmount", new BigDecimal(0));
            for (MallOrderEntity order : orderEntities) {
                String kwAndEdbStoreId;
                String[] kwAndEdbStoreIdArray;
                List<MallOrderGroupProductEntity> productEntities = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(order.getOrderNo());
                if (productEntities == null || productEntities.size() == 0) continue;
                OrderInfoDTO orderInfo = new OrderInfoDTO();
                orderInfo.setOrderMainNo(orderMainNo);
                orderInfo.setOrderNo(order.getOrderNo());
                orderInfo.setConsigneeName(order.getConsigneeName());
                orderInfo.setConsigneePhone(order.getConsigneePhone());
                orderInfo.setConsigneeProvinceName(order.getConsigneeProvincename());
                orderInfo.setConsigneeCityName(order.getConsigneeCityname());
                orderInfo.setConsigneeAreaName(order.getConsigneeAreaname());
                orderInfo.setConsigneeAddr(order.getConsigneeProvincename() + order.getConsigneeCityname() + order.getConsigneeAreaname() + order.getConsigneeAddr());
                orderInfo.setConsigneePostcode(order.getConsigneePostcode());
                orderInfo.setPickupDate(DateUtils.formatDate((Date)order.getPickupTime(), (String)""));
                orderInfo.setStatus(order.getStatus());
                orderInfo.setCreateTime(orderMain.getCreateTime());
                orderInfo.setPayTime(orderMain.getPayTime());
                orderInfo.setTotalAmount(PriceUtils.parse((BigDecimal)order.getTotalAmount()));
                orderInfo.setOrderAmount(PriceUtils.parse((BigDecimal)order.getOrderAmount()));
                orderInfo.setPayAmount(PriceUtils.parse((BigDecimal)order.getPayAmount()));
                orderInfo.setFreight(PriceUtils.parse((BigDecimal)order.getFreight()));
                orderInfo.setKefuRemark(order.getRemark());
                orderInfo.setChannelId(String.valueOf(orderMain.getChannelId()));
                orderInfo.setCustomerId(orderMain.getCustomerId());
                orderInfo.setInvoiceFlag(String.valueOf(orderMain.getInvoiceFlag()));
                orderInfo.setInvoiceTitle(orderMain.getInvoiceTitle());
                orderInfo.setInvoiceContent(orderMain.getInvoiceContent());
                orderInfo.setInvoiceType(String.valueOf(orderMain.getInvoiceType()));
                orderInfo.setRemark(orderMain.getRemark());
                orderInfo.setBuyFlag(String.valueOf(orderMain.getBuyFlag()));
                orderInfo.setDeliverCount(orderMain.getDeliverCount());
                orderInfo.setPsTime(order.getPsTimes());
                orderInfo.setOrderClass(orderMain.getOrderClass());
                if (order != null && StringUtils.isNotEmpty((String)order.getDcId()) && (kwAndEdbStoreIdArray = (kwAndEdbStoreId = order.getDcId()).split("\\|")) != null && kwAndEdbStoreIdArray.length > 1) {
                    orderInfo.setDcId(Integer.valueOf(kwAndEdbStoreIdArray[1]));
                }
                orderInfo.setDeliverName(order.getDeliverName());
                orderInfo.setThirdTradeNo((String)payMap.get("thirdTradeNo"));
                orderInfo.setWechatAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("wechatAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setAlipayAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("alipayAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setCouponAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("couponAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setBalanceAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("balanceAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setBalanceChargeAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("balanceChargeAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setBalanceFreeAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("balanceFreeAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setBalanceGiftAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("balanceGiftAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setUnionpayAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("unionpayAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setGiftChangeAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("giftChangeAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setCashAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("cashAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                orderInfo.setCashticketNo((String)payMap.get("cashticketNo"));
                HashMap<String, BigDecimal> productPayMap = new HashMap<String, BigDecimal>();
                productPayMap.put("orderAmount", new BigDecimal(0));
                productPayMap.put("freightAmount", new BigDecimal(0));
                productPayMap.put("wechatAmount", new BigDecimal(0));
                productPayMap.put("alipayAmount", new BigDecimal(0));
                productPayMap.put("balanceAmount", new BigDecimal(0));
                productPayMap.put("balanceChargeAmount", new BigDecimal(0));
                productPayMap.put("balanceFreeAmount", new BigDecimal(0));
                productPayMap.put("balanceGiftAmount", new BigDecimal(0));
                productPayMap.put("unionpayAmount", new BigDecimal(0));
                productPayMap.put("giftChangeAmount", new BigDecimal(0));
                productPayMap.put("cashAmount", new BigDecimal(0));
                productPayMap.put("couponAmount", new BigDecimal(0));
                ArrayList<OrderProductDTO> productVOS = new ArrayList<OrderProductDTO>();
                HashMap<String, String> remark = new HashMap<String, String>();
                for (MallOrderGroupProductEntity mallOrderGroupProductEntity : productEntities) {
                    OrderProductDTO orderProduct = new OrderProductDTO();
                    orderProduct.setOrderMainId(orderMainNo);
                    orderProduct.setOrderId(order.getOrderNo());
                    if (StringUtils.isNotEmpty((String)mallOrderGroupProductEntity.getGroupId()) && !"0".equals(mallOrderGroupProductEntity.getGroupId())) {
                        orderProduct.setGroupId(mallOrderGroupProductEntity.getGroupId());
                        orderProduct.setGroupName(this.groupInterface.getGroup(mallOrderGroupProductEntity.getGroupId()).getGroupName());
                    }
                    MallProductEntity pro = this.mallProductInterface.getProduct(mallOrderGroupProductEntity.getProductId());
                    orderProduct.setBarCode(pro.getBarCode());
                    orderProduct.setProductName(mallOrderGroupProductEntity.getProductName());
                    orderProduct.setQuantity(mallOrderGroupProductEntity.getQuantity());
                    orderProduct.setUnitPrice(PriceUtils.parse((BigDecimal)mallOrderGroupProductEntity.getUnitPrice()));
                    orderProduct.setTotalPrice(PriceUtils.parse((BigDecimal)order.getTotalAmount().multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    orderProduct.setTotalAmount(PriceUtils.parse((BigDecimal)order.getPayAmount().subtract(order.getFreight()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    orderProduct.setOrderPerAmount(PriceUtils.parse((BigDecimal)order.getOrderAmount().multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("orderAmount", ((BigDecimal)productPayMap.get("orderAmount")).add(new BigDecimal(orderProduct.getOrderPerAmount())));
                    orderProduct.setFreightPerAmount(PriceUtils.parse((BigDecimal)order.getFreight().multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("freightAmount", ((BigDecimal)productPayMap.get("freightAmount")).add(new BigDecimal(orderProduct.getFreightPerAmount())));
                    orderProduct.setWechatPerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getWechatAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("wechatAmount", ((BigDecimal)productPayMap.get("wechatAmount")).add(new BigDecimal(orderProduct.getWechatPerAmount())));
                    orderProduct.setAlipayPerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getAlipayAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("alipayAmount", ((BigDecimal)productPayMap.get("alipayAmount")).add(new BigDecimal(orderProduct.getAlipayPerAmount())));
                    orderProduct.setCouponPerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getCouponAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("couponAmount", ((BigDecimal)productPayMap.get("couponAmount")).add(new BigDecimal(orderProduct.getCouponPerAmount())));
                    orderProduct.setBalancePerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getBalanceAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("balanceAmount", ((BigDecimal)productPayMap.get("balanceAmount")).add(new BigDecimal(orderProduct.getBalancePerAmount())));
                    orderProduct.setBalanceChargePerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getBalanceChargeAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("balanceChargeAmount", ((BigDecimal)productPayMap.get("balanceChargeAmount")).add(new BigDecimal(orderProduct.getBalanceChargePerAmount())));
                    orderProduct.setBalanceFreePerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getBalanceFreeAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("balanceFreeAmount", ((BigDecimal)productPayMap.get("balanceFreeAmount")).add(new BigDecimal(orderProduct.getBalanceFreePerAmount())));
                    orderProduct.setBalanceGiftPerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getBalanceGiftAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("balanceGiftAmount", ((BigDecimal)productPayMap.get("balanceGiftAmount")).add(new BigDecimal(orderProduct.getBalanceGiftPerAmount())));
                    orderProduct.setUnionpayPerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getUnionpayAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("unionpayAmount", ((BigDecimal)productPayMap.get("unionpayAmount")).add(new BigDecimal(orderProduct.getUnionpayPerAmount())));
                    orderProduct.setGiftChangePerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getGiftChangeAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("giftChangeAmount", ((BigDecimal)productPayMap.get("giftChangeAmount")).add(new BigDecimal(orderProduct.getGiftChangePerAmount())));
                    orderProduct.setCashPerAmount(PriceUtils.parse((BigDecimal)new BigDecimal(orderInfo.getCashAmount()).multiply(mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    productPayMap.put("cashAmount", ((BigDecimal)productPayMap.get("cashAmount")).add(new BigDecimal(orderProduct.getCashPerAmount())));
                    if (StringUtils.isNotEmpty((String)orderProduct.getGroupName())) {
                        remark.put(orderProduct.getGroupName(), (StringUtils.isEmpty((String)((String)remark.get(orderProduct.getGroupName()))) ? "" : (String)remark.get(orderProduct.getGroupName())) + pro.getProNameSx() + "X" + orderProduct.getQuantity() + ";");
                    }
                    productVOS.add(orderProduct);
                }
                StringBuilder remarkString = new StringBuilder();
                for (String groupName : remark.keySet()) {
                    remarkString.append("\u300c").append(groupName).append(":").append((String)remark.get(groupName)).append("\u300d");
                }
                orderInfo.setRemark(remarkString.toString());
                OrderDTO orderDTO = new OrderDTO();
                orderDTO.setOrderInfo(orderInfo);
                orderDTO.setProduct_item(productVOS);
                BigDecimal proTotalPrice = productVOS.stream().map(productVo -> new BigDecimal(productVo.getUnitPrice()).multiply(new BigDecimal(productVo.getQuantity()))).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proTotalPrice.compareTo(new BigDecimal(orderInfo.getOrderAmount())) != 0) {
                    BigDecimal chajiaPrice = new BigDecimal(orderInfo.getOrderAmount()).subtract(proTotalPrice);
                    BigDecimal perChajia = chajiaPrice.divide(new BigDecimal(((OrderProductDTO)productVOS.get(productVOS.size() - 1)).getQuantity()), 6, 4);
                    ((OrderProductDTO)productVOS.get(productVOS.size() - 1)).setUnitPrice(new BigDecimal(((OrderProductDTO)productVOS.get(productVOS.size() - 1)).getUnitPrice()).add(perChajia).setScale(6).toString());
                    ((OrderProductDTO)productVOS.get(productVOS.size() - 1)).setTotalPrice(new BigDecimal(((OrderProductDTO)productVOS.get(productVOS.size() - 1)).getTotalPrice()).add(chajiaPrice).setScale(6).toString());
                }
                orderVOS.add(orderDTO);
            }
            this.logger.info("\u3010\u975e\u589e\u91cf\u83b7\u53d6\u5546\u57ce\u8ba2\u5355\u6570\u636e\u3011\u3010\u6784\u5efa\u5b8c\u6210\u3011[" + orderMainNo + "] \u5b50\u8ba2\u5355\u4e2a\u6570\uff1a" + orderVOS.size());
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u8ba2\u5355\u65f6\u51fa\u9519" + orderMainNo, (Throwable)e);
        }
        return orderVOS;
    }

    @RequestMapping(value={"/order/getMallOrderRefund"})
    public BaseJsonVo<List<MallOrderRefundDTO>> getMallOrderRefund(int pageNum, MallOrderRefundDTO dto) {
        Page page = PageHelper.startPage((int)pageNum, (int)100);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        List<Object> mallOrderRefundDTOList = new ArrayList();
        mallOrderRefundDTOList = this.mallRefundMapper.getMallOrderRefund(dto);
        PageInfo pg = page.toPageInfo();
        pg.setList(mallOrderRefundDTOList);
        baseJsonVo.setValue((Object)pg);
        return baseJsonVo;
    }
}

