/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallDeliverFreightMapper;
import cc.lechun.mall.entity.deliver.DeliverFreightVo;
import cc.lechun.mall.entity.deliver.MallDeliverFreightEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.iservice.deliver.DeliverFreightInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliverFreightService
extends BaseService
implements DeliverFreightInterface {
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallDeliverFreightMapper deliverFreightMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="getDeliverFreightByKey", expiration=300)
    public List<MallDeliverFreightEntity> getDeliverFreightList(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) int dicKey) {
        MallDeliverFreightEntity deliverFreightEntity = new MallDeliverFreightEntity();
        deliverFreightEntity.setPlatformGroupId(platformGroupId);
        deliverFreightEntity.setDictionaryKey(dicKey);
        deliverFreightEntity.setStatus(1);
        return this.deliverFreightMapper.getList(deliverFreightEntity);
    }

    @Override
    public BigDecimal getDeliverFreight(DeliverFreightVo deliverFreightVo) {
        BigDecimal[] rtn = new BigDecimal[]{new BigDecimal(0)};
        PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(deliverFreightVo.getPlatFormId());
        if (platFormEntity == null) {
            return rtn[0];
        }
        if (deliverFreightVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK.getValue() || deliverFreightVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue()) {
            return rtn[0];
        }
        List<DictionaryEntity> dictionaryEntityList = this.dictionaryInterface.getValidDictionaryList(platFormEntity.getPlatformGroupId(), 9);
        if (dictionaryEntityList != null && dictionaryEntityList.size() > 0) {
            dictionaryEntityList.forEach(c -> {
                if (c.getStatus() == 1) {
                    int dicKey = Integer.parseInt(c.getDictionaryKey());
                    List<MallDeliverFreightEntity> deliverFreightEntities = this.getDeliverFreightList(platFormEntity.getPlatformGroupId(), dicKey);
                    if (deliverFreightEntities != null && deliverFreightEntities.size() > 0) {
                        deliverFreightEntities.forEach(d -> {
                            if ((dicKey == 1 || dicKey == 3) && d.getCitys().indexOf(String.valueOf(deliverFreightVo.getCityId())) >= 0 && deliverFreightVo.getAmount().doubleValue() > 0.0 && deliverFreightVo.getAmount().doubleValue() >= d.getBeginAmount().doubleValue() && deliverFreightVo.getAmount().doubleValue() < d.getEndAmount().doubleValue()) {
                                BigDecimal bigDecimal = rtn[0] = d.getFreight().doubleValue() < 0.0 ? rtn[0] : d.getFreight();
                            }
                            if ((dicKey == 2 || dicKey == 4) && deliverFreightVo.getAmount().doubleValue() > 0.0 && deliverFreightVo.getAmount().doubleValue() >= d.getBeginAmount().doubleValue() && deliverFreightVo.getAmount().doubleValue() < d.getEndAmount().doubleValue()) {
                                rtn[0] = d.getFreight().doubleValue() < 0.0 ? rtn[0] : d.getFreight();
                            }
                        });
                    }
                }
            });
        }
        return rtn[0];
    }

    private void removeCache(int DeliverFreightId, int dicKey) {
        this.memcachedService.delete("getDeliverFreightByKey", dicKey + "");
    }
}

