/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.framework.common.utils.http.HttpUtil;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class kuaidi100Service
implements DeliverKuaidiInterface {
    private String pullUrl = "https://poll.kuaidi100.com/poll";
    private String searchUrl = "https://poll.kuaidi100.com/poll/query.do";
    private String key = "wDNFmwlJ1465";
    private String customer = "4919BADE23569BF8BBAFB734F5B7DC47";
    @Value(value="${kuaidi.callbackurl}")
    private String rollBackUrl;

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        String param = "{\"com\":\"" + deliverCode + "\",\"num\":\"" + wayBillNo + "\",\"phone\":\"" + phone + "\"}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("customer", this.customer);
        map.put("sign", MD5.sign((String)(param + this.key + this.customer)).toUpperCase());
        map.put("param", param);
        String result = HttpUtil.doPost((String)this.searchUrl, map);
        try {
            HashedMap r = (HashedMap)JsonUtils.fromJson((String)result, HashedMap.class);
            if (r.get((Object)"status") != null && r.get((Object)"status").toString().equals("200")) {
                MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                expressEntity.setDeliverNo(deliverCode);
                expressEntity.setCreateTime(new Date());
                expressEntity.setData(JsonUtils.toJson((Object)r.get((Object)"data"), (boolean)false));
                expressEntity.setExpressNo(wayBillNo);
                expressEntity.setLastTime(new Date());
                expressEntity.setIsSubscribe(0);
                expressEntity.setStatus(Integer.parseInt(r.get((Object)"state").toString()));
                return expressEntity;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        if (this.rollBackUrl == null || this.rollBackUrl.isEmpty()) {
            this.rollBackUrl = "https://mallapi.lechun.cc/express/kuaidi100CallBack";
        }
        String param = "{\"company\":\"" + deliverCode + "\",\"number\":\"" + wayBillNo + "\",\"key\":\"" + this.key + "\",\"parameters\":{\"callbackurl\":\"" + this.rollBackUrl + "\",\"phone\":\"" + phone + "\"}}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("schema", "JSON");
        map.put("param", param);
        String result = HttpUtil.doPost((String)this.pullUrl, map);
        try {
            HashedMap r = (HashedMap)JsonUtils.fromJson((String)result, HashedMap.class);
            MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
            expressEntity.setDeliverNo(deliverCode);
            expressEntity.setSubscribeCode(r.get((Object)"returnCode").toString());
            expressEntity.setCreateTime(new Date());
            if (expressEntity.getSubscribeCode().equals("500") || expressEntity.getSubscribeCode().equals("600") || expressEntity.getSubscribeCode().equals("601")) {
                expressEntity.setIsSubscribe(0);
            } else {
                expressEntity.setIsSubscribe(1);
            }
            expressEntity.setExpressNo(wayBillNo);
            return expressEntity;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String thirdExpressNo, String param) {
        try {
            HashedMap map1 = (HashedMap)JsonUtils.fromJson((String)param, HashedMap.class);
            LinkedHashMap map = (LinkedHashMap)map1.get((Object)"lastResult");
            String deliverNo = map.get("com").toString();
            String expressNo = map.get("nu").toString();
            String data = JsonUtils.toJson(map.get("data"), (boolean)false);
            Integer state = Integer.parseInt(map.get("state").toString());
            MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
            expressEntity.setCreateTime(new Date());
            expressEntity.setExpressNo(expressNo);
            expressEntity.setDeliverNo(deliverNo);
            expressEntity.setStatus(state);
            expressEntity.setIsSubscribe(1);
            expressEntity.setSubscribeCode("200");
            expressEntity.setLastTime(new Date());
            expressEntity.setData(data);
            return expressEntity;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

