/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.vo.ActiveCashticketMessageVo;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.jms.MessageQueueInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="sendActiveCashTicket")
public class ActiveCashSendListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private CustomerInterface customerService;

    @Override
    public boolean receive(Message message, ConsumeContext context) {
        try {
            this.log.info("\u6d88\u606f\u961f\u5217\u53d1\u9001\u4f18\u60e0\u52b5 \u63a5\u6536\u6d88\u606f:");
            ActiveCashticketMessageVo vo = (ActiveCashticketMessageVo)ObjectConvert.toObject((byte[])message.getBody());
            this.log.info("\u6d88\u606f\u961f\u5217\u53d1\u9001\u4f18\u60e0\u52b5 \u63a5\u6536\u6d88\u606f:" + vo.toString());
            if (StringUtils.isEmpty((String)vo.getUserId())) {
                CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(vo.getOpenId(), vo.getPlatFormId());
                if (customerDetailVo == null) {
                    this.log.error("\u7528\u6237\u4e0d\u5b58\u5728,oppenId=" + vo.getOpenId());
                    return true;
                }
                vo.setUserId(customerDetailVo.getCustomerId());
            }
            BaseJsonVo baseJsonVo = this.activeCashticketService.sendTicket4Base(vo.getUserId(), vo.getBindCode(), vo.getVersionDetailId(), vo.getPlatFormId(), vo.isSendMessage());
            this.log.info("\u6d88\u606f\u961f\u5217\u53d1\u9001\u4f18\u60e0\u52b5\u53d1\u653e:" + baseJsonVo.isSuccess());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u53d1\u9001\u4f18\u60e0\u52b5\u5904\u7406\u5931\u8d25" + message.getMsgID(), (Throwable)e);
        }
        return true;
    }
}

