/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.iservice.jms.MessageQueueInterface;
import cc.lechun.mall.service.cashticket.CashticketCustomerService;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="takedCash")
public class CashCustomerListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CashticketCustomerService cashticketCustomerService;

    @Override
    public boolean receive(Message message, ConsumeContext context) {
        this.log.info("\u5f00\u59cb\u5199\u5165\u7528\u6237\u9886\u53d6\u4f18\u60e0\u5238\u8bb0\u5f55...");
        try {
            Map messageBody = (Map)ObjectConvert.toObject((byte[])message.getBody());
            CashticketBatchEntity cashticketBatch = (CashticketBatchEntity)messageBody.get("cashticketBatch");
            CashticketCustomerEntity cashticketCustomerEntity = (CashticketCustomerEntity)messageBody.get("cashticketCustomer");
            Integer platformId = (Integer)messageBody.get("platformId");
            String openId = (String)messageBody.get("openId");
            double amount = (Double)messageBody.get("amount");
            boolean sendMessage = (Boolean)messageBody.get("sendMessage");
            return this.cashticketCustomerService.insertCashticketCustomer(cashticketBatch, cashticketCustomerEntity, amount, platformId, openId, sendMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

