/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.jms.MessageQueueInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pushTempQrcode")
public class PushTempQrcodeListener
implements MessageQueueInterface {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerQrcodeInterface customerQrcodeInterface;

    @Override
    public boolean receive(Message message, ConsumeContext consumeContext) {
        this.log.info("\u63a5\u53d7\u4e34\u65f6\u4e8c\u7ef4\u7801\u6d88\u606f...");
        try {
            Map messageBody = (Map)ObjectConvert.toObject((byte[])message.getBody());
            CustomerDetailVo customerDetailVo = new CustomerDetailVo();
            customerDetailVo.setPlatformId(Integer.parseInt(messageBody.get("platformId").toString()));
            customerDetailVo.setCustomerId(messageBody.get("customerId").toString());
            customerDetailVo.setOpenId(messageBody.get("openId").toString());
            customerDetailVo.setNickName(messageBody.get("nickName").toString());
            String activeNo = messageBody.get("activeNo").toString();
            return this.customerQrcodeInterface.pushMessage(customerDetailVo, activeNo, (Integer)Integer.parseInt(messageBody.get("platformId").toString())).isSuccess();
        }
        catch (Exception e) {
            this.log.error("\u4e34\u65f6\u4e8c\u7ef4\u7801\u6d88\u606f{}\u5904\u7406\u5931\u8d25{}", (Object)message.getMsgID(), (Object)e);
            e.printStackTrace();
            return true;
        }
    }
}

