/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay.balancepay;

import cc.lechun.framework.common.enums.pay.PayStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.pay.WechatRefundReturnEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.service.pay.PayStrategyInterface;
import java.math.BigDecimal;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="balancePay")
public class BalancePayService
extends BaseService
implements PayStrategyInterface {
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;

    @Override
    public BaseJsonVo pay(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        CustomerEntity customerEntity = this.customerInterface.getCustomer(inputEntity.getCustomerId());
        if (customerEntity == null) {
            result.setError("\u7528\u6237\u4e0d\u5b58\u5728");
            return result;
        }
        MallOrderPayEntity mallOrderPayEntity = this.orderPayInterface.getSingleOrderPayByTradeNo(inputEntity.getTradeNo());
        if (mallOrderPayEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (mallOrderPayEntity.getIssuccess().intValue() == PayStatusEnum.PAY_SUCCESS.getValue()) {
            result.setError("\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
            return result;
        }
        result = this.accountBalanceInterface.useGiftBalance(customerEntity.getCustomerId(), inputEntity.getOrderMainNo(), inputEntity.getPayAmount());
        if (result.isSuccess()) {
            Map wealth = (Map)result.getValue();
            BigDecimal store = new BigDecimal(wealth.get("store").toString());
            BigDecimal present = new BigDecimal(wealth.get("present").toString());
            BigDecimal card = new BigDecimal(wealth.get("card").toString());
            if (PriceUtils.add((BigDecimal)store, (BigDecimal)present).add(card).compareTo(new BigDecimal(0)) == 0) {
                present = inputEntity.getPayAmount();
            }
            PayOutputEntity payOutputEntity = new PayOutputEntity();
            payOutputEntity.setSendContent(result.getMessage());
            payOutputEntity.setSendUrl(result.getMessage());
            payOutputEntity.setReturnContent(result.getMessage());
            if (PriceUtils.add((BigDecimal)store, (BigDecimal)present).add(card).compareTo(PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100)) != 0) {
                result.setError("\u4f59\u989d\u6682\u65f6\u4e0d\u53ef\u7528,\u91d1\u989d\u4e0d\u4e00\u81f4");
                return result;
            }
            payOutputEntity.setOrderMainNo(mallOrderPayEntity.getOrderMainNo());
            payOutputEntity.setStatus(PayStatusEnum.PAY_SUCCESS.getValue());
            payOutputEntity.setPayTypeId(inputEntity.getPayType());
            payOutputEntity.setPayTypeSubId(inputEntity.getPaySubType());
            payOutputEntity.setPayId(mallOrderPayEntity.getPayId());
            payOutputEntity.setWealth(wealth);
            result.setValue((Object)payOutputEntity);
        }
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(T notifyInputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(Map<String, Object> map) {
        return null;
    }

    @Override
    public BaseJsonVo paySearch(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        return result;
    }

    @Override
    public BaseJsonVo payClose(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        if (inputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        CustomerEntity customerEntity = this.customerInterface.getCustomer(inputEntity.getCustomerId());
        if (customerEntity == null) {
            result.setError("\u7528\u6237\u4e0d\u5b58\u5728");
            return result;
        }
        if (inputEntity.isSuccess() && (result = this.accountBalanceInterface.cancelGiftBalance(customerEntity.getCustomerId(), inputEntity.getOrderMainNo(), inputEntity.getPayAmount())).isSuccess()) {
            MallOrderPayEntity mallOrderPayEntity = new MallOrderPayEntity();
            mallOrderPayEntity.setSuccessTime(DateUtils.now());
            mallOrderPayEntity.setIssuccess(0);
            mallOrderPayEntity.setPayId(inputEntity.getPayId());
            if (this.orderPayInterface.updateByPrimaryKey(mallOrderPayEntity)) {
                // empty if block
            }
        }
        return result;
    }

    @Override
    public BaseJsonVo payRefund(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        this.logger.info(">>>>>>>>" + JsonUtils.toJson((Object)inputEntity, (boolean)true));
        CustomerEntity customerEntity = this.customerInterface.getCustomer(inputEntity.getCustomerId());
        this.logger.info(">>>>>>>>" + customerEntity);
        if (customerEntity == null) {
            result.setError("\u7528\u6237\u4e0d\u5b58\u5728");
            return result;
        }
        MallOrderPayEntity mallOrderPayEntity = this.orderPayInterface.getSingleOrderPayByTradeNo(inputEntity.getTradeNo());
        if (mallOrderPayEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        result = this.accountBalanceInterface.refundOrder(inputEntity, "edb");
        if (result.isSuccess()) {
            WechatRefundReturnEntity wechatRefundReturnEntity = new WechatRefundReturnEntity();
            wechatRefundReturnEntity.setRefundFee(inputEntity.getRefundAmount().toString());
            wechatRefundReturnEntity.setThirdRefundId("");
            result.setValue((Object)wechatRefundReturnEntity);
        }
        return result;
    }

    @Override
    public <T> BaseJsonVo refundNotify(T notifyInputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        return result;
    }
}

