/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.platform;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.mall.dao.platform.PlatFormMapper;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatFormService
implements PlatFormInterface {
    private static final Logger log = LoggerFactory.getLogger(PlatFormService.class);
    @Autowired
    private PlatFormMapper platFormMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @WriteDataSource
    public PlatFormEntity savePlatForm(PlatFormEntity platFormEntity) {
        platFormEntity.setCreateTime(DateUtils.now());
        this.platFormMapper.insertSelective(platFormEntity);
        this.removeCache(platFormEntity.getPlatformId(), platFormEntity.getPlatformGroupId());
        return platFormEntity;
    }

    @Override
    @WriteDataSource
    public PlatFormEntity updatePlatForm(PlatFormEntity platFormEntity) {
        this.platFormMapper.updateByPrimaryKeySelective(platFormEntity);
        this.removeCache(platFormEntity.getPlatformId(), platFormEntity.getPlatformGroupId());
        return platFormEntity;
    }

    @Override
    @WriteDataSource
    public void deletePlatForm(int platformId) {
        PlatFormEntity platFormEntity = this.getPlatForm(platformId);
        platFormEntity.setStatus(-1);
        this.platFormMapper.updateByPrimaryKeySelective(platFormEntity);
        this.removeCache(platformId, platFormEntity.getPlatformGroupId());
    }

    @Override
    @ReadThroughSingleCache(namespace="PlatForm", expiration=7200)
    @ReadDataSource
    public PlatFormEntity getPlatForm(@ParameterValueKeyProvider int platformId) {
        return (PlatFormEntity)this.platFormMapper.selectByPrimaryKey(Integer.valueOf(platformId));
    }

    @Override
    public int getPlatFormGroupId(int platformId) {
        PlatFormEntity platFormEntity = ((PlatFormService)AopContext.currentProxy()).getPlatForm(platformId);
        if (platFormEntity != null) {
            return platFormEntity.getPlatformGroupId();
        }
        return 0;
    }

    @Override
    @ReadDataSource
    public PlatFormAndGroupVo getPlatFormAndGroup(int platformId) {
        log.info("getPlatFormAndGroup,platformId:" + platformId);
        try {
            Object obj = this.memcachedService.get("PlatFormAndGroup", String.valueOf(platformId));
            if (obj == null) {
                PlatFormAndGroupVo vo = this.platFormMapper.getPlatFormAndGroup(platformId);
                this.memcachedService.set("PlatFormAndGroup", String.valueOf(platformId), (Object)vo, 7200);
                return vo;
            }
            return (PlatFormAndGroupVo)obj;
        }
        catch (Exception e) {
            log.error("getPlatFormAndGroup ERROR", (Throwable)e);
            return this.platFormMapper.getPlatFormAndGroup(platformId);
        }
    }

    @Override
    @ReadDataSource
    public PlatFormAndGroupVo getPlatFormAndGroup(int platformId, String uid) {
        log.info("getPlatFormAndGroup,platformId:" + platformId + ",uid=" + uid);
        try {
            Object obj = this.memcachedService.get("PlatFormAndGroup", String.valueOf(platformId));
            if (obj == null) {
                PlatFormAndGroupVo vo = this.platFormMapper.getPlatFormAndGroup(platformId);
                this.memcachedService.set("PlatFormAndGroup", String.valueOf(platformId), (Object)vo, 7200);
                return vo;
            }
            return (PlatFormAndGroupVo)obj;
        }
        catch (Exception e) {
            log.error("getPlatFormAndGroup ERROR", (Throwable)e);
            return this.platFormMapper.getPlatFormAndGroup(platformId);
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="ValidPlatFormList", expiration=7200)
    @ReadDataSource
    public List<PlatFormEntity> getValidPlatFormList(@ParameterValueKeyProvider int platformGroupId) {
        PlatFormEntity platFormEntity = new PlatFormEntity();
        platFormEntity.setStatus(1);
        platFormEntity.setPlatformGroupId(platformGroupId);
        return this.platFormMapper.getList(platFormEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="PlatFormList", expiration=7200)
    @ReadDataSource
    public List<PlatFormEntity> getPlatFormList(@ParameterValueKeyProvider int platformGroupId) {
        PlatFormEntity platFormEntity = new PlatFormEntity();
        platFormEntity.setPlatformGroupId(platformGroupId);
        return this.platFormMapper.getList(platFormEntity);
    }

    @Override
    public List<PlatFormEntity> getPlatFormList() {
        return this.platFormMapper.getList(new PlatFormEntity());
    }

    @Override
    public List<PlatFormEntity> getValidPlatFormList4All() {
        PlatFormEntity platFormEntity = new PlatFormEntity();
        platFormEntity.setStatus(1);
        return this.platFormMapper.getList(platFormEntity);
    }

    @Override
    public PageInfo getPlatFormList(int pageNum, int pageSize, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.platFormMapper.getPlatFormList(platformGroupId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    private void removeCache(Integer platformId, Integer platformGroupId) {
        this.memcachedService.delete("PlatForm", platformId + "");
        this.memcachedService.delete("PlatFormAndGroup", platformId + "");
        this.memcachedService.delete("PlatFormList", platformGroupId + "");
        this.memcachedService.delete("ValidPlatFormList", platformGroupId + "");
    }
}

