/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.quartz;

import cc.lechun.common.enums.quartz.QuartzJobGroupEnum;
import cc.lechun.framework.common.enums.quartz.QuartzEnum;
import cc.lechun.framework.common.enums.quartz.QuartzTriggerGroupEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.quartz.DefaultJob;
import cc.lechun.mall.dao.quartz.QuartzTriggersMapper;
import cc.lechun.mall.entity.quartz.QuartzTriggersEntityVo;
import cc.lechun.mall.iservice.quartz.QuartzInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;

@Service
public class QuartzService
implements QuartzInterface {
    private static final Logger log = LoggerFactory.getLogger(QuartzService.class);
    @Autowired
    private SchedulerFactoryBean schedulerFactoryBean;
    @Autowired
    private QuartzTriggersMapper quartzTriggersMapper;

    @Override
    public boolean addQuartz4Spring(String job_name, QuartzJobGroupEnum job_group, String Description, String cronExpression, String springBean) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("springBean", springBean);
        return this.addQuartzTask(job_name, job_group, null, "", QuartzTriggerGroupEnum.DEFAULT_GROUP, Description + "\u6267\u884cservice:" + springBean, cronExpression, jobDataMap);
    }

    @Override
    public boolean addQuartz4JobClass(String job_name, QuartzJobGroupEnum job_group, Class<? extends Job> jobClass, String Description, String cronExpression) {
        return this.addQuartzTask(job_name, job_group, jobClass, "", QuartzTriggerGroupEnum.DEFAULT_GROUP, Description, cronExpression, null);
    }

    @Override
    public boolean addQuartz4JobClass(String job_name, QuartzJobGroupEnum job_group, String jobClass, String Description, String cronExpression) {
        try {
            Class<?> job = Class.forName(jobClass);
            return this.addQuartz4JobClass(job_name, job_group, job, Description, cronExpression);
        }
        catch (ClassNotFoundException e) {
            log.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean addQuartzOnce4Spring(String job_name, QuartzJobGroupEnum job_group, String Description, Date cronExpression, String springBean) {
        if (cronExpression == null) {
            return false;
        }
        return this.addQuartz4Spring(job_name, job_group, Description, DateUtils.taskDateToString((Date)cronExpression), springBean);
    }

    @Override
    public boolean addQuartzOnce4JobClass(String job_name, QuartzJobGroupEnum job_group, Class<? extends Job> jobClass, String Description, Date cronExpression) {
        if (cronExpression == null) {
            return false;
        }
        return this.addQuartz4JobClass(job_name, job_group, jobClass, Description, DateUtils.taskDateToString((Date)cronExpression));
    }

    @Override
    public boolean addQuartzOnce4JobClass(String job_name, QuartzJobGroupEnum job_group, String jobClass, String Description, Date cronExpression) {
        try {
            Class<?> job = Class.forName(jobClass);
            return this.addQuartzOnce4JobClass(job_name, job_group, job, Description, cronExpression);
        }
        catch (ClassNotFoundException e) {
            log.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean addQuartzTask(String job_name, QuartzJobGroupEnum job_group, Class<? extends Job> jobClass, String trigger_name, QuartzTriggerGroupEnum trigger_group, String Description, String cronExpression, JobDataMap jobDataMap) {
        boolean flag = false;
        try {
            Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
            if (jobClass == null) {
                jobClass = DefaultJob.class;
            }
            if (jobDataMap == null) {
                jobDataMap = new JobDataMap();
            }
            JobDetail jobDetail = null;
            if (!job_name.equals("") && !job_group.getValue().equals("")) {
                JobKey jobKey = JobKey.jobKey((String)job_name, (String)job_group.getValue());
                if (scheduler.checkExists(jobKey)) {
                    log.info("\u8fd9\u91cc1");
                    return flag;
                }
                jobDetail = JobBuilder.newJob(jobClass).withDescription(Description).withIdentity(jobKey).setJobData(jobDataMap).build();
            } else {
                jobDetail = JobBuilder.newJob(jobClass).withDescription(Description).setJobData(jobDataMap).build();
            }
            CronTrigger trigger = null;
            if (trigger_group.getValue() != null && !trigger_group.getValue().equals("")) {
                TriggerKey triggerKey;
                if (trigger_name == null || trigger_name.equals("")) {
                    trigger_name = TriggerKey.createUniqueName((String)trigger_group.getValue());
                }
                if (scheduler.checkExists(triggerKey = TriggerKey.triggerKey((String)trigger_name, (String)trigger_group.getValue()))) {
                    log.info("\u8fd9\u91cc2");
                    return flag;
                }
                trigger = (CronTrigger)TriggerBuilder.newTrigger().withDescription(Description).withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            } else {
                trigger = (CronTrigger)TriggerBuilder.newTrigger().withDescription(Description).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            }
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            scheduler.start();
            log.info("\u8fd9\u91cc4");
            flag = true;
        }
        catch (Exception e) {
            log.info("\u8fd9\u91cc5");
            log.error("\u521b\u5efaquartz\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        log.info("\u8fd9\u91cc3");
        return flag;
    }

    @Override
    public PageInfo getQrtzTriggers(int pageNum, int pageSize, String job_name, String job_group) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.quartzTriggersMapper.getQuartzTriggersList(job_name, job_group);
        PageInfo pg = page.toPageInfo();
        List ls = pg.getList();
        if (ls != null && ls.size() > 0) {
            for (QuartzTriggersEntityVo entity : ls) {
                entity.setJob_group_name(QuartzJobGroupEnum.getName(entity.getJobGroup()));
                entity.setStatus_name(QuartzEnum.getName((String)entity.getTriggerState()));
                if (entity.getNextFireTime() > 0L) {
                    entity.setNext_fire_time(DateFormatUtils.format((long)entity.getNextFireTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (entity.getPrevFireTime() > 0L) {
                    entity.setPrev_fire_time(DateFormatUtils.format((long)entity.getPrevFireTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (entity.getStartTime() > 0L) {
                    entity.setStart_time(DateFormatUtils.format((long)entity.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (entity.getEndTime() <= 0L) continue;
                entity.setEnd_time(DateFormatUtils.format((long)entity.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        return pg;
    }

    @Override
    public boolean checkExists(String job_name, String job_group) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)job_name, (String)job_group);
        try {
            return scheduler.checkExists(jobKey);
        }
        catch (SchedulerException e) {
            log.error("quartz \u67e5\u8be2\u5224\u65ad\u4efb\u52a1\u662f\u5426\u5b58\u5728\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    public void pauseJob(String job_name, String job_group) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)job_name, (String)job_group);
        try {
            scheduler.pauseJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("quartz \u6682\u505c\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void deleteJob(String job_name, String job_group) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)job_name, (String)job_group);
        try {
            scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("quartz \u5220\u9664\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public boolean executeOneceJob(String jobName, String jobGroup) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            scheduler.triggerJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("quartz \u7acb\u5373\u6267\u884c\u4efb\u52a1", (Throwable)e);
        }
        return true;
    }

    @Override
    public void resumeJob(String job_name, String job_group) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)job_name, (String)job_group);
        try {
            scheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("quartz \u6062\u590d\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void pauseTrigger(String trigger_name, String trigger_group) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        TriggerKey triggerKey = TriggerKey.triggerKey((String)trigger_name, (String)trigger_group);
        try {
            scheduler.pauseTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            log.error("quartz \u6682\u505c\u89e6\u53d1\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void deleteTrigger(String trigger_name, String trigger_group) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        TriggerKey triggerKey = TriggerKey.triggerKey((String)trigger_name, (String)trigger_group);
        try {
            scheduler.pauseTrigger(triggerKey);
            scheduler.unscheduleJob(triggerKey);
        }
        catch (SchedulerException e) {
            log.error("quartz \u5220\u9664\u89e6\u53d1\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void resumeTrigger(String trigger_name, String trigger_group) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        TriggerKey triggerKey = TriggerKey.triggerKey((String)trigger_name, (String)trigger_group);
        try {
            scheduler.resumeTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            log.error("quartz \u6062\u590d\u89e6\u53d1\u5668\u5931\u8d25", (Throwable)e);
        }
    }
}

