/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallGroupProductMapper;
import cc.lechun.mall.dao.sales.MallProductGroupMapper;
import cc.lechun.mall.dao.sales.MallSaleRecommendMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallGroupProductEntityKey;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallIndexGroupVo;
import cc.lechun.mall.entity.sales.MallPriceVO;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallSaleRecommendEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallGroupService
extends BaseService
implements MallGroupInterface {
    @Autowired
    MallProductGroupMapper groupMapper;
    @Autowired
    MallGroupProductMapper groupProductMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    MallSaleRecommendMapper saleRecommendMapper;
    @Autowired
    MallVipInterface vipInterface;
    @Autowired
    MallPriceCalcInterface priceCalcInterface;

    @Override
    public BaseJsonVo findEnnableGroup(Integer platformGroupId) {
        BaseJsonVo result = new BaseJsonVo();
        MallProductGroupEntity searchParam = new MallProductGroupEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setStatus(1);
        result.setValue((Object)this.groupMapper.getList(searchParam));
        return result;
    }

    @Override
    public BaseJsonVo buildGroupVOFromProIDs(List<String> groupIDs) {
        return null;
    }

    @Override
    public BaseJsonVo buildGroupVO(String groupId, Integer quantity, String promotionId, Boolean checked) {
        BaseJsonVo sr = new BaseJsonVo();
        MallGroupVO vo = new MallGroupVO();
        MallProductGroupEntity entity = (MallProductGroupEntity)this.groupMapper.selectByPrimaryKey((Serializable)((Object)groupId));
        if (entity == null) {
            sr.setError("\u4e0d\u5b58\u5728\u7684\u5957\u88c5ID");
            return sr;
        }
        try {
            ObjectConvert.fatherConvertToChild((Object)entity, (Object)vo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            sr.setError("\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
            return sr;
        }
        vo.setGroupPic(this.picService.getProductPicUrlMap(entity.getGroupId(), SalesTypeEnum.SALES_GROUP.getValue()));
        vo.setCount(quantity);
        vo.setShort(false);
        vo.setSoldOut(false);
        vo.setGroupId(groupId);
        vo.setPromotionId(promotionId);
        vo.setShoppingcartCheck(checked);
        vo.setFactPrice(PriceUtils.format((BigDecimal)entity.getSalePrice()));
        vo.setUseCoupon(0);
        ArrayList<MallProductVO> proList = new ArrayList<MallProductVO>();
        List<MallGroupProductEntity> entities = this.groupProductMapper.getGroupProduct(groupId);
        for (MallGroupProductEntity mallGroupProductEntity : entities) {
            BaseJsonVo buildProductVOsr = this.productService.buildProductVO(mallGroupProductEntity.getProId(), mallGroupProductEntity.getProCount(), groupId, null, null, null, false, checked, null, null);
            if (buildProductVOsr.isSuccess()) {
                MallProductVO proVo = (MallProductVO)buildProductVOsr.getValue();
                if (vo.getSplitPriceMode() == 1) {
                    proVo.setProPrice(PriceUtils.format((BigDecimal)mallGroupProductEntity.getProPrice()).toString());
                }
                if (!proVo.getValid().booleanValue()) {
                    vo.setValid(false);
                    vo.setInvalidReason(proVo.getProName() + proVo.getInvalidReason());
                    vo.setShoppingcartCheck(false);
                }
                proList.add(proVo);
                continue;
            }
            return buildProductVOsr;
        }
        vo.setProductList(proList);
        vo.setSelfModeType(this.productService.getProductSelfMode(proList));
        BaseJsonVo checkResult = this.checkGroup(vo);
        if (checkResult.isSuccess()) {
            vo.setValid(true);
        } else {
            vo.setValid(false);
            vo.setInvalidReason(checkResult.getError_msg());
            vo.setShoppingcartCheck(false);
        }
        sr.setValue((Object)vo);
        return sr;
    }

    @Override
    public BaseJsonVo checkGroup(MallGroupVO groupVO) {
        return this.checkGroup(groupVO, groupVO.getCount(), groupVO.getProductList());
    }

    private BaseJsonVo checkGroup(MallProductGroupEntity groupEntity, int buyCount, List<MallProductVO> productVOs) {
        if (groupEntity == null) {
            return BaseJsonVo.error((String)String.format("\u5957\u88c5\u4e0d\u5b58\u5728", new Object[0]));
        }
        if (groupEntity.getStatus() != 1) {
            return BaseJsonVo.error((String)String.format("\u5957\u88c5%s,\u5df2\u4e0b\u67b6", groupEntity.getGroupName()).toString());
        }
        if (groupEntity.getDeleteTime() != null) {
            return BaseJsonVo.error((String)String.format("\u5957\u88c5%s,\u5df2\u5220\u9664", groupEntity.getGroupName()).toString());
        }
        if (groupEntity.getLimitBuyCount() != 0 && buyCount > groupEntity.getLimitBuyCount()) {
            return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", groupEntity.getGroupName()).toString());
        }
        if (groupEntity.getBalanceCount() < buyCount) {
            return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", groupEntity.getGroupName()).toString());
        }
        if (productVOs != null) {
            for (MallProductVO proVo : productVOs) {
                if (proVo.getValid().booleanValue()) continue;
                return BaseJsonVo.error((String)String.format("\u5957\u88c5%s,%s", groupEntity.getGroupName(), proVo.getInvalidReason()));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public int updateLimitCountByPrimaryKey(String groupId, int count) {
        Integer i = this.groupMapper.updateLimitCountByPrimaryKey(groupId, count);
        return i == null ? 0 : i;
    }

    @Override
    public BaseJsonVo updateLimitCountByPrimaryKey(MallMainOrderVo mainOrderVo) {
        try {
            int i = 1;
            String message = "";
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                if (orderVo.getGroups() != null && orderVo.getGroups().size() > 0) {
                    for (MallGroupVO g : orderVo.getGroups()) {
                        i = this.updateLimitCountByPrimaryKey(g.getGroupId(), g.getCount());
                        if (i >= 1) continue;
                        message = String.format("\u5957\u88c5:%s,\u8d85\u8fc7\u5957\u88c5\u9650\u8d2d\u6570\u91cf", g.getGroupName());
                    }
                }
                if (orderVo.getPromotions() == null || orderVo.getPromotions().size() <= 0) continue;
                for (MallPromotionVO p : orderVo.getPromotions()) {
                    if (p.getGroup() == null || (i = this.updateLimitCountByPrimaryKey(p.getGroup().getGroupId(), p.getGroup().getCount())) >= 1) continue;
                    message = String.format("\u5957\u88c5:%s,\u8d85\u8fc7\u5957\u88c5\u9650\u8d2d\u6570\u91cf", p.getGroup().getGroupName());
                }
            }
            if (i < 1) {
                return BaseJsonVo.error((String)message);
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            throw new RuntimeException();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<Map> findRecommendGroups(Integer platformGroupId) {
        ArrayList<Map> rtnList = new ArrayList<Map>();
        MallSaleRecommendEntity searchParam = new MallSaleRecommendEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setStatus(1);
        searchParam.setSaleType(SalesTypeEnum.SALES_GROUP.getValue());
        List sales = this.saleRecommendMapper.getList(searchParam);
        sales.forEach(entity -> {
            BaseJsonVo result = this.buildGroupVO(entity.getSaleId(), 1, null, false);
            if (result.isSuccess() && ((MallGroupVO)result.getValue()).getValid().booleanValue()) {
                Map group = ObjectConvert.objectWithSuperConvertToObjectMap((Object)result.getValue());
                group.put("recommendReason", entity.getRecommendReason());
                rtnList.add(group);
            }
        });
        return rtnList;
    }

    @Override
    public MallProductGroupEntity getGroup(String groupId) {
        return (MallProductGroupEntity)this.groupMapper.selectByPrimaryKey((Serializable)((Object)groupId));
    }

    @Override
    public BaseJsonVo buildIndexGroupVo(String groupId, String customerId) {
        MallProductGroupEntity groupEntity = this.getGroup(groupId);
        BaseJsonVo baseJsonVo = this.checkGroup(groupEntity, 1, null);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallIndexGroupVo groupVo = new MallIndexGroupVo();
        groupVo.setGroupId(groupEntity.getGroupId());
        groupVo.setGroupName(groupEntity.getGroupName());
        groupVo.setGroupTagsName(groupEntity.getGroupOtherName());
        groupVo.setGroupUnit(groupEntity.getGroupUnit());
        groupVo.setPrice(groupEntity.getPrice());
        groupVo.setSalePrice(groupEntity.getSalePrice());
        groupVo.setSummary(groupEntity.getSummary());
        groupVo.setIsvipday(this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
        MallPriceVO priceVO = this.priceCalcInterface.getPrice(OrderSourceEnum.CART, SalesTypeEnum.SALES_GROUP, groupVo.getGroupId(), customerId, 0);
        if (priceVO != null && priceVO.getFactPrice() != null) {
            groupVo.setSalePrice(priceVO.getFactPrice());
            groupVo.setPrice(priceVO.getOriginPrice());
        }
        groupVo.setItemType(SalesTypeEnum.SALES_GROUP.getValue());
        groupVo.setPicMap(this.picService.getProductPicUrlMap(groupId, SalesTypeEnum.SALES_GROUP.getValue()));
        return BaseJsonVo.success((Object)groupVo);
    }

    @Override
    public PageInfo getGroupList(int pageNum, int pageSize, MallProductGroupEntity mallProductGroupEntity) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        String groupName = mallProductGroupEntity.getGroupName();
        Integer status = mallProductGroupEntity.getStatus();
        Integer platformGroupId = mallProductGroupEntity.getPlatformGroupId();
        List<MallProductGroupEntity> groups = this.groupMapper.getCmsList(groupName, status, platformGroupId);
        for (MallProductGroupEntity group : groups) {
            List<String> pics = this.picService.getProductPicUrl(group.getGroupId(), ProductPicTypeEnum.GRO_SAMLL.getValue());
            if (pics == null || pics.size() <= 0) continue;
            group.setListTemplateFile(pics.get(0));
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(groups);
        return pg;
    }

    @Override
    public BaseJsonVo addGroup(MallProductGroupEntity mallProductGroupEntity) {
        BaseJsonVo sr = new BaseJsonVo();
        if (mallProductGroupEntity == null) {
            sr.setError("\u53c2\u6570\u9519\u8bef");
            return sr;
        }
        this.logger.info(JsonUtils.toJson((Object)mallProductGroupEntity, (boolean)true));
        if (StringUtils.isEmpty((String)mallProductGroupEntity.getGroupId())) {
            mallProductGroupEntity.setGroupId(IDGenerate.getUniqueIdStr());
            mallProductGroupEntity.setCreateTime(DateUtils.now());
            mallProductGroupEntity.setStatus(1);
            mallProductGroupEntity.setBalanceCount(mallProductGroupEntity.getLimitCount());
            mallProductGroupEntity.setSort(0);
            this.groupMapper.insertSelective(mallProductGroupEntity);
        } else {
            this.groupMapper.updateByPrimaryKeySelective(mallProductGroupEntity);
        }
        return sr;
    }

    @Override
    public BaseJsonVo delGroup(MallProductGroupEntity mallProductGroupEntity) {
        if (mallProductGroupEntity != null && StringUtils.isNotEmpty((String)mallProductGroupEntity.getGroupId())) {
            mallProductGroupEntity.setDeleteTime(DateUtils.now());
            this.groupMapper.updateByPrimaryKeySelective(mallProductGroupEntity);
            return new BaseJsonVo();
        }
        BaseJsonVo sr = new BaseJsonVo();
        sr.setError("\u5185\u90e8\u9519\u8bef");
        return sr;
    }

    @Override
    public List<MallGroupProductEntity> getGroupProducts(String groupId) {
        return this.groupProductMapper.getListByParam(groupId);
    }

    @Override
    public BaseJsonVo addGroupProduct(MallGroupProductEntity mallGroupProductEntity) {
        MallGroupProductEntityKey searchParam = new MallGroupProductEntityKey();
        searchParam.setGroupId(mallGroupProductEntity.getGroupId());
        searchParam.setProId(mallGroupProductEntity.getProId());
        MallGroupProductEntity entity = (MallGroupProductEntity)this.groupProductMapper.selectByPrimaryKey(searchParam);
        if (entity != null) {
            if (mallGroupProductEntity.getProCount() > 0) {
                entity.setProCount(mallGroupProductEntity.getProCount());
                entity.setProPrice(mallGroupProductEntity.getProPrice());
                this.groupProductMapper.updateByPrimaryKeySelective(entity);
            } else {
                this.groupProductMapper.delete(entity.getGroupId(), entity.getProId());
            }
        } else if (mallGroupProductEntity.getProCount() > 0) {
            this.groupProductMapper.insert(mallGroupProductEntity);
        }
        return new BaseJsonVo();
    }

    @Override
    public List<MallSelectDataVo> getOptionGroupList(Integer platformGroupId) {
        return this.groupMapper.getOptionGroupList(platformGroupId);
    }

    @Override
    public BaseJsonVo delGroupProduct(MallGroupProductEntity mallGroupProductEntity) {
        this.groupProductMapper.delete(mallGroupProductEntity.getGroupId(), mallGroupProductEntity.getProId());
        return new BaseJsonVo();
    }
}

