/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sms;

import cc.lechun.apiinvoke.sms.SmsInvoke;
import cc.lechun.baseservice.model.sms.MessageDTO;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.thread.ThreadPool;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sms.OrderSmsRecordMapper;
import cc.lechun.mall.dao.sms.SmsWhiteMapper;
import cc.lechun.mall.entity.sms.OrderSmsRecordEntity;
import cc.lechun.mall.iservice.sms.OrderSmsRecordInterface;
import cc.lechun.mall.service.sms.OrderSmsSender;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderSmsRecordService
extends BaseService
implements OrderSmsRecordInterface {
    @Autowired
    private OrderSmsRecordMapper orderSmsRecordMapper;
    @Autowired
    private RedisService redisService;
    @Autowired
    private SmsInvoke smsInvoke;
    @Autowired
    private SmsWhiteMapper smsWhiteMapper;
    @Autowired
    private OrderSmsSender orderSmsSender;

    @Override
    public BaseJsonVo saveOrderSmsRecord(OrderSmsRecordEntity orderSmsRecordEntity) {
        return this.orderSmsRecordMapper.insertSelective(orderSmsRecordEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public OrderSmsRecordEntity getOrderSmsRecord(String order, String status, Integer sendStatus) {
        OrderSmsRecordEntity orderSmsRecordEntity = new OrderSmsRecordEntity();
        orderSmsRecordEntity.setOrderNo(order);
        orderSmsRecordEntity.setStatus(status);
        orderSmsRecordEntity.setSendStatus(sendStatus);
        this.logger.info("\u67e5\u8be2\u53c2\u6570:{}", (Object)orderSmsRecordEntity.toString());
        return (OrderSmsRecordEntity)this.orderSmsRecordMapper.getSingle(orderSmsRecordEntity);
    }

    @Override
    public List<Map<String, Object>> getOrderList4UnSendSms() {
        return this.orderSmsRecordMapper.getOrderList4delivery();
    }

    @Override
    public BaseJsonVo sendSms(final int status, Date start) {
        try {
            List<Object> list = new ArrayList();
            String strStatus2 = "";
            if (status == 3 || status == 7 || status == 16) {
                if (status == 7) {
                    list = this.orderSmsRecordMapper.getOrderList4delivery();
                    strStatus2 = "\u5df2\u53d1\u8d27";
                } else if (status == 16) {
                    list = this.orderSmsRecordMapper.getOrderList4finish();
                    strStatus2 = "\u786e\u8ba4\u6536\u8d27";
                }
                final List<Object> list2 = list;
                final String strStatus = strStatus2;
                if (list2 != null) {
                    this.logger.info("\u5c06\u8981\u53d1\u9001\u7684\u8ba2\u5355\u6570:{}", (Object)list2.size());
                    ThreadPool.services.execute(new Runnable(){

                        @Override
                        public void run() {
                            OrderSmsRecordService.this.sendSmsMessage(list2, strStatus, status);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    private void sendSmsMessage(List<Map<String, Object>> list, String strStatus, int status) {
        list.forEach(o -> {
            this.logger.info("\u5c06\u53d1\u9001\u8ba2\u5355\u79c1\u57df\u77ed\u4fe1\u6d88\u606f:{} ", (Object)o.toString());
            if (o.get("PHONE") != null) {
                if (this.smsWhiteMapper.getWhitePhone(o.get("PHONE").toString()) != null) {
                    this.logger.info("\u624b\u673a\u53f7:{} \u767d\u540d\u5355,\u4e0d\u53d1\u9001 ", (Object)o.get("PHONE").toString());
                    return;
                }
            } else {
                this.logger.info("\u8ba2\u5355:{} \u624b\u673a\u53f7\u4e3a\u7a7a ", (Object)(o.get("ORDER_NO") == null ? "" : o.get("ORDER_NO").toString()));
                return;
            }
            if (o.get("ORDER_NO") != null) {
                if (this.redisService.get(o.get("ORDER_NO").toString() + ":" + String.valueOf(status)) == null) {
                    if (this.getOrderSmsRecord(o.get("ORDER_NO").toString(), strStatus, 1) == null) {
                        MessageDTO mesaageDTO = new MessageDTO();
                        mesaageDTO.setMobile(o.get("PHONE").toString());
                        mesaageDTO.setTemplateId(this.getTemplateIdByStatus(strStatus));
                        mesaageDTO.setMsgId(o.get("ORDER_NO").toString() + ":" + String.valueOf(status));
                        BaseJsonVo baseJsonVo = null;
                        try {
                            this.orderSmsSender.sendOrderSms(mesaageDTO);
                            OrderSmsRecordEntity orderSmsRecordEntity = new OrderSmsRecordEntity();
                            orderSmsRecordEntity.setStatus(strStatus);
                            orderSmsRecordEntity.setOrderNo(o.get("ORDER_NO").toString());
                            orderSmsRecordEntity.setCreateTime(DateUtils.now());
                            orderSmsRecordEntity.setPhone(o.get("PHONE").toString());
                            orderSmsRecordEntity.setPickupDate((Date)o.get("PICKUP_DATE") == null ? DateUtils.now() : (Date)o.get("PICKUP_DATE"));
                            orderSmsRecordEntity.setOrderMainNo(o.get("ORDER_MAIN_NO") == null ? "" : o.get("ORDER_MAIN_NO").toString());
                            orderSmsRecordEntity.setSendStatus(1);
                            baseJsonVo = this.saveOrderSmsRecord(orderSmsRecordEntity);
                            this.logger.info("\u8ba2\u5355:{},\u624b\u673a\u53f7:{},\u8ba2\u5355\u72b6\u6001:{},\u4fdd\u5b58:{}", new Object[]{o.get("ORDER_NO").toString(), o.get("PHONE").toString(), strStatus, baseJsonVo.isSuccess()});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    this.logger.info("\u8ba2\u5355:{}\uff0c\u72b6\u6001:{} \u5df2\u53d1\u9001\u77ed\u4fe1", (Object)o.get("ORDER_NO").toString(), (Object)strStatus);
                }
            }
        });
    }

    private void sendSmsMessage(Map<String, Object> item, String strStatus, int status) {
        this.logger.info("\u5c06\u53d1\u9001\u8ba2\u5355\u79c1\u57df\u77ed\u4fe1\u6d88\u606f:{} ", (Object)item.toString());
        if (item.get("PHONE") != null) {
            if (this.smsWhiteMapper.getWhitePhone(item.get("PHONE").toString()) != null) {
                this.logger.info("\u624b\u673a\u53f7:{} \u767d\u540d\u5355,\u4e0d\u53d1\u9001 ", (Object)item.get("PHONE").toString());
                return;
            }
        } else {
            this.logger.info("\u8ba2\u5355:{} \u624b\u673a\u53f7\u4e3a\u7a7a ", (Object)(item.get("ORDER_NO") == null ? "" : item.get("ORDER_NO").toString()));
            return;
        }
        if (item.get("ORDER_NO") != null) {
            if (this.redisService.get(item.get("ORDER_NO").toString() + ":" + String.valueOf(status)) == null) {
                if (this.getOrderSmsRecord(item.get("ORDER_NO").toString(), strStatus, 1) == null) {
                    MessageDTO mesaageDTO = new MessageDTO();
                    mesaageDTO.setMobile(item.get("PHONE").toString());
                    mesaageDTO.setTemplateId(this.getTemplateIdByStatus(strStatus));
                    mesaageDTO.setMsgId(item.get("ORDER_NO").toString());
                    BaseJsonVo baseJsonVo = null;
                    try {
                        baseJsonVo = this.smsInvoke.send(mesaageDTO);
                        this.logger.info("\u8ba2\u5355:{},\u624b\u673a\u53f7:{},\u8ba2\u5355\u72b6\u6001:{},\u77ed\u4fe1\u53d1\u9001\u72b6\u6001:{}", new Object[]{item.get("ORDER_NO").toString(), item.get("PHONE").toString(), strStatus, baseJsonVo.isSuccess()});
                        if (baseJsonVo.isSuccess()) {
                            this.redisService.save(item.get("ORDER_NO").toString() + ":" + String.valueOf(status), 1, 259200L);
                        }
                        OrderSmsRecordEntity orderSmsRecordEntity = new OrderSmsRecordEntity();
                        orderSmsRecordEntity.setStatus(strStatus);
                        orderSmsRecordEntity.setOrderNo(item.get("ORDER_NO").toString());
                        orderSmsRecordEntity.setCreateTime(DateUtils.now());
                        orderSmsRecordEntity.setPhone(item.get("PHONE").toString());
                        orderSmsRecordEntity.setPickupDate((Date)item.get("PICKUP_DATE") == null ? DateUtils.now() : (Date)item.get("PICKUP_DATE"));
                        orderSmsRecordEntity.setOrderMainNo(item.get("ORDER_MAIN_NO") == null ? "" : item.get("ORDER_MAIN_NO").toString());
                        orderSmsRecordEntity.setSendStatus(0);
                        baseJsonVo = this.saveOrderSmsRecord(orderSmsRecordEntity);
                        this.logger.info("\u8ba2\u5355:{},\u624b\u673a\u53f7:{},\u8ba2\u5355\u72b6\u6001:{},\u4fdd\u5b58:{}", new Object[]{item.get("ORDER_NO").toString(), item.get("PHONE").toString(), strStatus, baseJsonVo.isSuccess()});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.logger.info("\u8ba2\u5355:{}\uff0c\u72b6\u6001:{} \u5df2\u53d1\u9001\u77ed\u4fe1", (Object)item.get("ORDER_NO").toString(), (Object)strStatus);
            }
        }
    }

    private String getTemplateIdByStatus(String status) {
        if (status.equals("\u5df2\u53d1\u8d27")) {
            return "1";
        }
        if (status.equals("\u786e\u8ba4\u6536\u8d27")) {
            return "2";
        }
        return "0";
    }
}

