/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sms;

import cc.lechun.baseservice.model.sms.MessageDTO;
import cc.lechun.framework.core.baseclass.BaseService;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OrderSmsSender
extends BaseService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Value(value="${spring.rabbitmq.listener.baseservice.sms.exchange.name}")
    private String exchangeName;
    @Value(value="${spring.rabbitmq.listener.baseservice.sms.routingKey}")
    private String routingKey;
    final RabbitTemplate.ConfirmCallback confirmCallback = new RabbitTemplate.ConfirmCallback(){

        public void confirm(CorrelationData correlationData, boolean ack, String cause) {
            OrderSmsSender.this.logger.info("correlationData:{}", (Object)correlationData);
            String messageId = correlationData.getId();
            if (ack) {
                String[] arr = messageId.split(":");
                OrderSmsSender.this.logger.info("\u8ba2\u5355\u6d88\u606f\u6d88\u606f\u5df2\u786e\u8ba4:{}\uff0c\u8ba2\u5355\u72b6\u6001:{}", (Object)arr[0], (Object)arr[1]);
            } else {
                System.err.println("\u5f02\u5e38\u5904\u7406\u3002\u3002\u3002");
            }
        }
    };

    public void sendOrderSms(MessageDTO messageDTO) {
        this.logger.info("\u5c06\u63a8\u9001\u77ed\u4fe1\u6d88\u606f\u961f\u5217{},{}:{}", new Object[]{this.exchangeName, this.routingKey, messageDTO.toString()});
        try {
            this.rabbitTemplate.setConfirmCallback(this.confirmCallback);
            CorrelationData correlationData = new CorrelationData(messageDTO.getMsgId());
            this.rabbitTemplate.convertAndSend(this.exchangeName, this.routingKey, (Object)messageDTO, correlationData);
        }
        catch (AmqpException e) {
            e.printStackTrace();
        }
    }
}

