/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.constants.message.MessageActionConstants;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.messagePush.PaySuccessMessageInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MallOrderMessageService
extends BaseService
implements MallOrderMessageInterface {
    @Value(value="${lechun.wechatweb.url}")
    private String webDomain;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private MallOrderPayInterface payInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private PaySuccessMessageInterface paySuccessMessageInterface;
    @Autowired
    private MallOrderInterface orderInterface;

    @Override
    public void sendOrderPaySuccessTextMessage(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity == null) {
            return;
        }
        this.sendOrderPaySuccessTextMessage(orderMainEntity);
    }

    @Override
    public void sendOrderPaySuccessTextMessage(MallOrderMainEntity orderMainEntity) {
        if (orderMainEntity == null) {
            return;
        }
        int orderClass = orderMainEntity.getOrderClass();
        if (orderClass == OrderClassEnum.ACTIVE_ORDER.getValue() || orderClass == OrderClassEnum.WISH_ORDER.getValue()) {
            return;
        }
        try {
            CustomerDetailVo customerDetail = this.customerInterface.getCustomerDetail(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId());
            if (customerDetail == null) {
                return;
            }
            String openId = customerDetail.getOpenId();
            if (orderClass == OrderClassEnum.CROWD_ORDER.getValue()) {
                this.messageInterface.sendWechatMessage((int)orderMainEntity.getPlatformId(), MessageActionConstants.orderpaysuccessCrowd, openId, null);
                return;
            }
            List<MallOrderPayEntity> orderPayEntities = this.payInterface.getList(orderMainEntity.getOrderMainNo());
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainEntity.getOrderMainNo());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("orderMainNo", orderMainEntity.getOrderMainNo());
            if (orderEntities != null && orderEntities.size() > 0) {
                map.put("orderNo", orderEntities.get(0).getOrderNo());
            }
            if (orderPayEntities.stream().filter(c -> c.getPaytypeId() == 8).count() > 0L) {
                this.messageInterface.sendWechatMessage((int)orderMainEntity.getPlatformId(), MessageActionConstants.orderpaysuccessMessageUsed, openId, map);
            } else {
                this.messageInterface.sendWechatMessage((int)orderMainEntity.getPlatformId(), MessageActionConstants.orderpaysuccessmessage, openId, map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

