/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.active.iservice.active.ActiveOrderRecordInterface;
import cc.lechun.common.constants.trade.OrderStatusClassConstants;
import cc.lechun.common.enums.customer.PasswordTypeEnum;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.ChannelEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.trade.CancelOrderVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntitiesVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupAndProductVo;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPackagePrintrecordEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderProductVo;
import cc.lechun.mall.entity.trade.MallOrderRecordEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.deliver.DeliverNewErpInterface;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.deliver.MallOrderDeliverRecordInterface;
import cc.lechun.mall.iservice.inventory.InventoryInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallProductSalesInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.trade.MallOrderCacheInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderLogCacheInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPackagePrintrecordInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderRecordInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.trade.SetCacheCheckInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.service.trade.MallOrderGroupProductService;
import cc.lechun.mall.service.trade.MallOrderSaleNewErpService;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class MallTradeService
extends BaseService
implements MallTradeInterface {
    private final Map<String, OrderHandleInterface> orderHandleInterfaces = new TreeMap<String, OrderHandleInterface>();
    @Autowired
    private InventoryInterface inventoryInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    private DefineFiledHandleInterface defineFiledHandleInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private SetCacheCheckInterface setCacheCheckInterface;
    @Autowired
    private ActiveOrderRecordInterface activeOrderRecordInterface;
    @Autowired
    private MallProductPicInterface productPicInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallAreaInterface areaInterface;
    @Autowired
    private MallCityInterface cityInterface;
    @Autowired
    private MallOrderPackagePrintrecordInterface packagePrintrecordInterface;
    @Autowired
    private MallOrderDeliverRecordInterface deliverRecordInterface;
    @Autowired
    private MallOrderRecordInterface orderRecordInterface;
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private MallOrderCacheInterface orderCacheInterface;
    @Autowired
    private DeliverInterface deliverService;
    @Autowired
    private MallPromotionProductInterface mallPromotionProductInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallProductSalesInterface salesInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private MallOrderGroupProductService mallOrderGroupProductService;
    @Autowired
    private MallOrderSaleNewErpService mallOrderSaleNewErpService;
    @Autowired
    private MallTradeInterface mallTradeInterface;
    @Autowired
    private DeliverNewErpInterface deliverNewErpInterface;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    private MallOrderLogCacheInterface logCacheInterface;
    @Value(value="${erp.addInventory.url}")
    private String addInventoryUrl;
    @Value(value="${autoConfirmDays:15}")
    private Integer autoConfirmDays;

    @Autowired
    public MallTradeService(Map<String, OrderHandleInterface> orderHandleInterfaces) {
        this.orderHandleInterfaces.clear();
        orderHandleInterfaces.forEach((k, v) -> this.orderHandleInterfaces.put((String)k, (OrderHandleInterface)v));
    }

    @Override
    public BaseJsonVo toPayPage(int platFormId, String customerId, MallOrderCacheVo orderCacheVo) {
        MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getDefaultPayType();
        if (mallPayTypeEntity == null) {
            return BaseJsonVo.paramError((String)"\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef");
        }
        orderCacheVo.setPayType(mallPayTypeEntity.getPaytypeId());
        if (orderCacheVo == null) {
            return BaseJsonVo.paramError((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (OrderSourceEnum.getName(orderCacheVo.getOrderSource()).isEmpty()) {
            return BaseJsonVo.paramError((String)"\u8f93\u5165\u4fe1\u606f\u8ba2\u5355\u6765\u6e90\u9519\u8bef");
        }
        MallMainOrderVo mallMainOrderVo = this.getMainMainOrderVo(customerId, platFormId, orderCacheVo);
        this.logger.info("+++++++++++toPayPage+++++++++++mallMainOrderVo={}", (Object)JSON.toJSONString((Object)mallMainOrderVo));
        if (!mallMainOrderVo.isBaseSuccess()) {
            return BaseJsonVo.error((String)mallMainOrderVo.getBaseErrMsg());
        }
        for (String key : this.orderHandleInterfaces.keySet()) {
            this.logger.info("\u4e1a\u52a1\u903b\u8f91\u6267\u884c\uff1a" + key);
            try {
                BaseJsonVo baseJsonVo = this.orderHandleInterfaces.get(key).orderHandle(mallMainOrderVo);
                if (baseJsonVo.isSuccess()) continue;
                return baseJsonVo;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u4e1a\u52a1\u903b\u8f91\u5f02\u5e38\uff1a" + key, (Throwable)e);
                return BaseJsonVo.error((String)("\u4e1a\u52a1\u903b\u8f91\u5f02\u5e38\uff1a" + key));
            }
        }
        this.logger.info("\u5904\u7406\u5404\u81ea\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5\uff1atoPayPage");
        return BaseJsonVo.success((Object)mallMainOrderVo);
    }

    @Override
    @ReadThroughSingleCache(namespace="MallTradeService.getMainMainOrderVo", expiration=300)
    public MallMainOrderVo getMainMainOrderVo(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) int platFormId, @ParameterValueKeyProvider(order=2) int orderSource, @ParameterValueKeyProvider(order=3) String cacheId, @ParameterValueKeyProvider(order=4) String bindCode) {
        MallOrderCacheVo cacheVo = new MallOrderCacheVo();
        cacheVo.setBindCode(bindCode);
        cacheVo.setCacheId(cacheId);
        cacheVo.setOrderSource(orderSource);
        return this.getMainMainOrderVo(customerId, platFormId, cacheVo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MallMainOrderVo getMainMainOrderVo(String customerId, int platFormId, MallOrderCacheVo orderCacheVo) {
        MallMainOrderVo mallMainOrderVo = new MallMainOrderVo();
        if (orderCacheVo.getOrderSource() == OrderSourceEnum.CART.getValue()) {
            BaseJsonVo result = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platFormId, customerId, true, orderCacheVo.getIsQuick());
            if (result.isSuccess()) {
                List<MallOrderVo> orderVos = this.orderInterface.ShoppingConvertOrder((List)result.getValue());
                if (orderVos.size() == 0) {
                    mallMainOrderVo.setBaseError("\u5f53\u524d\u8d2d\u7269\u8f66\u6ca1\u6709\u53ef\u7ed3\u7b97\u7684\u5546\u54c1");
                    return mallMainOrderVo;
                }
                mallMainOrderVo = this.orderMainInterface.getMainOrderVo(platFormId, customerId, orderVos, orderCacheVo);
                if (mallMainOrderVo.isBaseSuccess()) return mallMainOrderVo;
                return mallMainOrderVo;
            }
            mallMainOrderVo.setBaseError(result.getError_msg());
            return mallMainOrderVo;
        }
        BaseJsonVo baseJsonVo = this.orderInterface.getOrderVoFromCache(platFormId, customerId, orderCacheVo);
        if (!baseJsonVo.isSuccess()) {
            mallMainOrderVo.setBaseError(baseJsonVo.getMessage());
            return mallMainOrderVo;
        }
        mallMainOrderVo = this.orderMainInterface.getMainOrderVo(platFormId, customerId, (List)baseJsonVo.getValue(), orderCacheVo);
        if (mallMainOrderVo.isBaseSuccess()) return mallMainOrderVo;
        return mallMainOrderVo;
    }

    @Override
    public BaseJsonVo setOrderCache(int platFormId, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        if (mallOrderCacheInVo == null) {
            return BaseJsonVo.paramError((String)"\u8f93\u5165\u4fe1\u606f\u9519\u8bef");
        }
        if (OrderSourceEnum.getName(mallOrderCacheInVo.getOrderSource()).isEmpty()) {
            return BaseJsonVo.paramError((String)"\u8f93\u5165\u4fe1\u606f\u8ba2\u5355\u6765\u6e90\u9519\u8bef");
        }
        if (mallOrderCacheInVo.getMallOrderCacheInItemVoList() == null || mallOrderCacheInVo.getMallOrderCacheInItemVoList().size() == 0) {
            return BaseJsonVo.paramError((String)"\u8f93\u5165\u4fe1\u606f\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
        }
        BaseJsonVo jsonVo = this.setCacheCheckInterface.setCacheCheck(platFormId, customerId, mallOrderCacheInVo);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        int transportType = this.getTransportType(mallOrderCacheInVo.getMallOrderCacheInItemVoList());
        mallOrderCacheInVo.setTransportType(transportType);
        mallOrderCacheInVo.setPayJumpType(1);
        String cacheId = "MallTreadeService_setOrderCache_" + platFormId + "_" + customerId + "_" + mallOrderCacheInVo.getOrderSource() + DateUtils.now().getTime();
        if (this.orderCacheInterface.insertOrderCacheEntity(cacheId, JsonUtils.toJson((Object)mallOrderCacheInVo, (boolean)false)).booleanValue()) {
            MallOrderCacheVo orderCacheVo = new MallOrderCacheVo();
            orderCacheVo.setCacheId(cacheId);
            orderCacheVo.setTransportType(mallOrderCacheInVo.getTransportType());
            orderCacheVo.setOrderSource(mallOrderCacheInVo.getOrderSource());
            orderCacheVo.setBindCode(mallOrderCacheInVo.getBindCode());
            this.defineFiledHandleInterface.setCache(platFormId, customerId, cacheId, mallOrderCacheInVo);
            return BaseJsonVo.success((Object)orderCacheVo);
        }
        return BaseJsonVo.error((String)"\u7f13\u5b58\u9519\u8bef");
    }

    @Override
    public BaseJsonVo createOrder(int platFormId, String customerId, MallOrderCacheVo orderCacheVo) throws InvalidKeySpecException, NoSuchAlgorithmException {
        BaseJsonVo validPass;
        this.logger.info("+++++++++++createOrder+++++++++++orderCacheVo={}", (Object)JSON.toJSONString((Object)orderCacheVo));
        BaseJsonVo baseJsonVo = this.toPayPage(platFormId, customerId, orderCacheVo);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallMainOrderVo mallMainOrderVo = (MallMainOrderVo)baseJsonVo.getValue();
        if (mallMainOrderVo == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u521b\u5efa\u5931\u8d25");
        }
        if (mallMainOrderVo.getBalanceAmount().compareTo(new BigDecimal(0)) > 0 && mallMainOrderVo.getPayAmount().compareTo(new BigDecimal(0)) == 0 && !(validPass = this.customerInterface.validatePassword(customerId, orderCacheVo.getPayPassword(), PasswordTypeEnum.pay_password)).isSuccess()) {
            return validPass;
        }
        MallOrderEntitiesVo orderEntitiesVo = this.getOrderEntities(mallMainOrderVo);
        if (!orderEntitiesVo.isBaseSuccess()) {
            return BaseJsonVo.error((String)orderEntitiesVo.getBaseErrMsg());
        }
        baseJsonVo = this.defineFiledHandleInterface.createOrderBefore(customerId, orderCacheVo.getOrderSource(), orderCacheVo.getBindCode(), mallMainOrderVo);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        baseJsonVo = this.mallTradeInterface.buildOrder(orderEntitiesVo, mallMainOrderVo);
        this.logCacheInterface.saveOrderLog(orderEntitiesVo);
        this.defineFiledHandleInterface.createOrderAfter(mallMainOrderVo, orderCacheVo, baseJsonVo.isSuccess());
        return baseJsonVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, timeout=100, isolation=Isolation.SERIALIZABLE)
    public BaseJsonVo buildOrder(MallOrderEntitiesVo orderEntitiesVo, MallMainOrderVo mainOrderVo) {
        this.logger.info("=====================\u8fdb\u5165=======buildOrder==================orderEntitiesVo={},mainOrderVo={}", (Object)JSON.toJSONString((Object)orderEntitiesVo), (Object)JSON.toJSONString((Object)mainOrderVo));
        String message = "";
        boolean isSuccess = false;
        try {
            if (!orderEntitiesVo.isBaseSuccess()) {
                message = orderEntitiesVo.getBaseErrMsg();
                throw new RuntimeException(message);
            }
            BaseJsonVo baseJsonVo = this.defineFiledHandleInterface.createOrderBeforeWithTransaction(mainOrderVo);
            if (!baseJsonVo.isSuccess()) {
                message = baseJsonVo.getMessage();
                throw new RuntimeException(message);
            }
            baseJsonVo = this.promotionInterface.updatePromotionLimitCount(mainOrderVo, false);
            if (!baseJsonVo.isSuccess()) {
                message = baseJsonVo.getMessage();
                throw new RuntimeException(message);
            }
            boolean success = this.orderMainInterface.insertOrderMain(orderEntitiesVo.getOrderMainEntity());
            if (!success) {
                message = "\u751f\u6210\u8ba2\u5355\u4e3b\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            for (MallOrderEntity mallOrderEntity : orderEntitiesVo.getOrderEntities()) {
                success = this.orderInterface.insertOrder(mallOrderEntity);
                if (success) continue;
                message = "\u751f\u6210\u8ba2\u5355\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            for (MallOrderProductEntity mallOrderProductEntity : orderEntitiesVo.getOrderProductEntities()) {
                success = this.orderProductInterface.insertOrderProduct(mallOrderProductEntity);
                if (success) continue;
                message = "\u751f\u6210\u8ba2\u5355\u5546\u54c1\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            for (MallOrderGroupProductEntity mallOrderGroupProductEntity : orderEntitiesVo.getOrderGroupProductEntities()) {
                success = this.orderGroupProductInterface.insertOrderGroupProduct(mallOrderGroupProductEntity);
                if (success) continue;
                message = "\u751f\u6210\u8ba2\u5355\u5546\u54c1\u660e\u7ec6\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            for (MallOrderPayEntity mallOrderPayEntity : orderEntitiesVo.getOrderPayEntities()) {
                success = this.orderPayInterface.insertOrderPay(mallOrderPayEntity);
                if (success) continue;
                message = "\u751f\u6210\u8ba2\u5355\u652f\u4ed8\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            if (!this.tradeCommonInterface.isNoDeliverOrder(mainOrderVo)) {
                Optional<MallOrderVo> mallOrderVoOptional = mainOrderVo.getMallOrderVos().stream().filter(c -> "\u7f8e\u56e2\u914d\u9001".equals(c.getDeliverVo().getDeliverName())).findFirst();
                if (mallOrderVoOptional.isPresent()) {
                    this.logger.info("\u914d\u9001\u65b9\u5f0f\u662f : " + mallOrderVoOptional.get().getDeliverVo().getDeliverName());
                    baseJsonVo = this.inventoryInterface.lockProductInventory(mainOrderVo);
                    this.logger.info("\u6263\u51cf\u5e93\u5b58\uff1a" + baseJsonVo.isSuccess() + "," + baseJsonVo.getMessage());
                    if (!baseJsonVo.isSuccess()) {
                        this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                        message = baseJsonVo.getMessage();
                        throw new RuntimeException(message);
                    }
                } else if (!baseJsonVo.isSuccess()) {
                    this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                    message = baseJsonVo.getMessage();
                    throw new RuntimeException(message);
                }
                if ((mallOrderVoOptional = mainOrderVo.getMallOrderVos().stream().filter(c -> !"\u7f8e\u56e2\u914d\u9001".equals(c.getDeliverVo().getDeliverName())).findFirst()).isPresent() && orderEntitiesVo.getOrderEntities() != null && orderEntitiesVo.getOrderEntities().size() > 0) {
                    String string = this.mallOrderSaleNewErpService.checkOrderSaleCold(orderEntitiesVo, mainOrderVo);
                    if (string != null) {
                        message = string;
                        throw new RuntimeException(message);
                    }
                    String messageByNomal = this.mallOrderSaleNewErpService.checkOrderSaleNomal(orderEntitiesVo, mainOrderVo);
                    if (messageByNomal != null) {
                        message = messageByNomal;
                        throw new RuntimeException(message);
                    }
                }
            }
            isSuccess = true;
            if (mainOrderVo.getOrderCacheVo().getOrderSource() != OrderSourceEnum.CART.getValue()) {
                this.orderCacheInterface.deleteOrderCacheEntity(mainOrderVo.getOrderCacheVo().getCacheId());
            } else {
                this.shoppingcartInterface.removeCartChecked(mainOrderVo.getPlatFormId(), mainOrderVo.getCustomerId(), true, mainOrderVo.getOrderCacheVo().getIsQuick());
            }
            Iterator<Serializable> iterator = BaseJsonVo.success((Object)mainOrderVo.getMainOrderNo());
            return iterator;
        }
        catch (RuntimeException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("buildOrder\u5199\u8868\uff1a" + message + e.getMessage());
            if (message.isEmpty()) {
                message = "\u8ba2\u5355\u521b\u5efa\u5f02\u5e38";
            }
        }
        finally {
            this.defineFiledHandleInterface.createOrderAfterWithTransaction(mainOrderVo, isSuccess);
        }
        return BaseJsonVo.error((String)message);
    }

    private MallOrderEntitiesVo getOrderEntities(MallMainOrderVo mainOrderVo) {
        MallOrderEntitiesVo orderEntitiesVo = new MallOrderEntitiesVo();
        try {
            BaseJsonVo baseJsonVo = this.orderMainInterface.buildOrderMainEntity(mainOrderVo);
            if (!baseJsonVo.isSuccess()) {
                orderEntitiesVo.setBaseError(baseJsonVo.getError_msg());
                return orderEntitiesVo;
            }
            orderEntitiesVo.setOrderMainEntity((MallOrderMainEntity)baseJsonVo.getValue());
            baseJsonVo = this.orderInterface.buildOrderEntities(mainOrderVo);
            if (!baseJsonVo.isSuccess()) {
                orderEntitiesVo.setBaseError(baseJsonVo.getError_msg());
                return orderEntitiesVo;
            }
            orderEntitiesVo.setOrderEntities((List)baseJsonVo.getValue());
            baseJsonVo = this.orderProductInterface.buildOrderProductEntities(mainOrderVo);
            if (!baseJsonVo.isSuccess()) {
                orderEntitiesVo.setBaseError(baseJsonVo.getError_msg());
                return orderEntitiesVo;
            }
            MallOrderGroupAndProductVo orderGroupAndProductVo = (MallOrderGroupAndProductVo)baseJsonVo.getValue();
            orderEntitiesVo.setOrderProductEntities(orderGroupAndProductVo.getOrderProductEntities());
            orderEntitiesVo.setOrderGroupProductEntities(orderGroupAndProductVo.getOrderGroupProductEntities());
            if (mainOrderVo.getOrderPayEntities() == null || mainOrderVo.getOrderPayEntities().size() <= 0) {
                orderEntitiesVo.setBaseError("\u652f\u4ed8\u4fe1\u606f\u6784\u5efa\u5f02\u5e38");
                return orderEntitiesVo;
            }
            orderEntitiesVo.setOrderPayEntities(mainOrderVo.getOrderPayEntities());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.toString());
            orderEntitiesVo.setBaseError("\u8ba2\u5355\u4fe1\u606f\u6784\u5efa\u5f02\u5e38");
        }
        return orderEntitiesVo;
    }

    @Override
    public BaseJsonVo cancelCustomerOrder(String customerId, String orderMainNo, int cancelSource) {
        this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u65b9\u6cd5cancelCustomerOrder*************");
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.defineFiledHandleInterface.cancelOrderBefore(customerId, orderMainNo, cancelSource);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (customerId == null || customerId.isEmpty()) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!customerId.equals(orderMainEntity.getCustomerId())) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0e\u8ba2\u5355\u4e0d\u4e00\u81f4");
        }
        if (orderMainEntity.getStatus().intValue() == OrderStatusEnum.CANCEL.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d6\u6d88");
        }
        if (orderMainEntity.getStatus().intValue() != OrderStatusEnum.UNPAY.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88");
        }
        Date createTime = orderMainEntity.getCreateTime();
        String canCancelTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)-10, (String)"yyyy-MM-dd HH:mm:ss");
        if (DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)canCancelTime) < 0L) {
            this.logger.info("======cancelCustomerOrder====createTime:[{}],canCancelTime:[{}],DateDiff:[{}]", new Object[]{createTime, canCancelTime, DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)canCancelTime)});
            return BaseJsonVo.error((String)"\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
        }
        try {
            this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u5173\u95ed\u652f\u4ed8************");
            BaseJsonVo result = this.payOrderInterface.payClose(customerId, orderMainNo);
            this.logger.info("-------------------\u5173\u95ed\u652f\u4ed8\u7ed3\u679c------result={}", (Object)JSON.toJSONString((Object)result));
            if (!result.isSuccess() && !result.getError_msg().startsWith("E006")) {
                return BaseJsonVo.error((String)result.getError_msg());
            }
            this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u4e0b\u4e00\u6b65\u91ca\u653e\u5e93\u5b58*************");
            BaseJsonVo baseJsonVo = this.inventoryInterface.unLockProductInventory(orderMainNo, orderMainEntity.getPlatformId());
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            if (this.orderMainInterface.cancelOrderMain(orderMainNo, customerId)) {
                this.defineFiledHandleInterface.cancelOrderAfter(customerId, orderMainNo, cancelSource);
                return BaseJsonVo.success((Object)"");
            }
            BaseJsonVo.error((String)"\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u53d6\u6d88\u8ba2\u5355\u9519\u8bef", (Throwable)e);
        }
        return BaseJsonVo.error((String)"\u53d6\u6d88\u8ba2\u5355\u9519\u8bef");
    }

    @Override
    public BaseJsonVo updateOrderPaySuccess(String tradeNo, String thirdTradeNo) {
        String orderMainNo = "";
        MallOrderPayEntity orderPayEntity = this.orderPayInterface.getSingleOrderPayByTradeNo(tradeNo);
        String message = "\u66f4\u65b0\u8ba2\u5355\u5931\u8d25";
        if (orderPayEntity == null && (orderPayEntity = this.orderPayInterface.getSingle(tradeNo)) == null) {
            return BaseJsonVo.error((String)"\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        BaseJsonVo updateOrderPaySuccessVO = this.tradeInterface.updateOrderPaySuccess(orderPayEntity, thirdTradeNo);
        if (updateOrderPaySuccessVO.isSuccess()) {
            BaseJsonVo orderPaySuccessAfterVO = this.defineFiledHandleInterface.orderPaySuccessAfter(orderPayEntity.getOrderMainNo());
            return orderPaySuccessAfterVO;
        }
        return updateOrderPaySuccessVO;
    }

    @Override
    public BaseJsonVo updateOrderPaySuccess(MallOrderPayEntity orderPayEntity, String thirdTradeNo) {
        String orderMainNo = "";
        String message = "\u66f4\u65b0\u8ba2\u5355\u5931\u8d25";
        try {
            BaseJsonVo baseJsonVo;
            orderMainNo = orderPayEntity.getOrderMainNo();
            if (orderPayEntity.getIssuccess() == 0) {
                orderPayEntity.setIssuccess(1);
                orderPayEntity.setSuccessTime(DateUtils.now());
                orderPayEntity.setThirdTradeNo(thirdTradeNo);
            }
            if (!(baseJsonVo = this.tradeInterface.updateOrderSuccess(orderMainNo, orderPayEntity)).isSuccess()) {
                message = baseJsonVo.getMessage();
                throw new Exception();
            }
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            this.logger.error(message + ",\u8ba2\u5355\u53f7\uff1a" + orderMainNo + e.toString());
            return BaseJsonVo.error((String)message);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo updateOrderSuccess(String orderMainNo, MallOrderPayEntity orderPayEntity) {
        String message = "";
        try {
            BigDecimal payAmount;
            if (orderPayEntity != null && StringUtils.isNotEmpty((String)orderPayEntity.getPayId())) {
                this.orderPayInterface.updateByPrimaryKey(orderPayEntity);
            }
            List<MallOrderPayEntity> orderPayEntities = this.orderPayInterface.getList(orderMainNo);
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            if (orderMainEntity == null || orderPayEntities == null) {
                throw new Exception("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (orderMainEntity.getStatus() > 1) {
                this.logger.info("\u8ba2\u5355" + orderMainNo + ",\u72b6\u6001\u5df2\u7ecf\u66f4\u65b0\u4e3a\uff1a" + orderMainEntity.getStatus());
                return BaseJsonVo.success((Object)"");
            }
            if (orderPayEntity != null && StringUtils.isNotEmpty((String)orderPayEntity.getPayId())) {
                for (int i = 0; i < orderPayEntities.size(); ++i) {
                    if (!orderPayEntity.getPayId().equals(orderPayEntities.get(i).getPayId())) continue;
                    orderPayEntities.set(i, orderPayEntity);
                    break;
                }
            }
            if ((payAmount = orderPayEntities.stream().filter(c -> c.getIssuccess() == 1).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(orderMainEntity.getTotalAmount()) == 0) {
                if (!this.orderMainInterface.paySuccessOrderMain(orderMainNo)) {
                    throw new Exception("[updateOrderSuccess]\u66f4\u65b0\u8ba2\u5355\u65b9\u6cd5\u5f02\u5e38:\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
                }
            } else {
                this.logger.info("updateOrderSuccess\u66f4\u65b0\u8ba2\u5355" + orderMainNo + "\u65b9\u6cd5\u5f02\u5e38:\u652f\u4ed8\u91d1\u989d\u4e0e\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26\uff0c\u8ba2\u5355\u91d1\u989d\uff1a" + orderMainEntity.getTotalAmount().doubleValue() + "\uff0c\u652f\u4ed8\u91d1\u989d\uff1a" + payAmount.doubleValue());
                throw new Exception("[updateOrderSuccess]\u66f4\u65b0\u8ba2\u5355\u65b9\u6cd5\u5f02\u5e38:\u652f\u4ed8\u91d1\u989d\u4e0e\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26\uff0c\u8ba2\u5355\u91d1\u989d\uff1a" + orderMainEntity.getTotalAmount().doubleValue() + "\uff0c\u652f\u4ed8\u91d1\u989d\uff1a" + payAmount.doubleValue());
            }
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("[updateOrderSuccess]\u66f4\u65b0\u8ba2\u5355\u65b9\u6cd5\u5f02\u5e38:" + orderMainNo, (Throwable)e);
            return BaseJsonVo.error((String)"\u66f4\u65b0\u8ba2\u5355\u5f02\u5e38");
        }
    }

    @Override
    public Map<String, Long> getOrderCount(String customerId) {
        return this.orderInterface.getCustomerOrderCount(customerId);
    }

    @Override
    public PageInfo<OrderListVo> getOrderList(String customerId, int statusClass, int pageSize, int pageCount) {
        PageInfo<OrderListVo> orderMainEntities;
        int[] statusArr = null;
        if (statusClass != 0) {
            statusArr = OrderStatusClassConstants.getStatusByStatusClass(statusClass);
        }
        if ((orderMainEntities = this.orderMainInterface.getOrderMainList4cms(customerId, statusArr, statusClass, pageSize, pageCount)) == null || orderMainEntities.getList().size() == 0) {
            return null;
        }
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (final OrderListVo orderMain : orderMainEntities.getList()) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    MallTradeService.this.processOrderInfo(orderMain);
                }
            });
            if (orderMain.getStatus() <= 2 || orderMain.getStatus() >= 25 || orderMain.getOrderClass() == 2 || orderMain.getOrderSource() == 21 || orderMain.getOrderSource() == 22) {
                orderMain.setCanShare(2);
                continue;
            }
            orderMain.setCanShare(1);
        }
        pool.shutdown();
        try {
            boolean loop = true;
            while (loop = !pool.awaitTermination(2L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (statusClass == 4) {
            orderMainEntities.getList().removeIf(c -> c.getOrderClass() != 1 || c.getEvaluateStatus() == 1 || c.getOrderNo() == null);
        }
        return orderMainEntities;
    }

    public void processOrderInfo(OrderListVo orderMain) {
        MallCityEntity cityEntity;
        String orderNo = orderMain.getOrderNo();
        this.orderInterface.getOrderInfo(orderMain);
        if (orderMain.getOrderNo() == null || orderMain.getOrderNo().isEmpty()) {
            return;
        }
        List<MallOrderPayEntity> orderPayEntities = this.orderPayInterface.getList(orderMain.getOrderMainNo());
        orderMain.setBalanceAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
        orderMain.setCouponAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
        orderMain.setChannelName(ChannelEnum.getName(orderMain.getChannelId()));
        orderMain.setStatusName(OrderStatusEnum.getName(orderMain.getStatus()));
        int statusClass1 = this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass());
        orderMain.setStatusClass(statusClass1);
        if (orderMain.getStatus() == OrderStatusEnum.UNPAY.getValue()) {
            int cancelTimes = 570;
            long i = DateUtils.getDateDiffSecond((String)DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"), (String)DateUtils.getAddDateBySecond((Date)orderMain.getCreateTime(), (int)cancelTimes, (String)"yyyy-MM-dd HH:mm:ss"));
            if (i < 0L) {
                i = 0L;
            }
            orderMain.setCancelTimes(i);
            if (i == 0L) {
                statusClass1 = this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass());
                orderMain.setStatusClass(statusClass1);
            }
        } else {
            orderMain.setCancelTimes(0L);
        }
        boolean isEdit = this.orderMainInterface.iseditOrder(orderMain.getOrderNo(), orderMain.getDeliverDate(), orderMain.getPickUpDate(), orderMain.getPlatformGroupId(), orderMain.getStatus());
        orderMain.setEdit(isEdit);
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderMainNo(orderMain.getOrderMainNo());
        if (orderNo != null && !orderNo.isEmpty()) {
            orderProductEntity.setOrderNo(orderNo);
        }
        List<MallOrderProductEntity> orderProductEntities = this.orderProductInterface.getOrderProductList(orderProductEntity);
        ArrayList<MallOrderProductVo> orderProductVos = new ArrayList<MallOrderProductVo>();
        int transportType = 1;
        for (MallOrderProductEntity p : orderProductEntities) {
            MallOrderProductVo orderProductVo = new MallOrderProductVo();
            if (p.getGroupType() == 1) {
                orderProductVo.setItemId(p.getPromotionProductId());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getPromotionProductId() == null ? "" : p.getPromotionProductId(), ProductPicTypeEnum.PROMO_SAMLL.getValue()).get(0));
            }
            if (p.getGroupType() == 2) {
                orderProductVo.setItemId(p.getGroupId());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getGroupId() == null ? "" : p.getGroupId(), ProductPicTypeEnum.GRO_SAMLL.getValue()).get(0));
            }
            if (p.getGroupType() == 4) {
                orderProductVo.setItemId(p.getProductId());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getProductId() == null ? "" : p.getProductId(), ProductPicTypeEnum.PRO_SAMLL.getValue()).get(0));
            }
            if (p.getGroupType() == 5) {
                orderProductVo.setItemId(p.getActivityNo());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getActivityNo() == null ? "" : p.getActivityNo(), ProductPicTypeEnum.ACT_SAMLL.getValue()).get(0));
            }
            orderProductVo.setProductType(p.getGroupType());
            orderProductVo.setFactPrice(p.getUnitPrice());
            orderProductVo.setItemName(p.getProductName());
            orderProductVo.setQuantity(p.getQuantity());
            orderProductVo.setTotalPrice(p.getTotalPrice());
            orderProductVo.setUnitPrice(p.getOriginalPrice());
            orderProductVo.setOrderProductId(p.getOrderProductNo());
            MallProductEntity productEntity = this.productInterface.getProduct(p.getProductId());
            if (productEntity != null) {
                orderProductVo.setProDw(productEntity.getProDw());
                orderProductVo.setProTypeId(productEntity.getProTypeId());
                orderProductVo.setProTitle(productEntity.getProTitle());
            } else {
                orderProductVo.setProDw("\u5957");
            }
            orderProductVos.add(orderProductVo);
        }
        transportType = this.productInterface.getTransportType(this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderMain.getOrderNo()));
        orderMain.setOrderProductVos(orderProductVos);
        MallAreaEntity areaEntity = this.areaInterface.getArea(orderMain.getConsigneeAreaid());
        if (areaEntity != null && (cityEntity = this.cityInterface.getCity(areaEntity.getCityId())) != null) {
            orderMain.setOpenCityStatus(cityEntity.getOpenCityStatus());
        }
        orderMain.setTransportType(transportType);
        if (transportType == 2) {
            orderMain.setDeliverDateShow(this.tradeCommonInterface.getDelayDateName(DateUtils.formatDate((Date)orderMain.getCreateTime(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getDeliverDate(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getPickUpDate(), (String)"yyyy-MM-dd"), "", orderMain.getOrderSource(), orderMain.getTransportType(), orderMain.getOpenCityStatus(), orderMain.getStatusClass(), orderMain.getDeliverType(), orderMain.getOrderClass()));
        } else {
            orderMain.setDeliverDateShow(this.tradeCommonInterface.getDelayDateName(DateUtils.formatDate((Date)orderMain.getCreateTime(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getDeliverDate(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getPickUpDate(), (String)"yyyy-MM-dd"), "", orderMain.getOrderSource(), orderMain.getTransportType(), orderMain.getOpenCityStatus(), orderMain.getStatusClass(), orderMain.getDeliverType(), orderMain.getOrderClass()));
        }
        orderMain.setStatusClass(this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass()));
        orderMain.setStatusClassName(OrderStatusClassConstants.getStatusClassName(orderMain.getStatusClass()));
        this.logger.info(orderMain.toString());
    }

    @Override
    public OrderListVo getOrderDetail(String customerId, String orderMainNo, String orderNo) {
        OrderListVo orderListVo = this.orderMainInterface.getOrderMainDetail(customerId, orderMainNo);
        if (orderListVo == null) {
            return null;
        }
        orderListVo.setOrderNo(orderNo);
        this.processOrderInfo(orderListVo);
        List<MallOrderPayEntity> orderPayEntities = this.orderPayInterface.getList(orderMainNo);
        if (orderPayEntities != null) {
            orderListVo.setCouponAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
            orderListVo.setBalanceAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        int productQuantity = 0;
        if (orderListVo.getOrderProductVos() != null) {
            for (MallOrderProductVo orderProductVo : orderListVo.getOrderProductVos()) {
                List<MallOrderGroupProductEntity> orderGroupProductEntities = this.orderGroupProductInterface.getOrderGroupProductList(orderProductVo.getOrderProductId());
                if (orderGroupProductEntities != null) {
                    ArrayList<MallOrderGroupProductVo> orderGroupProductVos = new ArrayList<MallOrderGroupProductVo>();
                    for (MallOrderGroupProductEntity g : orderGroupProductEntities) {
                        MallOrderGroupProductVo orderGroupProductVo = new MallOrderGroupProductVo();
                        MallProductEntity productEntity = this.productInterface.getProduct(g.getProductId());
                        orderGroupProductVo.setProTypeId(productEntity == null ? 0 : productEntity.getProTypeId());
                        orderGroupProductVo.setProType(productEntity == null ? "" : productEntity.getProType());
                        orderGroupProductVo.setGetProductNameEx(productEntity == null ? "" : productEntity.getProNameSx());
                        orderGroupProductVo.setProductId(productEntity == null ? g.getProductId() : productEntity.getProId());
                        orderGroupProductVo.setProductName(productEntity == null ? g.getProductName() : productEntity.getProName());
                        orderGroupProductVo.setTransportType(productEntity == null ? 1 : productEntity.getTransportType());
                        orderGroupProductVos.add(orderGroupProductVo);
                    }
                    orderProductVo.setOrderGroupProductVos(orderGroupProductVos);
                }
                productQuantity += orderProductVo.getQuantity();
            }
            orderListVo.setSubOrderProductQuantity(productQuantity);
        }
        if ((orderListVo.getStatusClass() == 3 || orderListVo.getStatusClass() == 4 || orderListVo.getStatusClass() == 5 || orderListVo.getStatusClass() == 7) && orderListVo.getOrderClass() == OrderClassEnum.MALL_ORDER.getValue()) {
            OrderDeliverRecordVo deliverRecordVo;
            MallOrderPackagePrintrecordEntity packagePrintrecordEntity;
            List<OrderDeliverRecordVo> orderDeliverRecordVos = this.deliverRecordInterface.getDeliverRecordList(orderListVo.getOrderNo());
            if (orderDeliverRecordVos == null) {
                orderDeliverRecordVos = new ArrayList<OrderDeliverRecordVo>();
            }
            if ((packagePrintrecordEntity = this.packagePrintrecordInterface.getSingle(orderNo)) != null && packagePrintrecordEntity.getPrintTime() != null && orderListVo.getWayBillNo() != null) {
                deliverRecordVo = new OrderDeliverRecordVo();
                deliverRecordVo.setContent("\u7269\u6d41\u5355\u53f7\uff1a" + orderListVo.getWayBillNo());
                deliverRecordVo.setCreateTime(DateUtils.getDateFromString((String)packagePrintrecordEntity.getPrintTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                deliverRecordVo.setPushTime(deliverRecordVo.getCreateTime());
                orderDeliverRecordVos.add(deliverRecordVo);
            }
            if (orderDeliverRecordVos.size() == 0) {
                deliverRecordVo = new OrderDeliverRecordVo();
                deliverRecordVo.setContent(orderListVo.getStatusClassName());
                deliverRecordVo.setCreateTime(orderListVo.getCreateTime());
                deliverRecordVo.setPushTime(deliverRecordVo.getCreateTime());
                orderDeliverRecordVos.add(deliverRecordVo);
            }
            orderListVo.setOrderDeliverRecordVos(orderDeliverRecordVos);
        }
        return orderListVo;
    }

    @Override
    public void batchCancelOrder() {
        this.logger.info("*************\u8fdb\u5165\u6279\u91cf\u53d6\u6d88\u8ba2\u5355\u65b9\u6cd5*****batchCancelOrder************");
        int sendMessageSecond = 300;
        int second = 600;
        int size = 50;
        String sendMessageTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)(-sendMessageSecond), (String)"yyyy-MM-dd HH:mm:ss");
        String cancelTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)(-second), (String)"yyyy-MM-dd HH:mm:ss");
        List<CancelOrderVo> cancelOrderVos = this.orderMainInterface.getBacthCancelMainOrderList(sendMessageTime, size);
        String memcacheKey = "lechun_sendmessage_cancelorder_";
        for (CancelOrderVo c : cancelOrderVos) {
            int balanceTime = second / 60 - sendMessageSecond / 60;
            this.logger.info("*************\u8fdb\u5165\u6279\u91cf\u53d6\u6d88\u8ba2\u5355\u65b9\u6cd5********batchCancelOrder*********CreateTime={},cancelTime={}", (Object)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (Object)cancelTime);
            this.logger.info("****************DateUtils.getDateDiffSecond(DateUtils.formatDate(c.getCreateTime(),\"yyyy-MM-dd HH:mm:ss\"),cancelTime)>=0**********res={}", (Object)(DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)cancelTime) >= 0L ? 1 : 0));
            if (DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)cancelTime) >= 0L) {
                BaseJsonVo baseJsonVo = this.cancelCustomerOrder(c.getCustomerId(), c.getOrderMainNo(), 2);
                MallOrderRecordEntity orderRecordEntity = new MallOrderRecordEntity();
                orderRecordEntity.setOrderMainNo(c.getOrderMainNo());
                orderRecordEntity.setCancelCount(c.getIsExists() + 1);
                if (c.getIsExists() == 0) {
                    this.orderRecordInterface.insert(orderRecordEntity);
                    continue;
                }
                orderRecordEntity.setRecordId(c.getRecordId());
                this.orderRecordInterface.update(orderRecordEntity);
                continue;
            }
            if (this.memcachedService.get("", memcacheKey + c.getOrderMainNo()) != null) continue;
            CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(c.getCustomerId(), c.getPlatformId());
            if (customerDetailVo != null && customerDetailVo.getOpenId() != null && !customerDetailVo.getOpenId().isEmpty()) {
                this.memcachedService.set("", memcacheKey + c.getOrderMainNo(), (Object)c);
                continue;
            }
            WeiXinKeywordEntity keywordEntity = this.keywordInterface.getKeywordByKeyword("ordertopaymessage", c.getPlatformId());
            if (keywordEntity == null) {
                this.memcachedService.set("", memcacheKey + c.getOrderMainNo(), (Object)c);
                return;
            }
            String content = keywordEntity.getTitle();
            content = MessageFormat.format(content.replace("'", "''"), customerDetailVo.getNickName(), balanceTime);
            this.messageInterface.sendCustomerTextMessage(customerDetailVo.getOpenId(), c.getPlatformId(), content, 0);
            this.memcachedService.set("", memcacheKey + c.getOrderMainNo(), (Object)c);
        }
    }

    @Override
    public BaseJsonVo deleteCustomerOrder(String customerId, String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.defineFiledHandleInterface.deleteOrderBefore(customerId, orderMainNo);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (customerId == null || customerId.isEmpty()) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!customerId.equals(orderMainEntity.getCustomerId())) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0e\u8ba2\u5355\u4e0d\u4e00\u81f4");
        }
        if (orderMainEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
        }
        if (!this.orderMainInterface.deleteOrderMain(orderMainNo, customerId)) {
            return BaseJsonVo.error((String)"\u5220\u9664\u8ba2\u5355\u5931\u8d25");
        }
        this.defineFiledHandleInterface.deleteOrderAfter(customerId, orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo autoConfirmGoods() {
        this.logger.info(this.autoConfirmDays.toString());
        this.logger.info(String.valueOf(0 - this.autoConfirmDays));
        this.logger.info(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)).toString());
        this.logger.info(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)), (String)"yyyy-MM-dd"));
        this.logger.info(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)), (String)"yyyy-MM-dd") + " 00:00:00");
        this.logger.info(DateUtils.getDateFromString((String)(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)), (String)"yyyy-MM-dd") + " 00:00:00")).toString());
        Date fifteenDaysAgo = DateUtils.getDateFromString((String)(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)), (String)"yyyy-MM-dd") + " 00:00:00"));
        List<Map<String, String>> orders = this.orderInterface.getUnConfirmedOrders(fifteenDaysAgo);
        orders.forEach(order -> this.confirmGoods((String)order.get("CUSTOMER_ID"), (String)order.get("ORDER_MAIN_NO"), (String)order.get("ORDER_NO")));
        return BaseJsonVo.success(null);
    }

    @Override
    @Transactional
    public BaseJsonVo confirmGoods(String customerId, String orderMainNo, String orderNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.defineFiledHandleInterface.confirmGoodsBefore(customerId, orderMainNo, orderNo);
        if (orderMainEntity == null || !orderMainEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        ArrayList sqlUpdate = new ArrayList();
        List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainNo);
        if (orderList == null || orderList.size() == 0) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        boolean isAllComplete = true;
        boolean success = false;
        try {
            for (MallOrderEntity order : orderList) {
                int statusSubClass = this.orderInterface.getStatusClass(order.getStatus(), order.getEvaluateStatus(), orderMainEntity.getOrderClass());
                if (StringUtils.isNotEmpty((String)orderNo)) {
                    if (orderNo.equals(order.getOrderNo()) && statusSubClass == 3) {
                        success = this.orderInterface.updateOrderStatus(orderNo, OrderStatusEnum.COMPLETION.getName(), customerId, order.getStatus());
                        if (!success) {
                            throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
                        }
                        statusSubClass = 4;
                    }
                } else if (statusSubClass == 3) {
                    success = this.orderInterface.updateOrderStatus(order.getOrderNo(), OrderStatusEnum.COMPLETION.getName(), customerId, order.getStatus());
                    if (!success) {
                        throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
                    }
                    statusSubClass = 4;
                }
                if (statusSubClass != 0 && statusSubClass != 1 && statusSubClass != 2 && statusSubClass != 3) continue;
                isAllComplete = false;
            }
            if (isAllComplete && !(success = this.orderMainInterface.updateOrderMainStatus(orderMainNo, OrderStatusEnum.COMPLETION.getName(), customerId, orderMainEntity.getStatus()))) {
                throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
            }
            this.defineFiledHandleInterface.confirmGoodsAfter(orderMainEntity, orderNo);
            return BaseJsonVo.success((Object)"\u786e\u8ba4\u6536\u8d27\u6210\u529f");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.logger.error("user:" + customerId + ",\u4e3b\u8ba2\u5355\uff1a" + orderMainNo + ",\u5b50\u8ba2\u5355\uff1a" + orderNo + ",\u5f02\u5e38\uff1a" + e.getMessage());
            return BaseJsonVo.error((String)"\u786e\u8ba4\u6536\u8d27\u5931\u8d25");
        }
    }

    public int getTransportType(List<MallOrderCacheInItemVo> itemVoList) {
        int type = 0;
        boolean normatTransport = false;
        if (itemVoList == null || itemVoList.size() == 0) {
            this.logger.error("\u8f93\u5165\u5546\u54c1\u96c6\u5408\u4e3a\u4e3a\u7a7a");
            return type;
        }
        block16: for (MallOrderCacheInItemVo vo : itemVoList) {
            this.logger.info("\u4fc3\u9500\u7c7b\u578b\u4e3a:" + vo.getItemType() + ",\u4fc3\u9500id=" + vo.getItemId());
            if (vo.getItemType() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                type = this.getType(vo.getItemId());
                switch (type) {
                    case 1: {
                        continue block16;
                    }
                    case 2: {
                        normatTransport = true;
                        continue block16;
                    }
                }
                continue;
            }
            if (vo.getItemType() == SalesTypeEnum.SALES_GROUP.getValue()) {
                List<MallProductEntity> list = this.productInterface.getProductListByGroupId(vo.getItemId());
                type = this.getType(list);
                switch (type) {
                    case 1: {
                        continue block16;
                    }
                    case 2: {
                        normatTransport = true;
                        break;
                    }
                }
                continue;
            }
            if (vo.getItemType() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                MallPromotionProductEntity mallPromotionProductEntity = this.mallPromotionProductInterface.getPromotionProductEntity(vo.getItemId());
                this.logger.info("\u4fc3\u9500\u7ed1\u5b9a\u5957\u88c5\u7c7b\u578b:" + Integer.valueOf(mallPromotionProductEntity.getProductType()));
                if (mallPromotionProductEntity != null) {
                    if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(mallPromotionProductEntity.getProductType()).intValue()) {
                        List<MallProductEntity> list = this.productInterface.getProductListByGroupId(mallPromotionProductEntity.getProductId());
                        type = this.getType(list);
                        switch (type) {
                            case 1: {
                                continue block16;
                            }
                            case 2: {
                                normatTransport = true;
                                break;
                            }
                        }
                        continue;
                    }
                    if (SalesTypeEnum.SALES_PRODUCT.getValue() != Integer.valueOf(mallPromotionProductEntity.getProductType()).intValue()) continue;
                    type = this.getType(mallPromotionProductEntity.getProductId());
                    switch (type) {
                        case 1: {
                            continue block16;
                        }
                        case 2: {
                            normatTransport = true;
                            break;
                        }
                    }
                    continue;
                }
                this.logger.error("\u4fc3\u9500id\u4e0d\u5b58\u5728,promotionId=" + vo.getItemId());
                throw new RuntimeException("\u4fc3\u9500\u4e0d\u5b58\u5728");
            }
            this.logger.error("\u65e0\u6548\u7684\u7c7b\u578b, ItemType=" + vo.getItemType());
            throw new RuntimeException("\u65e0\u6548\u7684\u7c7b\u578b");
        }
        if (normatTransport && type == 3) {
            type = 2;
        }
        return type;
    }

    private int getType(String productId) {
        int type = 0;
        Integer transportType = this.productInterface.getProduct(productId).getTransportType();
        if (transportType != null) {
            if (TransportTypeEnum.COLD_CHAIN.getValue() == transportType.intValue()) {
                type = 1;
            } else if (TransportTypeEnum.NORMAL_CHAIN.getValue() == transportType.intValue()) {
                type = 2;
            } else if (TransportTypeEnum.ONLINE_SEND.getValue() == transportType.intValue()) {
                type = 3;
            }
        }
        return type;
    }

    private int getType(List<MallProductEntity> list) {
        int type = 0;
        boolean normatTransport = false;
        for (MallProductEntity item : list) {
            this.logger.info("\u904d\u5386\u5957\u88c5\u4ea7\u54c1:" + item.getProId());
            type = this.getType(item.getProId());
            this.logger.info("\u904d\u5386\u5957\u88c5\u4ea7\u54c1,type=" + type);
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    normatTransport = true;
                    break;
                }
            }
        }
        if (normatTransport && type == 3) {
            type = 2;
        }
        this.logger.info("\u8fd4\u56de\u503c,type=" + type);
        return type;
    }
}

