/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.defineFieldHandle;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.iservice.active.GiftInterface;
import cc.lechun.active.service.sales.ActiveSaleContext;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.constants.message.MessageActionConstants;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.open.SmsUtil;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.sales.MallPromotionBuyEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntitiesVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageQueueInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.service.thirdparty.OldApiUtil;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DefineFiledHandleService
extends BaseService
implements DefineFiledHandleInterface {
    @Autowired
    private GiftInterface giftInterface;
    @Autowired
    private MallOrderMessageQueueInterface messageQueueService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeService;
    @Autowired
    private DeliverInterface deliverInterface;
    @Autowired
    private OldApiUtil oldApiUtil;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    @Lazy
    private ActiveInterface activeInterface;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private ActiveSaleContext activeContext;
    @Autowired
    private MallOrderProductInterface mallOrderProductInterface;
    @Autowired
    private MallPromotionBuyInterface mallPromotionBuyInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallPromotionTimeInterface promotionTimeService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private RedisService redisService;

    @Override
    public BaseJsonVo setCache(int platFormId, String customerId, String cacheId, MallOrderCacheInVo cacheInVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo toPayPage(MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createOrderBefore(MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createOrderBefore(MallOrderEntitiesVo orderEntitiesVo, MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo createOrderBefore(String customerId, Integer orderSource, String bindCode) {
        try {
            ActiveSaleHandle activeHandle;
            ActiveEntity activeEntity;
            if (orderSource != null && StringUtils.isNotEmpty((String)bindCode) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode)) != null && (activeHandle = this.activeContext.getActiveHanle(String.valueOf(activeEntity.getActiveType()))) != null) {
                BaseJsonVo baseJsonVo = activeHandle.checkCanJoin(customerId, bindCode);
                return baseJsonVo;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo createOrderBefore(String customerId, Integer orderSource, String bindCode, MallMainOrderVo mainOrderVo) {
        try {
            ActiveSaleHandle activeHandle;
            ActiveEntity activeEntity;
            if (orderSource != null && StringUtils.isNotEmpty((String)bindCode) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode)) != null && (activeHandle = this.activeContext.getActiveHanle(String.valueOf(activeEntity.getActiveType()))) != null) {
                BaseJsonVo baseJsonVo = activeHandle.checkCanJoin(customerId, bindCode, mainOrderVo);
                return baseJsonVo;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createOrderBeforeWithTransaction(MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createOrderAfterWithTransaction(MallMainOrderVo mainOrderVo, boolean createSuccess) {
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo createOrderAfter(MallMainOrderVo mainOrderVo, MallOrderCacheVo orderCacheVo, boolean createSuccess) {
        this.messageQueueService.sendCommitOrderQueue(mainOrderVo);
        try {
            ActiveSaleHandle activeHandle;
            ActiveEntity activeEntity;
            if (StringUtils.isNotEmpty((String)orderCacheVo.getBindCode()) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(orderCacheVo.getBindCode())) != null && (activeHandle = this.activeContext.getActiveHanle(String.valueOf(activeEntity.getActiveType()))) != null) {
                activeHandle.afterCreateOrder(orderCacheVo, mainOrderVo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo orderPayBefore(String orderMainNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo orderPayAfter(String orderMainNo) {
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo orderPaySuccessAfter(String orderMainNo) {
        this.logger.info("\u652f\u4ed8\u6210\u529f\u7684\u4e8b\u4ef6\u5f00\u59cb:" + orderMainNo);
        try {
            Integer activeType = 0;
            MallOrderMainEntity mallOrderEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            if (StringUtils.isNotEmpty((String)mallOrderEntity.getBindCode())) {
                this.redisService.sadd(mallOrderEntity.getBindCode() + ":customer", mallOrderEntity.getCustomerId());
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(mallOrderEntity.getBindCode());
                activeType = activeEntity.getActiveType();
            }
            this.mallOrderInterface.edbOrderSync(orderMainNo);
            if (mallOrderEntity.getOrderClass().intValue() == OrderClassEnum.ACTIVE_ORDER.getValue() || mallOrderEntity.getOrderClass().intValue() == OrderClassEnum.CROWD_ORDER.getValue()) {
                this.oldApiUtil.activePaySuccessRecord(orderMainNo, mallOrderEntity.getCustomerId());
            }
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u652f\u4ed8\u6210\u529f\u6d88\u606f\u961f\u5217,\u8ba2\u5355\u53f7:{},\u6d3b\u52a8\u7c7b\u578b:{}", (Object)orderMainNo, (Object)activeType);
            this.messageQueueService.sendPaySuccessOrderQueue(mallOrderEntity, activeType);
            BaseJsonVo jsonVo = this.deliverInterface.createPrepositionOrder(orderMainNo);
            if (!jsonVo.isSuccess()) {
                String msg_id = RandomUtils.generateId() + "";
                SmsUtil.sendSms((String)"18612713230", (String)(orderMainNo + "\u8ba2\u5355\u524d\u7f6e\u4ed3\u4e0b\u5355\u5931\u8d25" + String.valueOf(jsonVo.getValue())), (String)msg_id);
                this.oldApiUtil.orderRefund(orderMainNo, "", "\u7f8e\u56e2\u4e0b\u5355\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + String.valueOf(jsonVo.getValue()), 1, mallOrderEntity.getOrderAmount().intValue());
                CustomerEntity customerEntity = this.customerService.getCustomer(mallOrderEntity.getCustomerId());
                HashMap<String, String> map = new HashMap<String, String>();
                if (Integer.valueOf(String.valueOf(jsonVo.getValue())) < 12) {
                    map.put("reason", "\u7cfb\u7edf\u539f\u56e0");
                } else {
                    map.put("reason", "\u8ba2\u5355\u8c03\u5ea6\u539f\u56e0");
                }
                this.messageService.sendWechatMessage((int)mallOrderEntity.getPlatformId(), MessageActionConstants.prepositionFail, customerEntity.getChannelCustomerId(), map);
            }
        }
        catch (Exception e) {
            this.logger.error("\u652f\u4ed8\u540e\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        this.logger.info("\u652f\u4ed8\u6210\u529f\u7684\u4e8b\u4ef6\u7ed3\u675f:" + orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo cancelOrderBefore(String customerId, String orderMainNo, int cancelSource) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo cancelOrderAfter(String customerId, String orderMainNo, int cancelSource) {
        List<MallOrderProductEntity> mallOrderProductEntityList = this.mallOrderProductInterface.getOrderProductInfoByOrderMianNoPromotion(orderMainNo);
        if (mallOrderProductEntityList.size() > 0) {
            int i;
            ArrayList<String> promotionIdList = new ArrayList<String>();
            ArrayList<MallPromotionBuyEntity> mallPromotionBuyEntityList = new ArrayList<MallPromotionBuyEntity>();
            for (MallOrderProductEntity mallOrderProductEntity : mallOrderProductEntityList) {
                MallPromotionBuyEntity promotionBuyEntity = new MallPromotionBuyEntity();
                promotionBuyEntity.setPromotionId(mallOrderProductEntity.getPromotionId());
                promotionBuyEntity.setBuyCount(-mallOrderProductEntity.getQuantity().intValue());
                promotionBuyEntity.setCreateTime(DateUtils.now());
                mallPromotionBuyEntityList.add(promotionBuyEntity);
                promotionIdList.add(mallOrderProductEntity.getPromotionId());
            }
            if (mallPromotionBuyEntityList != null && mallPromotionBuyEntityList.size() > 0 && (i = this.mallPromotionBuyInterface.insertPromotionBuyBatch(mallPromotionBuyEntityList)) > 0 && promotionIdList.size() > 0 && promotionIdList != null) {
                for (String promotionId : promotionIdList) {
                    MallPromotionEntity promotionEntity = this.promotionService.getPromotion(promotionId);
                    MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionId, DateUtils.date());
                    if (promotionTimeEntity != null && promotionEntity != null) {
                        Date beginTime = promotionTimeEntity.getBeginTime();
                        Date endTime = promotionTimeEntity.getEndTime();
                        if (promotionEntity.getPromotionType() == 2) {
                            beginTime = DateUtils.currentDate();
                            endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
                        }
                        this.mallPromotionBuyInterface.clearPromotionBuyCache(promotionId, beginTime, endTime);
                    }
                    this.memcachedService.delete("promotionEntity", promotionId);
                }
            }
        }
        this.messageQueueService.sendCancelOrderQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteOrderBefore(String customerId, String orderMainNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteOrderAfter(String customerId, String orderMainNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo confirmGoodsBefore(String customerId, String orderMainNo, String orderNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo confirmGoodsAfter(String customerId, String orderMainNo, String orderNo) {
        MallOrderMainEntity mallOrderEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        return this.confirmGoodsAfter(mallOrderEntity, orderNo);
    }

    @Override
    public BaseJsonVo confirmGoodsAfter(MallOrderMainEntity orderMainEntity, String orderNo) {
        try {
            this.messageQueueService.sendConfirmGoodsQueue(orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo(), orderNo);
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u786e\u8ba4\u6536\u8d27\u51fa\u9519,\u8ba2\u5355\u53f7:{},\u7528\u6237customerId={}", new Object[]{orderMainEntity.getOrderMainNo(), orderMainEntity.getCustomerId(), e});
            throw new RuntimeException(e);
        }
    }

    @Override
    public BaseJsonVo TakeGoodAfter(String orderMainNo) {
        this.messageQueueService.sendDeliverGoodsQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo RefundApplyAfter(String orderMainNo) {
        this.messageQueueService.sendRefundApplyQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo RefundAfter(String orderMainNo) {
        this.messageQueueService.sendRefundQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }
}

