/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.domain;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.organization.dao.VoteMapper;
import cc.lechun.organization.entity.VoteEntity;
import cc.lechun.organization.idomain.IOrgVoteDomain;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgVoteDomain
extends BaseService
implements IOrgVoteDomain {
    @Autowired
    private VoteMapper voteMapper;
    @Autowired
    private IOrgVoteDomain orgVoteDomain;

    @Override
    public boolean checkStandard(String paperId, Integer voteType, Integer periodId, Integer questionClassId) {
        try {
            Integer total = this.orgVoteDomain.getTotalNum(periodId, questionClassId, voteType);
            this.logger.info("\u5206\u7c7b:{},\u671f\u6b21:{},\u7c7b\u578b:{},\u603b\u7968\u6570:{}", new Object[]{questionClassId, periodId, voteType, total});
            Integer num = this.getTotalNum(paperId, voteType);
            this.logger.info("\u62a5\u544a:{},\u603b\u7968\u6570:{}", (Object)paperId, (Object)total);
            return total > 0 ? this.checkStandard(num, total) : false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u68c0\u67e5\u62a5\u544a\u662f\u5426\u5408\u683c\u51fa\u9519,paperId={},voteType={},periodId={},questionClassId={}", new Object[]{paperId, voteType, periodId, questionClassId});
            return false;
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="OrgVoteDomain.getTotalNum", expiration=300)
    public Integer getTotalNum(@ParameterValueKeyProvider(order=0) Integer periodId, @ParameterValueKeyProvider(order=1) Integer questionClassId, @ParameterValueKeyProvider(order=2) Integer voteType) {
        VoteEntity queryVoteEntity = new VoteEntity();
        queryVoteEntity.setVoteType(voteType);
        queryVoteEntity.setPeriodId(periodId);
        queryVoteEntity.setQuestionClassId(questionClassId);
        return this.getTotalNum(queryVoteEntity);
    }

    @Override
    public Integer getTotalNum(String paperId, Integer voteType) {
        VoteEntity queryVoteEntity = new VoteEntity();
        queryVoteEntity.setVoteType(voteType);
        queryVoteEntity.setPaperId(paperId);
        return this.getTotalNum(queryVoteEntity);
    }

    private Integer getTotalNum(VoteEntity voteEntity) {
        return this.voteMapper.getTotalNum(voteEntity);
    }

    @Override
    public VoteEntity getVoteEntity(VoteEntity voteEntity) {
        return (VoteEntity)this.voteMapper.getSingle(voteEntity);
    }

    @Override
    public List<VoteEntity> getVoteList(VoteEntity voteEntity) {
        return this.voteMapper.getList(voteEntity);
    }

    @Override
    public List<Map<String, Object>> getRankingList(Integer periodId, Integer questionClassId, String userId, Integer voteType) {
        return this.voteMapper.getRankingList(periodId, questionClassId, userId, voteType);
    }

    @Override
    public List<Map<String, Object>> getAcceptGratefulList(Integer periodId, Integer questionType) {
        return this.voteMapper.getAcceptGratefulList(periodId, questionType);
    }

    @Override
    public List<Map<String, Object>> getGratefulList(Integer periodId, Integer questionType) {
        return this.voteMapper.getGratefulList(periodId, questionType);
    }

    @Override
    public Integer getVoteStatus(String userId, String paperId, Integer voteType) {
        VoteEntity voteEntity = new VoteEntity();
        voteEntity.setPaperId(paperId);
        voteEntity.setUserId(userId);
        VoteEntity resultVoteEntity = (VoteEntity)this.voteMapper.getSingle(voteEntity);
        if (resultVoteEntity != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public BaseJsonVo saveVote(VoteEntity voteEntity) {
        BaseJsonVo baseJsonVo;
        VoteEntity queryVote = new VoteEntity();
        queryVote.setPaperId(voteEntity.getPaperId());
        queryVote.setVoteUserId(voteEntity.getVoteUserId());
        queryVote.setVoteType(voteEntity.getVoteType());
        if (this.voteMapper.existsByEntity(queryVote) > 0 && (baseJsonVo = this.removeVote(voteEntity.getVoteUserId(), voteEntity.getPaperId(), voteEntity.getVoteType())).isSuccess()) {
            voteEntity.setCreateTime(DateUtils.now());
            return this.voteMapper.insertSelective(voteEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        voteEntity.setCreateTime(DateUtils.now());
        return this.voteMapper.insertSelective(voteEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo removeVote(String userId, String paperId, Integer voteType) {
        VoteEntity voteEntity = new VoteEntity();
        voteEntity.setPaperId(paperId);
        voteEntity.setVoteUserId(userId);
        voteEntity.setVoteType(voteType);
        VoteEntity resultVoteEntity = (VoteEntity)this.voteMapper.getSingle(voteEntity);
        if (resultVoteEntity != null) {
            return this.voteMapper.deleteByPrimaryKey(resultVoteEntity.getId()) > 0 ? BaseJsonVo.success((Object)"\u70b9\u8d5e\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return BaseJsonVo.error((String)"\u70b9\u8d5e\u8bb0\u5f55\u4e0d\u5b58\u5728");
    }

    private boolean checkStandard(int a, int b) {
        return new BigDecimal((float)a / (float)b).setScale(2, 4).doubleValue() * 100.0 >= 60.0;
    }
}

