/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerRelationEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerRelationDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgPaperAnswerRelationService
extends BaseService
implements IOrgPaperAnswerRelationService {
    @Autowired
    private IOrgPaperAnswerRelationDomain relationDomain;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgQuestionDomain questionDomain;

    @Override
    public BaseJsonVo savePaperAnswerRelation(Integer questionType, PaperAnswerEntity answerEntity, List<PaperAnswerRelationEntity> relationEntityList) {
        PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
        search.setAnswerId(answerEntity.getId());
        List<PaperAnswerRelationEntity> relationEntities = this.relationDomain.getList(search);
        this.relationDomain.delete(answerEntity.getId());
        for (PaperAnswerRelationEntity r : relationEntityList) {
            Optional<PaperAnswerRelationEntity> entity;
            MallUserEntity userEntity;
            r.setAnswerId(answerEntity.getId());
            r.setQuestionId(answerEntity.getQuestionId());
            QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
            r.setQuestionName(questionEntity.getQuestionName());
            r.setCreateTime(new Date());
            r.setIsnew(1);
            r.setIsAnswer(0);
            if (r.getContent() != null) {
                r.setContent(r.getContent().replaceAll("[\\r]", "<br/>").replace("\n", "<br/>"));
            }
            if ((userEntity = this.userInterface.getMallUser(r.getRelationUserId())) != null) {
                r.setRelationUserName(userEntity.getUserNick());
            }
            if ((entity = relationEntities.stream().filter(c -> c.getRelationUserId().equals(r.getRelationUserId())).findFirst()).isPresent()) {
                r.setAnswerContent(entity.get().getAnswerContent());
                r.setAnswerTime(entity.get().getAnswerTime());
                r.setIsAnswer(entity.get().getIsAnswer());
            }
            this.relationDomain.insert(r);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveAnswer(String userId, Integer relationId, String content) {
        PaperAnswerRelationEntity relationEntity = this.relationDomain.select(relationId);
        if (relationEntity == null) {
            return BaseJsonVo.error((String)"\u95ee\u9898\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u56de\u590d");
        }
        if (!userId.equals(relationEntity.getRelationUserId())) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u95ee\u9898\uff0c\u60a8\u65e0\u6743\u56de\u590d");
        }
        if (relationEntity.getIsAnswer() == 1) {
            return BaseJsonVo.error((String)"\u5df2\u7ecf\u56de\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u56de\u590d");
        }
        if (content.trim().isEmpty()) {
            return BaseJsonVo.error((String)"\u56de\u590d\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (content.length() > 5000) {
            return BaseJsonVo.error((String)"\u56de\u590d\u5185\u5bb9\u8d85\u957f");
        }
        PaperAnswerRelationEntity updateEntity = new PaperAnswerRelationEntity();
        updateEntity.setId(relationId);
        updateEntity.setIsAnswer(1);
        updateEntity.setAnswerContent(content);
        updateEntity.setAnswerTime(new Date());
        this.relationDomain.update(updateEntity);
        return BaseJsonVo.success((Object)"\u56de\u590d\u6210\u529f");
    }
}

