/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.OptionVo;
import cc.lechun.organization.entity.PaperAnswerEditVo;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerLookVo;
import cc.lechun.organization.entity.PaperAnswerRelationEntity;
import cc.lechun.organization.entity.PaperAnswerRelationVo;
import cc.lechun.organization.entity.PaperAnswerUrlVo;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperAnswerRelationDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import cc.lechun.organization.iservice.IOrgPaperAnswerService;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgPaperAnswerService
extends BaseService
implements IOrgPaperAnswerService {
    @Autowired
    private IOrgPaperAnswerDomain orgPaperAnswerDomain;
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IOrgQuestionDomain questionDomain;
    @Autowired
    private IOrgPaperAnswerRelationDomain relationDomain;
    @Autowired
    private IOrgPaperAnswerRelationService relationService;
    @Autowired
    private IOrgPermittedUsersService permittedUsersService;
    @Autowired
    private IOrgQuestionClassDomain questionClassDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private SysUserInterface userInterface;

    @Override
    @Transactional
    public BaseJsonVo savePaperAnswer(List<PaperAnswerEntity> answerEntities) throws RuntimeException {
        if (answerEntities != null) {
            if (answerEntities.size() > 0) {
                PaperEntity paperEntity = this.orgPaperDomain.select(answerEntities.get(0).getPaperId());
                if (paperEntity == null) {
                    throw new RuntimeException("\u95ee\u5377\u4e0d\u5b58\u5728");
                }
                if (!paperEntity.getUserId().equals(answerEntities.get(0).getUserId())) {
                    throw new RuntimeException("\u60a8\u65e0\u6743\u586b\u5199\u8be5\u95ee\u5377");
                }
                if (!this.periodService.isInPeriodWithDelay(paperEntity.getPeriodId()).isSuccess()) {
                    throw new RuntimeException("\u975e\u5f53\u524d\u671f\u6b21\uff0c\u4e0d\u80fd\u4fdd\u5b58");
                }
            }
            Integer questionClassId = null;
            for (PaperAnswerEntity answerEntity : answerEntities) {
                QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
                if (questionEntity == null) {
                    throw new RuntimeException("\u95ee\u9898\u4e0d\u5b58\u5728");
                }
                if (questionEntity.getStatus() != 1) {
                    throw new RuntimeException("\u95ee\u9898[" + questionEntity.getQuestionName() + "]\u5df2\u7981\u7528");
                }
                if (answerEntities.size() > 1 && questionEntity.getRequired() == 1 && StringUtils.isEmpty((String)answerEntity.getAnswer().replace("[", "").replace("]", ""))) {
                    throw new RuntimeException("\u95ee\u9898[" + questionEntity.getQuestionName() + "]\u5fc5\u586b");
                }
                questionClassId = questionEntity.getQuestionClassId();
                PaperAnswerEntity ans = this.getSingle(answerEntity.getPaperId(), answerEntity.getQuestionId(), answerEntity.getUserId());
                if (ans != null) {
                    answerEntity.setId(ans.getId());
                    this.orgPaperAnswerDomain.update(answerEntity);
                    continue;
                }
                answerEntity.setId(IDGenerate.getUniqueIdStr());
                this.orgPaperAnswerDomain.insert(answerEntity);
            }
            this.savePaperAnswerRelation(answerEntities.get(0).getPaperId());
            this.updatePaper(answerEntities.get(0).getPaperId(), questionClassId);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public BaseJsonVo updatePaper(String paperId, Integer questionClassId) {
        boolean alreadyWrite = true;
        PaperAnswerEntity search = new PaperAnswerEntity();
        search.setPaperId(paperId);
        List<PaperAnswerEntity> answerEntities = this.orgPaperAnswerDomain.getList(search);
        List<QuestionEntity> questionEntities = this.questionDomain.getQuestionList(questionClassId, 1);
        questionEntities = questionEntities.stream().filter(c -> c.getRequired() == 1).collect(Collectors.toList());
        for (QuestionEntity questionEntity : questionEntities) {
            Optional<PaperAnswerEntity> answerEntity = answerEntities.stream().filter(c -> c.getQuestionId().intValue() == questionEntity.getId().intValue()).findFirst();
            if (answerEntity.isPresent()) {
                if (!StringUtils.isEmpty((String)answerEntity.get().getAnswer().replace("[", "").replace("]", ""))) continue;
                alreadyWrite = false;
                continue;
            }
            alreadyWrite = false;
        }
        PaperEntity updatePaper = new PaperEntity();
        updatePaper.setId(answerEntities.get(0).getPaperId());
        if (alreadyWrite) {
            updatePaper.setStatus(1);
            PaperEntity paperEntity = this.orgPaperDomain.select(answerEntities.get(0).getPaperId());
            if (paperEntity != null && paperEntity.getUpdateTime() == null) {
                updatePaper.setUpdateTime(new Date());
            }
        } else {
            updatePaper.setStatus(0);
            updatePaper.setUpdateTime(null);
        }
        this.orgPaperDomain.update(updatePaper);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo savePaperAnswerRelation(String paperId) {
        PaperAnswerEntity search = new PaperAnswerEntity();
        search.setPaperId(paperId);
        List<PaperAnswerEntity> answerEntities = this.orgPaperAnswerDomain.getList(search);
        for (PaperAnswerEntity answerEntity : answerEntities) {
            QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
            if (questionEntity.getQuestionType() != 4 && questionEntity.getQuestionType() != 5) continue;
            ArrayList<PaperAnswerRelationEntity> relationEntities = new ArrayList();
            if (!StringUtils.isNotEmpty((String)answerEntity.getAnswer())) continue;
            if (questionEntity.getQuestionType() == 5) {
                try {
                    relationEntities = JsonUtils.getListByArray(PaperAnswerRelationEntity.class, (String)answerEntity.getAnswer());
                    this.relationService.savePaperAnswerRelation(questionEntity.getQuestionType(), answerEntity, relationEntities);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            QuestionEntity searchQuestion = new QuestionEntity();
            searchQuestion.setRelationQuestionId(answerEntity.getQuestionId());
            List<QuestionEntity> questionEntities = this.questionDomain.getList(searchQuestion);
            StringBuilder sb = new StringBuilder();
            for (QuestionEntity q : questionEntities) {
                List relationAnswers = answerEntities.stream().filter(c -> c.getQuestionId().equals(q.getId())).collect(Collectors.toList());
                for (PaperAnswerEntity relationAnswer : relationAnswers) {
                    sb.append("Q\uff1a" + q.getQuestionName());
                    sb.append("<br/>");
                    sb.append("A\uff1a" + relationAnswer.getAnswer());
                    sb.append("<br/>");
                }
            }
            PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
            relationEntity.setAnswerId(answerEntity.getId());
            relationEntity.setCreateTime(new Date());
            relationEntity.setRelationUserId(answerEntity.getAnswer());
            relationEntity.setContent(sb.toString());
            relationEntities.add(relationEntity);
            this.relationService.savePaperAnswerRelation(questionEntity.getQuestionType(), answerEntity, relationEntities);
        }
        return BaseJsonVo.success((Object)"");
    }

    public PaperAnswerEntity getSingle(String paperId, Integer questionId, String userId) {
        PaperAnswerEntity answerEntity = new PaperAnswerEntity();
        answerEntity.setPaperId(paperId);
        answerEntity.setQuestionId(questionId);
        answerEntity.setUserId(userId);
        return this.orgPaperAnswerDomain.getSingle(answerEntity);
    }

    public boolean exists(String paperId, Integer questionId, String userId) {
        PaperAnswerEntity answerEntity = new PaperAnswerEntity();
        answerEntity.setPaperId(paperId);
        answerEntity.setQuestionId(questionId);
        answerEntity.setUserId(userId);
        return this.orgPaperAnswerDomain.exists(answerEntity);
    }

    @Override
    public BaseJsonVo getPaperAnswerList(Integer questionClass, String paperId) {
        PaperEntity paperEntity = this.orgPaperDomain.select(paperId);
        if (paperEntity == null) {
            return BaseJsonVo.error((String)"\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        List<PaperAnswerEditVo> editVos = this.orgPaperAnswerDomain.getAnswerQuestion(questionClass, paperId);
        for (PaperAnswerEditVo e : editVos) {
            e.setPaperId(paperId);
            if (e.getQuestionId() == 1 && e.getAnswer() == null) {
                e.setAnswer(this.getLastPeriodField(paperEntity.getUserId(), 6));
            }
            if (e.getQuestionType() != 5) continue;
            List<PaperAnswerRelationEntity> relationEntities = new ArrayList<PaperAnswerRelationEntity>();
            if (e.getId() != null) {
                PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                search.setAnswerId(e.getId());
                relationEntities = this.relationDomain.getList(search);
                for (PaperAnswerRelationEntity r : relationEntities) {
                    r.setContent(r.getContent().replace("<br/>", "\n"));
                }
            }
            if (relationEntities.size() == 0) {
                relationEntities.add(new PaperAnswerRelationEntity());
            }
            e.setRelationEntityList(relationEntities);
        }
        return BaseJsonVo.success(editVos);
    }

    public String getLastPeriodField(String userId, Integer questionId) {
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.getLastPeriod().getValue();
        if (periodEntity != null) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setPeriodId(periodEntity.getId());
            paperEntity.setUserId(userId);
            paperEntity = this.orgPaperDomain.getSingle(paperEntity);
            if (paperEntity != null) {
                PaperAnswerEntity search = new PaperAnswerEntity();
                search.setPaperId(paperEntity.getId());
                search.setQuestionId(questionId);
                search = this.orgPaperAnswerDomain.getSingle(search);
                if (search != null) {
                    return search.getAnswer();
                }
            }
        }
        return "";
    }

    @Override
    public BaseJsonVo relationMe(Integer pageNum, Integer pageSize, String userId, Integer classId, Integer ctype, Integer isself) {
        PageInfo pageInfo = this.orgPaperAnswerDomain.getRelationMe(pageNum, pageSize, userId, classId, ctype, isself);
        List relationVos = pageInfo.getList();
        Long unReadCount = relationVos.stream().filter(c -> c.getIsnew().equals(1)).count();
        if (unReadCount == null) {
            unReadCount = 0L;
        }
        for (PaperAnswerRelationVo v : relationVos.stream().filter(c -> c.getIsnew().equals(1)).collect(Collectors.toList())) {
            v.setUnReadCount(unReadCount);
            PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
            relationEntity.setId(v.getRelationId());
            relationEntity.setIsnew(0);
            this.relationDomain.update(relationEntity);
        }
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public BaseJsonVo lookPaperAnswer(PageForm pageForm, Integer year, Integer period, Integer classId, String userId, Integer questionId) {
        List<QuestionClassEntity> classEntities = this.questionClassDomain.getQuestionClassEntityList(0);
        if (classId == null && questionId == null) {
            return BaseJsonVo.error((String)"\u5206\u7c7b\u548c\u95ee\u9898\u81f3\u5c11\u9009\u62e9\u5176\u4e2d\u4e00\u4e2a\u67e5\u8be2");
        }
        if (classId == null) {
            QuestionEntity questionEntity = this.questionDomain.select(questionId);
            classId = questionEntity == null ? Integer.valueOf(0) : questionEntity.getQuestionClassId();
        }
        ArrayList paperAnswerLookVos = new ArrayList();
        PeriodEntity periodEntity = year == null || period == null ? (PeriodEntity)this.periodService.currentPeriod().getValue() : (PeriodEntity)this.periodService.getPeriodWithNum(year, period).getValue();
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        users.add(userId);
        PageInfo pageInfo = this.orgPaperAnswerDomain.lookPaperAnswer(pageForm.getCurrentPage(), pageForm.getPageSize(), periodEntity.getId(), classId, users, questionId);
        for (PaperAnswerLookVo l : pageInfo.getList()) {
            List urlVos;
            Optional<OptionVo> optionVo;
            List optionVos;
            QuestionEntity questionEntity;
            StringBuilder sb;
            if (l.getQuestionType() == 4 || l.getQuestionType() == 5) {
                PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                search.setAnswerId(l.getId());
                List<PaperAnswerRelationEntity> relationEntities = this.relationDomain.getList(search);
                sb = new StringBuilder();
                for (PaperAnswerRelationEntity r : relationEntities) {
                    sb.append("@");
                    sb.append(r.getRelationUserName());
                    sb.append("<br/>");
                    sb.append(r.getContent());
                }
                l.setAnswer(sb.toString());
            }
            if (l.getQuestionType() == 2 && (questionEntity = this.questionDomain.select(l.getQuestionId())) != null && (optionVos = JsonUtils.getListByArray(OptionVo.class, (String)questionEntity.getQuestionOption())) != null && (optionVo = optionVos.stream().filter(c -> c.getCode().equals(l.getAnswer())).findFirst()).isPresent()) {
                l.setAnswer(optionVo.get().getName());
            }
            if (l.getQuestionType() != 3 || (urlVos = JsonUtils.getListByArray(PaperAnswerUrlVo.class, (String)l.getAnswer())) == null) continue;
            String template = "<a href='%s' target='_blank'>%s</a><br/>";
            sb = new StringBuilder();
            for (PaperAnswerUrlVo u : urlVos) {
                sb.append(String.format(template, u.getUrl(), u.getName()));
            }
            l.setAnswer(sb.toString());
        }
        return BaseJsonVo.success((Object)pageInfo);
    }
}

