/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.MyPaperBonusVo;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperBonusDetailVo;
import cc.lechun.organization.entity.PaperBonusVo;
import cc.lechun.organization.entity.PaperDo;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PaperPageListVo;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.entity.VoteEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.idomain.IOrgVoteDomain;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgPaperService
extends BaseService
implements IOrgPaperService {
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgPermittedUsersService permittedUsersService;
    @Autowired
    private IOrgQuestionClassDomain classDomain;
    @Autowired
    private IOrgPaperService paperService;
    @Autowired
    private IOrgQuestionDomain orgQuestionDomain;
    @Autowired
    private IOrgVoteDomain orgVoteService;
    @Autowired
    private IOrgPaperAnswerDomain orgPaperAnswerDomain;
    private BigDecimal bonuse = new BigDecimal(0);
    private BigDecimal base = new BigDecimal(50);
    private BigDecimal facor = new BigDecimal(25);

    @Override
    public List<PaperBonusVo> getBonusesList(String userId, Integer year, Integer month, Integer questionClassId) {
        String bonusTime = String.format("%s-%s", year.toString(), month > 9 ? month : "0" + month.toString());
        List<PaperBonusVo> list = this.orgPaperDomain.getBonusesList(userId, bonusTime, questionClassId);
        if (list != null && list.size() > 0) {
            list.forEach(b -> b.setEmail(this.userInterface.getMallUser(b.getUserId()).getUserName()));
        }
        return list;
    }

    @Override
    public MyPaperBonusVo getMyBonusesList(String userId, Integer year, Integer month, Integer questionClassId) {
        String bonusTime = String.format("%s-%s", year.toString(), month > 9 ? month : "0" + month.toString());
        List<PaperBonusVo> list = this.orgPaperDomain.getBonusesList(userId, bonusTime, questionClassId);
        MyPaperBonusVo myPaperBonusVo = new MyPaperBonusVo();
        if (list != null && list.size() > 0) {
            PaperBonusVo paperBonusVo = list.get(0);
            BeanUtils.copyProperties((Object)paperBonusVo, (Object)myPaperBonusVo);
            QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(questionClassId);
            myPaperBonusVo.setClassName(questionClassEntity == null ? "" : questionClassEntity.getClassName());
            myPaperBonusVo.setEmail(this.userInterface.getMallUser(paperBonusVo.getUserId()).getUserName());
            return myPaperBonusVo;
        }
        return myPaperBonusVo;
    }

    @Override
    public List<PaperBonusDetailVo> getPaperBonusDetaiList(String userId, Integer year, Integer month, Integer questionClassId, Integer reportStatus) {
        Calendar c1 = Calendar.getInstance();
        c1.set(year, month - 1, 1, 0, 0, 0);
        c1.getTime();
        Date start = c1.getTime();
        Calendar c2 = Calendar.getInstance();
        c2.set(year, month, 1, 0, 0, 0);
        Date end = c2.getTime();
        List<PaperEntity> list = this.orgPaperDomain.getPaperBonusDetaiList(userId, start, end, questionClassId, reportStatus);
        ArrayList<PaperBonusDetailVo> resultList = new ArrayList<PaperBonusDetailVo>();
        if (list != null && list.size() > 0) {
            list.forEach(b -> {
                PaperBonusDetailVo paperBonusDetailVo = new PaperBonusDetailVo();
                BeanUtils.copyProperties((Object)b, (Object)paperBonusDetailVo);
                QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(b.getQuestionClassId());
                paperBonusDetailVo.setClassName(questionClassEntity == null ? "" : questionClassEntity.getClassName());
                resultList.add(paperBonusDetailVo);
            });
        }
        return resultList;
    }

    @Override
    public void calculateBonuses() {
        try {
            PeriodEntity perPeriodEntity;
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod();
            if (baseJsonVo.isSuccess() && (baseJsonVo = this.periodService.getLastPeriod((perPeriodEntity = (PeriodEntity)baseJsonVo.getValue()).getId())).isSuccess()) {
                perPeriodEntity = (PeriodEntity)baseJsonVo.getValue();
                this.calculateBonuses(perPeriodEntity.getId(), 1);
                this.calculateBonuses(perPeriodEntity.getId(), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void calculateBonuses(Integer periodId) {
        this.calculateBonuses(periodId, 1);
        this.calculateBonuses(periodId, 2);
    }

    @Override
    public void calculateBonuses(Integer periodId, Integer classId) {
        if (!this.periodService.checkCurrentPeriodOrLastPeriod(periodId).booleanValue()) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setPeriodId(periodId);
            paperEntity.setQuestionClassId(classId);
            List<PaperEntity> paperEntityList = this.orgPaperDomain.getList(paperEntity);
            if (paperEntityList != null && paperEntityList.size() > 0) {
                paperEntityList.forEach(p -> this.calculateBonuses((PaperEntity)p));
            }
        } else {
            this.logger.info("\u671f\u6b21{}\u4e0d\u7b26\u5408\u5956\u91d1\u8ba1\u7b97\u6761\u4ef6", (Object)periodId);
        }
    }

    @Override
    public void calculateBonuses(PaperEntity paperEntity) {
        PaperDo paperDo = new PaperDo();
        BigDecimal bonus = new BigDecimal(0);
        boolean release = false;
        if (paperEntity.getReportStatus() == 1) {
            paperDo.setLevel(paperEntity.getLevel());
            paperDo.setCurrent(paperEntity);
            bonus = this.getBonuse(paperEntity.getLevel());
            release = false;
            if (paperDo.getCurrent().getLevel() >= 4) {
                this.logger.info("\u62a5\u544a{}\u8fde\u63a54\u671f\u5408\u683c\uff0c\u8fbe\u5230\u7ed3\u7b97\u6761\u4ef6", (Object)paperDo.getCurrent());
                release = true;
            } else {
                BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getNextPeriod(paperDo.getCurrent().getPeriodId());
                if (baseJsonVo.isSuccess()) {
                    PaperEntity query = new PaperEntity();
                    query.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                    query.setQuestionClassId(paperDo.getCurrent().getQuestionClassId());
                    query.setUserId(paperDo.getCurrent().getUserId());
                    PaperEntity next = this.orgPaperDomain.getSingle(query);
                    if (next != null && next.getReportStatus() == 2) {
                        this.logger.info("\u4e0b\u4e00\u671f{}\u4e0d\u5408\u683c\uff0c\u8fbe\u5230\u7ed3\u7b97\u6761\u4ef6", (Object)next);
                        release = true;
                    }
                } else {
                    this.logger.info("\u671f\u6b21:{},{}", (Object)paperDo.getCurrent().getPeriodId(), (Object)baseJsonVo.getMessage());
                }
            }
            Calendar c = Calendar.getInstance();
            PeriodEntity periodEntity = this.periodService.getPeriodEntity(paperEntity.getPeriodId());
            paperDo.getCurrent().setBonusTime(periodEntity.getPeriodEnd());
            c.setTime(DateUtils.getAddDateByDay((Date)periodEntity.getPeriodEnd(), (int)8));
            this.logger.info("\u8ba1\u7b97\u65e5\u671f:{}", (Object)c.getTime());
            int weeks = c.get(4);
            this.logger.info("\u5f53\u524d\u65e5\u671f:{},\u4e3a\u672c\u6708\u7b2c{}\u5468", (Object)c.getTime(), (Object)weeks);
            if (weeks == 2) {
                release = true;
                this.logger.info("{}\u672c\u6708\u7b2c\u4e8c\u5468\u8ba1\u7b97\u4e0a\u6708\u7684\u5956\u91d1", (Object)c.getTime());
            }
            this.setBonuses(paperDo, bonus, release);
        } else {
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod(paperEntity.getPeriodId());
            if (baseJsonVo.isSuccess()) {
                PaperEntity query = new PaperEntity();
                query.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                query.setQuestionClassId(paperEntity.getQuestionClassId());
                query.setUserId(paperEntity.getUserId());
                PaperEntity prev = this.orgPaperDomain.getSingle(query);
                if (prev != null) {
                    this.logger.info("\u5f53\u671f{}\u4e0d\u5408\u683c\uff0c\u5f00\u59cb\u8ba1\u7b97\u4e0a\u4e00\u671f{}", (Object)paperEntity, (Object)prev);
                    this.calculateBonuses(prev);
                }
            }
        }
    }

    @Override
    public void setBonuses(PaperDo paperDo, BigDecimal bonuse, boolean release) {
        if (paperDo.getCurrent().getReportStatus() == 1) {
            this.logger.info("\u5f00\u59cb\u8ba1\u7b97\u5956\u91d1:{}", (Object)paperDo.getCurrent());
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setBonus(bonuse);
            paperEntity.setLevel(paperDo.getCurrent().getLevel());
            paperEntity.setId(paperDo.getCurrent().getId());
            if (release) {
                paperEntity.setReportStatus(3);
            }
            paperEntity.setBonusTime(paperDo.getCurrent().getBonusTime());
            Boolean temp = this.orgPaperDomain.update(paperEntity);
            this.logger.info("{}, \u5956\u91d1:{},\u4fdd\u5b58\u5956\u91d1:{}", new Object[]{paperEntity, bonuse, temp});
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod(paperDo.getCurrent().getPeriodId());
            if (baseJsonVo.isSuccess()) {
                PaperDo current = new PaperDo();
                PeriodEntity periodEntity = (PeriodEntity)baseJsonVo.getValue();
                PaperEntity query = new PaperEntity();
                query.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                query.setQuestionClassId(paperDo.getCurrent().getQuestionClassId());
                query.setUserId(paperDo.getCurrent().getUserId());
                PaperEntity prev = this.orgPaperDomain.getSingle(query);
                if (prev != null) {
                    prev.setLevel(paperEntity.getLevel());
                    prev.setBonus(paperEntity.getBonus());
                    prev.setBonusTime(paperEntity.getBonusTime());
                    current.setCurrent(prev);
                    current.setLevel(paperDo.getLevel() - 1);
                    this.setBonuses(current, bonuse, release);
                } else {
                    this.logger.info("\u5956\u91d1\u8ba1\u7b97\u7ed3\u675f:{},\u4e0a\u4e00\u671f\u62a5\u544a\u4e0d\u5b58\u5728:", (Object)paperDo.getCurrent());
                }
            } else {
                this.logger.info("\u5956\u91d1\u8ba1\u7b97\u7ed3\u675f,\u671f\u6b21:{}\u7684\u4e0a\u4e00\u671f\u4e0d\u5b58\u5728:", (Object)paperDo.getCurrent().getPeriodName());
            }
        } else {
            this.logger.info("\u5206\u7c7b:{},\u671f\u6b21:{},\u7528\u6237:{}\u4e0d\u7b26\u5408\u5956\u91d1\u8ba1\u7b97\u6761\u4ef6,\u62a5\u544a\u72b6\u6001:{}", new Object[]{paperDo.getCurrent().getQuestionClassId(), paperDo.getCurrent().getPeriodName(), paperDo.getCurrent().getUserName(), paperDo.getCurrent().getReportStatus()});
        }
    }

    private BigDecimal getBonuse(Integer level) {
        if (level < 1) {
            level = 1;
        }
        return this.base.add(this.facor.multiply(new BigDecimal(level - 1)));
    }

    @Override
    public BaseJsonVo setReportStatus() {
        try {
            PeriodEntity perPeriodEntity;
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod();
            if (baseJsonVo.isSuccess() && (baseJsonVo = this.periodService.getLastPeriod((perPeriodEntity = (PeriodEntity)baseJsonVo.getValue()).getId())).isSuccess()) {
                perPeriodEntity = (PeriodEntity)baseJsonVo.getValue();
                this.setReportStatus(perPeriodEntity.getId(), (Integer)1);
                this.setReportStatus(perPeriodEntity.getId(), (Integer)2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo initReportStatus() {
        List<PeriodEntity> list = this.periodService.getPeriodEntityList();
        if (list != null && list.size() > 0) {
            list.forEach(p -> {
                if (p.getId() >= 42 && !this.periodService.checkCurrentPeriodOrLastPeriod(p.getId()).booleanValue()) {
                    this.paperService.setReportStatus(p.getId(), (Integer)1);
                    this.paperService.setReportStatus(p.getId(), (Integer)2);
                }
            });
        }
        return null;
    }

    @Override
    public BaseJsonVo setReportStatus(Integer periodId, Integer classId) {
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(periodId);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)("\u671f\u6b21" + periodId + "\u4e0d\u5b58\u5728"));
        }
        if (this.periodService.checkCurrentPeriodOrLastPeriod(periodId).booleanValue()) {
            return BaseJsonVo.error((String)("\u671f\u6b21" + periodId + "\u4e0d\u7b26\u5408\u8ba1\u7b97\u6761\u4ef6 "));
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setPeriodId(periodId);
        paperEntity.setQuestionClassId(classId);
        paperEntity.setReportStatus(0);
        List<PaperEntity> paperEntityList = this.orgPaperDomain.getList(paperEntity);
        if (paperEntityList != null && paperEntityList.size() > 0) {
            paperEntityList.forEach(p -> {
                PaperEntity update = new PaperEntity();
                update.setId(p.getId());
                boolean statand = this.orgVoteService.checkStandard(p.getId(), 1, p.getPeriodId(), p.getQuestionClassId());
                Integer reportStatus = statand ? 1 : 2;
                update.setReportStatus(reportStatus);
                Integer level = 0;
                if (statand) {
                    level = 1;
                    BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod(periodId);
                    if (baseJsonVo.isSuccess()) {
                        PaperEntity queryPaper = new PaperEntity();
                        queryPaper.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                        queryPaper.setQuestionClassId(classId);
                        queryPaper.setUserId(p.getUserId());
                        PaperEntity query = this.orgPaperDomain.getSingle(queryPaper);
                        if (query != null) {
                            level = query.getLevel() == null ? 0 : query.getLevel() + 1;
                        }
                    }
                    if (level >= 4) {
                        level = 4;
                    }
                    update.setLevel(level);
                }
                boolean temp = this.orgPaperDomain.update(update);
                this.logger.info("\u62a5\u544a{}\u72b6\u6001\u66f4\u65b0{}", p, (Object)temp);
            });
        }
        return BaseJsonVo.success((Object)"\u62a5\u544a\u662f\u5426\u5408\u683c\u72b6\u6001\u8bbe\u7f6e\u5b8c\u6bd5");
    }

    @Override
    public BaseJsonVo setReportStatus(String id, Integer reportStatus) {
        PaperEntity update = new PaperEntity();
        update.setId(id);
        update.setReportStatus(reportStatus);
        return this.orgPaperDomain.update(update) ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo savePaper(PaperEntity paperEntity) {
        boolean success = false;
        PaperEntity search = new PaperEntity();
        search.setPeriodId(paperEntity.getPeriodId());
        search.setUserId(paperEntity.getUserId());
        search.setQuestionClassId(paperEntity.getQuestionClassId());
        PaperEntity paperExists = this.orgPaperDomain.getSingle(search);
        if (StringUtils.isEmpty((String)paperEntity.getId())) {
            paperEntity.setId(IDGenerate.getUniqueIdStr());
        }
        if (paperExists == null) {
            success = this.orgPaperDomain.insert(paperEntity);
        }
        return success ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo buildPaper() {
        List<QuestionClassEntity> classEntities = this.classDomain.getQuestionClassEntityList(0);
        for (QuestionClassEntity c : classEntities) {
            if (c.getRoleId() == null) continue;
            List<MallUserEntity> userEntities = this.userInterface.getSysUserList4RoleId(c.getRoleId());
            for (MallUserEntity u : userEntities) {
                this.paperService.buildPaper(u.getUserId(), c.getClassId());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo buildPaper(Integer periodId) {
        List<QuestionClassEntity> classEntities = this.classDomain.getQuestionClassEntityList(0);
        for (QuestionClassEntity c : classEntities) {
            if (c.getRoleId() == null) continue;
            List<MallUserEntity> userEntities = this.userInterface.getSysUserList4RoleId(c.getRoleId());
            for (MallUserEntity u : userEntities) {
                try {
                    this.paperService.buildPaper(u.getUserId(), c.getClassId(), periodId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo buildPaper(String userId, Integer classId) {
        BaseJsonVo<PeriodEntity> periodEntity = this.periodService.currentPeriod();
        if (periodEntity.getValue() == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)userId) || classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(IDGenerate.getUniqueIdStr());
        paperEntity.setQuestionClassId(classId);
        paperEntity.setPeriodId(((PeriodEntity)periodEntity.getValue()).getId());
        paperEntity.setPeriodName(((PeriodEntity)periodEntity.getValue()).getPeriodDesc());
        paperEntity.setUserId(userId);
        paperEntity.setBonus(new BigDecimal(0));
        paperEntity.setReportStatus(0);
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        if (userEntity != null) {
            paperEntity.setUserName(userEntity.getUserNick());
        }
        paperEntity.setCreateTime(new Date());
        paperEntity.setStatus(0);
        return this.savePaper(paperEntity);
    }

    @Override
    public BaseJsonVo buildPaper(String userId, Integer classId, Integer periodId) {
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(periodId);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)userId) || classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(IDGenerate.getUniqueIdStr());
        paperEntity.setQuestionClassId(classId);
        paperEntity.setPeriodId(periodEntity.getId());
        paperEntity.setPeriodName(periodEntity.getPeriodDesc());
        paperEntity.setUserId(userId);
        paperEntity.setBonus(new BigDecimal(0));
        paperEntity.setReportStatus(0);
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        if (userEntity != null) {
            paperEntity.setUserName(userEntity.getUserNick());
        }
        paperEntity.setCreateTime(new Date());
        paperEntity.setStatus(0);
        return this.savePaper(paperEntity);
    }

    @Override
    public BaseJsonVo getPaperPageList(PageForm pageForm, PaperEntity paperEntity, String userId) {
        List<MallUserEntity> userEntities;
        QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(paperEntity.getQuestionClassId());
        if (questionClassEntity != null && (userEntities = this.userInterface.getSysUserList4RoleId(questionClassEntity.getRoleId())).stream().filter(c -> c.getUserId().equals(userId)).count() > 0L) {
            this.buildPaper(userId, paperEntity.getQuestionClassId());
        }
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        users.add(userId);
        PageInfo pageInfo = this.orgPaperDomain.getPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), paperEntity, users, userId);
        pageInfo.getList().forEach(c -> this.getStatus(paperEntity, userId, (PaperPageListVo)c));
        return BaseJsonVo.success((Object)pageInfo);
    }

    private boolean isEdit(PaperEntity paperEntity, String userId) {
        return this.periodService.isInPeriodWithDelay(paperEntity.getPeriodId()).isSuccess() && userId.equals(paperEntity.getUserId());
    }

    private boolean isVote(PaperEntity paperEntity, String userId) {
        return !userId.equals(paperEntity.getUserId());
    }

    @Override
    public BaseJsonVo getPublicPapers(PageForm pageForm, PaperEntity paperEntity, String userId) {
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        users.add(userId);
        PageInfo<Map<String, Object>> pageInfo = this.orgPaperDomain.getPublicPages(pageForm.getCurrentPage(), pageForm.getPageSize(), paperEntity, users, userId);
        HashSet<String> paperIds = new HashSet<String>();
        pageInfo.getList().forEach(vo -> paperIds.add((String)vo.get("paperId")));
        this.logger.info("*****" + JsonUtils.toJson(paperIds, (boolean)false));
        QuestionEntity param = new QuestionEntity();
        param.setQuestionClassId(paperEntity.getQuestionClassId());
        param.setIsPublicColumn(1);
        List<QuestionEntity> publicQuestions = this.orgQuestionDomain.getList(param);
        ArrayList<String> publicColumns = new ArrayList<String>();
        publicColumns.add("\u8bbf\u8c08\u4eba");
        publicColumns.add("\u8bbf\u8c08\u65f6\u95f4");
        publicColumns.add("\u83b7\u5f97\u8d5e\u6570");
        int from = 3;
        for (QuestionEntity entity : publicQuestions) {
            publicColumns.add(from - 1, entity.getQuestionName());
            if (paperIds.size() > 0) {
                List<PaperAnswerEntity> paperAnswers = this.orgPaperAnswerDomain.findPublicAnswers(paperIds, entity.getId());
                for (PaperAnswerEntity answerEntity : paperAnswers) {
                    Optional<Map> map = pageInfo.getList().stream().filter(paper -> paper.get("paperId").equals(answerEntity.getPaperId())).findAny();
                    if (!map.isPresent()) continue;
                    map.get().put(from == 3 ? "customerType" : "customerPic", answerEntity.getAnswer());
                    map.get().put("createTime", answerEntity.getCreateTime());
                }
            }
            ++from;
        }
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        map.put("columns", publicColumns);
        map.put("data", (ArrayList<Object>)pageInfo);
        return BaseJsonVo.success(map);
    }

    private void getStatus(PaperEntity paperEntity, String userId, PaperPageListVo c) {
        if (c.getReportStatus() == 3) {
            c.setReportStatus(1);
        }
        if (c.getStatus() == null || c.getStatus() == 0) {
            c.setStatus(0);
            c.setStatusName("\u672a\u586b\u5199");
            c.setIsVote(0);
            c.setCommit("");
            c.setVoteNum(0);
        }
        c.setIsEdit(this.isEdit(c, userId) ? 1 : 0);
        if (!userId.equals(paperEntity.getUserId())) {
            if (c.getStatus() == 1) {
                c.setStatusName("\u5df2\u586b\u5199");
                VoteEntity queryVote = new VoteEntity();
                queryVote.setVoteUserId(userId);
                queryVote.setPeriodId(paperEntity.getPeriodId());
                queryVote.setQuestionClassId(paperEntity.getQuestionClassId());
                queryVote.setUserId(c.getUserId());
                queryVote.setVoteType(1);
                VoteEntity voteEntity = this.orgVoteService.getVoteEntity(queryVote);
                if (voteEntity != null) {
                    c.setIsVote(2);
                    c.setVoteNum(1);
                    c.setCommit(StringUtils.isNotEmpty((String)voteEntity.getCommit()) ? voteEntity.getCommit() : "\u672a\u8bc4\u8bba");
                } else {
                    c.setIsVote(this.periodService.checkCurrentPeriodOrLastPeriod(paperEntity.getPeriodId()) != false ? 1 : 0);
                    c.setCommit("");
                    c.setVoteNum(0);
                }
            } else {
                c.setIsVote(0);
            }
        } else {
            c.setIsVote(0);
        }
    }
}

