/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.constants.CommonConstants;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.dao.PeriodMapper;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.iservice.IPeriodService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PeriodService
extends BaseService
implements IPeriodService {
    private static final String CURRENT_PERIOD = "CURRENT_PERIOD";
    @Autowired
    PeriodMapper periodMapper;
    @Autowired
    RedisCacheUtil<PeriodEntity> redisService;
    @Autowired
    SysUserInterface userInterface;
    @Autowired
    DictionaryInterface dictionaryService;
    @Autowired
    private IPeriodService periodService;

    @Override
    public List<PeriodEntity> getPeriodEntityList() {
        PeriodEntity periodEntity = new PeriodEntity();
        return this.periodMapper.getList(periodEntity);
    }

    @Override
    public Boolean checkCurrentPeriodOrLastPeriod(int periodId) {
        Boolean temp = this.periodService.isInPeriod(periodId).isSuccess();
        if (temp.booleanValue()) {
            return true;
        }
        BaseJsonVo<PeriodEntity> baseJsonVo = this.getLastPeriod();
        if (baseJsonVo.isSuccess()) {
            return periodId == ((PeriodEntity)baseJsonVo.getValue()).getId();
        }
        return false;
    }

    @Override
    public PeriodEntity getPeriodEntity(int id) {
        return (PeriodEntity)this.periodMapper.selectByPrimaryKey(Integer.valueOf(id));
    }

    private PeriodEntity getCurrentPeriod() {
        Object periodObject;
        if (this.redisService.exists(CURRENT_PERIOD) && (periodObject = this.redisService.get(CURRENT_PERIOD)) instanceof PeriodEntity) {
            return (PeriodEntity)periodObject;
        }
        PeriodEntity periodEntity = this.periodMapper.getCurrentPeriod();
        this.setCurrentPeriodCache(periodEntity);
        return periodEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentPeriodCache(PeriodEntity periodEntity) {
        Class<PeriodService> clazz = PeriodService.class;
        synchronized (PeriodService.class) {
            long expire;
            if (!this.redisService.exists(CURRENT_PERIOD) && (expire = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)DateUtils.getAddDateByDay((Date)periodEntity.getPeriodEnd(), (int)1))) > 60L) {
                this.redisService.set(CURRENT_PERIOD, (Object)periodEntity, Long.valueOf(expire - 60L));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriod(Date date) {
        PeriodEntity periodEntity = this.getCurrentPeriod();
        if (date.compareTo(periodEntity.getPeriodStart()) >= 0 && date.compareTo(periodEntity.getPeriodStart()) <= 0) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriod(String date) {
        Date thisDate = DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd HH:mm:ss");
        thisDate = thisDate == null ? DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd") : thisDate;
        return this.isInPeriod(thisDate);
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriod(int id) {
        PeriodEntity periodEntity = this.getCurrentPeriod();
        if (periodEntity.getId() == id) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithDelay(Date date) {
        PeriodEntity periodEntity = this.getCurrentPeriod();
        if (date.compareTo(periodEntity.getPeriodStart()) >= 0 && date.compareTo(periodEntity.getPeriodStart()) <= 0) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        PeriodEntity lastPeriod = (PeriodEntity)this.getLastPeriod().getValue();
        if (date.compareTo(lastPeriod.getPeriodStart()) >= 0 && date.compareTo(lastPeriod.getPeriodEnd()) <= 0) {
            long dateDiffSecond = DateUtils.getDateDiffSecond((Date)periodEntity.getPeriodStart(), (Date)date);
            DictionaryEntity delay_hours = this.dictionaryService.getDictionary(CommonConstants.DEFAULT_PLATFORM_GROUP_ID, 58, "DELAY_HOURS");
            if (delay_hours != null && dateDiffSecond < (long)(Integer.valueOf(delay_hours.getDictionaryName()) * 3600)) {
                return BaseJsonVo.success((Object)lastPeriod);
            }
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithDelay(String date) {
        Date thisDate = DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd HH:mm:ss");
        thisDate = thisDate == null ? DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd") : thisDate;
        return this.isInPeriodWithDelay(thisDate);
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithDelay(int id) {
        PeriodEntity periodEntity = this.getCurrentPeriod();
        if (periodEntity.getId() == id) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        PeriodEntity lastPeriod = (PeriodEntity)this.getLastPeriod().getValue();
        if (id == lastPeriod.getId()) {
            long dateDiffSecond = DateUtils.getDateDiffSecond((Date)periodEntity.getPeriodStart(), (Date)DateUtils.now());
            DictionaryEntity delay_hours = this.dictionaryService.getDictionary(CommonConstants.DEFAULT_PLATFORM_GROUP_ID, 58, "DELAY_HOURS");
            if (delay_hours != null && dateDiffSecond < (long)(Integer.valueOf(delay_hours.getDictionaryName()) * 3600)) {
                return BaseJsonVo.success((Object)lastPeriod);
            }
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithNum(Integer year, int periodNum) {
        PeriodEntity periodEntity = this.getCurrentPeriod();
        if (year.intValue() == periodEntity.getHeadYear().intValue() && periodEntity.getHeadPeriod() == periodNum) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> getPeriodWithNum(Integer year, int periodNum) {
        PeriodEntity param = new PeriodEntity();
        param.setHeadYear(year);
        param.setHeadPeriod(periodNum);
        List list = this.periodMapper.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        return BaseJsonVo.error(null);
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithNum(int periodNum) {
        PeriodEntity periodEntity = this.getCurrentPeriod();
        if (periodEntity.getHeadPeriod() == periodNum) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> currentPeriod() {
        return BaseJsonVo.success((Object)this.getCurrentPeriod());
    }

    @Override
    public BaseJsonVo<PeriodEntity> getLastPeriod() {
        PeriodEntity currentPeriod = (PeriodEntity)this.currentPeriod().getValue();
        PeriodEntity param = new PeriodEntity();
        param.setPeriodEnd(DateUtils.getAddDateByDay((Date)currentPeriod.getPeriodStart(), (int)-1));
        List list = this.periodMapper.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u4e0a\u4e00\u4e2a\u671f\u6b21");
    }

    @Override
    public BaseJsonVo<PeriodEntity> getLastPeriod(int id) {
        PeriodEntity currentPeriod = this.getPeriodEntity(id);
        PeriodEntity param = new PeriodEntity();
        param.setPeriodEnd(DateUtils.getAddDateByDay((Date)currentPeriod.getPeriodStart(), (int)-1));
        List list = this.periodMapper.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u4e0a\u4e00\u4e2a\u671f\u6b21");
    }

    @Override
    public BaseJsonVo<PeriodEntity> getPeriodByPeriod(int period) {
        BaseJsonVo<PeriodEntity> baseJsonVo = this.getLastPeriod();
        if (baseJsonVo.isSuccess()) {
            PeriodEntity param = new PeriodEntity();
            param.setPeriodEnd(DateUtils.getAddDateByDay((Date)((PeriodEntity)baseJsonVo.getValue()).getPeriodStart(), (int)(-(period * 7 + 1))));
            List list = this.periodMapper.getList(param);
            if (list != null && list.size() > 0) {
                return BaseJsonVo.success(list.get(0));
            }
            return BaseJsonVo.error((String)("\u83b7\u53d6" + period * 7 + "\u5929\u524d\u7684\u671f\u6b21\u51fa\u9519"));
        }
        return BaseJsonVo.error((String)("\u83b7\u53d6" + period * 7 + "\u5929\u524d\u7684\u671f\u6b21\u51fa\u9519"));
    }

    @Override
    public BaseJsonVo<PeriodEntity> getNextPeriod(int id) {
        PeriodEntity currentPeriod = this.getPeriodEntity(id);
        PeriodEntity param = new PeriodEntity();
        param.setPeriodStart(DateUtils.getAddDateByDay((Date)currentPeriod.getPeriodEnd(), (int)1));
        List list = this.periodMapper.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u4e0b\u4e00\u4e2a\u671f\u6b21");
    }

    @Override
    public BaseJsonVo createPeriod() {
        int whatDayTodayIs = DateUtils.getWeekIndexOfDate((Date)DateUtils.now());
        this.logger.info("\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u4eca\u5929\u5468" + whatDayTodayIs);
        if (whatDayTodayIs < 6) {
            this.logger.info("\u672a\u5230\u5468\u516d\u65e5\uff0c\u4e0d\u751f\u6210\u4e0b\u5468\u671f\u6b21");
            return BaseJsonVo.success((Object)"\u672a\u5230\u5468\u516d\u65e5\uff0c\u4e0d\u751f\u6210\u4e0b\u5468\u671f\u6b21");
        }
        Date date = DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)(10 - DateUtils.getWeekIndexOfDate((Date)DateUtils.now())));
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        PeriodEntity entity = new PeriodEntity();
        entity.setHeadYear(calendar.get(1));
        entity.setHeadPeriod(calendar.get(3));
        List list = this.periodMapper.getList(entity);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        Date periodStart = DateUtils.getAddDateByDay((Date)date, (int)-2);
        Date periodEnd = DateUtils.getAddDateByDay((Date)date, (int)4);
        entity.setPeriodStart(periodStart);
        entity.setPeriodEnd(periodEnd);
        Integer count = this.userInterface.getRoleUserCount(29);
        entity.setParticipantNumber(count);
        entity.setPeriodDesc(calendar.get(1) + "\u5e74\u7b2c" + entity.getHeadPeriod() + "\u5468(" + DateUtils.formatDate((Date)entity.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)entity.getPeriodEnd(), (String)"MM.dd") + ")");
        this.periodMapper.insert(entity);
        return BaseJsonVo.success((Object)entity);
    }

    @Override
    public void createPeriodInit(String dateStr) {
        Date initNow = DateUtils.getDateFromString((String)dateStr, (String)"yyyy-MM-dd");
        do {
            Date date = DateUtils.getAddDateByDay((Date)initNow, (int)3);
            Calendar calendar = Calendar.getInstance();
            calendar.setFirstDayOfWeek(2);
            calendar.setTime(date);
            PeriodEntity entity = new PeriodEntity();
            entity.setHeadYear(calendar.get(1));
            entity.setHeadPeriod(calendar.get(3));
            Date periodStart = DateUtils.getAddDateByDay((Date)initNow, (int)1);
            Date periodEnd = DateUtils.getAddDateByDay((Date)initNow, (int)7);
            entity.setPeriodStart(periodStart);
            entity.setPeriodEnd(periodEnd);
            Integer count = this.userInterface.getRoleUserCount(29);
            entity.setParticipantNumber(count);
            entity.setPeriodDesc(calendar.get(1) + "\u5e74\u7b2c" + entity.getHeadPeriod() + "\u5468(" + DateUtils.formatDate((Date)entity.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)entity.getPeriodEnd(), (String)"MM.dd") + ")");
            this.logger.info(">>>>>>>>>>>" + JsonUtils.toJson((Object)entity, (boolean)true));
            this.periodMapper.insert(entity);
        } while ((initNow = DateUtils.getAddDateByDay((Date)initNow, (int)7)).compareTo(DateUtils.now()) <= 0);
    }

    @Override
    public BaseJsonVo<PeriodEntity> getPeriod(Date date) {
        PeriodEntity param = new PeriodEntity();
        param.setPeriodEnd(date);
        PeriodEntity periodEntity = this.periodMapper.getPeriod(date);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)periodEntity);
    }
}

