/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCheckinMapper;
import cc.lechun.active.dao.active.ActiveMapper;
import cc.lechun.active.entity.active.ActiveCheckinEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveEntityVo;
import cc.lechun.active.entity.active.ActivePageEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.ActiveQueryVo;
import cc.lechun.active.entity.active.IndexActiveVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePageInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.service.sales.ActiveSaleContext;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ActiveService
extends BaseService
implements ActiveInterface {
    @Autowired
    private ActiveMapper activeMapper;
    @Autowired
    private ActiveQrcodeInterface activeQrcodeInterface;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActivePageInterface activePageInterface;
    @Autowired
    private ActiveCheckinMapper checkinMapper;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceService;
    @Autowired
    private MallRedisLock redisLock;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private ActiveSaleContext activeContext;

    @Override
    public BaseJsonVo setOnline(ActiveEntity activeEntity) {
        ActiveEntity updateActive = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeEntity.getActiveNo()));
        this.removeCache(updateActive);
        this.activeMapper.updateByPrimaryKeySelective(activeEntity);
        return BaseJsonVo.success((Object)"\u5df2\u4e0a\u7ebf!");
    }

    @Override
    public BaseJsonVo confirmOrder(MallOrderMainEntity orderMain, ActiveEntity activeEntity) {
        ActiveSaleHandle activeHandle = this.activeContext.getActiveHanle(String.valueOf(activeEntity.getActiveType()));
        if (activeHandle != null) {
            this.logger.info("\u7528\u6237\u786e\u8ba4\u6536\u8d27\u6210\u529f{}", (Object)orderMain.toString());
            activeHandle.confirmOrder(orderMain);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain, ActiveEntity activeEntity) {
        ActiveSaleHandle activeHandle = this.activeContext.getActiveHanle(String.valueOf(activeEntity.getActiveType()));
        if (activeHandle != null) {
            this.logger.info("\u7528\u6237\u652f\u4ed8\u6210\u529f{}", (Object)orderMain.toString());
            activeHandle.afterPay(orderMain);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public int getOrderSourceByActiveType(Integer activeType) {
        int orderSource = 0;
        switch (activeType) {
            case 23: {
                orderSource = OrderSourceEnum.TEAM_BUY.getValue();
                break;
            }
            case 22: {
                orderSource = OrderSourceEnum.ALL_FIT.getValue();
                break;
            }
            case 6: {
                orderSource = OrderSourceEnum.LIMIT_BUY.getValue();
                break;
            }
            case 19: {
                orderSource = OrderSourceEnum.NORMAT_FIT.getValue();
                break;
            }
            case 20: {
                orderSource = OrderSourceEnum.COLLAGE.getValue();
                break;
            }
            case 21: {
                orderSource = OrderSourceEnum.LIMIT_NO_DELIVER.getValue();
                break;
            }
            case 18: {
                orderSource = OrderSourceEnum.CROWD.getValue();
                break;
            }
            default: {
                orderSource = OrderSourceEnum.CART.getValue();
            }
        }
        return orderSource;
    }

    @Override
    public BaseJsonVo saveActive(ActiveEntity active) {
        BaseJsonVo result = this.checkSaveActive(active);
        if (result.isSuccess()) {
            this.removeCache(active);
            if (StringUtils.isEmpty((String)active.getActiveNo())) {
                boolean temp;
                active.setActiveNo(String.valueOf(RandomUtils.generateId()));
                active.setCreateTime(DateUtils.now());
                if (active.getKeywordId() == null) {
                    active.setKeywordId(0);
                }
                if (active.getPayKeywordId() == null) {
                    active.setPayKeywordId(0);
                }
                if (active.getPayamount() == null) {
                    active.setPayamount(new BigDecimal(0));
                }
                if (StringUtils.isEmpty((String)active.getVipRightType())) {
                    active.setVipRightType("0");
                }
                active.setStatus(0);
                active.setBindCode(String.valueOf(RandomUtils.generateId()));
                active.setPlatformGroupId(this.platFormService.getPlatFormGroupId(active.getPlatformId()));
                boolean bl = temp = this.activeMapper.insert(active) >= 1;
                if (!temp) {
                    result.setError_msg("\u6d3b\u52a8\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                    return result;
                }
                result.setValue((Object)active);
            } else {
                return this.activeMapper.updateByPrimaryKeySelective(active) >= 1 ? BaseJsonVo.success((Object)active) : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
            }
        }
        return result;
    }

    private BaseJsonVo checkSaveActive(ActiveEntity active) {
        if (StringUtils.isEmpty((String)active.getActiveName())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u4e3a\u7a7a");
        }
        if (active.getBeginTime() == null) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (active.getEndTime() == null) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (active.getEndTime().before(active.getBeginTime())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        ActiveEntity tempActiveNo = new ActiveEntity();
        tempActiveNo.setActiveNo(active.getActiveNo());
        tempActiveNo.setActiveName(active.getActiveName());
        if (StringUtils.isEmpty((String)active.getActiveNo())) {
            if (this.activeMapper.existsActiveName(tempActiveNo) >= 1) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u5df2\u5b58\u5728");
            }
            if (active.getActiveType() == -1) {
                return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
            }
            if (active.getPlatformId() <= 0) {
                return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5e73\u53f0");
            }
        } else if (this.activeMapper.existsActiveNameByActiveNo(tempActiveNo) >= 1) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u5df2\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.checkActiveEnable")
    public BaseJsonVo checkActiveEnable(@ParameterValueKeyProvider String activeNo) {
        ActiveEntity activeEntity = this.getActiveEntityByActiveNo(activeNo);
        return this.checkActiveEnable(activeEntity);
    }

    @Override
    public BaseJsonVo checkActiveEnable(ActiveEntity activeEntity) {
        if (activeEntity == null) {
            this.logger.error("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return BaseJsonVo.error((String)"\u672a\u77e5\u6d3b\u52a8");
        }
        if (activeEntity.getBeginTime().after(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u672a\u5f00\u59cb."));
        }
        if (activeEntity.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u5df2\u7ed3\u675f."));
        }
        if (activeEntity.getStatus() != 1) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u672a\u542f\u7528"));
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveNoByBindCode")
    public String getActiveNoByBindCode(@ParameterValueKeyProvider String bindCode) {
        if (StringUtils.isNotEmpty((String)bindCode)) {
            ActiveEntity activeEntity = this.getActiveEntityByQrcode(bindCode);
            if (activeEntity == null) {
                this.logger.error("\u65e0\u5339\u914d\u8bb0\u5f55,bindcode={}", (Object)bindCode);
                return "";
            }
            return activeEntity.getActiveNo();
        }
        this.logger.info("\u53c2\u6570,bindcode\u4e3a\u7a7a");
        return "";
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveEntityByQrcode")
    public ActiveEntity getActiveEntityByQrcode(@ParameterValueKeyProvider String bindCode) {
        if (StringUtils.isEmpty((String)bindCode)) {
            this.logger.info("\u67e5\u8be2bindcode\u4e3a\u7a7a");
            return null;
        }
        this.logger.info("bindCode={}", (Object)bindCode);
        if (bindCode.length() >= 32) {
            ActiveQrcodeEntity qrcode = this.activeQrcodeInterface.getActiveQrcode(bindCode);
            if (qrcode != null) {
                return (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)qrcode.getActiveNo()));
            }
            return null;
        }
        ActiveEntity activeEntity = new ActiveEntity();
        activeEntity.setBindCode(bindCode);
        return (ActiveEntity)this.activeMapper.getSingle(activeEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveEntityByActiveNo")
    public ActiveEntity getActiveEntityByActiveNo(@ParameterValueKeyProvider String activeNo) {
        return (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveCouponByKeyWordId")
    public String getActiveCouponByKeyWordId(@ParameterValueKeyProvider Integer keyWordId) {
        return this.activeMapper.getActiveCouponByKeyWordId(keyWordId);
    }

    @Override
    public boolean deleteActive(String activeNo) {
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
        this.removeCache(activeEntity);
        return this.activeMapper.deleteByPrimaryKey((Serializable)((Object)activeNo)) >= 1;
    }

    @Override
    @ReadThroughAssignCache(namespace="ActiveService.getEnableActiveForOption", expiration=300)
    public List<ActiveEntity> getEnableActiveForOption() {
        return this.getActiveForOptionByStatus(1, 1000);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveForOptionByStatus", expiration=300)
    public List<ActiveEntity> getActiveForOptionByStatus(@ParameterValueKeyProvider(order=0) Integer status, @ParameterValueKeyProvider(order=1) Integer platformGroupId) {
        return this.activeMapper.getActiveForOptionByStatus(status, platformGroupId);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveForOption", expiration=300)
    public List<ActiveEntity> getActiveForOption(@ParameterValueKeyProvider Integer platformGroupId) {
        return this.activeMapper.getActiveForOption(platformGroupId);
    }

    @Override
    public PageInfo getActiveList(ActiveQueryVo activeQueryVo) {
        Page page = PageHelper.startPage((int)activeQueryVo.getCurrentPage(), (int)activeQueryVo.getPageSize()).setOrderBy(" ACTIVE_NO DESC ");
        List<ActiveEntity> list = this.activeMapper.getActiveList(activeQueryVo);
        PageInfo pg = page.toPageInfo();
        ArrayList result = new ArrayList();
        list.forEach(a -> {
            ActiveEntityVo activeEntityVo = new ActiveEntityVo();
            BeanUtils.copyProperties((Object)a, (Object)activeEntityVo);
            ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeInterface.getActiveQrcode(a.getBindCode());
            if (activeQrcodeEntity != null) {
                if (a.getActiveType() == 6 || a.getActiveType() == 21) {
                    activeEntityVo.setUrl("https://wx.lechun.cc/pages/active/limit_sale/limit_sale.html?bindCode=" + activeQrcodeEntity.getBindCode() + "&orderSource=" + this.getOrderSourceByActiveType(a.getActiveType()));
                }
                if (a.getActiveType() == 15) {
                    activeEntityVo.setUrl("https://wx.lechun.cc/pages/active/getCoupon/getCoupon.html?bindCode=" + activeQrcodeEntity.getBindCode());
                }
                if (a.getActiveType() == 19 || a.getActiveType() == 22) {
                    activeEntityVo.setUrl("https://wx.lechun.cc/pages/active/five_active/start/start.html?bindCode=" + activeQrcodeEntity.getBindCode());
                }
                if (a.getActiveType() == 23) {
                    activeEntityVo.setUrl("https://wx.lechun.cc/pages/active/group/group_index/group_index.html?bindcode=" + activeQrcodeEntity.getBindCode());
                }
            } else {
                activeEntityVo.setUrl("");
            }
            result.add(activeEntityVo);
        });
        pg.setList(result);
        return pg;
    }

    @Override
    public boolean updateActive(ActiveEntity activeEntity) {
        this.removeCache(activeEntity);
        return this.activeMapper.updateByPrimaryKeySelective(activeEntity) >= 1;
    }

    @Override
    public BaseJsonVo buildIndexActiveVo(String activeId, String customerId) {
        ActiveEntity activeEntity = this.getActiveEntityByActiveNo(activeId);
        BaseJsonVo baseJsonVo = this.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        IndexActiveVo indexActiveVo = new IndexActiveVo();
        indexActiveVo.setActiveName(activeEntity.getActiveName());
        indexActiveVo.setActiveNo(activeEntity.getActiveNo());
        indexActiveVo.setBeginTime(activeEntity.getBeginTime());
        indexActiveVo.setEndTime(activeEntity.getEndTime());
        indexActiveVo.setIsShow(1);
        ActivePageEntity activePageEntity = this.activePageInterface.getActivePageEntityByActiveNo(activeId);
        if (activePageEntity != null) {
            if (activePageEntity.getIsvip() == 1 && !this.vipInterface.checkVipRightByType(customerId, activePageEntity.getVipRightType())) {
                indexActiveVo.setIsShow(0);
            }
            indexActiveVo.setUrl(activePageEntity.getActiveUrl());
            indexActiveVo.setVipRightType(Integer.parseInt(activePageEntity.getVipRightType()));
            indexActiveVo.setIsVip(activePageEntity.getIsvip());
        }
        indexActiveVo.setIsvipday(this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
        indexActiveVo.setPicMap(this.picInterface.getProductPicUrlMap(activeId, SalesTypeEnum.SALES_ACTIVE.getValue()));
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)activeEntity.getEndTime());
        indexActiveVo.setHour((int)(seconds / 3600L));
        indexActiveVo.setMinute((int)(seconds % 3600L / 60L));
        indexActiveVo.setSecond((int)(seconds % 3600L % 60L));
        indexActiveVo.setSeconds(seconds);
        indexActiveVo.setItemType(SalesTypeEnum.SALES_ACTIVE.getValue());
        return BaseJsonVo.success((Object)indexActiveVo);
    }

    @Override
    public List<MallSelectDataVo> getOptionActiveList(Integer platformGroupId) {
        return this.activeMapper.getOptionActiveList(platformGroupId);
    }

    @Override
    public List<MallSelectDataVo> getOptionActiveList(Integer platformGroupId, Integer[] activeTypes) {
        return this.activeMapper.getOptionActiveListByActiveTypes(platformGroupId, activeTypes);
    }

    @Override
    public List<ActiveEntity> getActiveList4ActiveType(int platformGroupId, int activeType) {
        ActiveEntity activeEntity = new ActiveEntity();
        activeEntity.setPlatformGroupId(platformGroupId);
        activeEntity.setActiveType(activeType);
        return this.activeMapper.getList(activeEntity);
    }

    @Override
    public BaseJsonVo getUserDailyCheckInCount(String bindCode, String customerId) {
        ActiveCheckinEntity checkinEntity = new ActiveCheckinEntity();
        checkinEntity.setBindCode(bindCode);
        checkinEntity.setCustomerId(customerId);
        List checkinEntities = this.checkinMapper.getList(checkinEntity);
        return BaseJsonVo.success((Object)(checkinEntities == null ? 0 : checkinEntities.size()));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BaseJsonVo dailyCheckIn(String bindCode, String customerId, int checkedCount) {
        if (!this.hasChecked(bindCode, customerId).isSuccess()) {
            BaseJsonVo chargeResult;
            ActiveCheckinEntity checkinEntity = new ActiveCheckinEntity();
            checkinEntity.setBindCode(bindCode);
            checkinEntity.setCustomerId(customerId);
            checkinEntity.setSn(++checkedCount);
            int insertResult = this.checkinMapper.insert(checkinEntity);
            if (checkedCount == 1) {
                this.activeCashticketInterface.sendTicket4BaseAsynchronous(customerId, bindCode, "", 1, true);
            }
            if (!(chargeResult = this.accountBalanceService.activeCharge(customerId, bindCode, 100)).isSuccess()) {
                this.logger.error("\u7528\u6237\u6253\u5361\u53d1\u4f59\u989d\u5931\u8d25[customerId : " + customerId + "][bindCode : " + bindCode + "] : " + chargeResult.getError_msg());
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)chargeResult.getError_msg());
            }
            final CustomerEntity customer = this.customerService.getCustomer(customerId);
            BaseJsonVo result = this.messageService.sendWechatMessage(1, "CHECKIN_AFTER", customer.getChannelCustomerId(), (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("nickName", customer.getNickName());
                }
            });
            this.logger.info("\u7528\u6237\u6253\u5361\u53d1\u4f59\u989d\u6210\u529f[customerId : " + customerId + "][bindCode : " + bindCode + "]");
        }
        return BaseJsonVo.success((Object)checkedCount);
    }

    @Override
    public BaseJsonVo hasChecked(String bindCode, String customerId) {
        List<ActiveCheckinEntity> checkinEntities = this.checkinMapper.getTodayCheckList(bindCode, customerId);
        return checkinEntities == null || checkinEntities.size() == 0 ? BaseJsonVo.error() : BaseJsonVo.success((Object)checkinEntities.size());
    }

    @Override
    public BaseJsonVo canParticipate(String bindCode, String customerId) {
        ActiveQrcodeEntity qrcode = this.activeQrcodeInterface.getQrcode(bindCode);
        ActiveEntity active = this.getActiveEntityByActiveNo(qrcode.getActiveNo());
        if (active.getStatus() == 0) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u5173\u95ed");
        }
        if (active.getBeginTime().after(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5c1a\u672a\u5f00\u59cb");
        }
        if (active.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        BaseJsonVo result = this.canParticipateWithCondition(bindCode, customerId);
        return result;
    }

    @Override
    public BaseJsonVo canParticipateWithCondition(String bindCode, String customerId) {
        Integer checkInCount;
        int MAX_CHECKIN_COUNT = 30;
        BaseJsonVo countResult = this.getUserDailyCheckInCount(bindCode, customerId);
        if (countResult.isSuccess() && (checkInCount = (Integer)countResult.getValue()) >= MAX_CHECKIN_COUNT) {
            return BaseJsonVo.success((Object)"\u6253\u5361\u5b8c\u6210");
        }
        BaseJsonVo hasCheckedTodayResult = this.hasChecked(bindCode, customerId);
        if (hasCheckedTodayResult.isSuccess()) {
            return BaseJsonVo.success((Object)"\u67e5\u770b\u6253\u5361");
        }
        return BaseJsonVo.success((Object)"\u5f00\u542f\u6253\u5361");
    }

    @Override
    public void checkinRemind() {
        List<String> openIds = this.checkinMapper.findRemindUsers();
        ExecutorService pool = Executors.newCachedThreadPool();
        openIds.forEach(openId -> pool.execute(new Runnable((String)openId){
            final /* synthetic */ String val$openId;
            {
                this.val$openId = string;
            }

            @Override
            public void run() {
                BaseJsonVo result = ActiveService.this.messageService.sendWechatMessage(1, "CHECKIN_TEXT_MESSAGE", this.val$openId, null);
                ActiveService.this.logger.info("\u65e0\u7cd6\u6253\u5361\u63d0\u9192\u7ed3\u679c[" + this.val$openId + "] : " + JsonUtils.toJson((Object)result, (boolean)true));
            }
        }));
    }

    @Override
    public BaseJsonVo participate(String bindCode, String customerId) {
        if (this.redisLock.lock("CHECK_IN_" + customerId, "", 60L, TimeUnit.SECONDS)) {
            BaseJsonVo checkResult = this.canParticipate(bindCode, customerId);
            BaseJsonVo countResult = this.getUserDailyCheckInCount(bindCode, customerId);
            if (!checkResult.isSuccess() || checkResult.isSuccess() && "\u6253\u5361\u5b8c\u6210".equals(checkResult.getValue())) {
                String picUrl = this.activeQrcodeInterface.getDailyCheckInPic(bindCode, (Integer)countResult.getValue());
                this.redisLock.unlock("CHECK_IN_" + customerId);
                checkResult.setValue((Object)picUrl);
                return checkResult;
            }
            BaseJsonVo checkInResult = this.dailyCheckIn(bindCode, customerId, countResult.isSuccess() ? (Integer)countResult.getValue() : 0);
            String picUrl = this.activeQrcodeInterface.getDailyCheckInPic(bindCode, (Integer)checkInResult.getValue());
            this.redisLock.unlock("CHECK_IN_" + customerId);
            return BaseJsonVo.success((Object)picUrl);
        }
        BaseJsonVo countResult = this.getUserDailyCheckInCount(bindCode, customerId);
        String picUrl = this.activeQrcodeInterface.getDailyCheckInPic(bindCode, countResult.isSuccess() ? (Integer)countResult.getValue() + 1 : 1);
        return BaseJsonVo.success((Object)picUrl);
    }

    private void removeCache(ActiveEntity activeEntity) {
        if (activeEntity != null) {
            if (activeEntity.getKeywordId() != null && activeEntity.getKeywordId() > 0) {
                this.memcachedService.delete("ActiveService.getActiveCouponByKeyWordId", String.valueOf(activeEntity.getKeywordId()));
            }
            this.memcachedService.delete("ActiveService.getActiveEntityByActiveNo", activeEntity.getActiveNo());
            this.memcachedService.delete("ActiveService.getActiveEntityByQrcode", activeEntity.getBindCode());
            this.memcachedService.delete("ActiveService.getActiveNoByBindCode", activeEntity.getBindCode());
            this.memcachedService.delete("ActiveService.checkActiveEnable", activeEntity.getActiveNo());
            this.memcachedService.delete("ActiveQrcodeService.getQrcodeList", activeEntity.getBindCode());
            List<ActiveQrcodeEntity> list = this.activeQrcodeInterface.getQrcodeListByActiveNo(activeEntity.getActiveNo());
            if (list != null) {
                list.forEach(q -> this.memcachedService.delete("ActiveService.getActiveEntityByQrcode", q.getBindCode()));
            }
        }
    }
}

