/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.fit;

import cc.lechun.active.entity.active.ActiveCustomerEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.entity.active.PrizeCouponVo;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.entity.invite.ActiveInviteQueryDo;
import cc.lechun.active.entity.invite.ActiveJoinRecord;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.active.iservice.fit.FitInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.fit.FitCommonService;
import cc.lechun.active.service.fit.FitServiceContext;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.active.vo.FitActiveInviteResultVo;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.user.User;

@Service
public class FitService
extends ActiveBaseService
implements FitInterface {
    @Autowired
    private ActiveCustomerInterface activeCustomerInterface;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveRuleInterface activeRuleInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private WeiXinMediaInterface weiXinMediaInterface;
    @Autowired
    private OssService ossService;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private MallRedisLock redisLock;
    @Autowired
    private FitServiceContext fitServiceContext;

    @Override
    public BaseJsonVo canJoinActive(String customerId, String bindCode) {
        return this.canJoinActive(customerId, bindCode, "");
    }

    @Override
    public BaseJsonVo canJoinActive(String customerId, String bindCode, String source) {
        FitCommonService fitCommonService;
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null && (fitCommonService = this.fitServiceContext.getActiveHanle(String.valueOf(activeEntity.getActiveType()))) != null) {
            return fitCommonService.canJoinActive(customerId, activeEntity, bindCode, source);
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
    }

    @Override
    public BaseJsonVo getActiveInvite(String bindCode, String customerId) {
        FitActiveInviteResultVo inviteResultVo = new FitActiveInviteResultVo();
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null) {
            Integer defaultCount = 0;
            defaultCount = this.getInviteNum(customerId, bindCode);
            ActiveRuleEntity activeRule = this.getPrizeRule(defaultCount, activeEntity);
            inviteResultVo.setPrizeStatus(0);
            ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
            activeCustomerEntity.setCustomerId(customerId);
            activeCustomerEntity.setBindCode(activeEntity.getBindCode());
            int baseCount = this.activeCustomerInterface.getInviteNum(activeCustomerEntity);
            if (baseCount == 0) {
                baseCount = activeEntity.getInviteNum();
            }
            inviteResultVo.setBaseCount(baseCount);
            if (activeRule != null) {
                this.logger.info("\u67e5\u8be2\u7528\u6237\u9080\u8bf7\u4eba\u6570\u4e3a:" + defaultCount);
                inviteResultVo.setPrizeStatus(1);
            }
            inviteResultVo.setCount(defaultCount);
            inviteResultVo.setCityName("");
            this.logger.info("\u76ee\u6807\u4eba\u6570:" + inviteResultVo.getBaseCount());
            inviteResultVo.setEndTime(activeEntity.getEndTime());
            return BaseJsonVo.success((Object)inviteResultVo);
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
    }

    @Override
    public BaseJsonVo getActiveInvite(String bindCode, String customerId, String openId, Integer platFormId) {
        BaseJsonVo baseJsonVo = this.getActiveInvite(bindCode, customerId);
        if (baseJsonVo.isSuccess()) {
            WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getWeixinBaseByFlatformId(platFormId);
            User user = UserAPI.userInfo((String)weiXinBaseEntity.getAccessToken(), (String)openId);
            FitActiveInviteResultVo inviteResultVo = (FitActiveInviteResultVo)baseJsonVo.getValue();
            inviteResultVo.setIssubscribe(user.getSubscribe());
        }
        return baseJsonVo;
    }

    private ActiveRuleEntity getPrizeRule(String customerId, ActiveEntity activeEntity, Integer defaultCount) {
        return this.activeRuleInterface.getRuleByQuantity(activeEntity.getActiveNo(), defaultCount);
    }

    private ActiveRuleEntity getPrizeRule(Integer defaultCount, ActiveEntity activeEntity) {
        return this.activeRuleInterface.getRuleByQuantity(activeEntity.getActiveNo(), defaultCount);
    }

    private Integer getInviteNum(String customerId, String bindCode) {
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setBindCode(bindCode);
        List<ActiveCustomerEntity> list = this.activeCustomerInterface.getActiveCustomerEntityList(activeCustomerEntity);
        Integer defaultCount = 0;
        if (list != null && list.size() > 0) {
            ActiveCustomerEntity result = list.stream().filter(c -> c.getStatus() >= 1).findFirst().get();
            if (result != null) {
                defaultCount = defaultCount + result.getGiveShareCount();
            }
            Integer inviteNum = this.activeInviteInterface.getInviteNum(customerId, bindCode);
            defaultCount = defaultCount + (inviteNum == null ? 0 : inviteNum);
        }
        return defaultCount;
    }

    private ActiveRuleEntity getPrizeRule(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        Integer defaultCount = this.getInviteNum(customerId, bindCode);
        return activeEntity != null ? this.getPrizeRule(customerId, activeEntity, defaultCount) : null;
    }

    @Override
    public BaseJsonVo prizeActive(String bindCode, String customerId, Integer platformId) {
        boolean lock = this.redisLock.lock(customerId + bindCode + ":prize", "", 60L, TimeUnit.SECONDS);
        if (lock) {
            ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
            if (activeEntity != null) {
                Integer status = this.activeCustomerInterface.getJoinActiveStatus(customerId, bindCode);
                if (status != null) {
                    if (status >= 2) {
                        return BaseJsonVo.error((String)"\u5df2\u5151\u5956");
                    }
                } else {
                    return BaseJsonVo.error((String)"\u672a\u53c2\u4e0e\u6d3b\u52a8,\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
                }
                Integer inviteNum = this.getInviteNum(customerId, bindCode);
                ActiveRuleEntity activeRuleEntity = this.activeRuleInterface.getRuleByQuantity(activeEntity.getActiveNo(), inviteNum);
                if (activeRuleEntity == null) {
                    return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
                }
                this.activeCashticketInterface.sendTicket4BaseAsynchronous(customerId, activeRuleEntity.getBindCode(), "", activeEntity.getPlatformId(), true);
                BaseJsonVo baseJsonVo = this.activeCustomerInterface.prizeActive(customerId, bindCode);
                this.activeInviteInterface.setPrize(customerId, bindCode);
                return BaseJsonVo.success((Object)"");
            }
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        return BaseJsonVo.error((String)"\u8bf7\u7a0d\u5019\u518d\u8bd5!");
    }

    @Override
    public BaseJsonVo prizeActive(String inviteId) {
        ActiveInviteEntity inviteEntity = this.activeInviteInterface.getActiveInviteEntity(inviteId);
        if (inviteEntity != null) {
            return this.prizeActive(inviteEntity.getBindCode(), inviteEntity.getCustomerId(), 1);
        }
        return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
    }

    @Override
    public BaseJsonVo getShareByBindCode(String bindCode, String nickName, String customerId) {
        WeiXinMediaEntity weiXinMediaEntity;
        ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
        if (activeQrcodeEntity != null && StringUtils.isNotEmpty((String)activeQrcodeEntity.getShareMedia()) && (weiXinMediaEntity = this.weiXinMediaInterface.getMediaByMediaId(activeQrcodeEntity.getShareMedia())) != null) {
            if (StringUtils.isNotEmpty((String)weiXinMediaEntity.getUrl())) {
                if (weiXinMediaEntity.getUrl().indexOf("?") > 0) {
                    if (weiXinMediaEntity.getUrl().indexOf("bindCode") <= 0) {
                        weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "&bindCode=" + bindCode + "&source=" + customerId);
                    } else {
                        String url = weiXinMediaEntity.getUrl();
                        weiXinMediaEntity.setUrl(url.substring(0, url.indexOf("bindCode")) + "bindCode=" + bindCode + "&source=" + customerId);
                    }
                } else {
                    weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "?bindCode=" + bindCode + "&source=" + customerId);
                }
            }
            weiXinMediaEntity.setDigest(weiXinMediaEntity.getDigest().replace("{nickName}", StringUtils.isEmpty((String)nickName) ? "" : nickName));
            weiXinMediaEntity.setTitle(weiXinMediaEntity.getTitle().replace("{nickName}", StringUtils.isEmpty((String)nickName) ? "" : nickName));
            weiXinMediaEntity.setImageUrl(this.ossService.getImageResoure(weiXinMediaEntity.getImageUrl()));
            return BaseJsonVo.success((Object)weiXinMediaEntity);
        }
        return BaseJsonVo.error((String)"\u672a\u7ed1\u5b9a\u5206\u4eab\u8fde\u63a5");
    }

    @Override
    public List<PrizeCouponVo> getActiveRuleList(String bindCode) {
        ArrayList<PrizeCouponVo> ruleVoList = new ArrayList<PrizeCouponVo>();
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        List<ActiveRuleEntity> list = this.activeRuleInterface.getRuleList(activeEntity.getActiveNo());
        if (list != null && list.size() >= 1) {
            list.sort((c1, c2) -> c1.getInviteQuantityMin() - c2.getInviteQuantityMin());
            list.forEach(c -> {
                PrizeCouponVo vo = new PrizeCouponVo();
                vo.setInviteQuantityMin(c.getInviteQuantityMin());
                List<ActiveCashticketVo> cashList = this.activeCashticketInterface.getSelectCashticketByBindCode(c.getBindCode());
                if (cashList != null && cashList.size() > 0) {
                    vo.setTicketBatchName(cashList.get(0).getTicketBatchName());
                }
                ruleVoList.add(vo);
            });
            return ruleVoList;
        }
        return new ArrayList<PrizeCouponVo>();
    }

    @Override
    public BaseJsonVo getJoinRcordList(ActiveInviteQueryDo activeInviteQueryDo) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(0));
        PageInfo<ActiveInviteEntity> pageInfo = this.activeInviteInterface.getJoinRcordList(activeInviteQueryDo);
        if (pageInfo != null && pageInfo.getList() != null) {
            map.put("total", Long.valueOf(pageInfo.getTotal()));
            ArrayList list = new ArrayList();
            if (pageInfo.getList() != null && pageInfo.getList().size() > 0) {
                pageInfo.getList().forEach(i -> {
                    ActiveJoinRecord activeJoinRecord = new ActiveJoinRecord();
                    BeanUtils.copyProperties((Object)i, (Object)activeJoinRecord);
                    ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(i.getActiveNo());
                    activeJoinRecord.setActiveName(activeEntity == null ? "" : activeEntity.getActiveName());
                    CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(i.getCustomerId(), activeEntity.getPlatformId());
                    activeJoinRecord.setHeadImageUrl(customerDetailVo == null ? "" : customerDetailVo.getHeadImageUrl());
                    activeJoinRecord.setNickName(customerDetailVo == null ? "" : customerDetailVo.getNickName());
                    Integer status = 0;
                    if (activeEntity.getActiveType() == 19 || activeEntity.getActiveType() == 22) {
                        status = this.activeCustomerInterface.getJoinActiveStatus(i.getCustomerId(), i.getBindCode());
                    } else if (activeEntity.getActiveType() == 11) {
                        status = 1;
                    }
                    activeJoinRecord.setIsPrize(status == null ? 0 : status);
                    list.add(activeJoinRecord);
                });
            }
            map.put("list", list);
        }
        return BaseJsonVo.success(map);
    }
}

