/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.groupon;

import cc.lechun.active.dao.groupon.GrouponConfigMapper;
import cc.lechun.active.dao.groupon.GrouponDetailMapper;
import cc.lechun.active.dao.groupon.GrouponMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.groupon.GrouponConfigEntity;
import cc.lechun.active.entity.groupon.GrouponDetailEntity;
import cc.lechun.active.entity.groupon.GrouponEntity;
import cc.lechun.active.entity.groupon.GrouponOrder;
import cc.lechun.active.entity.groupon.GrouponOrderQueryVo;
import cc.lechun.active.entity.groupon.GrouponOrderResultVo;
import cc.lechun.active.entity.groupon.GrouponOrderVo;
import cc.lechun.active.entity.groupon.GrouponRefundOrderVo;
import cc.lechun.active.entity.groupon.JoinOrderVo;
import cc.lechun.active.entity.groupon.StartGrouponItemVo;
import cc.lechun.active.entity.groupon.SuccessJoinOrderVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.groupon.GrouponMessageContext;
import cc.lechun.active.service.groupon.GrouponMessageHandle;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GrouponService
extends ActiveBaseService
implements GrouponInterface {
    @Autowired
    private GrouponMapper grouponMapper;
    @Autowired
    private GrouponDetailMapper grouponDetailMapper;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MallOrderMainInterface mallOrderMainService;
    @Autowired
    private GrouponConfigMapper configMapper;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private GrouponMessageContext grouponMessageContext;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketService;

    @Override
    public List<GrouponOrderResultVo> getGrouponOrderResultList(GrouponOrderQueryVo grouponOrderQueryVo) {
        Page page = PageHelper.startPage((int)grouponOrderQueryVo.getCurrentPage(), (int)grouponOrderQueryVo.getPageSize()).setOrderBy(" INVITE_ID DESC ");
        this.grouponMapper.getGrouponOrderList(grouponOrderQueryVo);
        List list = page.toPageInfo().getList();
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<GrouponOrderResultVo> resultVoList = new ArrayList<GrouponOrderResultVo>();
        list.forEach(g -> {
            GrouponOrderResultVo grouponOrderResultVo = new GrouponOrderResultVo();
            CustomerEntity customerEntity = this.customerService.getCustomer(g.getCustomerId());
            grouponOrderResultVo.setHeadImageUrl(customerEntity == null ? "" : customerEntity.getHeadImageUrl());
            grouponOrderResultVo.setNickName(customerEntity == null ? "" : customerEntity.getNickName());
            GrouponEntity grouponEntity = this.getGrouponInfoByInviteId(g.getInviteId());
            BeanUtils.copyProperties((Object)grouponEntity, (Object)grouponOrderResultVo);
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(grouponEntity.getActiveNo());
            grouponOrderResultVo.setActiveName(activeEntity == null ? "" : activeEntity.getActiveName());
            grouponOrderResultVo.setGrouponRoleType(g.getCustomerId().equals(g.getCustomerId()) ? 1 : 2);
            resultVoList.add(grouponOrderResultVo);
        });
        return resultVoList;
    }

    @Override
    public List<JoinOrderVo> getJoinOrderVoList(String inviteId) {
        ArrayList<JoinOrderVo> list = new ArrayList<JoinOrderVo>();
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(grouponEntity.getCustomerId(), grouponEntity.getPlatformId());
        JoinOrderVo joinOrderVo = new JoinOrderVo();
        joinOrderVo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
        joinOrderVo.setNickName(customerDetailVo.getNickName());
        list.add(joinOrderVo);
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        grouponDetailEntity.setInviteId(inviteId);
        List detailEntityList = this.grouponDetailMapper.getList(grouponDetailEntity);
        if (detailEntityList != null && detailEntityList.size() >= 1) {
            detailEntityList.stream().filter(d -> d.getStatus() >= 0).forEach(d -> {
                CustomerDetailVo customerDetailVo2 = this.customerService.getCustomerDetail(d.getAcceptCustomerId(), grouponEntity.getPlatformId());
                JoinOrderVo joinOrderVo2 = new JoinOrderVo();
                joinOrderVo2.setHeadImageUrl(customerDetailVo2.getHeadImageUrl());
                joinOrderVo2.setNickName(customerDetailVo2.getNickName());
                list.add(joinOrderVo2);
            });
        }
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponConfigByBindCode")
    public GrouponConfigEntity getGrouponConfigByBindCode(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            throw new RuntimeException("\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        return this.getGrouponConfig(activeEntity.getActiveNo());
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getSuccessGrouponList", expiration=300)
    public List<SuccessJoinOrderVo> getSuccessGrouponList(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer num, @ParameterValueKeyProvider(order=2) Integer platformId) {
        ArrayList<SuccessJoinOrderVo> successJoinOrderVoArrayList = new ArrayList<SuccessJoinOrderVo>();
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        grouponDetailEntity.setStatus(1);
        grouponDetailEntity.setBindCode(bindCode);
        List<GrouponDetailEntity> dettailList = this.grouponDetailMapper.getSuccessGrouponList(bindCode, num, 1);
        if (dettailList != null && dettailList.size() >= 1) {
            dettailList.forEach(g -> {
                SuccessJoinOrderVo successJoinOrderVo = new SuccessJoinOrderVo();
                CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(g.getAcceptCustomerId(), platformId);
                BeanUtils.copyProperties((Object)customerDetailVo, (Object)successJoinOrderVo);
                successJoinOrderVoArrayList.add(successJoinOrderVo);
            });
        }
        return successJoinOrderVoArrayList;
    }

    @Override
    public BaseJsonVo checkCanJoin(String bindCode, String customerId, String inviteId) {
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        if (grouponEntity == null) {
            return BaseJsonVo.error((String)"\u554a\u5662~\u672a\u77e5\u7684\u56e2\u8d2d\u6d3b\u52a8");
        }
        if (grouponEntity.getIsPrize() == 1) {
            return BaseJsonVo.success((Object)3);
        }
        if (grouponEntity.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.success((Object)6);
        }
        GrouponConfigEntity grouponConfigEntity = this.getGrouponConfig(grouponEntity.getActiveNo());
        if (grouponConfigEntity.getAllowUserType() == 2) {
            if (customerId.equals(grouponEntity.getCustomerId())) {
                return BaseJsonVo.success((Object)7);
            }
        } else {
            int num = this.mallOrderMainService.getOrderNum(customerId);
            if (num >= 1) {
                return BaseJsonVo.success((Object)5);
            }
        }
        return BaseJsonVo.success((Object)1);
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponList", expiration=30)
    public List<StartGrouponItemVo> getGrouponList(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer num) {
        ArrayList<StartGrouponItemVo> listStart = new ArrayList<StartGrouponItemVo>();
        GrouponEntity grouponEntity = new GrouponEntity();
        grouponEntity.setIsPrize(0);
        grouponEntity.setBindCode(bindCode);
        List<GrouponEntity> list = this.grouponMapper.getStartOrderList(bindCode, 0, num);
        if (list != null && list.size() >= 1) {
            list.forEach(g -> {
                if (g.getEndTime().after(DateUtils.now())) {
                    StartGrouponItemVo startGrouponItemVo = new StartGrouponItemVo();
                    BeanUtils.copyProperties((Object)g, (Object)startGrouponItemVo);
                    CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(g.getCustomerId(), g.getPlatformId());
                    if (customerDetailVo != null) {
                        startGrouponItemVo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
                        startGrouponItemVo.setNickName(customerDetailVo.getNickName());
                        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)g.getEndTime());
                        startGrouponItemVo.setSecond(seconds);
                        startGrouponItemVo.setShortNum(g.getJoinNum() - g.getInviteCount());
                        listStart.add(startGrouponItemVo);
                    }
                }
            });
        }
        return listStart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveGrouponOrder(GrouponOrderVo grouponOrderVo) {
        try {
            if (grouponOrderVo.getStatus().intValue() == OrderStatusEnum.UNPAY.getValue()) {
                this.logger.info("\u63d0\u4ea4\u4e86\u53c2\u56e2\u8ba2\u5355:{}", (Object)grouponOrderVo.toString());
                this.joinGroupon(grouponOrderVo);
                return;
            }
            if (grouponOrderVo.getStatus().intValue() == OrderStatusEnum.UNCONFIRM.getValue()) {
                String productName = this.getProductName(grouponOrderVo.getOrderMainNo());
                grouponOrderVo.setProductName(productName);
                GrouponOrder grouponOrder = this.grouponMapper.chaXunGrouponOrderByOrderNo(grouponOrderVo.getOrderMainNo());
                if (grouponOrder == null) {
                    if (StringUtils.isEmpty((String)grouponOrderVo.getInviteId())) {
                        this.createGroupon(grouponOrderVo);
                        return;
                    } else {
                        this.logger.error("\u672a\u8bb0\u5f55\u62fc\u56e2\u8ba2\u5355\u63d0\u4ea4\u8bb0\u5f55,orderNo={}", (Object)grouponOrder.getOrderMainNo());
                        this.joinGroupon(grouponOrderVo);
                    }
                    return;
                } else {
                    if (grouponOrder.getOrderType() != 2) return;
                    this.logger.info("\u62fc\u56e2\u8ba2\u5355\u4e0b\u76f4\u63a5\u652f\u4ed8:{}", (Object)grouponOrderVo.toString());
                    if (StringUtils.isEmpty((String)grouponOrderVo.getInviteId())) {
                        grouponOrderVo.setInviteId(grouponOrder.getInviteId());
                    }
                    this.joinGroupon(grouponOrderVo);
                }
                return;
            }
            if (grouponOrderVo.getStatus().intValue() != OrderStatusEnum.COMPLETION.getValue()) return;
        }
        catch (Exception e) {
            this.logger.error("\u56e2\u8d2d\u8ba2\u5355\u51fa\u9519:{}", (Object)grouponOrderVo.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void saveGrouponOrder(MallOrderMainEntity mallOrderEntity) {
        GrouponOrderVo grouponOrderVo = new GrouponOrderVo();
        grouponOrderVo.setOrderMainNo(mallOrderEntity.getOrderMainNo());
        grouponOrderVo.setCustomerId(mallOrderEntity.getCustomerId());
        grouponOrderVo.setPlatFormId(mallOrderEntity.getPlatformId());
        grouponOrderVo.setStatus(OrderStatusEnum.UNCONFIRM.getValue());
        grouponOrderVo.setBindCode(mallOrderEntity.getBindCode());
        grouponOrderVo.setInviteId("");
        grouponOrderVo.setActiveNo(mallOrderEntity.getActiveNo());
        grouponOrderVo.setPrice(mallOrderEntity.getTotalAmount());
        this.saveGrouponOrder(grouponOrderVo);
    }

    @Override
    public GrouponOrder getGrouponOrderByOrderNo(String orderMainNo) {
        return this.grouponMapper.chaXunGrouponOrderByOrderNo(orderMainNo);
    }

    @Override
    public GrouponEntity getGrouponInfoByInviteId(String inviteid) {
        return (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteid));
    }

    @Override
    public Integer getGrouponNumByOrderNo(String orderNo) {
        MallOrderMainEntity orderMainEntity = this.mallOrderMainService.selectByPrimaryKey(orderNo);
        return this.getJoinNum(orderMainEntity.getBindCode());
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponHourByBindCode")
    public Integer getGrouponHourByBindCode(@ParameterValueKeyProvider String bindCode) {
        String activeNo = this.activeQrcodeService.getActiveQrcode(bindCode).getActiveNo();
        GrouponConfigEntity grouponConfigEntity = this.getGrouponConfig(activeNo);
        return grouponConfigEntity == null ? null : Integer.valueOf(grouponConfigEntity.getGrouponHour() + 1);
    }

    @Override
    public Integer getJoinNumByInviteId(String inviteId) {
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        return grouponEntity.getJoinNum();
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponConfig")
    public GrouponConfigEntity getGrouponConfig(@ParameterValueKeyProvider String activeNo) {
        GrouponConfigEntity grouponConfigEntity = new GrouponConfigEntity();
        grouponConfigEntity.setActiveNo(activeNo);
        return (GrouponConfigEntity)this.configMapper.getSingle(grouponConfigEntity);
    }

    @Override
    public Integer saveGrouponConfig(GrouponConfigEntity grouponConfigEntity) {
        this.removeCache(grouponConfigEntity);
        if (grouponConfigEntity.getId() == null) {
            return this.configMapper.insertSelective(grouponConfigEntity);
        }
        return this.configMapper.updateByPrimaryKeySelective(grouponConfigEntity);
    }

    @Override
    public void sendFastGrouponedCoupon(String bindCode, String orderNo, String customerId) {
        GrouponDetailEntity grouponDetailEntity = this.grouponDetailMapper.getJoinGrouponOrder(orderNo);
        if (grouponDetailEntity != null) {
            GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponDetailEntity.getInviteId()));
            if (grouponEntity.getPrizeTime().before(DateUtils.getAddDateBySecond((Date)grouponEntity.getCreateTime(), (int)10800))) {
                GrouponDetailEntity tempGrouponDetailEntity = new GrouponDetailEntity();
                tempGrouponDetailEntity.setInviteId(grouponDetailEntity.getInviteId());
                List list = this.grouponDetailMapper.getList(tempGrouponDetailEntity);
            } else {
                this.logger.info("\u8ba2\u5355\u53f7:{},\u5f00\u56e2\u65f6\u95f4\uff1a{},\u6210\u56e2\u65f6\u95f4:{} \u6210\u56e2\u65f6\u95f4\u8d85\u8fc73\u5c0f\u65f6", new Object[]{orderNo, grouponEntity.getCreateTime(), grouponEntity.getPrizeTime()});
            }
        }
    }

    private void paySucessGroupon(GrouponOrderVo grouponOrderVo) {
        String keyNum = grouponOrderVo.getInviteId() + ":joinedGrouponKey:Num";
        grouponOrderVo.setProductType(this.getGrouponType(grouponOrderVo.getBindCode()));
        this.memcachedService.incr("", keyNum, 1, 1L, 172800);
        GrouponMessageHandle grouponMessageHandle = this.grouponMessageContext.getGrouponMessageHanle(grouponOrderVo.getPlatFormId());
        if (grouponMessageHandle != null) {
            grouponMessageHandle.startGrouponNotice(grouponOrderVo);
        }
    }

    private void createGroupon(GrouponOrderVo grouponOrderVo) {
        boolean temp;
        GrouponEntity grouponEntity = new GrouponEntity();
        grouponEntity.setCreateTime(DateUtils.now());
        grouponEntity.setCustomerId(grouponOrderVo.getCustomerId());
        grouponEntity.setInviteId(String.valueOf(RandomUtils.generateId()));
        grouponEntity.setInviteCount(1);
        grouponEntity.setIsPrize(0);
        grouponEntity.setOrderMainNo(grouponOrderVo.getOrderMainNo());
        grouponEntity.setBindCode(grouponOrderVo.getBindCode());
        grouponEntity.setOrderType(1);
        grouponEntity.setPrizeTime(DateUtils.now());
        grouponEntity.setPlatformId(grouponOrderVo.getPlatFormId());
        grouponEntity.setActiveNo(grouponOrderVo.getActiveNo());
        grouponEntity.setJoinNum(this.getJoinNum(grouponOrderVo.getBindCode()));
        this.logger.info("\u5199\u5f00\u56e2\u8bb0\u5f55:\u56e2\u8d2d\u62fc\u56e2\u65f6\u95f4\u8bbe\u7f6e:{}", (Object)this.getGrouponConfig(grouponEntity.getActiveNo()).getGrouponHour());
        grouponEntity.setEndTime(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)(this.getGrouponConfig(grouponEntity.getActiveNo()).getGrouponHour() * 60 * 60)));
        this.logger.info("\u5199\u5f00\u56e2\u8bb0\u5f55:{}", (Object)grouponOrderVo.toString());
        boolean bl = temp = this.grouponMapper.insertSelective(grouponEntity) >= 1;
        if (temp) {
            grouponOrderVo.setEndTime(grouponEntity.getEndTime());
            grouponOrderVo.setInviteId(grouponEntity.getInviteId());
            grouponOrderVo.setTotal(grouponEntity.getJoinNum());
            grouponOrderVo.setOnly(grouponEntity.getInviteCount());
            grouponOrderVo.setGrouponRoleType(1);
            String nick = this.customerService.getCustomer(grouponEntity.getCustomerId()).getNickName();
            grouponOrderVo.setGrouponerNick(StringUtils.isEmpty((String)nick) ? "" : nick);
            this.paySucessGroupon(grouponOrderVo);
            HashMap<String, Object> messageBody2 = new HashMap<String, Object>();
            messageBody2.put("userId", grouponOrderVo.getCustomerId());
            messageBody2.put("dataFrom", "\u5f00\u56e2");
            messageBody2.put("bindCode", grouponOrderVo.getBindCode());
            messageBody2.put("activeNo", grouponEntity.getActiveNo());
            messageBody2.put("versionName", "");
            messageBody2.put("createTime", DateUtils.now());
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.activeData, MessageParam.messageParam((String)grouponOrderVo.getOrderMainNo(), messageBody2));
        }
        this.logger.info("\u5199\u5f00\u56e2\u8bb0\u5f55\u72b6\u6001:{},{}", (Object)temp, (Object)grouponOrderVo.toString());
    }

    private void joinGroupon(GrouponOrderVo grouponOrderVo) {
        HashMap<String, Object> messageBody2 = new HashMap<String, Object>();
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        if (grouponOrderVo.getStatus().intValue() == OrderStatusEnum.UNPAY.getValue()) {
            this.createJoinGroupon(grouponOrderVo, grouponDetailEntity);
            messageBody2.put("dataFrom", "\u63d0\u4ea4\u53c2\u56e2\u8ba2\u5355");
        } else if (grouponOrderVo.getStatus().intValue() == OrderStatusEnum.UNCONFIRM.getValue()) {
            this.paySuccessJoinGroupon(grouponOrderVo);
            messageBody2.put("dataFrom", "\u53c2\u56e2");
        }
        messageBody2.put("userId", grouponOrderVo.getCustomerId());
        messageBody2.put("bindCode", grouponOrderVo.getBindCode());
        messageBody2.put("activeNo", grouponOrderVo.getActiveNo());
        messageBody2.put("versionName", "");
        messageBody2.put("createTime", DateUtils.now());
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.activeData, MessageParam.messageParam((String)grouponOrderVo.getOrderMainNo(), messageBody2));
    }

    @Override
    public void paySuccessJoinGroupon(GrouponOrderVo grouponOrderVo) {
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        String keyNum = grouponOrderVo.getInviteId() + ":joinedGrouponKey:Num";
        Long num = this.memcachedService.incr("", keyNum, 1, 1L, 172800);
        this.logger.info("\u56e2\u8d2dId:{} ,\u4eba\u6570:{}", (Object)grouponOrderVo.getInviteId(), (Object)num.intValue());
        GrouponDetailEntity tempGroupon = this.getGrouponDetailByOrder(grouponOrderVo.getOrderMainNo());
        grouponDetailEntity.setInviteDetailId(tempGroupon.getInviteDetailId());
        GrouponEntity updateGrouponEntity = new GrouponEntity();
        updateGrouponEntity.setInviteId(tempGroupon.getInviteId());
        GrouponEntity tempGrouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)tempGroupon.getInviteId()));
        if (tempGrouponEntity.getInviteCount() > num.intValue()) {
            num = (long)tempGrouponEntity.getInviteCount();
        }
        grouponDetailEntity.setCustomerId(tempGrouponEntity.getCustomerId());
        tempGroupon.setCustomerId(tempGrouponEntity.getCustomerId());
        Integer totalNum = tempGrouponEntity.getJoinNum();
        grouponOrderVo.setTotal(totalNum);
        if (num < (long)totalNum.intValue()) {
            grouponDetailEntity.setStatus(0);
            updateGrouponEntity.setInviteCount(num.intValue());
            grouponOrderVo.setGrouponRoleType(2);
            grouponOrderVo.setOnly(num.intValue());
            grouponOrderVo.setEndTime(tempGrouponEntity.getEndTime());
            grouponOrderVo.setInviteId(tempGroupon.getInviteId());
            GrouponMessageHandle grouponMessageHandle = this.grouponMessageContext.getGrouponMessageHanle(grouponOrderVo.getPlatFormId());
            if (grouponMessageHandle != null) {
                grouponMessageHandle.startGrouponNotice(grouponOrderVo);
                grouponMessageHandle.noticeGrouponerShare(grouponOrderVo, tempGroupon);
            }
        } else {
            grouponDetailEntity.setStatus(1);
            grouponDetailEntity.setPrizeTime(DateUtils.now());
            updateGrouponEntity.setInviteCount(totalNum);
            updateGrouponEntity.setIsPrize(1);
            updateGrouponEntity.setPrizeTime(DateUtils.now());
        }
        this.updateGrouponOrderInfo(grouponDetailEntity, updateGrouponEntity);
        if (num >= (long)totalNum.intValue()) {
            HashMap<String, Object> messageBody2 = new HashMap<String, Object>();
            messageBody2.put("userId", grouponOrderVo.getCustomerId());
            messageBody2.put("dataFrom", "\u6210\u56e2");
            messageBody2.put("bindCode", grouponOrderVo.getBindCode());
            messageBody2.put("activeNo", grouponOrderVo.getActiveNo());
            messageBody2.put("versionName", "");
            messageBody2.put("createTime", DateUtils.now());
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.activeData, MessageParam.messageParam((String)grouponOrderVo.getOrderMainNo(), messageBody2));
            String key = tempGroupon.getInviteId() + ":success:notice";
            if (this.memcachedService.get("", key) == null) {
                this.memcachedService.set("", key, (Object)1, 300);
                grouponOrderVo.setEndTime(tempGrouponEntity.getEndTime());
                grouponOrderVo.setProductType(this.getGrouponType(tempGrouponEntity.getBindCode()));
                String nick = this.customerService.getCustomer(tempGrouponEntity.getCustomerId()).getNickName();
                this.logger.info("\u56e2\u957f\u6635\u79f0:{},\u56e2\u957fcustomerId={}", (Object)nick, (Object)tempGroupon.getCustomerId());
                grouponOrderVo.setGrouponerNick(StringUtils.isNotEmpty((String)nick) ? nick : "");
                this.pushGrouponedSuccessNotice(grouponOrderVo, tempGrouponEntity, totalNum);
            } else {
                int grouponType = this.getGrouponType(tempGrouponEntity.getBindCode());
                String orderStatusName = grouponType == 1 ? OrderStatusEnum.PAYCONFIRM.getName() : OrderStatusEnum.COMPLETION.getName();
                boolean orderStatus = this.mallOrderMainService.updateOrderMainStatus(grouponOrderVo.getOrderMainNo(), orderStatusName, grouponDetailEntity.getAcceptCustomerId(), OrderStatusEnum.UNCONFIRM.getValue());
                List<MallOrderEntity> orderEntities = this.mallOrderInterface.getOrderList(grouponOrderVo.getOrderMainNo());
                for (MallOrderEntity o : orderEntities) {
                    if (this.mallOrderInterface.paySuccessOrder(o.getOrderNo(), orderStatusName)) continue;
                    this.logger.error("\u66f4\u65b0\u5b50\u8ba2\u5355\u5931\u8d25{}", (Object)grouponDetailEntity.toString());
                }
            }
        }
    }

    @Override
    @Transactional
    public void updateGrouponOrderInfo(GrouponDetailEntity grouponDetailEntity, GrouponEntity updateGrouponEntity) {
        this.grouponMapper.updateByPrimaryKeySelective(updateGrouponEntity);
        this.grouponDetailMapper.updateByPrimaryKeySelective(grouponDetailEntity);
    }

    @Override
    public String getProductName(String orderNo) {
        Map<String, Object> proMap = this.grouponMapper.getGroupInfoByOrderNo(orderNo);
        return (String)proMap.getOrDefault("PRODUCT_NAME", "");
    }

    private void pushGrouponedSuccessNotice(GrouponOrderVo grouponOrderVo, GrouponEntity tempGrouponEntity, Integer totalNum) {
        List<GrouponOrder> grouponOrderList = this.grouponMapper.chaXunGrouponOrderList(tempGrouponEntity.getInviteId());
        int grouponType = this.getGrouponType(tempGrouponEntity.getBindCode());
        String orderStatusName = grouponType == 1 ? OrderStatusEnum.PAYCONFIRM.getName() : OrderStatusEnum.COMPLETION.getName();
        boolean setJoinFlag = false;
        for (GrouponOrder m : grouponOrderList) {
            MallOrderMainEntity orderMainEntity = this.mallOrderMainService.selectByPrimaryKey(m.getOrderMainNo());
            if (orderMainEntity.getStatus() == 2) {
                GrouponMessageHandle grouponMessageHandle;
                this.logger.info("\u66f4\u65b0\u4e3b\u8ba2\u5355\u72b6\u6001:{},\u72b6\u6001\u4e3a:{},\u8001\u72b6\u6001\u4e3a:{}", new Object[]{grouponOrderVo.getOrderMainNo(), orderStatusName, orderMainEntity.getStatus()});
                boolean orderStatus = this.mallOrderMainService.updateOrderMainStatus(m.getOrderMainNo(), orderStatusName, m.getCustomerId(), OrderStatusEnum.UNCONFIRM.getValue());
                this.logger.info("\u66f4\u65b0\u4e3b\u8ba2\u5355\u72b6\u6001:{},\u72b6\u6001\u4e3a:{}", (Object)grouponOrderVo.getOrderMainNo(), (Object)orderStatus);
                List<MallOrderEntity> orderEntities = this.mallOrderInterface.getOrderList(m.getOrderMainNo());
                for (MallOrderEntity o : orderEntities) {
                    if (this.mallOrderInterface.paySuccessOrder(o.getOrderNo(), orderStatusName)) continue;
                    this.logger.error("\u66f4\u65b0\u5b50\u8ba2\u5355\u5931\u8d25,{}", (Object)m.toString());
                }
                if (null != m.getOrderType()) {
                    this.logger.info("\u6210\u56e2\u8ba2\u5355\u4fe1\u606f:{}", (Object)m.toString());
                    if (1 == m.getOrderType()) {
                        GrouponEntity tempGroupon2 = new GrouponEntity();
                        tempGroupon2.setInviteId(tempGrouponEntity.getInviteId());
                        tempGroupon2.setOrderMainNo(m.getOrderMainNo());
                        tempGroupon2.setIsPrize(1);
                        tempGroupon2.setPrizeTime(DateUtils.now());
                        tempGroupon2.setInviteCount(totalNum);
                        this.grouponMapper.updateByPrimaryKeySelective(tempGroupon2);
                        this.logger.info("\u5df2\u8bbe\u7f6e\u5f00\u56e2\u8ba2\u5355\u4e3a\u5df2\u6210\u56e2:{}", (Object)tempGroupon2.toString());
                    } else if (2 == m.getOrderType() && !setJoinFlag) {
                        boolean tempStatus;
                        GrouponDetailEntity tempGrouponDetailEntity = new GrouponDetailEntity();
                        tempGrouponDetailEntity.setStatus(1);
                        tempGrouponDetailEntity.setPrizeTime(DateUtils.now());
                        tempGrouponDetailEntity.setInviteId(m.getInviteId());
                        boolean bl = tempStatus = this.grouponDetailMapper.updateGrouponOrderInfoByInviteId(tempGrouponDetailEntity) >= 1;
                        if (tempStatus) {
                            setJoinFlag = true;
                            this.logger.info("\u5df2\u8bbe\u7f6e\u62fc\u56e2\u8ba2\u5355\u4e3a\u5df2\u6210\u56e2:{}", (Object)tempGrouponDetailEntity.toString());
                        }
                    }
                }
                if (grouponType == 2) {
                    this.logger.info("\u5f00\u59cb\u53d1\u653e\u4f18\u60e0\u5238:customerId={},bincode={}", (Object)m.getCustomerId(), (Object)grouponOrderVo.getBindCode());
                    this.activeCashticketService.sendTicket4BaseAsynchronous(m.getCustomerId(), grouponOrderVo.getBindCode(), "", grouponOrderVo.getPlatFormId(), true);
                }
                if ((grouponMessageHandle = this.grouponMessageContext.getGrouponMessageHanle(orderMainEntity.getPlatformId())) == null) continue;
                grouponOrderVo.setCustomerId(orderMainEntity.getCustomerId());
                grouponMessageHandle.joinGrouponNoticeSuccess(grouponOrderVo);
                continue;
            }
            this.logger.info("\u56e2\u8d2d\u8ba2\u5355\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u5f85\u53d1\u8d27:{},\u8ba2\u5355\u72b6\u6001\u4e3a:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)orderMainEntity.getStatus());
            this.logger.info("\u56e2\u8d2d\u8ba2\u5355:{}", (Object)orderMainEntity.toString());
        }
    }

    private void createJoinGroupon(GrouponOrderVo grouponOrderVo, GrouponDetailEntity grouponDetailEntity) {
        this.logger.info("\u63d0\u4ea4\u62fc\u56e2\u8ba2\u5355:{}", (Object)grouponDetailEntity.toString());
        GrouponEntity tempGrouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponOrderVo.getInviteId()));
        grouponDetailEntity.setCreateTime(DateUtils.now());
        grouponDetailEntity.setCustomerId(tempGrouponEntity.getCustomerId());
        grouponDetailEntity.setInviteId(grouponOrderVo.getInviteId());
        grouponDetailEntity.setStatus(-1);
        grouponDetailEntity.setAcceptCustomerId(grouponOrderVo.getCustomerId());
        grouponDetailEntity.setBindCode(grouponOrderVo.getBindCode());
        grouponDetailEntity.setPlatformId(grouponOrderVo.getPlatFormId());
        grouponDetailEntity.setOrderMainNo(grouponOrderVo.getOrderMainNo());
        boolean temp = this.grouponDetailMapper.insertSelective(grouponDetailEntity) >= 1;
        this.logger.info("\u521b\u5efa\u62fc\u56e2\u8ba2\u5355\u72b6\u6001:{},{}", (Object)temp, (Object)grouponDetailEntity.toString());
    }

    public Integer getJoinNum(String bindCode) {
        String activeNo = this.activeQrcodeService.getActiveQrcode(bindCode).getActiveNo();
        if ("".equals(bindCode)) {
            return 3;
        }
        return this.getGrouponConfig(activeNo).getJoinNum();
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponType")
    public Integer getGrouponType(@ParameterValueKeyProvider String bindCode) {
        String activeNo = this.activeQrcodeService.getActiveNoQrcode(bindCode);
        return this.getGrouponConfig(activeNo).getGrouponType();
    }

    private GrouponDetailEntity getGrouponDetailByOrder(String orderNo) {
        GrouponDetailEntity temp = new GrouponDetailEntity();
        temp.setOrderMainNo(orderNo);
        return (GrouponDetailEntity)this.grouponDetailMapper.getSingle(temp);
    }

    @Override
    public List<GrouponRefundOrderVo> getUnRefundApplyOrders(Date date) {
        List<GrouponRefundOrderVo> unknownList;
        List<GrouponRefundOrderVo> joinList;
        ArrayList<GrouponRefundOrderVo> orderList = new ArrayList<GrouponRefundOrderVo>();
        List<GrouponRefundOrderVo> startList = this.starerRefund(date);
        if (startList != null && startList.size() >= 1) {
            orderList.addAll(startList);
        }
        if ((joinList = this.joinRefund(date)) != null && joinList.size() >= 1) {
            orderList.addAll(joinList);
        }
        if ((unknownList = this.unknowRefund(date)) != null && unknownList.size() >= 1) {
            orderList.addAll(unknownList);
        }
        return orderList;
    }

    @Override
    public BaseJsonVo updateGrouponOrderStatus(GrouponRefundOrderVo grouponRefundOrderVo) {
        this.logger.info("\u8d85\u65f6\u8ba2\u5355\u4e3a:{}", (Object)grouponRefundOrderVo.toString());
        if (grouponRefundOrderVo.getGrouponRoleType() != null) {
            if (grouponRefundOrderVo.getGrouponRoleType() == 1) {
                GrouponEntity grouponEntity = new GrouponEntity();
                grouponEntity.setOrderMainNo(grouponRefundOrderVo.getOrderMainNo());
                grouponEntity.setIsPrize(2);
                int k = this.grouponMapper.updateGrouponOrderInfoByOrderNo(grouponEntity);
                this.logger.info("\u8bbe\u7f6e\u5f00\u56e2\u72b6\u6001\u4e3a\u62fc\u56e2\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={},\u8bbe\u7f6e\u72b6\u6001\uff1a{}", (Object)grouponRefundOrderVo.getOrderMainNo(), (Object)(k >= 1 ? 1 : 0));
            } else if (grouponRefundOrderVo.getGrouponRoleType() == 2) {
                GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
                grouponDetailEntity.setOrderMainNo(grouponRefundOrderVo.getOrderMainNo());
                grouponDetailEntity.setStatus(2);
                int k = this.grouponDetailMapper.updateGrouponOrderInfoByOrderNo(grouponDetailEntity);
                this.logger.info("\u8bbe\u7f6e\u62fc\u56e2\u72b6\u6001\u4e3a\u62fc\u56e2\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={},\u8bbe\u7f6e\u72b6\u6001\uff1a{}", (Object)grouponRefundOrderVo.getOrderMainNo(), (Object)(k >= 1 ? 1 : 0));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<String> getUnRefundOrders() {
        List<String> tt;
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setOrderSource(OrderSourceEnum.TEAM_BUY.getValue());
        orderMainEntity.setStatus(OrderStatusEnum.REFUND_APPLY.getValue());
        List<MallOrderMainEntity> list = this.mallOrderMainService.getOrderMainList(orderMainEntity);
        if (list != null && list.size() >= 1 && (tt = list.stream().filter(c -> c.getCreateTime().after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-25))).map(MallOrderMainEntity::getOrderMainNo).collect(Collectors.toList())) != null && tt.size() >= 1) {
            return tt;
        }
        return null;
    }

    private List<GrouponRefundOrderVo> starerRefund(Date date) {
        List<GrouponEntity> list = this.grouponMapper.getUnrefundStartOrder(date);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(g -> g.getIsPrize() == 0).map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setGrouponRoleType(1);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private List<GrouponRefundOrderVo> joinRefund(Date date) {
        List<GrouponDetailEntity> list = this.grouponDetailMapper.getUnrefundJoinOrder(date);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(g -> g.getStatus() == 0).map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setCustomerId(c.getAcceptCustomerId());
                grouponRefundOrderVo.setGrouponRoleType(2);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private List<GrouponRefundOrderVo> unknowRefund(Date date) {
        List<MallOrderMainEntity> list = this.mallOrderMainService.getTeamSaleOrderList(date);
        if (list != null && list.size() >= 1) {
            return list.stream().map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setGrouponRoleType(3);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private void removeCache(GrouponConfigEntity grouponConfigEntity) {
        if (grouponConfigEntity != null) {
            this.memcachedService.delete("GrouponService.getGrouponConfig", grouponConfigEntity.getActiveNo());
            List<ActiveQrcodeEntity> list = this.activeQrcodeService.getQrcodeListByActiveNo(grouponConfigEntity.getActiveNo());
            if (list != null && list.size() >= 1) {
                list.forEach(q -> {
                    this.memcachedService.delete("GrouponService.getGrouponHourByBindCode", q.getBindCode());
                    this.memcachedService.delete("GrouponService.getGrouponConfigByBindCode", q.getBindCode());
                    this.memcachedService.delete("GrouponService.getGrouponType", q.getBindCode());
                });
            }
        }
    }
}

