/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.ask;

import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.ask.MallAnswerMapper;
import cc.lechun.mall.dao.ask.MallCustomerAnswerMapper;
import cc.lechun.mall.dao.ask.MallQuestionnewMapper;
import cc.lechun.mall.entity.ask.MallAnswerEntity;
import cc.lechun.mall.entity.ask.MallCustomerAnswerEntity;
import cc.lechun.mall.entity.ask.MallQuestionAnswerVo;
import cc.lechun.mall.entity.ask.MallQuestionnewEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.ask.MallAskInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallAskService
extends BaseService
implements MallAskInterface {
    @Autowired
    private MallQuestionnewMapper mallQuestionnewMapper;
    @Autowired
    private MallAnswerMapper mallAnswerMapper;
    @Autowired
    private MallCustomerAnswerMapper mallCustomerAnswerMapper;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo getNextQuestion(String customerId, String bindCode) {
        this.logger.info("+++cc.lechun.mall.service.ask.MallAskService.getNextQuestion+++start++++customerId={},bindCode={}", (Object)customerId, (Object)bindCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)customerId) || StringUtils.isEmpty((String)bindCode)) {
            this.logger.info("+++cc.lechun.mall.service.ask.MallAskService.getNextQuestion:customerId or bindCode is empty++++");
            map.put("status", 0);
            map.put("questionArray", "");
            map.put("answerNo", "");
            map.put("message", "\u6ca1\u6709\u53ef\u7528\u7684\u95ee\u9898");
            return BaseJsonVo.success(map);
        }
        this.memcachedService.delete("lechun_12question_" + customerId + bindCode);
        Object objectSequence = null;
        int curCount = 0;
        List<MallQuestionnewEntity> mallQuestionnewList = this.mallQuestionnewMapper.getQuestionnewInfo(bindCode);
        if (objectSequence == null || StringUtils.isEmpty((String)objectSequence.toString())) {
            Set<MallCustomerAnswerEntity> mallCustomerAnswerEntitySet = this.mallCustomerAnswerMapper.getCustomerAnswerByCustomerIdSet(customerId, bindCode);
            if (mallCustomerAnswerEntitySet.size() == mallQuestionnewList.size()) {
                map.put("status", 2);
                map.put("questionArray", "");
                map.put("answerNo", "");
                map.put("message", "");
                return BaseJsonVo.success(map);
            }
            List<MallCustomerAnswerEntity> mallCustomerAnswerList = this.mallCustomerAnswerMapper.getAnswerByTime(customerId, bindCode);
            curCount = mallCustomerAnswerList.size() == 0 ? 1 : mallCustomerAnswerList.size() + 1;
        } else {
            curCount = Integer.parseInt(objectSequence.toString());
        }
        long num = mallQuestionnewList.size();
        if ((long)curCount > num) {
            map.put("status", 2);
            map.put("questionArray", "");
            map.put("answerNo", "");
            map.put("message", "");
            return BaseJsonVo.success(map);
        }
        map.put("answerNo", curCount);
        if (mallQuestionnewList.size() > 0) {
            ArrayList<MallQuestionAnswerVo> mallQuestionAnswerVoList = new ArrayList<MallQuestionAnswerVo>();
            for (MallQuestionnewEntity mallQuestionnewEntity : mallQuestionnewList) {
                MallQuestionAnswerVo mallQuestionAnswerVo = new MallQuestionAnswerVo();
                List<MallAnswerEntity> mallAnswerEntityList = this.mallAnswerMapper.getAnswerByQuestionId(mallQuestionnewEntity.getId());
                if (mallAnswerEntityList.size() <= 0) {
                    map.put("status", 0);
                    map.put("message", "\u6ca1\u6709\u53ef\u7528\u7684\u95ee\u9898\u7b54\u6848");
                    return BaseJsonVo.success(map);
                }
                mallQuestionAnswerVo.setQuestion(mallQuestionnewEntity.getQuestion());
                mallQuestionAnswerVo.setQuestionId(mallQuestionnewEntity.getId());
                mallQuestionAnswerVo.setSequence(mallQuestionnewEntity.getSequence());
                mallQuestionAnswerVo.setAnswerList(mallAnswerEntityList);
                mallQuestionAnswerVoList.add(mallQuestionAnswerVo);
            }
            map.put("status", 1);
            map.put("message", "");
            map.put("questionArray", mallQuestionAnswerVoList);
            return BaseJsonVo.success(map);
        }
        map.put("status", 0);
        map.put("questionArray", "");
        map.put("answerNo", "");
        map.put("message", "\u6ca1\u6709\u53ef\u7528\u7684\u95ee\u9898");
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo commitAnswer(CustomerDetailVo customerDetailVo, String questionId, String answerId, String bindCode) {
        this.logger.info("+++cc.lechun.mall.service.ask.MallAskService.commitAnswer+++start++++questionId={},answerId={},bindCode={}", new Object[]{questionId, answerId, bindCode});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)questionId) || StringUtils.isEmpty((String)answerId) || StringUtils.isEmpty((String)customerDetailVo.getCustomerId()) || StringUtils.isEmpty((String)bindCode)) {
            map.put("status", 0);
            map.put("message", "\u95ee\u9898\u4e0d\u5b58\u5728");
            return BaseJsonVo.success(map);
        }
        MallQuestionnewEntity mallQuestionnewEntity = this.mallQuestionnewMapper.getQuestionnewById(questionId);
        if (mallQuestionnewEntity == null) {
            map.put("status", 0);
            map.put("message", "\u95ee\u9898\u4e0d\u5b58\u5728");
            return BaseJsonVo.success(map);
        }
        MallAnswerEntity mallAnswerEntity = this.mallAnswerMapper.getRightAnswerByQuestionId(questionId);
        if (mallAnswerEntity == null) {
            map.put("status", 0);
            map.put("message", "\u7b54\u6848\u4e0d\u5b58\u5728");
            return BaseJsonVo.success(map);
        }
        if (!answerId.equals(mallAnswerEntity.getAnswerId())) {
            map.put("status", -1);
            map.put("message", mallAnswerEntity.getDescription());
            return BaseJsonVo.success(map);
        }
        MallCustomerAnswerEntity mallCustomerAnswerEntity = this.mallCustomerAnswerMapper.getCustomerAnswerByCustomerId(customerDetailVo.getCustomerId(), questionId, answerId, bindCode);
        if (mallCustomerAnswerEntity != null) {
            map.put("status", 1);
            map.put("message", mallAnswerEntity.getDescription());
            return BaseJsonVo.success(map);
        }
        mallCustomerAnswerEntity = new MallCustomerAnswerEntity();
        mallCustomerAnswerEntity.setCustomerId(customerDetailVo.getCustomerId());
        mallCustomerAnswerEntity.setQuestionId(questionId);
        mallCustomerAnswerEntity.setSequence(mallQuestionnewEntity.getSequence());
        mallCustomerAnswerEntity.setAnswerId(answerId);
        mallCustomerAnswerEntity.setCreateTime(DateUtils.now());
        mallCustomerAnswerEntity.setIsSendCashticket(0);
        mallCustomerAnswerEntity.setQuestionBindCode(bindCode);
        int i = this.mallCustomerAnswerMapper.insertCustomerAnswerInfo(mallCustomerAnswerEntity);
        this.logger.info("+++cc.lechun.mall.service.ask.MallAskService.insertCustomerAnswerInfo+++start++++questionId={},answerId={},bindCode={}", new Object[]{questionId, answerId, bindCode});
        if (i > 0) {
            // empty if block
        }
        List<MallQuestionnewEntity> mallQuestionnewList = this.mallQuestionnewMapper.getQuestionnewInfo(bindCode);
        Set<MallCustomerAnswerEntity> mallCustomerAnswerEntitySet = this.mallCustomerAnswerMapper.getCustomerAnswerByCustomerIdSet(customerDetailVo.getCustomerId(), bindCode);
        if (mallCustomerAnswerEntitySet.size() == mallQuestionnewList.size() && i > 0) {
            this.activeCashticketInterface.sendTicket4Base(customerDetailVo.getCustomerId(), bindCode, "", customerDetailVo.getPlatformId(), true);
            map.put("status", 2);
            map.put("message", mallAnswerEntity.getDescription());
            return BaseJsonVo.success(map);
        }
        map.put("status", 1);
        map.put("message", mallAnswerEntity.getDescription());
        return BaseJsonVo.success(map);
    }
}

