/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket.cashRule;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.cashticket.CashRuleSearchVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.service.cashticket.cashRule.CashRuleHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CashRuleContext {
    @Autowired
    private CashticketBatchNewRuleInterface cashticketBatchNewRuleService;
    private final Map<String, CashRuleHandle> cashRuleHandleMap = new ConcurrentHashMap<String, CashRuleHandle>();

    @Autowired
    public CashRuleContext(Map<String, CashRuleHandle> cashRuleHandle) {
        this.cashRuleHandleMap.clear();
        cashRuleHandle.forEach((k, v) -> this.cashRuleHandleMap.put((String)k, (CashRuleHandle)v));
    }

    public Map<String, Object> getCashRuleItemList(CashRuleSearchVo cashRuleSearchVo) {
        CashRuleHandle cashRule;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (cashRuleSearchVo.getItemId() != null && (cashRule = this.cashRuleHandleMap.get("cashRuleType_" + cashRuleSearchVo.getItemId())) != null) {
            map.put("all", cashRule.getCashRuleItemList(cashRuleSearchVo));
            List<CashticketBatchNewRuleVo> selectList = this.cashticketBatchNewRuleService.getCashRule(cashRuleSearchVo.getTicketBatchId(), cashRuleSearchVo.getItemId(), cashRuleSearchVo.getPlatformGroupId());
            List<MallSelectDataVo> list = this.getSelectCashRuleItemList(selectList);
            map.put("select", this.getSelectCashRuleItemList(selectList));
        }
        return map;
    }

    public List<MallSelectDataVo> getSelectCashRuleItemList(List<CashticketBatchNewRuleVo> selectList) {
        HashSet set = new HashSet();
        if (selectList != null) {
            selectList.forEach(selectItem -> {
                if (StringUtils.isNotEmpty((String)selectItem.getDetailIds())) {
                    String[] idarr = selectItem.getDetailIds().split(",");
                    String[] namearr = selectItem.getDetailIdNames().split(",");
                    for (int i = 0; i < idarr.length; ++i) {
                        MallSelectDataVo item = new MallSelectDataVo();
                        item.setId(StringUtils.isNotEmpty((String)idarr[i]) ? idarr[i] : "");
                        if (namearr.length > i) {
                            item.setName(StringUtils.isNotEmpty((String)namearr[i]) ? namearr[i] : "");
                        } else {
                            item.setName("");
                        }
                        set.add(item);
                    }
                }
            });
        }
        return new ArrayList<MallSelectDataVo>(set);
    }
}

