/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributionOrderMapper;
import cc.lechun.mall.entity.distribution.DistributionOrderEntity;
import cc.lechun.mall.entity.distribution.DistributionOrderEntityEx;
import cc.lechun.mall.entity.distribution.DistributionOrderVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteLogInterface;
import cc.lechun.mall.iservice.distribution.DistributionOrderInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionOrderService
extends BaseService<DistributionOrderEntity, Integer>
implements DistributionOrderInterface {
    @Resource
    private DistributionOrderMapper distributionOrderMapper;
    @Autowired
    MallOrderInterface orderInterface;
    @Autowired
    MallOrderPayInterface payInterface;
    @Autowired
    DistributionInviteLogInterface inviteLogInterface;
    @Autowired
    DictionaryInterface dictionaryInterface;
    @Autowired
    DistributorRelationInterface distributorRelationInterface;

    @Override
    public void finishDistributionOrders() {
        try {
            String confirmDays = this.dictionaryInterface.getDictionary(1000, 206, "CONFIRM_DAYS_BEFORE").getDictionaryName();
            List<DistributionOrderEntityEx> orders = this.distributionOrderMapper.getFinishedDistributionOrders();
            orders.forEach(order -> {
                Map<String, BigDecimal> finalOrderAmount = this.orderInterface.getFinalOrderAmount(order.getOrderNo());
                BigDecimal refundAmount = finalOrderAmount.get("refundAmount");
                order.setSaleAmount(finalOrderAmount.get("orderAmount").subtract(refundAmount));
                BigDecimal rate = finalOrderAmount.get("orderAmount").doubleValue() == 0.0 ? BigDecimal.ZERO : order.getExpectOrderAmount().divide(finalOrderAmount.get("orderAmount"));
                refundAmount = refundAmount.multiply(rate);
                order.setRefundAmount(refundAmount);
                order.setFinalOrderAmount(order.getExpectOrderAmount().subtract(refundAmount));
                if (order.getFinalOrderAmount().doubleValue() < 0.0) {
                    order.setFinalOrderAmount(BigDecimal.valueOf(0L));
                }
                if (refundAmount.doubleValue() > 0.0) {
                    order.setDiffReason("\u9000\u6b3e" + refundAmount.setScale(2) + "\u5143");
                }
                Date finishOrderTimeEnd = DateUtils.getAddDateByDay((Date)(order.getPickupDate() == null ? order.getCreateTime() : order.getPickupDate()), (int)Integer.valueOf(confirmDays));
                finishOrderTimeEnd = DateUtils.getDateFromString((String)DateUtils.formatDate((Date)finishOrderTimeEnd, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                if (DateUtils.currentDate().after(finishOrderTimeEnd)) {
                    order.setHasSettled(1);
                }
                BigDecimal perRefundAmount = order.getExpectOrderAmount().doubleValue() == 0.0 ? BigDecimal.ZERO : order.getExpectPercentageAmount().divide(order.getExpectOrderAmount()).multiply(refundAmount);
                order.setFinalPercentageAmount(order.getExpectPercentageAmount().subtract(perRefundAmount));
                if (order.getFinalPercentageAmount().doubleValue() < 0.0) {
                    order.setFinalPercentageAmount(BigDecimal.ZERO);
                }
                this.distributionOrderMapper.updateByPrimaryKey(order);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PageInfo<DistributionOrderVo> getListVo(Integer pageNum, Integer pageSize, DistributionOrderVo vo) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        if (StringUtils.isEmpty((String)vo.getMobile())) {
            vo.setMobile(null);
        } else {
            vo.setMobile(SqlUtils.sqlLike((String)vo.getMobile(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isEmpty((String)vo.getNickName())) {
            vo.setNickName(null);
        } else {
            vo.setNickName(SqlUtils.sqlLike((String)vo.getNickName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isEmpty((String)vo.getOrderNo())) {
            vo.setOrderNo(null);
        } else {
            vo.setOrderNo(SqlUtils.sqlLike((String)vo.getOrderNo(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        this.distributionOrderMapper.getListVo(vo);
        PageInfo pg = page.toPageInfo();
        return pg;
    }
}

