/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallFullcutMapper;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutEntity;
import cc.lechun.mall.entity.sales.MallFullcutVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.sales.MallFullcutDetailService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallFullcutService
extends BaseService
implements MallFullcutInterface {
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallFullcutMapper fullcutMapper;
    @Autowired
    private MallFullcutDetailService mallFullcutDetailService;
    @Autowired
    private MallProductInterface productService;

    public MallFullcutEntity getFullcutEntity(String fullcutId) {
        return (MallFullcutEntity)this.fullcutMapper.selectByPrimaryKey((Serializable)((Object)fullcutId));
    }

    @Override
    public BaseJsonVo getEnableFullcut(MallShoppingcartVO cart) {
        return this.getEnableFullcut(cart.getBindCode());
    }

    @Override
    public BaseJsonVo getEnableFullcut(String bindCode) {
        if (bindCode == null || bindCode.isEmpty()) {
            return BaseJsonVo.paramError((String)"\u7ed1\u5b9a\u7801\u4e0d\u5b58\u5728");
        }
        String activeNo = this.activeInterface.getActiveNoByBindCode(bindCode);
        if (!this.activeInterface.checkActiveEnable(activeNo).isSuccess()) {
            return BaseJsonVo.paramError((String)"\u6d3b\u52a8\u5df2\u8fc7\u671f");
        }
        MallFullcutVo fullcutVo = this.fullcutMapper.getSingleEntityByTime(activeNo, DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
        if (fullcutVo == null && (fullcutVo = this.fullcutMapper.getSingleEntityByTime(bindCode, DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"))) == null) {
            return BaseJsonVo.paramError((String)"\u6d3b\u52a8\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e");
        }
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)fullcutVo.getEndTime());
        fullcutVo.setSeconds(seconds);
        fullcutVo.setSecond(seconds / 3600L);
        fullcutVo.setMinute(seconds % 3600L / 60L);
        fullcutVo.setHour(seconds % 3600L % 60L);
        return BaseJsonVo.success((Object)fullcutVo);
    }

    @Override
    public boolean checkFullcut(MallFullcutVo fullcutVo, List<MallFullcutDetailEntity> detailEntities, MallShoppingcartVO shoppingcartVO) {
        BigDecimal[] count = new BigDecimal[]{BigDecimal.valueOf(0L)};
        List<MallProductVO> productVOs = shoppingcartVO.getProducts();
        detailEntities.forEach(f -> {
            MallProductVO productVO;
            List list = productVOs.stream().filter(c -> c.getProId().equals(f.getProductId())).collect(Collectors.toList());
            if (list != null && list.size() > 0 && (productVO = (MallProductVO)list.get(0)) != null && StringUtils.isEmpty((String)productVO.getFullCutId())) {
                productVO.setFullCutId(fullcutVo.getFullCutId());
                productVO.setUseCoupon(fullcutVo.getEnableUseCoupon());
                count[0] = fullcutVo.getType() == 1 ? PriceUtils.add((BigDecimal)count[0], (BigDecimal)BigDecimal.valueOf(productVO.getCount().intValue())) : PriceUtils.add((BigDecimal)count[0], (BigDecimal)productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getCount().intValue())));
            }
        });
        return count[0].doubleValue() >= (double)fullcutVo.getCutNumber().intValue();
    }

    @Override
    public BaseJsonVo getEnableFullcutDetail(String bindCode) {
        MallFullcutVo vo;
        List<MallFullcutDetailEntity> ls;
        BaseJsonVo rs = this.getEnableFullcut(bindCode);
        if (rs.isSuccess() && (ls = this.mallFullcutDetailService.getFullcutDetails((vo = (MallFullcutVo)rs.getValue()).getFullCutId())) != null && ls.size() > 0) {
            ArrayList<MallProductVO> productVOs = new ArrayList<MallProductVO>();
            ls.forEach(mallFullcutDetailEntity -> {
                BaseJsonVo sr = this.productService.buildProductVO(mallFullcutDetailEntity.getProductId(), 1, null, null, null, null, true, true, null, null);
                if (sr.isSuccess()) {
                    productVOs.add((MallProductVO)sr.getValue());
                }
            });
            vo.setProducts(productVOs);
        }
        return rs;
    }

    @Override
    public BaseJsonVo saveOrUpdateFullCutList(MallFullcutEntity mallFullcutEntity) {
        if (mallFullcutEntity.getBeginTime() == null || mallFullcutEntity.getEndTime() == null) {
            return BaseJsonVo.paramError((String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallFullcutEntity.getBeginTime().after(mallFullcutEntity.getEndTime())) {
            return BaseJsonVo.paramError((String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (StringUtils.isEmpty((String)mallFullcutEntity.getCutRuleName())) {
            return BaseJsonVo.paramError((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallFullcutEntity.getType() != 2 && mallFullcutEntity.getFullClass() == 1) {
            return BaseJsonVo.paramError((String)"\u5168\u5c40\u6ee1\u51cf\u53ea\u652f\u6301\u6309\u91d1\u989d\u51cf");
        }
        if (mallFullcutEntity.getType() == 2 && mallFullcutEntity.getCutRule() == 4) {
            return BaseJsonVo.paramError((String)"\u6ee1\u51cf\u7c7b\u578b\u4e3a\u91d1\u989d\u65f6\uff0c\u6ee1\u51cf\u89c4\u5219\u4e0d\u652f\u6301\u6309\u5546\u54c1\u51cf");
        }
        if (mallFullcutEntity.getFullNumber() < mallFullcutEntity.getCutNumber()) {
            return BaseJsonVo.paramError((String)("\u6682\u4e0d\u652f\u6301\u6ee1[" + mallFullcutEntity.getFullNumber() + "]\u51cf[" + mallFullcutEntity.getCutNumber() + "]"));
        }
        if (mallFullcutEntity.getActiveNo().isEmpty()) {
            return BaseJsonVo.paramError((String)"\u5fc5\u987b\u9009\u62e9\u6d3b\u52a8");
        }
        MallFullcutEntity search = new MallFullcutEntity();
        search.setActiveNo(mallFullcutEntity.getActiveNo());
        List searchs = this.fullcutMapper.getList(search);
        if (searchs.size() > 0) {
            if (StringUtils.isEmpty((String)mallFullcutEntity.getFullCutId())) {
                return BaseJsonVo.paramError((String)("\u5176\u4ed6\u6ee1\u51cf[" + ((MallFullcutEntity)searchs.get(0)).getFullCutName() + "]\u5df2\u7ecf\u9009\u62e9\u4e86\u8be5\u6d3b\u52a8\uff0c\u4e0d\u80fd\u518d\u6b21\u9009\u62e9"));
            }
            if (searchs.stream().filter(c -> !c.getFullCutId().equals(mallFullcutEntity.getFullCutId())).count() > 0L) {
                return BaseJsonVo.paramError((String)("\u5176\u4ed6\u6ee1\u51cf[" + ((MallFullcutEntity)searchs.get(0)).getFullCutName() + "]\u5df2\u7ecf\u9009\u62e9\u4e86\u8be5\u6d3b\u52a8\uff0c\u4e0d\u80fd\u518d\u6b21\u9009\u62e9"));
            }
        }
        if (StringUtils.isEmpty((String)mallFullcutEntity.getFullCutId())) {
            mallFullcutEntity.setFullCutId(IDGenerate.getUniqueID() + "");
            mallFullcutEntity.setCreateTime(DateUtils.now());
            this.fullcutMapper.insertSelective(mallFullcutEntity);
        } else {
            List<MallFullcutDetailEntity> fullcutDetails;
            if (mallFullcutEntity.getCutRule() == 4 && (fullcutDetails = this.mallFullcutDetailService.getFullcutDetails(mallFullcutEntity.getFullCutId())).size() > 0 && fullcutDetails.stream().filter(c -> c.getGroupType() != 4).count() > 0L) {
                return BaseJsonVo.paramError((String)"\u6ee1\u51cf\u4e2d\u5b58\u5728\u5957\u88c5\uff0c\u6ee1\u51cf\u89c4\u5219\u4e0d\u652f\u6301\u6309\u5546\u54c1\u51cf");
            }
            BaseJsonVo baseJsonVo = this.mallFullcutDetailService.checkGroup(mallFullcutEntity.getFullCutId());
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            this.fullcutMapper.updateByPrimaryKeySelective(mallFullcutEntity);
        }
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }

    @Override
    public PageInfo getFullCutList(int pageNum, int pageSize, int platformGroupId, String fullCutName) {
        MallFullcutEntity mallFullcutEntity = new MallFullcutEntity();
        mallFullcutEntity.setPlatformGroupId(platformGroupId);
        if (!StringUtils.isEmpty((String)fullCutName)) {
            mallFullcutEntity.setFullCutName(SqlUtils.sqlLike((String)fullCutName, (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.fullcutMapper.getList(mallFullcutEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public MallFullcutEntity getFullCutEntity(String fullCutid) {
        return (MallFullcutEntity)this.fullcutMapper.selectByPrimaryKey((Serializable)((Object)fullCutid));
    }

    @Override
    public BaseJsonVo addFullCutAllColdProducts(String fullCutId, int transPort) {
        if (StringUtils.isEmpty((String)fullCutId)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6ee1\u51cf\u6d3b\u52a8");
        }
        List<MallProductEntity> productEntities = this.productService.getOnProductList(1000);
        productEntities = productEntities.stream().filter(c -> c.getTransportType() == transPort).collect(Collectors.toList());
        List<MallFullcutDetailEntity> detailEntities = this.mallFullcutDetailService.getFullcutDetails(fullCutId);
        detailEntities = detailEntities.stream().filter(c -> c.getGroupType() == 4).collect(Collectors.toList());
        for (MallProductEntity p : productEntities) {
            if (detailEntities.stream().filter(c -> p.getProId().equals(c.getProductId())).count() != 0L) continue;
            MallFullcutDetailEntity detailEntity = new MallFullcutDetailEntity();
            detailEntity.setFullCutId(fullCutId);
            detailEntity.setGroupType(4);
            detailEntity.setProductId(p.getProId());
            detailEntity.setFullCutDetailId(IDGenerate.getUniqueIdStr());
            this.mallFullcutDetailService.saveMallFullcutDetail(detailEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo delFullCutAllProducts(String fullCutId) {
        if (StringUtils.isEmpty((String)fullCutId)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6ee1\u51cf\u6d3b\u52a8");
        }
        List<MallFullcutDetailEntity> detailEntities = this.mallFullcutDetailService.getFullcutDetails(fullCutId);
        for (MallFullcutDetailEntity d : detailEntities) {
            this.mallFullcutDetailService.deleteMallFullcutDetail(d.getFullCutDetailId());
        }
        return BaseJsonVo.success((Object)"");
    }
}

