/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.cache;

import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallRefundDetailMapper;
import cc.lechun.mall.dao.trade.MallRefundMapper;
import cc.lechun.mall.dao.trade.MallRefundPayDetailMapper;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.trade.CheckRefundPayDetailVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderRefundDetailVo;
import cc.lechun.mall.entity.trade.MallRefundDetailEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import cc.lechun.mall.entity.trade.MallRefundPayDetailEntity;
import cc.lechun.mall.entity.trade.OrderRefundApplyVo;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallRefundInterface;
import cc.lechun.mall.iservice.trade.MallRefundPayDetailInterface;
import cc.lechun.mall.service.pay.PayOrderService;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallRefundPayDetailService
extends BaseService
implements MallRefundPayDetailInterface {
    @Autowired
    private MallRefundPayDetailMapper refundPayDetailMapper;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallRefundMapper refundMapper;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MallRefundDetailMapper refundDetailMapper;
    @Autowired
    private PayOrderService payOrderService;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    private MallRefundInterface mallRefundInterface;

    @Override
    public int updateRefundPayDetailStatusByRefundId(String refundId, int paytypeId, String refundStatus) {
        return this.refundPayDetailMapper.updateRefundPayDetailStatusByRefundId(refundId, paytypeId, Integer.valueOf(refundStatus));
    }

    @Override
    public void queryRefundPayDetailList() {
        List<MallRefundPayDetailEntity> refundPayDetailList = this.refundPayDetailMapper.queryRefundPayDetailList();
        if (refundPayDetailList != null && refundPayDetailList.size() > 0) {
            for (MallRefundPayDetailEntity mallRefundPayDetailEntity : refundPayDetailList) {
                MallRefundEntity mallRefundEntity;
                MallOrderPayEntity mallOrderPayEntity;
                MallOrderMainEntity orderMain;
                if (mallRefundPayDetailEntity.getPaytypeId().equals(PayTypeEnum.BALANCE_PAY.getValue()) || mallRefundPayDetailEntity.getPaytypeId().equals(PayTypeEnum.COUPON_PAY.getValue()) || (orderMain = this.mallOrderMainInterface.selectByPrimaryKey(mallRefundPayDetailEntity.getOrderMainNo())) == null || (mallOrderPayEntity = this.mallOrderPayInterface.getOrderPayInfoByOrderMainNoPayType(mallRefundPayDetailEntity.getPaytypeId(), mallRefundPayDetailEntity.getOrderMainNo())) == null || (mallRefundEntity = this.createRefundInfo(mallRefundPayDetailEntity, orderMain)) == null) continue;
                BigDecimal wechatAmount = new BigDecimal("0");
                BigDecimal alipayAmount = new BigDecimal("0");
                BigDecimal balanceAmount = new BigDecimal("0");
                BigDecimal couponAmount = new BigDecimal("0");
                if (mallRefundPayDetailEntity.getPaytypeId().equals(PayTypeEnum.WECHAT_PAY.getValue())) {
                    wechatAmount = mallRefundPayDetailEntity.getReallyReturnAmount();
                }
                if (mallRefundPayDetailEntity.getPaytypeId().equals(PayTypeEnum.BANK_PAY.getValue())) {
                    wechatAmount = mallRefundPayDetailEntity.getReallyReturnAmount();
                }
                if (mallRefundPayDetailEntity.getPaytypeId().equals(PayTypeEnum.ALIPAY_PAY.getValue())) {
                    alipayAmount = mallRefundPayDetailEntity.getReallyReturnAmount();
                }
                this.logger.info("========MallRefundPayDetailService.queryRefundPayDetailList=======wechatAmount:[{}],alipayAmount:[{}],balanceAmount:[{}],couponAmount:[{}]", new Object[]{wechatAmount, alipayAmount, balanceAmount, couponAmount});
                BaseJsonVo result = this.payOrderService.payRefund(mallRefundEntity, mallRefundPayDetailEntity.getOrderNo(), mallOrderPayEntity.getTradeNo(), mallRefundEntity.getRefundId(), mallOrderPayEntity.getPayamount(), mallRefundPayDetailEntity.getReallyReturnAmount(), orderMain.getCustomerId(), "", false);
                this.logger.info("===============MallRefundPayDetailService.queryRefundPayDetailList.result=====result={}", (Object)JSON.toJSONString((Object)result));
                if (!result.isSuccess()) continue;
                this.mallRefundInterface.updateRefundAmount(mallRefundEntity.getRefundId(), wechatAmount, alipayAmount, balanceAmount, couponAmount);
                this.refundPayDetailMapper.deleteByPrimaryKey((Serializable)((Object)mallRefundPayDetailEntity.getRefundPayId()));
            }
        }
    }

    public MallRefundEntity createRefundInfo(MallRefundPayDetailEntity mallRefundPayDetailEntity, MallOrderMainEntity orderMain) {
        MallRefundEntity refundEntity = new MallRefundEntity();
        refundEntity.setRefundId(IDGenerate.getUniqueIdStr());
        refundEntity.setOrderMainNo(mallRefundPayDetailEntity.getOrderMainNo());
        refundEntity.setOrderNo(mallRefundPayDetailEntity.getOrderNo());
        refundEntity.setCreateSource(3);
        refundEntity.setCreateTime(DateUtils.now());
        refundEntity.setRefundType(2);
        refundEntity.setStatus(1);
        refundEntity.setReason("\u518d\u6b21\u8bf7\u6c42\u9000\u6b3e");
        refundEntity.setTotalAmount(orderMain.getTotalAmount());
        refundEntity.setReturnAmount(new BigDecimal(0));
        refundEntity.setFactReturnAmount(new BigDecimal(0));
        refundEntity.setHandingCost(new BigDecimal(0));
        refundEntity.setDebit(new BigDecimal(0));
        refundEntity.setOperaterId("3254864471995961944");
        refundEntity.setOperaterTime(DateUtils.now());
        refundEntity.setRefundClass(0);
        refundEntity.setOrderStatus(orderMain.getStatus());
        refundEntity.setRemark("");
        refundEntity.setOtherTkOrderNo("");
        refundEntity.setRefundOrderType(1);
        refundEntity.setCustomerId(orderMain.getCustomerId());
        this.refundMapper.insert(refundEntity);
        MallRefundDetailEntity refundDetailEntity = new MallRefundDetailEntity();
        refundDetailEntity.setRefundDetailId(IDGenerate.getUniqueIdStr());
        refundDetailEntity.setRefundId(refundEntity.getRefundId());
        refundDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        refundDetailEntity.setOrderNo(mallRefundPayDetailEntity.getOrderNo());
        refundDetailEntity.setCustomerId(orderMain.getCustomerId());
        refundDetailEntity.setCreateTime(refundEntity.getCreateTime());
        refundDetailEntity.setOperaterId("3254864471995961944");
        refundDetailEntity.setStatus(refundEntity.getStatus());
        refundDetailEntity.setReason(refundEntity.getReason());
        this.refundDetailMapper.insert(refundDetailEntity);
        MallRefundPayDetailEntity refundPayDetailEntity = new MallRefundPayDetailEntity();
        refundPayDetailEntity.setRefundPayId(IDGenerate.getUniqueIdStr());
        refundPayDetailEntity.setRefundId(refundEntity.getRefundId());
        refundPayDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        refundPayDetailEntity.setOrderNo(mallRefundPayDetailEntity.getOrderNo());
        refundPayDetailEntity.setPaytypeId(mallRefundPayDetailEntity.getPaytypeId());
        refundPayDetailEntity.setPaytypeName(mallRefundPayDetailEntity.getPaytypeName());
        refundPayDetailEntity.setRefundStatus(1);
        refundPayDetailEntity.setReturnAmount(mallRefundPayDetailEntity.getReturnAmount());
        refundPayDetailEntity.setReallyReturnAmount(new BigDecimal(0));
        this.refundPayDetailMapper.insert(refundPayDetailEntity);
        return refundEntity;
    }

    @Override
    public List<MallRefundPayDetailEntity> createRefundPay(OrderRefundApplyVo refundApplyVo, MallRefundEntity refundEntity) throws Exception {
        ArrayList<MallRefundPayDetailEntity> mallRefundPayDetailEntityList = new ArrayList<MallRefundPayDetailEntity>();
        List<PayInputEntity> payInputEntities = refundApplyVo.getPayInputEntities();
        for (PayInputEntity payInputEntity : payInputEntities) {
            MallRefundPayDetailEntity refundPayDetailEntity = new MallRefundPayDetailEntity();
            refundPayDetailEntity.setRefundPayId(IDGenerate.getUniqueIdStr());
            refundPayDetailEntity.setRefundId(refundEntity.getRefundId());
            refundPayDetailEntity.setOrderMainNo(refundEntity.getOrderMainNo());
            refundPayDetailEntity.setOrderNo(refundEntity.getOrderNo());
            refundPayDetailEntity.setPaytypeId(payInputEntity.getPayType());
            refundPayDetailEntity.setPaytypeSubId(payInputEntity.getPaySubType());
            refundPayDetailEntity.setCashType(payInputEntity.getCashType());
            refundPayDetailEntity.setPaytypeName(PayTypeEnum.getPayTypeName((int)payInputEntity.getPayType()));
            refundPayDetailEntity.setTradeNo(payInputEntity.getTradeNo());
            refundPayDetailEntity.setRefundStatus(0);
            if (payInputEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                refundPayDetailEntity.setReturnAmount(payInputEntity.getPayAmount());
            } else {
                refundPayDetailEntity.setReturnAmount(new BigDecimal(0));
            }
            refundPayDetailEntity.setFactReturnAmount(refundPayDetailEntity.getReturnAmount());
            refundPayDetailEntity.setReallyReturnAmount(new BigDecimal(0));
            if (this.refundPayDetailMapper.insert(refundPayDetailEntity) <= 0) {
                throw new Exception("\u65e0\u6cd5\u521b\u5efa\u9000\u6b3e\u660e\u7ec6");
            }
            mallRefundPayDetailEntityList.add(refundPayDetailEntity);
        }
        return mallRefundPayDetailEntityList;
    }

    @Override
    public List<MallRefundPayDetailEntity> getRefundPayDetailList(String orderMainNo) {
        MallRefundPayDetailEntity refundPayDetailEntity = new MallRefundPayDetailEntity();
        refundPayDetailEntity.setOrderMainNo(orderMainNo);
        return this.refundPayDetailMapper.getList(refundPayDetailEntity);
    }

    @Override
    public void FailOrderRefund(String refundId) throws Exception {
        boolean result = true;
        MallRefundPayDetailEntity refundPayDetailEntity = new MallRefundPayDetailEntity();
        refundPayDetailEntity.setRefundId(refundId);
        List list = this.refundPayDetailMapper.getList(refundPayDetailEntity);
        if (list == null || list.size() == 0) {
            result = false;
        } else {
            for (MallRefundPayDetailEntity mallRefundDetail : list) {
                mallRefundDetail.setRefundStatus(-1);
                if (this.refundPayDetailMapper.updateByPrimaryKey(mallRefundDetail) != 0) continue;
                result = false;
            }
        }
        if (!result) {
            throw new Exception("\u66f4\u65b0\u9000\u6b3e\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public void CancelOrderRefund(String refundId) throws Exception {
        this.FailOrderRefund(refundId);
    }

    @Override
    public void SuccessOrderRefund(String refundId, int payTypeId) {
        MallRefundPayDetailEntity refundPayDetailEntity = new MallRefundPayDetailEntity();
        refundPayDetailEntity.setRefundId(refundId);
        refundPayDetailEntity.setPaytypeId(payTypeId);
        List list = this.refundPayDetailMapper.getList(refundPayDetailEntity);
        list.forEach(mallRefundDetail -> {
            mallRefundDetail.setRefundStatus(1);
            mallRefundDetail.setConfirmTime(DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
            if (mallRefundDetail.getPaytypeId() != 3) {
                mallRefundDetail.setReallyReturnAmount(mallRefundDetail.getFactReturnAmount());
            }
            this.refundPayDetailMapper.updateByPrimaryKey(mallRefundDetail);
        });
    }

    @Override
    public boolean isAllSuccess(String refundId) {
        MallRefundPayDetailEntity refundPayDetailEntity = new MallRefundPayDetailEntity();
        refundPayDetailEntity.setRefundId(refundId);
        List list = this.refundPayDetailMapper.getList(refundPayDetailEntity);
        return list.stream().filter(c -> c.getRefundStatus() != 1).count() <= 0L;
    }

    @Override
    public void PassOrderRefund(String refundId, List<CheckRefundPayDetailVo> payDetailVo) throws Exception {
        if (payDetailVo == null || payDetailVo.size() == 0) {
            return;
        }
        for (CheckRefundPayDetailVo d : payDetailVo) {
            MallRefundPayDetailEntity refundPayDetailEntity = (MallRefundPayDetailEntity)this.refundPayDetailMapper.selectByPrimaryKey((Serializable)((Object)d.getRefundPayId()));
            if (refundPayDetailEntity == null) {
                throw new Exception("\u9000\u6b3e\u660e\u7ec6[" + d.getRefundPayId() + "]\u4e0d\u5b58\u5728");
            }
            refundPayDetailEntity.setFactReturnAmount(d.getFactReturnAmount());
            this.refundPayDetailMapper.updateByPrimaryKey(refundPayDetailEntity);
        }
    }

    @Override
    public MallRefundPayDetailEntity getSingle(String pk) {
        return (MallRefundPayDetailEntity)this.refundPayDetailMapper.selectByPrimaryKey((Serializable)((Object)pk));
    }

    @Override
    public List<MallRefundPayDetailEntity> queryRefundPayDetailListByRefundId(String refundId) {
        return this.refundPayDetailMapper.queryRefundPayDetailListByRefundId(refundId);
    }

    @Override
    public List<MallRefundPayDetailEntity> queryRefundPayDetailListByRefundIdStatus(int refundStatus, String refundId) {
        return this.refundPayDetailMapper.queryRefundPayDetailListByRefundIdStatus(refundStatus, refundId);
    }

    @Override
    public BaseJsonVo getOrderRefundInfo(String orderMainNo, String orderNo) {
        List<MallOrderRefundDetailVo> mallOrderRefundDetailVoList = this.refundPayDetailMapper.getOrderRefundInfo(orderMainNo, orderNo);
        return BaseJsonVo.success(mallOrderRefundDetailVoList);
    }
}

