/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.dao.KpiMapper;
import cc.lechun.organization.entity.KpiEntity;
import cc.lechun.organization.entity.KpiImportVo;
import cc.lechun.organization.entity.KpiMonthsVo;
import cc.lechun.organization.entity.KpiRankingDetailVo;
import cc.lechun.organization.entity.KpiRankingVo;
import cc.lechun.organization.entity.MonthKpiVo;
import cc.lechun.organization.entity.OrgQuestionClassTimeoutVO;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassTimeoutDomain;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.KpiInterface;
import cc.lechun.utils.ExcelUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class KpiService
extends BaseService<KpiEntity, String>
implements KpiInterface {
    @Resource
    private KpiMapper kpiMapper;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private IOrgQuestionClassTimeoutDomain orgQuestionClassTimeoutDomain;
    @Autowired
    private IOrgPermittedUsersService permittedUsersService;

    @Override
    public List<KpiEntity> getKpis(String paperId, String leaderUserId) {
        Integer isLeader = -1;
        KpiEntity kpiEntity = new KpiEntity();
        kpiEntity.setPaperId(paperId);
        List kpis = this.getList(kpiEntity, 0L);
        for (KpiEntity k : kpis) {
            isLeader = this.isEdit(paperId, leaderUserId, k);
            k.setIsEdit(isLeader);
        }
        return kpis;
    }

    private BaseJsonVo<OrgQuestionClassTimeoutVO> isEdit(PaperEntity paper, String userId, Integer classSubType, KpiEntity kpiEntity) {
        BaseJsonVo<OrgQuestionClassTimeoutVO> jsonVo = this.orgQuestionClassTimeoutDomain.isEdit(paper, userId, classSubType);
        return jsonVo;
    }

    public int isEdit(String paperId, String loginUserId, KpiEntity kpiEntity) {
        int isEdit = 0;
        Integer classSubType = 1;
        PaperEntity paperEntity = this.orgPaperDomain.select(paperId);
        if (paperEntity == null) {
            return isEdit;
        }
        String userId = paperEntity.getUserId();
        if (userId == null) {
            return isEdit;
        }
        if (loginUserId == null || loginUserId.isEmpty()) {
            return isEdit;
        }
        classSubType = 1;
        BaseJsonVo<OrgQuestionClassTimeoutVO> jsonVo = this.isEdit(paperEntity, userId, classSubType, kpiEntity);
        if (jsonVo.isSuccess()) {
            isEdit = 1;
            return isEdit;
        }
        return isEdit;
    }

    public int isLeader(String paperId, String loginUserId, KpiEntity kpiEntity) {
        int isLeader = -1;
        Integer classSubType = 1;
        PaperEntity paperEntity = this.orgPaperDomain.select(paperId);
        if (paperEntity == null) {
            return isLeader;
        }
        String userId = paperEntity.getUserId();
        if (userId == null) {
            return isLeader;
        }
        if (loginUserId == null || loginUserId.isEmpty()) {
            return isLeader;
        }
        if (this.userInterface.isLeadership(loginUserId, userId).booleanValue()) {
            classSubType = 1;
            BaseJsonVo<OrgQuestionClassTimeoutVO> jsonVo = this.isEdit(paperEntity, userId, classSubType, kpiEntity);
            if (jsonVo.isSuccess()) {
                isLeader = 1;
                return isLeader;
            }
        } else {
            Set<String> users = this.userInterface.getFinancialSubordinate(loginUserId);
            if (loginUserId.equals(userId)) {
                if (users != null && users.contains(loginUserId)) {
                    classSubType = 1;
                    BaseJsonVo<OrgQuestionClassTimeoutVO> jsonVo = this.isEdit(paperEntity, userId, classSubType, kpiEntity);
                    if (jsonVo.isSuccess()) {
                        isLeader = 3;
                        return isLeader;
                    }
                } else {
                    classSubType = 1;
                    BaseJsonVo<OrgQuestionClassTimeoutVO> jsonVo = this.isEdit(paperEntity, userId, classSubType, kpiEntity);
                    if (jsonVo.isSuccess()) {
                        isLeader = 0;
                        return isLeader;
                    }
                }
            } else if (users != null && users.contains(userId)) {
                classSubType = 1;
                BaseJsonVo<OrgQuestionClassTimeoutVO> jsonVo = this.isEdit(paperEntity, userId, classSubType, kpiEntity);
                if (jsonVo.isSuccess()) {
                    isLeader = 2;
                    return isLeader;
                }
            } else {
                Set<String> users1 = this.permittedUsersService.findAllPermittedUsersFromResource(loginUserId);
                if (users1 != null && users1.size() > 0 && users1.contains(loginUserId)) {
                    isLeader = -1;
                    return isLeader;
                }
            }
        }
        return isLeader;
    }

    @Override
    @Transactional
    public BaseJsonVo saveKpi(List<KpiEntity> kpiEntityList, String userId) throws RuntimeException {
        if (kpiEntityList == null || kpiEntityList.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u4fdd\u5b58\u7684\u6570\u636e");
        }
        PaperEntity paperEntity = this.orgPaperDomain.select(kpiEntityList.get(0).getPaperId());
        if (paperEntity == null) {
            throw new RuntimeException("Kpi\u4e0d\u5b58\u5728");
        }
        if (!this.periodService.isInPeriodWithDelay(paperEntity.getPeriodId()).isSuccess()) {
            throw new RuntimeException("\u975e\u5f53\u524d\u671f\u6b21\uff0c\u4e0d\u80fd\u4fdd\u5b58");
        }
        int isLeader = -1;
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.selectByPrimaryKey(paperEntity.getPeriodId());
        if (periodEntity == null) {
            throw new RuntimeException("\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        String error = "";
        for (KpiEntity k : kpiEntityList) {
            isLeader = this.isLeader(paperEntity.getId(), userId, k);
            if (isLeader == 0) {
                // empty if block
            }
            k.setUserId(paperEntity.getUserId());
            k.setPeriodId(paperEntity.getPeriodId());
            k.setQuestionClassId(paperEntity.getQuestionClassId());
            k.setYear(periodEntity.getHeadYear());
            k.setMonthKpi(1);
            k.setWeight(BigDecimal.valueOf(100L));
            if (Integer.valueOf(1).equals(k.getConfirm()) || Integer.valueOf(1).equals(k.getLeaderConfirm())) {
                k.setMonthKpi(null);
                k.setMonth(null);
                k.setValue(null);
                k.setFormula(null);
                k.setWeight(null);
                k.setKpi(null);
            }
            if (Integer.valueOf(1).equals(k.getFactConfirm()) || Integer.valueOf(1).equals(k.getLeaderFactConfirm())) {
                k.setFactValue(null);
                k.setFactFormula(null);
            }
            if (k.getCreateTime() == null) {
                k.setCreateTime(new Date());
            }
            if (isLeader == 0) {
                if (Integer.valueOf(1).equals((int)k.getConfirm())) {
                    k.setConfirmTime(new Date());
                }
                if (Integer.valueOf(1).equals(k.getFactConfirm())) {
                    k.setFactConfirmTime(new Date());
                }
            }
            if (isLeader == 1) {
                if (Integer.valueOf(1).equals(k.getLeaderConfirm())) {
                    k.setLeaderConfirmTime(new Date());
                }
                if (Integer.valueOf(1).equals(k.getLeaderFactConfirm())) {
                    k.setLeaderFactConfirmTime(new Date());
                }
            }
            k.setLeaderValue(k.getValue());
            k.setLeaderWeight(k.getWeight());
            k.setLeaderFormula(k.getFormula());
            k.setLeaderKpi(k.getKpi());
            if (k.getId() == null) {
                k.setId(IDGenerate.getUniqueIdStr());
                BaseJsonVo<OrgQuestionClassTimeoutVO> edit = this.isEdit(paperEntity, userId, 1, k);
                if (edit.isSuccess()) {
                    this.insertSelective(k);
                } else {
                    error = error + "\u5f53\u524dkpi[" + k.getKpi() + "]\u4fdd\u5b58\u5931\u8d25\uff0c\u6708\u4efd\u4e0d\u5141\u8bb8\u4fdd\u5b58\r\n";
                }
            } else {
                this.updateByPrimaryKeySelective(k);
            }
            PaperEntity updatePaper = new PaperEntity();
            updatePaper.setId(k.getPaperId());
            updatePaper.setStatus(1);
            if (paperEntity != null && paperEntity.getUpdateTime() == null) {
                updatePaper.setUpdateTime(new Date());
            }
            this.orgPaperDomain.update(updatePaper);
        }
        if (StringUtils.isNotEmpty((String)error)) {
            return BaseJsonVo.error((String)error);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public List<MonthKpiVo> getMonthKpi(int periodId, String userId) {
        List<Object> lastList = new ArrayList();
        List<Object> nextList = new ArrayList();
        BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod(periodId);
        if (baseJsonVo.isSuccess()) {
            lastList = this.getMonthKpi(((PeriodEntity)baseJsonVo.getValue()).getPeriodStart(), userId, 1, ((PeriodEntity)baseJsonVo.getValue()).getHeadPeriod());
        }
        if ((baseJsonVo = this.periodService.getNextPeriod(periodId)).isSuccess()) {
            nextList = this.getMonthKpi(((PeriodEntity)baseJsonVo.getValue()).getPeriodStart(), userId, 2, ((PeriodEntity)baseJsonVo.getValue()).getHeadPeriod());
        }
        if (lastList.size() >= nextList.size()) {
            int i = 0;
            for (MonthKpiVo monthKpiVo : lastList) {
                if (i < nextList.size()) {
                    monthKpiVo.setNextMonthValue(((MonthKpiVo)nextList.get(i)).getNextMonthValue());
                }
                ++i;
            }
            return lastList;
        }
        if (lastList.size() < nextList.size()) {
            int i = 0;
            for (MonthKpiVo monthKpiVo : nextList) {
                if (i < lastList.size()) {
                    monthKpiVo.setLastMonthFactValue(((MonthKpiVo)lastList.get(i)).getLastMonthFactValue());
                    monthKpiVo.setLastMonthValue(((MonthKpiVo)lastList.get(i)).getLastMonthValue());
                }
                ++i;
            }
            return nextList;
        }
        return new ArrayList<MonthKpiVo>();
    }

    private List<MonthKpiVo> getMonthKpi(Date date, String userId, int type, int month) {
        ArrayList<MonthKpiVo> kpiVos = new ArrayList<MonthKpiVo>();
        BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getPeriod(date, 2);
        if (baseJsonVo.isSuccess()) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setUserId(userId);
            paperEntity.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
            paperEntity = this.orgPaperDomain.getSingle(paperEntity);
            if (paperEntity != null) {
                KpiEntity searchKip = new KpiEntity();
                searchKip.setPaperId(paperEntity.getId());
                List kpiEntities = this.getList(searchKip);
                for (KpiEntity k : kpiEntities) {
                    MonthKpiVo kpiVo = new MonthKpiVo();
                    if (type == 1 && k.getMonth() != null && k.getMonth() == month) {
                        if (k.getLeaderValue() != null && k.getLeaderValue().doubleValue() > 0.0) {
                            kpiVo.setLastMonthValue(k.getLeaderValue());
                        }
                        if (k.getFactValue() != null && k.getFactValue().doubleValue() > 0.0) {
                            kpiVo.setLastMonthFactValue(k.getFactValue());
                        }
                    }
                    if (type == 2 && k.getMonth() != null && k.getMonth() == month && k.getLeaderValue() != null && k.getLeaderValue().doubleValue() > 0.0) {
                        kpiVo.setNextMonthValue(k.getLeaderValue());
                    }
                    if (!(kpiVo.getLastMonthFactValue() != null && kpiVo.getLastMonthFactValue().doubleValue() > 0.0 || kpiVo.getLastMonthValue() != null && kpiVo.getLastMonthValue().doubleValue() > 0.0) && (kpiVo.getNextMonthValue() == null || !(kpiVo.getNextMonthValue().doubleValue() > 0.0))) continue;
                    kpiVos.add(kpiVo);
                }
            }
        }
        return kpiVos;
    }

    @Override
    public BaseJsonVo deleteKpi(String kpiId) {
        if (kpiId == null) {
            return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
        }
        KpiEntity kpiEntity = (KpiEntity)this.selectByPrimaryKey((Serializable)((Object)kpiId));
        if (kpiEntity == null) {
            return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
        }
        if (Integer.valueOf(1).equals(kpiEntity.getLeaderConfirm()) || Integer.valueOf(1).equals(kpiEntity.getConfirm())) {
            return BaseJsonVo.error((String)"\u5458\u5de5\u6216Leader\u5df2\u7ecf\u786e\u8ba4\u4e0d\u80fd\u5220\u9664");
        }
        int count = this.deleteByPrimaryKey((Serializable)((Object)kpiId));
        if (count > 0) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo BuildKpiId(String paperId, String userId) {
        String id = IDGenerate.getUniqueIdStr();
        PaperEntity paperEntity = this.orgPaperDomain.select(paperId);
        KpiEntity kpiEntity = new KpiEntity();
        kpiEntity.setPaperId(paperId);
        if (paperEntity != null) {
            kpiEntity.setUserId(paperEntity.getUserId());
        }
        kpiEntity.setId(id);
        int i = this.insertSelective(kpiEntity);
        if (i > 0) {
            return BaseJsonVo.success((Object)id);
        }
        return BaseJsonVo.error((String)"\u83b7\u53d6Id\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getKpiMonthRanking(Integer year) {
        ArrayList<HashedMap> maps = new ArrayList<HashedMap>();
        String periodName = year + "\u5e74%s\u6708\u6392\u884c\u699c";
        Calendar calendar = Calendar.getInstance();
        for (int i = calendar.get(2) + 1; i >= 1; --i) {
            List<KpiRankingVo> kpiRankingVos;
            Date beginDate = DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)(year + "-" + i + "-01"), (String)"yyyy-MM-dd"), (int)20);
            if (!DateUtils.currentDate().after(beginDate) || (kpiRankingVos = this.getKpiMonthRanking(year, i, 10)).size() <= 0) continue;
            HashedMap map = new HashedMap();
            map.put(String.format(periodName, i), kpiRankingVos);
            maps.add(map);
        }
        return BaseJsonVo.success(maps);
    }

    private List<KpiRankingVo> getKpiMonthRanking(Integer year, Integer month, Integer questionClassId) {
        List<KpiRankingVo> kpiRankingVos = this.kpiMapper.getRankingList(year, month, questionClassId);
        BigDecimal weight = BigDecimal.ZERO;
        for (KpiRankingVo k : kpiRankingVos) {
            weight = BigDecimal.ONE;
            k.setValue(k.getValue().multiply(weight).setScale(4, RoundingMode.HALF_UP));
            k.setFactValue(k.getFactValue().multiply(weight).setScale(4, RoundingMode.HALF_UP));
            BigDecimal value = k.getValue();
            BigDecimal fact = k.getFactValue();
            BigDecimal rate = this.getCompletionRate(value, fact);
            k.setRate(rate.multiply(new BigDecimal(100)));
        }
        kpiRankingVos = kpiRankingVos.stream().sorted((c, d) -> d.getFactValue().compareTo(c.getFactValue())).collect(Collectors.toList());
        int factValueRow = 1;
        BigDecimal factValue = kpiRankingVos.size() > 0 ? kpiRankingVos.get(0).getFactValue() : BigDecimal.ZERO;
        for (KpiRankingVo k : kpiRankingVos) {
            if (k.getFactValue().doubleValue() < factValue.doubleValue()) {
                ++factValueRow;
                factValue = k.getFactValue();
            }
            k.setValueRow(BigDecimal.valueOf(factValueRow));
        }
        kpiRankingVos = kpiRankingVos.stream().sorted((c, d) -> d.getRate().compareTo(c.getRate())).collect(Collectors.toList());
        int i = 1;
        BigDecimal oldRate = kpiRankingVos.size() > 0 ? kpiRankingVos.get(0).getRate() : BigDecimal.ZERO;
        for (KpiRankingVo k : kpiRankingVos) {
            if (k.getRate().doubleValue() < oldRate.doubleValue()) {
                ++i;
                oldRate = k.getRate();
            }
            k.setRow(BigDecimal.valueOf(i));
        }
        return kpiRankingVos;
    }

    @Override
    public List<KpiMonthsVo> getKpiMonthsTotal(String userId, Integer questionClassId) {
        return this.kpiMapper.getKpiMonthsData(questionClassId, userId);
    }

    private BigDecimal getCompletionRate(BigDecimal value, BigDecimal fact) {
        BigDecimal rate = BigDecimal.ZERO;
        if (value != null && value.doubleValue() != 0.0 && fact.doubleValue() != 0.0) {
            rate = fact.subtract(value).add(value.abs()).divide(value.abs(), 4, RoundingMode.HALF_UP);
        }
        return rate;
    }

    @Override
    @ReadThroughSingleCache(namespace="getKpiRankingForErp", expiration=30)
    public BaseJsonVo getKpiRankingForErp(@ParameterValueKeyProvider(order=0) String date, @ParameterValueKeyProvider(order=2) String userMail) {
        Date d = DateUtils.getDateFromString((String)(date + "-01"), (String)"yyyy-MM-dd");
        if (d == null) {
            d = DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd");
        }
        if (d == null) {
            return BaseJsonVo.error((String)"date\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f:yyyy-MM\u6216yyyy-MM-dd");
        }
        BaseJsonVo<PeriodEntity> periodEntity = this.periodService.getPeriod(d, 2);
        if (!periodEntity.isSuccess()) {
            return BaseJsonVo.error((String)"\u5b63\u5ea6\u4e0d\u5b58\u5728");
        }
        BaseJsonVo<List<KpiRankingDetailVo>> kpiRankingDetail = this.getKpiRankingDetail(((PeriodEntity)periodEntity.getValue()).getHeadYear(), ((PeriodEntity)periodEntity.getValue()).getHeadPeriod(), userMail);
        if (!kpiRankingDetail.isSuccess() || kpiRankingDetail.getValue() == null) {
            return kpiRankingDetail;
        }
        BigDecimal value = BigDecimal.valueOf(((List)kpiRankingDetail.getValue()).stream().mapToDouble(c -> c.getValue().doubleValue()).sum());
        BigDecimal factValue = BigDecimal.valueOf(((List)kpiRankingDetail.getValue()).stream().mapToDouble(c -> c.getFactValue().doubleValue()).sum());
        BigDecimal rate = this.getCompletionRate(value, factValue);
        HashedMap map = new HashedMap();
        map.put("kpiDetail", kpiRankingDetail.getValue());
        map.put("totalValue", value.setScale(4, RoundingMode.HALF_UP));
        map.put("totalFactValue", factValue.setScale(4, RoundingMode.HALF_UP));
        map.put("totalRate", rate);
        map.put("totalStandard", this.getStandard(rate).getValue());
        map.put("remark", this.getStandardExplain(rate).replace("\u6b64\u9879", ""));
        return BaseJsonVo.success((Object)map);
    }

    private BaseJsonVo<List<KpiRankingDetailVo>> getKpiRankingDetail(Integer year, Integer quarter, String userMail) {
        if (StringUtils.isEmpty((String)userMail)) {
            return BaseJsonVo.error((String)"email\u4e3a\u7a7a");
        }
        if (year == null) {
            return BaseJsonVo.error((String)"\u5e74\u5ea6\u4e3a\u7a7a");
        }
        if (quarter == null) {
            return BaseJsonVo.error((String)"\u5b63\u5ea6\u4e3a\u7a7a");
        }
        BaseJsonVo<PeriodEntity> entityBaseJsonVo = this.periodService.getPeriodWithNum(year, quarter, 2);
        if (!entityBaseJsonVo.isSuccess()) {
            return BaseJsonVo.error((String)"\u5b63\u5ea6\u4e0d\u5b58\u5728");
        }
        MallUserEntity userEntity = this.userInterface.getSysUser4name(userMail);
        if (userEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u90ae\u7bb1\u4e0d\u5b58\u5728");
        }
        KpiEntity param = new KpiEntity();
        param.setPeriodId(((PeriodEntity)entityBaseJsonVo.getValue()).getId());
        param.setUserId(userEntity.getUserId());
        param.setQuestionClassId(10);
        param.setLeaderConfirm(1);
        param.setLeaderFactConfirm(1);
        List kpiEntities = this.getList(param);
        if (kpiEntities.size() == 0) {
            BaseJsonVo js = BaseJsonVo.success(null);
            js.setMessage("\u6ca1\u6709\u67e5\u5230leader\u786e\u8ba4\u7684\u4ef7\u503c\u76ee\u6807");
            return js;
        }
        ArrayList<KpiRankingDetailVo> detailVos = new ArrayList<KpiRankingDetailVo>();
        for (KpiEntity k : kpiEntities) {
            KpiRankingDetailVo rankingDetailVo = new KpiRankingDetailVo();
            BeanUtils.beanCopy((Object)k, (Object)rankingDetailVo);
            rankingDetailVo.setQuarter(((PeriodEntity)entityBaseJsonVo.getValue()).getHeadPeriod());
            rankingDetailVo.setUserName(userMail);
            rankingDetailVo.setRate(this.getCompletionRate(k.getValue(), k.getFactValue()));
            rankingDetailVo.setStandard((BigDecimal)this.getStandard(rankingDetailVo.getRate()).getValue());
            rankingDetailVo.setRemark(this.getStandardExplain(rankingDetailVo.getRate()));
            detailVos.add(rankingDetailVo);
        }
        return BaseJsonVo.success(detailVos);
    }

    private String getStandardExplain(BigDecimal rate) {
        StringBuilder sb = new StringBuilder();
        BaseJsonVo<BigDecimal> jsonVo = this.getStandard(rate);
        BigDecimal standard = (BigDecimal)jsonVo.getValue();
        DecimalFormat numberDecimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance();
        numberDecimalFormat.applyPattern("###.##");
        numberDecimalFormat.setRoundingMode(RoundingMode.DOWN);
        sb.append("\u6b64\u9879\u5b8c\u6210\u7387" + numberDecimalFormat.format(rate.multiply(BigDecimal.valueOf(100L))) + "%\uff0c\u6ee1\u8db3" + standard + "\u5206\u7684\u57fa\u7840\uff08" + jsonVo.getMessage() + "\uff09");
        return sb.toString();
    }

    private BaseJsonVo<BigDecimal> getStandard(BigDecimal rate) {
        BigDecimal lowScore = BigDecimal.valueOf(1.5);
        BaseJsonVo jsonVo = new BaseJsonVo(200, "");
        if (rate == null) {
            jsonVo.setMessage("60%\u4ee5\u4e0b");
            jsonVo.setValue((Object)lowScore);
            return jsonVo;
        }
        if (rate.doubleValue() >= 1.2) {
            jsonVo.setMessage("120%\u53ca\u4ee5\u4e0a");
            jsonVo.setValue((Object)BigDecimal.valueOf(5L));
            return jsonVo;
        }
        if (rate.doubleValue() >= 1.1 && rate.doubleValue() < 1.2) {
            jsonVo.setMessage("110%(\u542b)~120%(\u4e0d\u542b)");
            jsonVo.setValue((Object)BigDecimal.valueOf(4.5));
            return jsonVo;
        }
        if (rate.doubleValue() >= 1.0 && rate.doubleValue() < 1.1) {
            jsonVo.setMessage("100%(\u542b)~110%(\u4e0d\u542b)");
            jsonVo.setValue((Object)BigDecimal.valueOf(4L));
            return jsonVo;
        }
        if (rate.doubleValue() >= 0.9 && rate.doubleValue() < 1.0) {
            jsonVo.setMessage("90%(\u542b)~100%(\u4e0d\u542b)");
            jsonVo.setValue((Object)BigDecimal.valueOf(3.5));
            return jsonVo;
        }
        if (rate.doubleValue() >= 0.8 && rate.doubleValue() < 0.9) {
            jsonVo.setMessage("80%(\u542b)~90%(\u4e0d\u542b)");
            jsonVo.setValue((Object)BigDecimal.valueOf(3L));
            return jsonVo;
        }
        if (rate.doubleValue() >= 0.7 && rate.doubleValue() < 0.8) {
            jsonVo.setMessage("70%(\u542b)~80%(\u4e0d\u542b)");
            jsonVo.setValue((Object)BigDecimal.valueOf(2.5));
            return jsonVo;
        }
        if (rate.doubleValue() >= 0.6 && rate.doubleValue() < 0.7) {
            jsonVo.setMessage("60%(\u542b)~70%(\u4e0d\u542b)");
            jsonVo.setValue((Object)BigDecimal.valueOf(2L));
            return jsonVo;
        }
        if (rate.doubleValue() < 0.6) {
            jsonVo.setMessage("60%\u4ee5\u4e0b");
            jsonVo.setValue((Object)BigDecimal.valueOf(1.5));
            return jsonVo;
        }
        jsonVo.setMessage("60%\u4ee5\u4e0b");
        jsonVo.setValue((Object)lowScore);
        return jsonVo;
    }

    @Override
    public BaseJsonVo importKpi(MultipartFile file, String loginUserId) {
        BaseJsonVo baseJson = new BaseJsonVo();
        HashSet<String> setStr = new HashSet<String>();
        try (InputStream inputStream = file.getInputStream();){
            List<KpiImportVo> kpiImportVos = ExcelUtil.readExcel(new BufferedInputStream(inputStream), KpiImportVo.class);
            this.logger.info(">>>>>>>>>importPaperAnswer rows:{} excelDataVos={}", (Object)kpiImportVos.size(), (Object)JSON.toJSONString(kpiImportVos));
            if (kpiImportVos != null && kpiImportVos.size() > 0) {
                ArrayList paperAnswerEntityList = new ArrayList();
                int i = 0;
                ArrayList<KpiEntity> kpiEntities = new ArrayList<KpiEntity>();
                for (KpiImportVo kpiImportVo : kpiImportVos) {
                    ++i;
                    if (kpiImportVo.getYear() == null) {
                        setStr.add("\u7b2c" + i + "\u884c\u5e74\u5ea6\u4e3a\u7a7a");
                        continue;
                    }
                    if (kpiImportVo.getMonth() == null) {
                        setStr.add("\u7b2c" + i + "\u884c\u76ee\u6807\u5f52\u5c5e\u6708\u4e3a\u7a7a");
                        continue;
                    }
                    if (StringUtils.isEmpty((String)kpiImportVo.getEmail())) {
                        setStr.add("\u7b2c" + i + "\u884c\u90ae\u7bb1\u4e3a\u7a7a");
                        continue;
                    }
                    if (StringUtils.isEmpty((String)kpiImportVo.getKpi())) {
                        setStr.add("\u7b2c" + i + "\u884cKPI\u4e3a\u7a7a");
                        continue;
                    }
                    if (kpiImportVo.getValue() == null) {
                        setStr.add("\u7b2c" + i + "\u884c\u76ee\u6807\u4ef7\u503c\u4e3a\u7a7a");
                        continue;
                    }
                    BaseJsonVo<PeriodEntity> periodEntity = this.periodService.getPeriod(DateUtils.StrToDate((String)(kpiImportVo.getYear() + "-" + kpiImportVo.getMonth() + "-1"), (String)"yyyy-M-d"), 2);
                    if (!periodEntity.isSuccess()) {
                        setStr.add("\u7b2c" + i + "\u884c\u5e74\u6708\u4e0d\u80fd\u5bfc\u5165");
                        continue;
                    }
                    MallUserEntity userEntity = this.userInterface.getSysUser4name(kpiImportVo.getEmail());
                    if (userEntity == null) {
                        setStr.add("\u7b2c" + i + "\u884c\u7528\u6237\u90ae\u7bb1\u4e0d\u5b58\u5728\u4e0d\u80fd\u5bfc\u5165");
                        continue;
                    }
                    KpiEntity param = new KpiEntity();
                    param.setPeriodId(((PeriodEntity)periodEntity.getValue()).getId());
                    param.setUserId(userEntity.getUserId());
                    param.setQuestionClassId(10);
                    param.setKpi(kpiImportVo.getKpi());
                    KpiEntity kpiEntity = (KpiEntity)this.getSingle(param);
                    if (kpiEntity == null) {
                        kpiEntity = new KpiEntity();
                    } else {
                        if (Integer.valueOf(1).equals(kpiEntity.getConfirm()) || Integer.valueOf(1).equals(kpiEntity.getLeaderConfirm())) {
                            kpiEntity.setKpi(null);
                            kpiEntity.setValue(null);
                            kpiEntity.setFormula(null);
                            setStr.add("\u7b2c" + i + "\u884c\u76ee\u6807\u4ef7\u503c\u5df2\u786e\u8ba4\uff0c\u76ee\u6807\u516c\u5f0f\u548c\u76ee\u6807\u4ef7\u503c\u6ca1\u6709\u5bfc\u5165");
                        }
                        if ((Integer.valueOf(1).equals(kpiEntity.getFactConfirm()) || Integer.valueOf(1).equals(kpiEntity.getLeaderFactConfirm())) && kpiEntity.getFactValue() != null && kpiEntity.getFactValue().doubleValue() != 0.0 && StringUtil.isNotEmpty((String)kpiEntity.getFactFormula())) {
                            kpiEntity.setFactValue(null);
                            kpiEntity.setFactFormula(null);
                            setStr.add("\u7b2c" + i + "\u884c\u5b9e\u9645\u4ef7\u503c\u5df2\u786e\u8ba4\uff0c\u5b9e\u9645\u516c\u5f0f\u548c\u5b9e\u9645\u4ef7\u503c\u6ca1\u6709\u5bfc\u5165");
                        }
                    }
                    BeanUtils.beanCopy((Object)kpiImportVo, (Object)kpiEntity);
                    kpiEntity.setMonthKpi(1);
                    kpiEntity.setPeriodId(((PeriodEntity)periodEntity.getValue()).getId());
                    kpiEntity.setUserId(userEntity.getUserId());
                    kpiEntity.setQuestionClassId(10);
                    kpiEntity.setWeight(BigDecimal.valueOf(100L));
                    kpiEntity.setLeaderWeight(BigDecimal.valueOf(100L));
                    if (kpiEntity.getCreateTime() == null) {
                        kpiEntity.setCreateTime(new Date());
                    }
                    ArrayList<Integer> periods = new ArrayList<Integer>();
                    periods.add(((PeriodEntity)periodEntity.getValue()).getId());
                    List<PaperEntity> paperEntities = this.orgPaperDomain.getPaperByPeriodId(periods, kpiEntity.getUserId(), 10);
                    if (paperEntities.size() <= 0) {
                        setStr.add("\u7b2c" + i + "\u884c\u6708\u5ea6\u4e0d\u5141\u8bb8\u5bfc\u5165");
                        continue;
                    }
                    kpiEntity.setPaperId(paperEntities.get(0).getId());
                    Integer edit = this.isEdit(paperEntities.get(0).getId(), loginUserId, kpiEntity);
                    if (edit == 0) {
                        setStr.add("\u7b2c" + i + "\u884c\u5df2\u9501\u5b9a\u4e0d\u80fd\u5bfc\u5165");
                        continue;
                    }
                    kpiEntities.add(kpiEntity);
                }
                this.saveKpi(kpiEntities, loginUserId);
            }
        }
        catch (Exception e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        if (setStr != null && setStr.size() > 0) {
            baseJson.setValue(setStr);
            baseJson.setMessage("\u90e8\u5206\u5bfc\u5165\u5931\u8d25 \u5931\u8d25\u6570\u636e\uff1a" + JSON.toJSONString(setStr));
        }
        return baseJson;
    }
}

