/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallDepartmentEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.user.MallUserEntityVo;
import cc.lechun.mall.iservice.user.SysDepartmentInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.ExcelDataVo;
import cc.lechun.organization.entity.MonthKpiVo;
import cc.lechun.organization.entity.OptionVo;
import cc.lechun.organization.entity.OrgDayReportVo;
import cc.lechun.organization.entity.PaperAnswerEditVo;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerLookVo;
import cc.lechun.organization.entity.PaperAnswerPeriodVo;
import cc.lechun.organization.entity.PaperAnswerRelationEntity;
import cc.lechun.organization.entity.PaperAnswerRelationVo;
import cc.lechun.organization.entity.PaperAnswerUrlVo;
import cc.lechun.organization.entity.PaperAnswerVo;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperAnswerRelationDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import cc.lechun.organization.iservice.IOrgPaperAnswerService;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.service.KpiService;
import cc.lechun.utils.ExcelUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OrgPaperAnswerService
extends BaseService
implements IOrgPaperAnswerService {
    @Autowired
    private IOrgPaperAnswerDomain orgPaperAnswerDomain;
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IOrgQuestionDomain questionDomain;
    @Autowired
    private IOrgPaperAnswerRelationDomain relationDomain;
    @Autowired
    private IOrgPaperAnswerRelationService relationService;
    @Autowired
    private IOrgPermittedUsersService permittedUsersService;
    @Autowired
    private IOrgQuestionClassDomain questionClassDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private SysDepartmentInterface departmentInterface;
    @Autowired
    private KpiService kpiService;
    @Autowired
    private IOrgPaperService iOrgPaperService;
    @Autowired
    private SysUserInterface sysUserInterface;
    @Autowired
    private MallRedisLock redisLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public BaseJsonVo savePaperAnswer(List<PaperAnswerEntity> answerEntities, String userId) throws RuntimeException {
        this.logger.info(">>>>>>>>>savePaperAnswer param rows:{} >>>>>>answerEntities={}", (Object)answerEntities.size(), (Object)JSON.toJSONString(answerEntities));
        StringBuffer sb = new StringBuffer("org:").append(userId).append(answerEntities.get(0).getPaperId()).append(answerEntities.get(0).getAnswer());
        boolean lock = this.redisLock.tryLock(sb.toString(), 20000L);
        this.logger.info("******************************************lock=" + lock);
        try {
            if (lock && answerEntities != null) {
                PaperEntity paperEntity = null;
                if (answerEntities.size() > 0) {
                    paperEntity = this.orgPaperDomain.select(answerEntities.get(0).getPaperId());
                    if (paperEntity == null) {
                        throw new RuntimeException("\u95ee\u5377\u4e0d\u5b58\u5728");
                    }
                    if (paperEntity.getQuestionClassId() != 9 && !paperEntity.getUserId().equals(answerEntities.get(0).getUserId())) {
                        throw new RuntimeException("\u60a8\u65e0\u6743\u586b\u5199\u8be5\u95ee\u5377");
                    }
                }
                Integer questionClassId = null;
                for (PaperAnswerEntity answerEntity : answerEntities) {
                    QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
                    if (questionEntity == null) {
                        throw new RuntimeException("\u95ee\u9898\u4e0d\u5b58\u5728");
                    }
                    if (questionEntity.getStatus() != 1) {
                        throw new RuntimeException("\u95ee\u9898[" + questionEntity.getQuestionName() + "]\u5df2\u7981\u7528");
                    }
                    if (answerEntities.size() > 1 && questionEntity.getRequired() == 1 && StringUtils.isEmpty((String)answerEntity.getAnswer().replace("[", "").replace("]", ""))) {
                        throw new RuntimeException("\u95ee\u9898[" + questionEntity.getQuestionName() + "]\u5fc5\u586b");
                    }
                    if (questionEntity.getQuestionType() == 16) {
                        String answer = answerEntity.getAnswer().replace("T", " ").replace(".000Z", "");
                        answerEntity.setAnswer(DateUtils.formatDate((Date)DateUtils.getAddDateBySecond((Date)DateUtils.getDateFromString((String)answer, (String)"yyyy-MM-dd"), (int)28800), (String)"yyyy-MM-dd"));
                    }
                    questionClassId = questionEntity.getQuestionClassId();
                    PaperAnswerEntity ans = this.getSingle(answerEntity.getPaperId(), answerEntity.getQuestionId(), answerEntity.getUserId());
                    if (ans != null) {
                        answerEntity.setId(ans.getId());
                        this.orgPaperAnswerDomain.update(answerEntity);
                    } else {
                        answerEntity.setId(IDGenerate.getUniqueIdStr());
                        this.orgPaperAnswerDomain.insert(answerEntity);
                    }
                    if (questionEntity.getId() != 58 && questionEntity.getId() != 59 && questionEntity.getId() != 60 && questionEntity.getId() != 61) continue;
                    PaperEntity updatePaper = new PaperEntity();
                    updatePaper.setId(answerEntity.getPaperId());
                    updatePaper.setStatus(1);
                    updatePaper.setUpdateTime(new Date());
                    this.orgPaperDomain.update(updatePaper);
                }
                this.savePaperAnswerRelation(answerEntities.get(0).getPaperId(), userId);
                this.updatePaper(answerEntities.get(0).getPaperId(), questionClassId);
            }
        }
        finally {
            this.redisLock.unlock(sb.toString());
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public BaseJsonVo updatePaper(String paperId, Integer questionClassId) {
        boolean alreadyWrite = true;
        List<Object> questionEntities = new ArrayList();
        QuestionClassEntity questionClassEntity = this.questionClassDomain.getQuestionClassEntity(questionClassId);
        if (questionClassEntity != null) {
            if (questionClassEntity.getParrentClassId() != null && questionClassEntity.getParrentClassId() != 0) {
                List<QuestionClassEntity> classEntities = this.questionClassDomain.getQuestionClassEntityList(questionClassEntity.getParrentClassId());
                for (QuestionClassEntity questionClassEntity2 : classEntities) {
                    questionEntities.addAll(this.questionDomain.getQuestionList(questionClassEntity2.getClassId(), 1));
                }
            } else {
                questionEntities = this.questionDomain.getQuestionList(questionClassId, 1);
            }
        } else {
            questionEntities = this.questionDomain.getQuestionList(questionClassId, 1);
        }
        PaperAnswerEntity search = new PaperAnswerEntity();
        search.setPaperId(paperId);
        List<PaperAnswerEntity> answerEntities = this.orgPaperAnswerDomain.getList(search);
        questionEntities = questionEntities.stream().filter(c -> c.getRequired() == 1).collect(Collectors.toList());
        for (QuestionEntity questionEntity : questionEntities) {
            Optional<PaperAnswerEntity> answerEntity = answerEntities.stream().filter(c -> c.getQuestionId().intValue() == questionEntity.getId().intValue()).findFirst();
            if (answerEntity.isPresent()) {
                if (!StringUtils.isEmpty((String)answerEntity.get().getAnswer().replace("[", "").replace("]", ""))) continue;
                alreadyWrite = false;
                continue;
            }
            alreadyWrite = false;
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(answerEntities.get(0).getPaperId());
        if (alreadyWrite) {
            paperEntity.setStatus(1);
            PaperEntity paperEntity2 = this.orgPaperDomain.select(answerEntities.get(0).getPaperId());
            if (paperEntity2 != null && paperEntity2.getUpdateTime() == null) {
                paperEntity.setUpdateTime(new Date());
            }
        } else {
            paperEntity.setStatus(0);
            paperEntity.setUpdateTime(null);
        }
        this.orgPaperDomain.update(paperEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo savePaperAnswerRelation(String paperId, String userId) {
        PaperAnswerEntity search = new PaperAnswerEntity();
        search.setPaperId(paperId);
        List<PaperAnswerEntity> answerEntities = this.orgPaperAnswerDomain.getList(search);
        this.logger.info("++++savePaperAnswerRelation++++++++answerEntities={}", (Object)JSON.toJSONString(answerEntities));
        for (PaperAnswerEntity answerEntity : answerEntities) {
            QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
            if (questionEntity.getQuestionType() != 4 && questionEntity.getQuestionType() != 5 && questionEntity.getQuestionType() != 6 && questionEntity.getQuestionType() != 11 && questionEntity.getQuestionType() != 13 && questionEntity.getId() != 63) continue;
            List<PaperAnswerRelationEntity> relationEntities = new ArrayList();
            if (!StringUtils.isNotEmpty((String)answerEntity.getAnswer()) && questionEntity.getQuestionClassId() != 13) continue;
            if (questionEntity.getQuestionType() == 5 || questionEntity.getQuestionType() == 6 || questionEntity.getQuestionType() == 13 || questionEntity.getId() == 63) {
                try {
                    relationEntities = JsonUtils.getListByArray(PaperAnswerRelationEntity.class, (String)answerEntity.getAnswer());
                    relationEntities.forEach(r -> {
                        if (r.getFinished() == null) {
                            r.setFinished(0);
                        }
                        if (r.getIsLeader() == 1) {
                            r.setLeaderId(userId);
                        }
                    });
                    this.logger.info("+++++relationEntities={}", (Object)JSON.toJSONString(relationEntities));
                    this.relationService.savePaperAnswerRelation(questionEntity.getQuestionType(), answerEntity, relationEntities);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            QuestionEntity searchQuestion = new QuestionEntity();
            searchQuestion.setRelationQuestionId(answerEntity.getQuestionId());
            List<QuestionEntity> questionEntities = this.questionDomain.getList(searchQuestion);
            this.logger.info("+++++questionEntities={}", (Object)JSON.toJSONString(questionEntities));
            StringBuilder sb = new StringBuilder();
            for (QuestionEntity q : questionEntities) {
                List relationAnswers = answerEntities.stream().filter(c -> c.getQuestionId().equals(q.getId())).collect(Collectors.toList());
                this.logger.info("+++++relationAnswers={}", (Object)JSON.toJSONString(relationAnswers));
                for (PaperAnswerEntity relationAnswer : relationAnswers) {
                    sb.append("Q\uff1a" + q.getQuestionName());
                    sb.append("<br/>");
                    sb.append("A\uff1a" + relationAnswer.getAnswer());
                    sb.append("<br/>");
                }
            }
            PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
            relationEntity.setAnswerId(answerEntity.getId());
            relationEntity.setCreateTime(new Date());
            if (answerEntity.getQuestionId() != 39) {
                relationEntity.setRelationUserId(answerEntity.getAnswer());
            }
            if (questionEntity.getQuestionClassId() == 13) {
                PaperEntity paper = this.orgPaperDomain.select(paperId);
                MallUserEntity mallUser = this.userInterface.getMallUser(paper.getUserId());
                if (mallUser.getDeptId() == null || mallUser.getDeptId() == 0) {
                    relationEntity.setRelationUserId(mallUser.getLeader());
                } else {
                    MallDepartmentEntity department = (MallDepartmentEntity)this.departmentInterface.selectByPrimaryKey(mallUser.getDeptId());
                    if (department == null || StringUtils.isEmpty((String)department.getAdministrator())) {
                        relationEntity.setRelationUserId(mallUser.getLeader());
                    } else {
                        relationEntity.setRelationUserId(department.getAdministrator());
                    }
                }
            }
            relationEntity.setContent(sb.toString());
            if (StringUtils.isNotEmpty((String)relationEntity.getContent()) || questionEntity.getQuestionClassId() == 12 || questionEntity.getQuestionClassId() == 13) {
                relationEntities.add(relationEntity);
            }
            this.logger.info("+++relationEntitiesrelationEntities++relationEntities={}", (Object)JSON.toJSONString(relationEntities));
            this.relationService.savePaperAnswerRelation(questionEntity.getQuestionType(), answerEntity, relationEntities);
        }
        return BaseJsonVo.success((Object)"");
    }

    public PaperAnswerEntity getSingle(String paperId, Integer questionId, String userId) {
        PaperAnswerEntity answerEntity = new PaperAnswerEntity();
        answerEntity.setPaperId(paperId);
        answerEntity.setQuestionId(questionId);
        answerEntity.setUserId(userId);
        return this.orgPaperAnswerDomain.getSingle(answerEntity);
    }

    public boolean exists(String paperId, Integer questionId, String userId) {
        PaperAnswerEntity answerEntity = new PaperAnswerEntity();
        answerEntity.setPaperId(paperId);
        answerEntity.setQuestionId(questionId);
        answerEntity.setUserId(userId);
        return this.orgPaperAnswerDomain.exists(answerEntity);
    }

    @Override
    public BaseJsonVo getPaperAnswerList(Integer questionClass, String paperId, String userId) {
        PaperEntity paperEntity = this.orgPaperDomain.select(paperId);
        if (paperEntity == null) {
            return BaseJsonVo.error((String)"\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(paperEntity.getPeriodId());
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        List<PaperAnswerEditVo> editVos = this.orgPaperAnswerDomain.getAnswerQuestion(questionClass, paperId);
        HashMap subQuestions = new HashMap();
        for (PaperAnswerEditVo e : editVos) {
            BaseJsonVo baseJsonVo;
            if (StringUtils.isEmpty((String)e.getPaperId())) {
                e.setPaperId(paperId);
            }
            if (e.getQuestionId() == 25 && StringUtil.isEmpty((String)e.getAnswer())) {
                String q1 = this.getCurrentPeriodField(paperEntity.getUserId(), 44);
                String q2 = this.getCurrentPeriodField(paperEntity.getUserId(), 50);
                if (q1 == null) {
                    q1 = "";
                }
                if (q2 == null) {
                    q2 = "";
                }
                if (editVos.stream().filter(c -> c.getQuestionId() == 1 && "0001".equals(c.getAnswer())).count() > 0L) {
                    q2 = "";
                }
                if (editVos.stream().filter(c -> c.getQuestionId() == 1 && "0002".equals(c.getAnswer())).count() > 0L) {
                    q1 = "";
                }
                if (StringUtil.isNotEmpty((String)q1)) {
                    q1 = q1 + "\n";
                }
                e.setAnswer(q1 + q2);
            }
            if (e.getQuestionType() == 5 || e.getQuestionType() == 6 || e.getQuestionType() == 13) {
                List<PaperAnswerRelationEntity> relationEntities = new ArrayList<PaperAnswerRelationEntity>();
                if (StringUtils.isNotEmpty((String)e.getId())) {
                    PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                    search.setAnswerId(e.getId());
                    relationEntities = this.relationDomain.getListBySort(search);
                    for (PaperAnswerRelationEntity paperAnswerRelationEntity : relationEntities) {
                        String befContent = "";
                        if (paperAnswerRelationEntity.getIsDissent() != null && paperAnswerRelationEntity.getIsDissent() == 1) {
                            befContent = "\u3010\u5f02\u8bae\u3011";
                        }
                        if (!StringUtils.isNotEmpty((String)paperAnswerRelationEntity.getContent())) continue;
                        paperAnswerRelationEntity.setContent(befContent + paperAnswerRelationEntity.getContent().replace("<br/>", "\n"));
                    }
                }
                if (relationEntities.size() == 0 && e.getQuestionType() != 6) {
                    relationEntities.add(new PaperAnswerRelationEntity());
                }
                e.setRelationEntityList(relationEntities);
            }
            if (e.getQuestionClassId() == 13 && e.getQuestionType() == 11 && StringUtils.isEmpty((String)e.getAnswer())) {
                MallUserEntity mallUser = this.userInterface.getMallUser(paperEntity.getUserId());
                if (mallUser.getDeptId() == null || mallUser.getDeptId() == 0) {
                    e.setAnswer(mallUser.getLeader());
                } else {
                    MallDepartmentEntity department = (MallDepartmentEntity)this.departmentInterface.selectByPrimaryKey(mallUser.getDeptId());
                    if (department == null || StringUtils.isEmpty((String)department.getAdministrator())) {
                        e.setAnswer(mallUser.getLeader());
                    } else {
                        e.setAnswer(department.getAdministrator());
                    }
                }
            }
            if (e.getQuestionId() == 63) {
                baseJsonVo = this.getWeekThingWeekFinish(paperEntity.getPeriodId(), paperEntity.getUserId(), userId);
                if (baseJsonVo.isSuccess()) {
                    List<PaperAnswerRelationEntity> relationNewList = new ArrayList<PaperAnswerRelationEntity>();
                    List tempList = (List)baseJsonVo.getValue();
                    tempList.forEach(a -> a.setCheckWeekAfterWeek(true));
                    for (PaperAnswerEditVo paperAnswerEditVo : tempList) {
                        if (!StringUtils.isNotEmpty((String)paperAnswerEditVo.getId())) continue;
                        PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                        search.setAnswerId(paperAnswerEditVo.getId());
                        relationNewList = this.relationDomain.getListBySort(search);
                        for (PaperAnswerRelationEntity relationEntityNew : relationNewList) {
                            String befContent = "";
                            if (relationEntityNew.getIsDissent() != null && relationEntityNew.getIsDissent() == 1) {
                                befContent = "\u3010\u5f02\u8bae\u3011";
                            }
                            if (!StringUtils.isNotEmpty((String)relationEntityNew.getContent())) continue;
                            relationEntityNew.setContent(befContent + relationEntityNew.getContent().replace("<br/>", "\n"));
                        }
                    }
                    if (relationNewList.size() == 0) {
                        relationNewList.add(new PaperAnswerRelationEntity());
                    }
                    e.setRelationEntityListTwo(relationNewList);
                }
                List<PaperAnswerRelationEntity> relationContentList = new ArrayList<PaperAnswerRelationEntity>();
                if (StringUtils.isNotEmpty((String)e.getId())) {
                    PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                    search.setAnswerId(e.getId());
                    relationContentList = this.relationDomain.getListBySort(search);
                }
                if (relationContentList.size() == 0) {
                    relationContentList.add(new PaperAnswerRelationEntity());
                }
                e.setRelationEntityList(relationContentList);
            }
            if (e.getQuestionType() == 9 && StringUtils.isEmpty((String)e.getAnswer())) {
                e.setAnswer(e.getQuestionOption());
            }
            if (e.getQuestionId() == 62) {
                baseJsonVo = this.queryDayReport(paperEntity.getPeriodId(), paperEntity.getUserId());
                if (baseJsonVo.isSuccess()) {
                    List orgDayReportVoList = (List)baseJsonVo.getValue();
                    String orgDayReportVoListStr = JSON.toJSON((Object)orgDayReportVoList).toString();
                    String string = orgDayReportVoListStr.replace("\\n", "<br/>");
                    e.setAnswer(string);
                }
                if (StringUtils.isEmpty((String)e.getAnswer())) {
                    e.setAnswer("[]");
                }
            }
            if (e.getQuestionClassId() == 8) {
                List<PeriodEntity> periodEntityVoList;
                if (e.getQuestionId() == 37) {
                    List<MonthKpiVo> monthKpiList = this.kpiService.getMonthKpi(paperEntity.getPeriodId(), paperEntity.getUserId());
                    this.logger.info("++++++++++++++++++++getPaperAnswerList+++++++++++++monthKpiList={}", (Object)JSON.toJSONString(monthKpiList));
                    if (monthKpiList != null && monthKpiList.size() > 0) {
                        e.setAnswer(JSON.toJSONString(monthKpiList));
                    }
                    if (StringUtils.isEmpty((String)e.getAnswer())) {
                        e.setAnswer("[]");
                    }
                }
                if (e.getQuestionId() == 36 && String.valueOf(e.getAnswer()).isEmpty()) {
                    e.setAnswer(this.getLastPeriodField(paperEntity.getUserId(), 31));
                }
                if (e.getQuestionId() == 35 && (periodEntityVoList = this.periodService.getPeriodInfoByDate(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd())) != null && periodEntityVoList.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (PeriodEntity periodEntity2 : periodEntityVoList) {
                        sb.append("<li style=\"font-size:14px;color:black;\">\u3010" + periodEntity2.getPeriodDesc() + "\u3011\uff1a");
                        String s = this.getWeekThingWeekFinish(periodEntity2.getId(), paperEntity.getUserId());
                        if (StringUtil.isNotEmpty((String)s)) {
                            sb.append("</li>" + s);
                            continue;
                        }
                        sb.append("\u672a\u586b\u5199</li>");
                    }
                    e.setQuestionDesc("<div style=\"list-style:none;\">" + sb.toString() + "</div><br/>" + e.getQuestionDesc());
                }
            }
            QuestionEntity question = this.questionDomain.select(e.getQuestionId());
            if (e.getQuestionClassId() == 9) {
                BaseJsonVo<PeriodEntity> baseJsonVo2;
                if (userId.equals(paperEntity.getUserId()) && this.iOrgPaperService.isEdit(paperEntity, paperEntity.getUserId(), null).isSuccess() && (StringUtils.isEmpty((String)e.getAnswer()) || "[]".equals(e.getAnswer())) && (baseJsonVo2 = this.periodService.getLastPeriod(periodEntity.getId())).isSuccess()) {
                    ArrayList<Integer> periodIdList = new ArrayList<Integer>();
                    periodIdList.add(((PeriodEntity)baseJsonVo2.getValue()).getId());
                    List<PaperEntity> list = this.iOrgPaperService.getPaperByPeriodId(periodIdList, paperEntity.getUserId(), 3);
                    if (list != null && list.size() > 0) {
                        PaperEntity paperEntityNew = list.get(0);
                        ArrayList<String> paperIdList = new ArrayList<String>();
                        paperIdList.add(paperEntityNew.getId());
                        PaperAnswerVo paperAnswerVo = new PaperAnswerVo();
                        paperAnswerVo.setQuestionId(question.getRelationQuestionId());
                        paperAnswerVo.setPaperIdList(paperIdList);
                        paperAnswerVo.setUserId(paperEntity.getUserId());
                        List<PaperAnswerPeriodVo> paperAnswerEntityList = this.orgPaperAnswerDomain.queryPaperAnswerByQuestionId(paperAnswerVo);
                        if (paperAnswerEntityList != null && paperAnswerEntityList.size() > 0) {
                            ArrayList<PaperAnswerRelationEntity> relationEntityList = new ArrayList<PaperAnswerRelationEntity>();
                            for (PaperAnswerPeriodVo paperAnswerPeriodVo : paperAnswerEntityList) {
                                String[] answerList;
                                String answer = paperAnswerPeriodVo.getAnswer();
                                for (String answerStr : answerList = answer.split("\n")) {
                                    if (!StringUtils.isNotEmpty((String)answerStr)) continue;
                                    PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
                                    relationEntity.setContent(answerStr);
                                    relationEntity.setIsLeader(0);
                                    relationEntityList.add(relationEntity);
                                }
                            }
                            e.setRelationEntityList(relationEntityList);
                        }
                    }
                }
                e.setQuestionDesc(e.getQuestionDesc() + "<p style='color:#e50011 font-size:20px'>&nbsp;&nbsp;&nbsp;\u53ef\u5728\u3010\u5468\u4e8b\u5468\u6bd5\u3011\u6a21\u5757\u4e0b\u62d6\u62fd\u6392\u5e8f</p>");
            }
            if (question.getParentQuestionId() != null && question.getParentQuestionId() != 0) {
                if (subQuestions.containsKey(question.getParentQuestionId())) {
                    ((List)subQuestions.get(question.getParentQuestionId())).add(e);
                } else {
                    ArrayList<PaperAnswerEditVo> list = new ArrayList<PaperAnswerEditVo>();
                    list.add(e);
                    subQuestions.put(question.getParentQuestionId(), list);
                }
                e.setSubAnswer(true);
            }
            if (question.getIsPublicColumn() != null && question.getIsPublicColumn() == 0) {
                e.setPublic(false);
            }
            if (question.getIsReadonlyColumn() == null || question.getIsReadonlyColumn() != 1) continue;
            e.setReadonly(true);
        }
        if (!subQuestions.isEmpty()) {
            Iterator<PaperAnswerEditVo> iterator = editVos.iterator();
            while (iterator.hasNext()) {
                PaperAnswerEditVo editVo = iterator.next();
                if (subQuestions.containsKey(editVo.getQuestionId())) {
                    editVo.setSubPaperAnswerEditVos((List)subQuestions.get(editVo.getQuestionId()));
                }
                if (!editVo.getSubAnswer().booleanValue()) continue;
                iterator.remove();
            }
        }
        return BaseJsonVo.success(editVos);
    }

    public String getWeekThingWeekFinish(Integer periodId, String userId) {
        StringBuilder sb = new StringBuilder();
        BaseJsonVo baseJsonVo = this.getWeekThingWeekFinish(periodId, userId, userId);
        if (baseJsonVo.isSuccess()) {
            List<Object> relationNewList = new ArrayList();
            List tempList = (List)baseJsonVo.getValue();
            tempList.forEach(a -> a.setCheckWeekAfterWeek(true));
            for (PaperAnswerEditVo paperAnswerEditVo : tempList) {
                if (!StringUtils.isNotEmpty((String)paperAnswerEditVo.getId())) continue;
                PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                search.setAnswerId(paperAnswerEditVo.getId());
                relationNewList = this.relationDomain.getListBySort(search);
                for (PaperAnswerRelationEntity paperAnswerRelationEntity : relationNewList) {
                    sb.append("<li style=\"margin-left:20px;font-size:12px;\">");
                    if (paperAnswerRelationEntity.getIsFinishLeader() != null) {
                        if (paperAnswerRelationEntity.getIsFinishLeader() == 1) {
                            sb.append("\u3010\u5df2\u5b8c\u6210\u3011");
                        } else if (paperAnswerRelationEntity.getIsFinishLeader() == 2) {
                            sb.append("\u3010\u672a\u5b8c\u6210\u3011");
                        } else {
                            sb.append("\u3010\u672a\u786e\u8ba4\u3011");
                        }
                    } else {
                        sb.append("\u3010\u672a\u786e\u8ba4\u3011");
                    }
                    sb.append(paperAnswerRelationEntity.getContent().replace("<br/>", ""));
                    sb.append("</li>");
                }
            }
        }
        return sb.toString();
    }

    public String getLastPeriodField(String userId, Integer questionId) {
        QuestionEntity questionEntity = this.questionDomain.select(questionId);
        int periodType = this.periodService.getPeriodTypeByQuestionClass(questionEntity.getQuestionClassId());
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.getLastPeriodByType(periodType).getValue();
        if (periodEntity != null) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setPeriodId(periodEntity.getId());
            paperEntity.setUserId(userId);
            paperEntity.setQuestionClassId(questionEntity.getQuestionClassId());
            paperEntity = this.orgPaperDomain.getSingle(paperEntity);
            if (paperEntity != null) {
                PaperAnswerEntity search = new PaperAnswerEntity();
                search.setPaperId(paperEntity.getId());
                search.setQuestionId(questionId);
                search = this.orgPaperAnswerDomain.getSingle(search);
                if (search != null) {
                    return search.getAnswer();
                }
            }
        }
        return "";
    }

    public String getCurrentPeriodField(String userId, Integer questionId) {
        QuestionEntity questionEntity = this.questionDomain.select(questionId);
        int periodType = this.periodService.getPeriodTypeByQuestionClass(questionEntity.getQuestionClassId());
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.currentPeriod(periodType).getValue();
        if (periodEntity != null) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setPeriodId(periodEntity.getId());
            paperEntity.setUserId(userId);
            paperEntity.setQuestionClassId(questionEntity.getQuestionClassId());
            paperEntity = this.orgPaperDomain.getSingle(paperEntity);
            if (paperEntity != null && this.iOrgPaperService.isEdit(paperEntity, userId, null).isSuccess()) {
                PaperAnswerEntity search = new PaperAnswerEntity();
                search.setPaperId(paperEntity.getId());
                search.setQuestionId(questionId);
                search = this.orgPaperAnswerDomain.getSingle(search);
                if (search != null) {
                    return search.getAnswer();
                }
            }
        }
        return "";
    }

    @Override
    public BaseJsonVo relationMe(Integer pageNum, Integer pageSize, String userId, String classIds, Integer ctype, Integer isself) {
        PageInfo pageInfo = this.orgPaperAnswerDomain.getRelationMe(pageNum, pageSize, userId, classIds, ctype, isself);
        List relationVos = pageInfo.getList();
        Long unReadCount = relationVos.stream().filter(c -> c.getIsnew().equals(1)).count();
        if (unReadCount == null) {
            unReadCount = 0L;
        }
        for (PaperAnswerRelationVo v : relationVos.stream().filter(c -> c.getIsnew().equals(1)).collect(Collectors.toList())) {
            v.setUnReadCount(unReadCount);
            PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
            relationEntity.setId(v.getRelationId());
            relationEntity.setIsnew(0);
            this.relationDomain.update(relationEntity);
        }
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public BaseJsonVo lookPaperAnswer(PageForm pageForm, Integer year, Integer period, Integer classId, String userId, Integer questionId) {
        List<QuestionClassEntity> classEntities = this.questionClassDomain.getQuestionClassEntityList(0);
        if (classId == null && questionId == null) {
            return BaseJsonVo.error((String)"\u5206\u7c7b\u548c\u95ee\u9898\u81f3\u5c11\u9009\u62e9\u5176\u4e2d\u4e00\u4e2a\u67e5\u8be2");
        }
        if (classId == null) {
            QuestionEntity questionEntity = this.questionDomain.select(questionId);
            classId = questionEntity == null ? Integer.valueOf(0) : questionEntity.getQuestionClassId();
        }
        ArrayList paperAnswerLookVos = new ArrayList();
        int periodType = this.periodService.getPeriodTypeByQuestionClass(classId);
        PeriodEntity periodEntity = year == null || period == null ? (PeriodEntity)this.periodService.currentPeriod(periodType).getValue() : (PeriodEntity)this.periodService.getPeriodWithNum(year, period, periodType).getValue();
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        users.add(userId);
        PageInfo pageInfo = this.orgPaperAnswerDomain.lookPaperAnswer(pageForm.getCurrentPage(), pageForm.getPageSize(), periodEntity.getId(), classId, users, questionId);
        for (PaperAnswerLookVo l : pageInfo.getList()) {
            List urlVos;
            Optional<OptionVo> optionVo;
            List optionVos;
            QuestionEntity questionEntity;
            StringBuilder sb;
            if (l.getQuestionType() == 4 || l.getQuestionType() == 5) {
                PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                search.setAnswerId(l.getId());
                List<PaperAnswerRelationEntity> relationEntities = this.relationDomain.getList(search);
                sb = new StringBuilder();
                for (PaperAnswerRelationEntity r : relationEntities) {
                    sb.append("@");
                    sb.append(r.getRelationUserName());
                    sb.append("<br/>");
                    sb.append(r.getContent());
                }
                l.setAnswer(sb.toString());
            }
            if (l.getQuestionType() == 2 && (questionEntity = this.questionDomain.select(l.getQuestionId())) != null && (optionVos = JsonUtils.getListByArray(OptionVo.class, (String)questionEntity.getQuestionOption())) != null && (optionVo = optionVos.stream().filter(c -> c.getCode().equals(l.getAnswer())).findFirst()).isPresent()) {
                l.setAnswer(optionVo.get().getName());
            }
            if (l.getQuestionType() != 3 || (urlVos = JsonUtils.getListByArray(PaperAnswerUrlVo.class, (String)l.getAnswer())) == null) continue;
            String template = "<a href='%s' target='_blank'>%s</a><br/>";
            sb = new StringBuilder();
            for (PaperAnswerUrlVo u : urlVos) {
                sb.append(String.format(template, u.getUrl(), u.getName()));
            }
            l.setAnswer(sb.toString());
        }
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public BaseJsonVo getWeekThingWeekFinish(Integer period, String userId, String leaderUserId) {
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setPeriodId(period);
        paperEntity.setUserId(userId);
        paperEntity.setQuestionClassId(9);
        List<PaperEntity> paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
        if (paperList == null || paperList.size() <= 0) {
            return BaseJsonVo.error((String)"\u65e0\u6570\u636e");
        }
        paperEntity = paperList.get(0);
        List<PaperAnswerEditVo> editVos = this.orgPaperAnswerDomain.getAnswerQuestion(9, paperEntity.getId());
        boolean canRated = this.userInterface.isLeadership(leaderUserId, userId);
        for (PaperAnswerEditVo e : editVos) {
            e.setPaperId(paperEntity.getId());
            e.setCanRated(canRated);
            if (e.getQuestionType() != 5 && e.getQuestionType() != 13) continue;
            List<PaperAnswerRelationEntity> relationEntities = new ArrayList<PaperAnswerRelationEntity>();
            if (StringUtils.isNotEmpty((String)e.getId())) {
                PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                search.setAnswerId(e.getId());
                relationEntities = this.relationDomain.getList(search);
                for (PaperAnswerRelationEntity r : relationEntities) {
                    String befContent = "";
                    if (r.getIsDissent() != null && r.getIsDissent() == 1) {
                        befContent = "\u3010\u5f02\u8bae\u3011";
                    }
                    String content = r.getContent() == null ? "" : r.getContent();
                    r.setContent(befContent + content.replace("<br/>", "\n"));
                }
            }
            if (relationEntities.size() == 0) {
                relationEntities.add(new PaperAnswerRelationEntity());
            }
            e.setRelationEntityList(relationEntities);
        }
        return BaseJsonVo.success(editVos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseJsonVo importPaperAnswer(MultipartFile file) {
        HashSet<String> setStr;
        BaseJsonVo baseJson;
        block29: {
            baseJson = new BaseJsonVo();
            setStr = new HashSet<String>();
            try (InputStream inputStream = file.getInputStream();){
                List<ExcelDataVo> excelDataVos = ExcelUtil.readExcel(new BufferedInputStream(inputStream), ExcelDataVo.class);
                this.logger.info(">>>>>>>>>importPaperAnswer rows:{} excelDataVos={}", (Object)excelDataVos.size(), (Object)JSON.toJSONString(excelDataVos));
                if (excelDataVos == null || excelDataVos.size() <= 0) break block29;
                ArrayList<PaperAnswerEntity> paperAnswerEntityList = new ArrayList<PaperAnswerEntity>();
                for (ExcelDataVo excelDataVo : excelDataVos) {
                    PeriodEntity periodEntity;
                    Date createTime;
                    PaperEntity paperEntity;
                    String userId;
                    PaperAnswerEntity paperAnswerEntity;
                    block31: {
                        Integer writeSecond;
                        int endTime;
                        block32: {
                            block30: {
                                paperAnswerEntity = new PaperAnswerEntity();
                                userId = "";
                                MallUserEntityVo mallUserEntityVo = new MallUserEntityVo();
                                List<MallUserEntityVo> userEntityVos = this.sysUserInterface.getMallUserInfoByParam(null, null, excelDataVo.getDingdingId(), 1000);
                                if (userEntityVos == null || userEntityVos.size() == 0) {
                                    String companyMail;
                                    userEntityVos = this.sysUserInterface.getMallUserInfoByParam(null, excelDataVo.getUserName(), null, 1000);
                                    if ((userEntityVos == null || userEntityVos.size() == 0 || userEntityVos.size() > 1) && StringUtils.isNotEmpty((String)(companyMail = excelDataVo.getCompanyMail()))) {
                                        if (!companyMail.contains("@lechun.cc")) {
                                            companyMail = companyMail + "@lechun.cc";
                                        }
                                        userEntityVos = this.sysUserInterface.getMallUserInfoByParam(companyMail, null, null, 1000);
                                    }
                                    if (userEntityVos != null && userEntityVos.size() == 1) {
                                        this.sysUserInterface.updateUserDingDingIdById(userEntityVos.get(0).getUserId(), excelDataVo.getDingdingId());
                                    }
                                }
                                if (userEntityVos == null || userEntityVos.size() <= 0) break block30;
                                mallUserEntityVo = userEntityVos.get(0);
                                userId = mallUserEntityVo.getUserId();
                                paperAnswerEntity.setUserId(userId);
                                paperEntity = new PaperEntity();
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
                                createTime = sdf.parse(excelDataVo.getCreateTime());
                                endTime = 25200;
                                String createTimeStr = excelDataVo.getCreateTime();
                                String str1 = createTimeStr.substring(0, createTimeStr.indexOf("\u65e5"));
                                String str2 = createTimeStr.substring(str1.length() + 1, createTimeStr.length());
                                Date createTimeStrDate = DateUtils.StrToDate((String)str2, (String)"HH:mm");
                                createTimeStr = DateUtils.formatDate((Date)createTimeStrDate, (String)"HH:mm");
                                String[] createTimeStrArry = createTimeStr.split(":");
                                Integer hour = Integer.valueOf(createTimeStrArry[0]);
                                Integer minute = Integer.valueOf(createTimeStrArry[1]);
                                writeSecond = 0;
                                writeSecond = writeSecond + hour * 3600;
                                writeSecond = writeSecond + minute * 60;
                                if (writeSecond < 0) break block31;
                                break block32;
                            }
                            setStr.add(excelDataVo.getUserName());
                            continue;
                        }
                        if (writeSecond <= endTime) {
                            createTime = DateUtils.getAddDateBySecond((Date)createTime, (int)-86400);
                        }
                    }
                    if ((periodEntity = (PeriodEntity)this.periodService.getPeriod(createTime, 4).getValue()) != null) {
                        paperEntity.setPeriodId(periodEntity.getId());
                    }
                    paperEntity.setUserId(userId);
                    paperEntity.setQuestionClassId(11);
                    List<PaperEntity> paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
                    if (paperList == null || paperList.size() <= 0) {
                        BaseJsonVo baseJsonVo = this.iOrgPaperService.buildPaper(userId, 11, periodEntity.getId());
                        if (!baseJsonVo.isSuccess()) {
                            BaseJsonVo baseJsonVo2 = baseJsonVo;
                            return baseJsonVo2;
                        }
                        paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
                    }
                    paperEntity = paperList.get(0);
                    paperAnswerEntity.setPaperId(paperEntity.getId());
                    if (StringUtils.isNotEmpty((String)excelDataVo.getTodayAnswer())) {
                        PaperAnswerEntity paperAnswerEntity1 = new PaperAnswerEntity();
                        paperAnswerEntity1.setUserId(paperAnswerEntity.getUserId());
                        paperAnswerEntity1.setPaperId(paperAnswerEntity.getPaperId());
                        paperAnswerEntity1.setQuestionId(58);
                        paperAnswerEntity1.setAnswer(excelDataVo.getTodayAnswer());
                        paperAnswerEntity1.setCreateTime(createTime);
                        paperAnswerEntityList.add(paperAnswerEntity1);
                    }
                    if (StringUtils.isNotEmpty((String)excelDataVo.getTomorrowAnswer())) {
                        PaperAnswerEntity paperAnswerEntity2 = new PaperAnswerEntity();
                        paperAnswerEntity2.setUserId(paperAnswerEntity.getUserId());
                        paperAnswerEntity2.setPaperId(paperAnswerEntity.getPaperId());
                        paperAnswerEntity2.setQuestionId(59);
                        paperAnswerEntity2.setAnswer(excelDataVo.getTomorrowAnswer());
                        paperAnswerEntity2.setCreateTime(createTime);
                        paperAnswerEntityList.add(paperAnswerEntity2);
                    }
                    if (StringUtils.isNotEmpty((String)excelDataVo.getNeedHelp())) {
                        PaperAnswerEntity paperAnswerEntity3 = new PaperAnswerEntity();
                        paperAnswerEntity3.setUserId(paperAnswerEntity.getUserId());
                        paperAnswerEntity3.setPaperId(paperAnswerEntity.getPaperId());
                        paperAnswerEntity3.setQuestionId(60);
                        paperAnswerEntity3.setAnswer(excelDataVo.getNeedHelp());
                        paperAnswerEntity3.setCreateTime(createTime);
                        paperAnswerEntityList.add(paperAnswerEntity3);
                    }
                    if (!StringUtils.isNotEmpty((String)excelDataVo.getCompanyMail())) continue;
                    PaperAnswerEntity paperAnswerEntity4 = new PaperAnswerEntity();
                    paperAnswerEntity4.setUserId(paperAnswerEntity.getUserId());
                    paperAnswerEntity4.setPaperId(paperAnswerEntity.getPaperId());
                    paperAnswerEntity4.setQuestionId(61);
                    paperAnswerEntity4.setAnswer(excelDataVo.getCompanyMail());
                    paperAnswerEntity4.setCreateTime(createTime);
                    paperAnswerEntityList.add(paperAnswerEntity4);
                }
                this.savePaperAnswer(paperAnswerEntityList, null);
            }
            catch (Exception e) {
                baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
                e.printStackTrace();
            }
        }
        if (setStr == null) return baseJson;
        if (setStr.size() <= 0) return baseJson;
        baseJson.setValue(setStr);
        baseJson.setMessage("\u90e8\u5206\u7528\u6237\u5bfc\u5165\u5931\u8d25 \u7528\u6237\u540d\u79f0\u96c6\u5408\uff1a" + JSON.toJSONString(setStr));
        return baseJson;
    }

    @Override
    public BaseJsonVo queryDayReport(Integer periodId, String userId) {
        if (periodId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(periodId);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        ArrayList<OrgDayReportVo> orgDayReportVoList = new ArrayList<OrgDayReportVo>();
        List<PeriodEntity> periodEntityList = this.periodService.getPeriodInfoByDate(4, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        if (periodEntityList != null && periodEntityList.size() > 0) {
            ArrayList<Integer> periodIdList = new ArrayList<Integer>();
            for (PeriodEntity periodVo : periodEntityList) {
                periodIdList.add(periodVo.getId());
            }
            List<PaperEntity> paperEntityList = this.iOrgPaperService.getPaperByPeriodId(periodIdList, userId, 11);
            if (paperEntityList != null && paperEntityList.size() > 0) {
                ArrayList<String> paperIdList = new ArrayList<String>();
                for (PaperEntity paperEntity : paperEntityList) {
                    paperIdList.add(paperEntity.getId());
                }
                List<PaperAnswerEntity> paperAnswerEntityList = this.orgPaperAnswerDomain.queryPaperAnswerByParam(paperIdList, userId);
                if (paperAnswerEntityList != null && paperAnswerEntityList.size() > 0) {
                    for (String paperId : paperIdList) {
                        OrgDayReportVo orgDayReportVo = new OrgDayReportVo();
                        for (PaperAnswerEntity paperAnswerVo1 : paperAnswerEntityList) {
                            if (!paperId.equals(paperAnswerVo1.getPaperId())) continue;
                            if (paperAnswerVo1.getQuestionId() == 58) {
                                orgDayReportVo.setTodayAnswer(paperAnswerVo1.getAnswer());
                            }
                            if (paperAnswerVo1.getQuestionId() == 59) {
                                orgDayReportVo.setTomorrowAnswer(paperAnswerVo1.getAnswer());
                            }
                            orgDayReportVo.setDateWeek(DateUtils.getShortWeekOfDate((Date)paperAnswerVo1.getCreateTime()));
                        }
                        if (!StringUtils.isNotEmpty((String)orgDayReportVo.getTodayAnswer())) continue;
                        orgDayReportVoList.add(orgDayReportVo);
                    }
                }
            }
        }
        return BaseJsonVo.success(orgDayReportVoList);
    }
}

