/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.framework.common.utils.thread.ThreadPool;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.MyPaperBonusVo;
import cc.lechun.organization.entity.PaparStatusEnum;
import cc.lechun.organization.entity.PaperBonusDetailExcelVo;
import cc.lechun.organization.entity.PaperBonusDetailVo;
import cc.lechun.organization.entity.PaperBonusVo;
import cc.lechun.organization.entity.PaperDo;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PaperVoteInfoDo;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgVoteDomain;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IPaperReportBounsService;
import cc.lechun.organization.iservice.IPeriodService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PaperReportBounsService
implements IPaperReportBounsService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgQuestionClassDomain classDomain;
    @Autowired
    @Lazy
    private IOrgPaperService paperService;
    @Autowired
    private IOrgVoteDomain orgVoteService;
    @Autowired
    private MallRedisLock redisLock;
    private BigDecimal bonuse = new BigDecimal(0);
    private final BigDecimal base = new BigDecimal(50);
    private final BigDecimal facor = new BigDecimal(25);

    @Override
    public Date getBonusesDate(Integer year, Integer month) {
        LocalDate localDate = LocalDate.of((int)year, month, 1);
        LocalDate nextMonthDay = localDate.plusMonths(1L);
        int i = 1;
        while (i < 2) {
            if ((nextMonthDay = nextMonthDay.plusDays(1L)).getDayOfWeek().getValue() != 1) continue;
            ++i;
        }
        return this.LocalDateTodate(nextMonthDay);
    }

    private Date LocalDateTodate(LocalDate localDate) {
        if (localDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            return date;
        }
        return null;
    }

    @Override
    public List<PaperBonusVo> getBonusesList(String userId, Integer year, Integer month, Integer questionClassId) {
        String bonusTime = String.format("%s-%s", year.toString(), month > 9 ? month : "0" + month.toString());
        List<PaperBonusVo> list = this.orgPaperDomain.getBonusesList(userId, bonusTime, questionClassId);
        if (list != null && list.size() > 0) {
            list.forEach(b -> b.setEmail(this.userInterface.getMallUser(b.getUserId()).getUserName()));
        }
        return list;
    }

    @Override
    public MyPaperBonusVo getMyBonusesList(String userId, Integer year, Integer month, Integer questionClassId) {
        String bonusTime = String.format("%s-%s", year.toString(), month > 9 ? month : "0" + month.toString());
        List<PaperBonusVo> list = this.orgPaperDomain.getBonusesList(userId, bonusTime, questionClassId);
        MyPaperBonusVo myPaperBonusVo = new MyPaperBonusVo();
        if (list != null && list.size() > 0) {
            PaperBonusVo paperBonusVo = list.get(0);
            BeanUtils.copyProperties((Object)paperBonusVo, (Object)myPaperBonusVo);
            QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(questionClassId);
            myPaperBonusVo.setClassName(questionClassEntity == null ? "" : questionClassEntity.getClassName());
            myPaperBonusVo.setEmail(this.userInterface.getMallUser(paperBonusVo.getUserId()).getUserName());
            return myPaperBonusVo;
        }
        return myPaperBonusVo;
    }

    @Override
    public List<PaperBonusDetailVo> getPaperBonusDetaiList(String userId, Integer year, Integer month, Integer questionClassId, Integer reportStatus) {
        LocalDate startLocalDate = LocalDate.of((int)year, month, 1);
        Date start = this.LocalDateTodate(startLocalDate);
        Date end = this.LocalDateTodate(startLocalDate.plusMonths(1L));
        List<PaperEntity> list = this.orgPaperDomain.getPaperBonusDetaiList(userId, start, end, questionClassId, reportStatus);
        ArrayList<PaperBonusDetailVo> resultList = new ArrayList<PaperBonusDetailVo>();
        if (list != null && list.size() > 0) {
            list.forEach(b -> {
                PaperBonusDetailVo paperBonusDetailVo = new PaperBonusDetailVo();
                BeanUtils.copyProperties((Object)b, (Object)paperBonusDetailVo);
                QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(b.getQuestionClassId());
                paperBonusDetailVo.setClassName(questionClassEntity == null ? "" : questionClassEntity.getClassName());
                resultList.add(paperBonusDetailVo);
            });
        }
        return resultList;
    }

    @Override
    public List<PaperBonusDetailExcelVo> getPaperBonusDetailExcelList(String userId, Integer year, Integer month, Integer questionClassId, Integer reportStatus) {
        Date end;
        ArrayList<PaperBonusDetailExcelVo> resultList = new ArrayList<PaperBonusDetailExcelVo>();
        LocalDate startLocalDate = LocalDate.of((int)year, month, 1);
        Date start = this.LocalDateTodate(startLocalDate);
        List<PaperEntity> list = this.orgPaperDomain.getPaperBonusDetaiList(userId, start, end = this.LocalDateTodate(startLocalDate.plusMonths(1L)), questionClassId, reportStatus);
        if (list != null && list.size() > 0) {
            list.forEach(b -> {
                PaperBonusDetailExcelVo paperBonusDetailVo = new PaperBonusDetailExcelVo();
                BeanUtils.copyProperties((Object)b, (Object)paperBonusDetailVo);
                QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(b.getQuestionClassId());
                paperBonusDetailVo.setClassName(questionClassEntity == null ? "" : questionClassEntity.getClassName());
                MallUserEntity userEntity = this.userInterface.getMallUser(b.getUserId());
                if (userEntity != null) {
                    paperBonusDetailVo.setEmail(userEntity.getUserName());
                    paperBonusDetailVo.setUserName(userEntity.getUserNick());
                }
                paperBonusDetailVo.setReportStatusName(PaparStatusEnum.getName((int)b.getReportStatus()));
                this.logger.info("\u8ba1\u7b97\u5f97\u8d5e\u7387:{}", (Object)paperBonusDetailVo.toString());
                paperBonusDetailVo.setVoteRate(paperBonusDetailVo.getTotalVoteNum() > 0 ? this.getVoteRate(paperBonusDetailVo.getVoteNum(), paperBonusDetailVo.getTotalVoteNum()) + "%" : "0%");
                resultList.add(paperBonusDetailVo);
            });
        }
        return resultList;
    }

    private BigDecimal getVoteRate(int a, int b) {
        return new BigDecimal(a).divide(new BigDecimal(b), 3, 5).multiply(new BigDecimal(100));
    }

    @Override
    public void calculateBonuses() {
        try {
            PeriodEntity perPeriodEntity;
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriodByType(0);
            if (baseJsonVo.isSuccess() && (baseJsonVo = this.periodService.getLastPeriod((perPeriodEntity = (PeriodEntity)baseJsonVo.getValue()).getId())).isSuccess()) {
                perPeriodEntity = (PeriodEntity)baseJsonVo.getValue();
                this.calculateBonuses(perPeriodEntity.getId(), 1);
                this.calculateBonuses(perPeriodEntity.getId(), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void calculateBonuses(Integer periodId) {
        this.calculateBonuses(periodId, 1);
        this.calculateBonuses(periodId, 2);
    }

    @Override
    public void calculateBonuses(Integer periodId, Integer classId) {
        if (!this.periodService.checkCurrentPeriodOrLastPeriod(periodId).booleanValue()) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setPeriodId(periodId);
            paperEntity.setQuestionClassId(classId);
            List<PaperEntity> paperEntityList = this.orgPaperDomain.getList(paperEntity);
            if (paperEntityList != null && paperEntityList.size() > 0) {
                paperEntityList.forEach(p -> this.calculateBonuses((PaperEntity)p));
            }
        } else {
            this.logger.info("\u671f\u6b21{}\u4e0d\u7b26\u5408\u5956\u91d1\u8ba1\u7b97\u6761\u4ef6", (Object)periodId);
        }
    }

    @Override
    public void calculateBonuses(PaperEntity paperEntity) {
        PaperDo paperDo = new PaperDo();
        BigDecimal bonus = new BigDecimal(0);
        boolean release = false;
        if (paperEntity.getReportStatus() == 1) {
            paperDo.setLevel(paperEntity.getLevel());
            paperDo.setCurrent(paperEntity);
            bonus = this.getBonuse(paperEntity.getLevel());
            release = false;
            if (paperDo.getCurrent().getLevel() >= 4) {
                this.logger.info("\u62a5\u544a{}\u8fde\u63a54\u671f\u5408\u683c\uff0c\u8fbe\u5230\u7ed3\u7b97\u6761\u4ef6", (Object)paperDo.getCurrent());
                release = true;
            } else {
                BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getNextPeriod(paperDo.getCurrent().getPeriodId());
                if (baseJsonVo.isSuccess()) {
                    PeriodEntity currentPeriod = this.periodService.getPeriodEntity(paperDo.getCurrent().getPeriodId());
                    Calendar c = Calendar.getInstance();
                    c.setTime(currentPeriod.getPeriodEnd());
                    Calendar c2 = Calendar.getInstance();
                    c2.setTime(((PeriodEntity)baseJsonVo.getValue()).getPeriodEnd());
                    if (c.get(2) != c2.get(2)) {
                        this.logger.info("\u62a5\u544a:{}\u672c\u671f\u7ed3\u675f\u65f6\u95f4{},\u4e0b\u671f\u7ed3\u675f\u65f6\u95f4:{}\uff0c\u8fbe\u5230\u7ed3\u7b97\u6761\u4ef6", new Object[]{paperEntity.toString(), currentPeriod.getPeriodEnd(), ((PeriodEntity)baseJsonVo.getValue()).getPeriodEnd()});
                        release = true;
                    } else {
                        PaperEntity query = new PaperEntity();
                        query.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                        query.setQuestionClassId(paperDo.getCurrent().getQuestionClassId());
                        query.setUserId(paperDo.getCurrent().getUserId());
                        PaperEntity next = this.orgPaperDomain.getSingle(query);
                        if (next != null && next.getReportStatus() == 2) {
                            this.logger.info("\u4e0b\u4e00\u671f{}\u4e0d\u5408\u683c\uff0c\u8fbe\u5230\u7ed3\u7b97\u6761\u4ef6", (Object)next);
                            release = true;
                        }
                    }
                } else {
                    this.logger.info("\u671f\u6b21:{},{}", (Object)paperDo.getCurrent().getPeriodId(), (Object)baseJsonVo.getMessage());
                }
            }
            PeriodEntity periodEntity = this.periodService.getPeriodEntity(paperEntity.getPeriodId());
            paperDo.getCurrent().setBonusTime(periodEntity.getPeriodEnd());
            this.setBonuses(paperDo, bonus, release);
        } else {
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod(paperEntity.getPeriodId());
            if (baseJsonVo.isSuccess()) {
                PaperEntity query = new PaperEntity();
                query.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                query.setQuestionClassId(paperEntity.getQuestionClassId());
                query.setUserId(paperEntity.getUserId());
                PaperEntity prev = this.orgPaperDomain.getSingle(query);
                if (prev != null) {
                    if (prev.getReportStatus() == 1) {
                        this.logger.info("\u5f53\u671f{}\u4e0d\u5408\u683c\uff0c\u5f00\u59cb\u8ba1\u7b97\u4e0a\u4e00\u671f{}", (Object)paperEntity, (Object)prev);
                        this.calculateBonuses(prev);
                    } else {
                        this.logger.info("\u4e0a\u4e00\u671f{}\u8ba1\u7b97\u5b8c\u6210", (Object)prev);
                    }
                }
            }
        }
    }

    @Override
    public void calculateBonuses(String paperId) {
        if (this.redisLock.lock("Calcu:" + paperId, "", 60L, TimeUnit.SECONDS)) {
            PaperEntity paperEntity = (PaperEntity)this.paperService.selectByPrimaryKey((Serializable)((Object)paperId), 0L);
            this.calculateBonuses(paperEntity);
        }
    }

    @Override
    public void setBonuses(PaperDo paperDo, BigDecimal bonuse, boolean release) {
        if (paperDo.getCurrent().getReportStatus() == 1) {
            this.logger.info("\u5f00\u59cb\u8ba1\u7b97\u5956\u91d1:{}", (Object)paperDo.getCurrent());
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setBonus(bonuse);
            paperEntity.setLevel(paperDo.getCurrent().getLevel());
            paperEntity.setId(paperDo.getCurrent().getId());
            if (release) {
                paperEntity.setReportStatus(3);
            }
            paperEntity.setBonusTime(paperDo.getCurrent().getBonusTime());
            Boolean temp = this.orgPaperDomain.update(paperEntity);
            this.logger.info("{}, \u5956\u91d1:{},\u4fdd\u5b58\u5956\u91d1:{}", new Object[]{paperEntity, bonuse, temp});
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod(paperDo.getCurrent().getPeriodId());
            if (baseJsonVo.isSuccess()) {
                PaperDo current = new PaperDo();
                PeriodEntity periodEntity = (PeriodEntity)baseJsonVo.getValue();
                PaperEntity query = new PaperEntity();
                query.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                query.setQuestionClassId(paperDo.getCurrent().getQuestionClassId());
                query.setUserId(paperDo.getCurrent().getUserId());
                PaperEntity prev = this.orgPaperDomain.getSingle(query);
                if (prev != null) {
                    prev.setLevel(paperEntity.getLevel());
                    prev.setBonus(paperEntity.getBonus());
                    prev.setBonusTime(paperEntity.getBonusTime());
                    current.setCurrent(prev);
                    current.setLevel(paperDo.getLevel() - 1);
                    this.setBonuses(current, bonuse, release);
                } else {
                    this.logger.info("\u5956\u91d1\u8ba1\u7b97\u7ed3\u675f:{},\u4e0a\u4e00\u671f\u62a5\u544a\u4e0d\u5b58\u5728:", (Object)paperDo.getCurrent());
                }
            } else {
                this.logger.info("\u5956\u91d1\u8ba1\u7b97\u7ed3\u675f,\u671f\u6b21:{}\u7684\u4e0a\u4e00\u671f\u4e0d\u5b58\u5728:", (Object)paperDo.getCurrent().getPeriodName());
            }
        } else {
            this.logger.info("\u5206\u7c7b:{},\u671f\u6b21:{},\u7528\u6237:{}\u4e0d\u7b26\u5408\u5956\u91d1\u8ba1\u7b97\u6761\u4ef6,\u62a5\u544a\u72b6\u6001:{}", new Object[]{paperDo.getCurrent().getQuestionClassId(), paperDo.getCurrent().getPeriodName(), paperDo.getCurrent().getUserName(), paperDo.getCurrent().getReportStatus()});
        }
    }

    private BigDecimal getBonuse(Integer level) {
        if (level < 1) {
            level = 1;
        }
        return this.base.add(this.facor.multiply(new BigDecimal(level - 1)));
    }

    @Override
    public BaseJsonVo setReportStatus() {
        try {
            PeriodEntity perPeriodEntity;
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriodByType(0);
            if (baseJsonVo.isSuccess() && (baseJsonVo = this.periodService.getLastPeriod((perPeriodEntity = (PeriodEntity)baseJsonVo.getValue()).getId())).isSuccess()) {
                perPeriodEntity = (PeriodEntity)baseJsonVo.getValue();
                this.setReportStatus(perPeriodEntity.getId(), (Integer)1);
                this.setReportStatus(perPeriodEntity.getId(), (Integer)2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Async
    public BaseJsonVo initReportStatus() {
        List<PeriodEntity> list = this.periodService.getPeriodEntityList(0);
        if (list != null && list.size() > 0) {
            list.forEach(p -> {
                if (p.getId() >= 42 && !this.periodService.checkCurrentPeriodOrLastPeriod(p.getId()).booleanValue()) {
                    this.setReportStatus(p.getId(), (Integer)1);
                    this.setReportStatus(p.getId(), (Integer)2);
                }
            });
        }
        return null;
    }

    @Override
    public BaseJsonVo setReportStatus(Integer periodId, Integer classId) {
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(periodId);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)("\u671f\u6b21" + periodId + "\u4e0d\u5b58\u5728"));
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setPeriodId(periodId);
        paperEntity.setQuestionClassId(classId);
        List<PaperEntity> paperEntityList = this.orgPaperDomain.getList(paperEntity);
        if (paperEntityList != null && paperEntityList.size() > 0) {
            paperEntityList.forEach(p -> this.setReportStatus(periodId, classId, (PaperEntity)p));
        }
        return BaseJsonVo.success((Object)"\u62a5\u544a\u662f\u5426\u5408\u683c\u72b6\u6001\u8bbe\u7f6e\u5b8c\u6bd5");
    }

    @Override
    public BaseJsonVo setReportStatusAsync(final Integer periodId, final Integer classId, final PaperEntity p) {
        ThreadPool.services.execute(new Runnable(){

            @Override
            public void run() {
                PaperReportBounsService.this.setReportStatus(periodId, classId, p);
            }
        });
        return BaseJsonVo.success((Object)"\u8ba1\u7b97\u6210\u529f");
    }

    private void setReportStatus(Integer periodId, Integer classId, PaperEntity p) {
        PaperEntity update = new PaperEntity();
        update.setId(p.getId());
        PaperVoteInfoDo paperVoteInfoDo = this.orgVoteService.checkStandard(p.getUserId(), p.getId(), 1, p.getPeriodId(), p.getQuestionClassId());
        Integer reportStatus = paperVoteInfoDo.getResult() != false ? 1 : 2;
        Integer level = 0;
        if (!paperVoteInfoDo.getResult().booleanValue()) {
            update.setBonus(new BigDecimal(0));
        }
        if (reportStatus == 1) {
            update.setReportStatus(reportStatus);
            level = 1;
        }
        if (!this.periodService.checkCurrentPeriodOrLastPeriod(periodId).booleanValue() && reportStatus == 2) {
            update.setReportStatus(reportStatus);
        }
        update.setVoteNum(paperVoteInfoDo.getNum());
        update.setTotalVoteNum(paperVoteInfoDo.getTotal());
        if (paperVoteInfoDo.getResult().booleanValue()) {
            level = 1;
            BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod(periodId);
            if (baseJsonVo.isSuccess()) {
                PaperEntity queryPaper = new PaperEntity();
                queryPaper.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                queryPaper.setQuestionClassId(classId);
                queryPaper.setUserId(p.getUserId());
                PaperEntity query = this.orgPaperDomain.getSingle(queryPaper);
                if (query != null) {
                    level = query.getLevel() == null ? 1 : (query.getLevel().intValue() != p.getLevel().intValue() ? query.getLevel() + 1 : p.getLevel());
                }
            }
            if (level >= 4) {
                level = 4;
            }
        }
        update.setLevel(level);
        boolean temp = this.orgPaperDomain.update(update);
        this.logger.info("\u62a5\u544a{}\u72b6\u6001\u66f4\u65b0{}", (Object)p, (Object)temp);
        if (temp && reportStatus == 1) {
            this.logger.info("\u62a5\u544a:{}\u5408\u683c\u5f00\u59cb\u8ba1\u7b97\u5956\u91d1", (Object)p.toString());
            this.calculateBonuses(p.getId());
        }
    }

    @Override
    public BaseJsonVo setReportStatus(String id, Integer reportStatus) {
        PaperEntity update = new PaperEntity();
        update.setId(id);
        update.setReportStatus(reportStatus);
        return this.orgPaperDomain.update(update) ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

