/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.collage;

import cc.lechun.active.dao.collage.CollageConfigMapper;
import cc.lechun.active.dao.collage.CollageConfigProductMapper;
import cc.lechun.active.dao.collage.CollageDetailMapper;
import cc.lechun.active.dao.collage.CollageDiscountMapper;
import cc.lechun.active.dao.collage.CollageMapper;
import cc.lechun.active.dao.collage.CollageProductMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.collage.CollageConfigEntity;
import cc.lechun.active.entity.collage.CollageConfigProductEntity;
import cc.lechun.active.entity.collage.CollageConfigProductVo;
import cc.lechun.active.entity.collage.CollageConfigVo;
import cc.lechun.active.entity.collage.CollageDetailEntity;
import cc.lechun.active.entity.collage.CollageDiscountEntity;
import cc.lechun.active.entity.collage.CollageEntity;
import cc.lechun.active.entity.collage.CollageOrderReductionVo;
import cc.lechun.active.entity.collage.CollageProductEntity;
import cc.lechun.active.entity.collage.CollageProductVo;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.collage.CollageInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.item.IndexNavVo;
import cc.lechun.mall.entity.sales.MallIndexGroupVo;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CollageService
extends ActiveBaseService
implements CollageInterface {
    @Autowired
    private CollageConfigMapper collageConfigMapper;
    @Autowired
    private CollageProductMapper collageProductMapper;
    @Autowired
    private CollageMapper collageMapper;
    @Autowired
    private CollageDetailMapper collageDetailMapper;
    @Autowired
    private CollageConfigProductMapper collageConfigProductMapper;
    @Autowired
    private MallIndexItemInterface indexItemInterface;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private OssService ossService;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MessageInterface messageService;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    @Lazy
    private ActiveCommonInterface activeCommonService;
    @Autowired
    private CollageDiscountMapper collageDiscountMapper;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;

    @Override
    @ReadThroughSingleCache(namespace="CollageService.getCollageList", expiration=300)
    public List<Map<String, Object>> getCollageList(@ParameterValueKeyProvider int platFormId) {
        List<Map<String, Object>> mapList = this.collageConfigMapper.getCollageList(platFormId);
        if (mapList != null && mapList.size() >= 1) {
            for (Map<String, Object> map : mapList) {
                ActiveQrcodeEntity activeQrcodeEntity = new ActiveQrcodeEntity();
                activeQrcodeEntity.setActiveType(1);
                activeQrcodeEntity.setActiveNo(map.get("ACTIVE_NO").toString());
                ActiveQrcodeEntity qrcodeEntity = this.activeQrcodeService.getActiveQrcode(activeQrcodeEntity);
                if (qrcodeEntity != null) {
                    map.put("BINDCODE", qrcodeEntity.getBindCode());
                } else {
                    this.logger.error("\u672a\u914d\u7f6e\u6d3b\u52a8\u4e8c\u7ef4\u7801");
                    map.put("BINDCODE", "");
                }
                map.put("PIC_URL", map.get("BANNER") == null ? "" : map.get("BANNER").toString());
            }
        }
        return mapList;
    }

    @Override
    public BaseJsonVo getCollageProductList(String bindCode, Integer platformId, String customerId, int itemType) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null) {
            CollageConfigEntity queryCollage = new CollageConfigEntity();
            queryCollage.setActiveNo(activeEntity.getActiveNo());
            CollageConfigEntity collageConfigEntity = (CollageConfigEntity)this.collageConfigMapper.getSingle(queryCollage);
            if (collageConfigEntity != null) {
                BaseJsonVo baseJsonVo = this.indexItemInterface.getIndexNavProductList(platformId, customerId, itemType);
                List navs = (List)baseJsonVo.getValue();
                ArrayList<Object> colloageList = new ArrayList<Object>();
                TreeSet<String> productList = new TreeSet<String>();
                if (Integer.valueOf(1).equals(collageConfigEntity.getProductType())) {
                    for (IndexNavVo indexNavVo : navs) {
                        boolean isFiller = false;
                        for (Object o : indexNavVo.getItems()) {
                            if (o instanceof MallIndexPromotionVo) {
                                if (productList.contains(((MallIndexPromotionVo)o).getPromotionId())) continue;
                                isFiller = true;
                                productList.add(((MallIndexPromotionVo)o).getPromotionId());
                                colloageList.add(o);
                                continue;
                            }
                            if (!(o instanceof MallIndexProductVo) || productList.contains(((MallIndexProductVo)o).getProductId())) continue;
                            isFiller = true;
                            productList.add(((MallIndexProductVo)o).getProductId());
                            colloageList.add(o);
                        }
                    }
                    return BaseJsonVo.success(colloageList);
                }
                if (Integer.valueOf(2).equals(collageConfigEntity.getProductType())) {
                    CollageConfigProductEntity collageProductEntity = new CollageConfigProductEntity();
                    collageProductEntity.setActiveNo(activeEntity.getActiveNo());
                    collageProductEntity.setStatus(1);
                    List list = this.collageConfigProductMapper.getList(collageProductEntity);
                    for (IndexNavVo indexNavVo : navs) {
                        boolean isFiller = false;
                        for (Object o : indexNavVo.getItems()) {
                            if (o instanceof MallIndexPromotionVo) {
                                for (CollageConfigProductEntity productEntity : list) {
                                    if (!productEntity.getProductId().equals(((MallIndexPromotionVo)o).getPromotionId()) || productEntity.getProductType() != 1 || productList.contains(((MallIndexPromotionVo)o).getPromotionId())) continue;
                                    isFiller = true;
                                    productList.add(((MallIndexGroupVo)o).getGroupId());
                                    colloageList.add(o);
                                }
                                continue;
                            }
                            if (!(o instanceof MallIndexProductVo)) continue;
                            for (CollageConfigProductEntity productEntity : list) {
                                if (!productEntity.getProductId().equals(((MallIndexProductVo)o).getProductId()) || productEntity.getProductType() != 4 || productList.contains(((MallIndexProductVo)o).getProductId())) continue;
                                isFiller = true;
                                productList.add(((MallIndexProductVo)o).getProductId());
                                colloageList.add(o);
                            }
                        }
                    }
                    return BaseJsonVo.success(colloageList);
                }
                return BaseJsonVo.error((String)"\u62fc\u5355\u7c7b\u578b\u914d\u7f6e\u4e0d\u6b63\u786e");
            }
            return BaseJsonVo.error((String)"\u62fc\u5355\u914d\u7f6e\u4e0d\u6b63\u786e");
        }
        return BaseJsonVo.error((String)"\u6d3b\u52a8\u914d\u7f6e\u4e0d\u6b63\u786e");
    }

    @Override
    public BaseJsonVo getCollageProductList(String bindCode, Integer platformGroupId) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null) {
            CollageConfigEntity queryCollage = new CollageConfigEntity();
            queryCollage.setActiveNo(activeEntity.getActiveNo());
            CollageConfigEntity collageConfigEntity = (CollageConfigEntity)this.collageConfigMapper.getSingle(queryCollage);
            if (collageConfigEntity != null) {
                List<CollageConfigProductVo> list = this.getCollageProductList(activeEntity.getActiveNo(), platformGroupId, collageConfigEntity.getProductType());
                if (list != null) {
                    return BaseJsonVo.success(list);
                }
                return BaseJsonVo.error((String)"\u62fc\u5355\u5546\u54c1\u914d\u7f6e\u4e0d\u6b63\u786e");
            }
            return BaseJsonVo.error((String)"\u62fc\u5355\u914d\u7f6e\u4e0d\u6b63\u786e");
        }
        return BaseJsonVo.error((String)"\u6d3b\u52a8\u914d\u7f6e\u4e0d\u6b63\u786e");
    }

    @Override
    @ReadThroughSingleCache(namespace="CollageService.getCollageProductList")
    public List<CollageConfigProductVo> getCollageProductList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer platformGroupId, Integer productType) {
        ArrayList<CollageConfigProductVo> colloageList = new ArrayList<CollageConfigProductVo>();
        TreeSet productList = new TreeSet();
        List<MallProductEntity> list = this.mallProductInterface.getOnAndShowProductList(platformGroupId, true);
        CollageConfigProductVo collageConfigProductVo = null;
        if (Integer.valueOf(1).equals(productType)) {
            for (MallProductEntity mallProductEntity : list) {
                collageConfigProductVo = this.getProdutct(mallProductEntity);
                if (collageConfigProductVo == null) continue;
                colloageList.add(collageConfigProductVo);
            }
            List<MallPromotionVO> promotionList = this.promotionInterface.getCurrentPromotionList(platformGroupId, true);
            if (productList != null) {
                for (MallPromotionVO promotionVO : promotionList) {
                    collageConfigProductVo = this.getPromotion(promotionVO);
                    colloageList.add(collageConfigProductVo);
                }
            }
            return colloageList;
        }
        if (Integer.valueOf(2).equals(productType)) {
            CollageConfigProductEntity collageProductEntity = new CollageConfigProductEntity();
            collageProductEntity.setActiveNo(activeNo);
            collageProductEntity.setStatus(1);
            List list2 = this.collageConfigProductMapper.getList(collageProductEntity);
            for (CollageConfigProductEntity collageConfigProductEntity : list2) {
                BaseJsonVo sr;
                if (Integer.valueOf(4).equals(collageConfigProductEntity.getProductType())) {
                    for (MallProductEntity product : list) {
                        if (!product.getProId().equals(collageConfigProductEntity.getProductId()) || (collageConfigProductVo = this.getProdutct(product)) == null) continue;
                        colloageList.add(collageConfigProductVo);
                    }
                    continue;
                }
                if (!Integer.valueOf(1).equals(collageConfigProductEntity.getProductType()) || !(sr = this.promotionInterface.buildPromotionVO(collageConfigProductEntity.getProductId(), 1, true)).isSuccess()) continue;
                collageConfigProductVo = this.getPromotion((MallPromotionVO)sr.getValue());
                colloageList.add(collageConfigProductVo);
            }
            return colloageList;
        }
        return null;
    }

    private CollageConfigProductVo getProdutct(MallProductEntity product) {
        BigDecimal bigDecimal = new BigDecimal(product.getProPrice());
        if (bigDecimal.doubleValue() > 0.0 && ("\u9178\u5976".equals(product.getProType()) || "\u96f6\u98df".equals(product.getProType()) || "\u5927\u5305\u88c5".equals(product.getProType())) && ("\u96f6\u552e".equals(product.getSoldType()) || "\u96f6\u552e".equals(product.getSoldType()))) {
            CollageConfigProductVo collageConfigProductVo = new CollageConfigProductVo();
            collageConfigProductVo.setProductId(product.getProId());
            collageConfigProductVo.setProductName(product.getProName());
            collageConfigProductVo.setProductType(4);
            collageConfigProductVo.setPicPath(product.getListTemplateFile());
            collageConfigProductVo.setPrice(new BigDecimal(product.getProPrice()));
            collageConfigProductVo.setProSummary(product.getProSummary());
            collageConfigProductVo.setProductUnit(product.getProDw());
            return collageConfigProductVo;
        }
        return null;
    }

    private CollageConfigProductVo getPromotion(MallPromotionVO promotionVO) {
        CollageConfigProductVo collageConfigProductVo = new CollageConfigProductVo();
        collageConfigProductVo.setProductId(promotionVO.getPromotionId());
        collageConfigProductVo.setProductName(promotionVO.getPromotionName());
        collageConfigProductVo.setProductType(1);
        if (promotionVO.getPromotionPic() != null && promotionVO.getPromotionPic().get("picPromotionList") != null && promotionVO.getPromotionPic().get("picPromotionList").get(0) != null) {
            collageConfigProductVo.setPicPath(promotionVO.getPromotionPic().get("picPromotionList").get(0));
        }
        collageConfigProductVo.setPrice(promotionVO.getOriginPrice());
        collageConfigProductVo.setProductUnit(promotionVO.getPromotionUnit());
        collageConfigProductVo.setProSummary("");
        return collageConfigProductVo;
    }

    @Override
    @ReadThroughSingleCache(namespace="CollageService.getAllProductList", expiration=300)
    public List<CollageConfigProductVo> getAllProductList(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) boolean containPic) {
        CollageConfigProductVo collageConfigProductVo;
        List<MallProductEntity> list = this.mallProductInterface.getOnAndShowProductList(platformGroupId, containPic);
        ArrayList<CollageConfigProductVo> colloageList = new ArrayList<CollageConfigProductVo>();
        for (MallProductEntity product : list) {
            if (product.getShowState() != 1 || product.getProState() != 1) continue;
            try {
                Double price = Double.parseDouble(product.getProPrice());
                if (!(price > 0.0)) continue;
                collageConfigProductVo = new CollageConfigProductVo();
                collageConfigProductVo.setProductName(product.getProName());
                collageConfigProductVo.setProductType(4);
                collageConfigProductVo.setProductId(product.getProId());
                colloageList.add(collageConfigProductVo);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        List<MallPromotionVO> promotionList = this.promotionService.getCurrentPromotionList(platformGroupId, false);
        for (MallPromotionVO promotionVO : promotionList) {
            collageConfigProductVo = new CollageConfigProductVo();
            collageConfigProductVo.setProductName(promotionVO.getPromotionName());
            collageConfigProductVo.setProductType(1);
            collageConfigProductVo.setProductId(promotionVO.getPromotionId());
            colloageList.add(collageConfigProductVo);
        }
        return colloageList;
    }

    @Override
    @Transactional
    public BaseJsonVo saveCollage(String bindCode, String inviteId, String items, String customerId) throws UnsupportedEncodingException {
        BaseJsonVo baseJsonVo = this.checkCanJoinCollage(inviteId, customerId, bindCode);
        HashMap resultMap = (HashMap)baseJsonVo.getValue();
        if ((Integer)resultMap.get("status") > 0) {
            return baseJsonVo;
        }
        if (!(items = URLDecoder.decode(items, "utf-8")).startsWith("[")) {
            items = "[" + items + "]";
        }
        List itemVoList = JsonUtils.getListByArray(CollageProductVo.class, (String)items);
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        CollageDetailEntity collageDetailEntity = new CollageDetailEntity();
        CollageEntity collageEntity = new CollageEntity();
        if (StringUtils.isNotEmpty((String)inviteId)) {
            collageEntity = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
            collageDetailEntity.setBindCode(bindCode);
            collageDetailEntity.setCustomerId(customerId);
            collageDetailEntity.setCollageId(inviteId);
            CollageDetailEntity tempCollageDetail = (CollageDetailEntity)this.collageDetailMapper.getSingle(collageDetailEntity);
            if (tempCollageDetail != null) {
                collageDetailEntity.setId(tempCollageDetail.getId());
                this.collageProductMapper.deleteCollageProduct(tempCollageDetail.getId());
            }
        } else {
            CollageConfigEntity config = new CollageConfigEntity();
            config.setActiveNo(activeEntity.getActiveNo());
            config = (CollageConfigEntity)this.collageConfigMapper.getSingle(config);
            if (config != null) {
                collageEntity.setStartingPrice(config.getStartingPrice());
                collageEntity.setActiveNo(activeEntity.getActiveNo());
                collageEntity.setBindCode(bindCode);
                collageEntity.setCreateTime(DateUtils.now());
                collageEntity.setCustomerId(customerId);
                collageEntity.setId(String.valueOf(RandomUtils.generateId()));
                collageEntity.setEndTime(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)86400));
                collageEntity.setStatus(0);
                this.collageMapper.insert(collageEntity);
            } else {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage("\u62fc\u5355\u914d\u7f6e\u4e0d\u6b63\u786e");
                return baseJsonVo;
            }
        }
        if (itemVoList != null && itemVoList.size() >= 1) {
            collageDetailEntity.setActiveNo(activeEntity.getActiveNo());
            collageDetailEntity.setBindCode(bindCode);
            collageDetailEntity.setCustomerId(customerId);
            collageDetailEntity.setCollageId(collageEntity.getId());
            collageDetailEntity.setId(String.valueOf(RandomUtils.generateId()));
            collageDetailEntity.setCutAmout(this.getCollageCutAmout(customerId, inviteId, bindCode));
            collageDetailEntity.setStatus(0);
            collageDetailEntity.setJoinType(StringUtils.isNotEmpty((String)inviteId) ? (collageEntity.getCustomerId().equals(customerId) ? 1 : 2) : 1);
            collageDetailEntity.setCreateTime(DateUtils.now());
            BigDecimal price = new BigDecimal(0);
            ArrayList<CollageProductEntity> list = new ArrayList<CollageProductEntity>();
            for (CollageProductVo collageProduct : itemVoList) {
                CollageProductEntity collageProductEntity = new CollageProductEntity();
                collageProductEntity.setCollageDetailId(collageDetailEntity.getId());
                collageProductEntity.setNum(collageProduct.getNum());
                if (collageProduct.getProductType() == 4) {
                    MallProductEntity productEntity = this.productInterface.getProduct(collageProduct.getProductId());
                    collageProductEntity.setPrice(new BigDecimal(productEntity.getProPrice()));
                }
                if (collageProduct.getProductType() == 1) {
                    BaseJsonVo promotion = this.promotionInterface.buildIndexPromotionVo(collageProduct.getProductId(), customerId);
                    if (promotion.isSuccess()) {
                        MallIndexPromotionVo promotionVO = (MallIndexPromotionVo)promotion.getValue();
                        collageProductEntity.setPrice(promotionVO.getPrice());
                    } else {
                        throw new RuntimeException(promotion.getMessage());
                    }
                }
                collageProductEntity.setProductid(collageProduct.getProductId());
                collageProductEntity.setProductType(collageProduct.getProductType());
                collageProductEntity.setCreateTime(DateUtils.now());
                list.add(collageProductEntity);
                price = price.add(collageProductEntity.getPrice().multiply(new BigDecimal(collageProduct.getNum())));
            }
            this.collageProductMapper.insertCollageProduct(list);
            collageDetailEntity.setPrice(price);
            this.collageDetailMapper.insert(collageDetailEntity);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("inviteId", collageEntity.getId());
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo getCollageList(String inviteId, CustomerDetailVo customerDetailVo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.collageDetailMapper.getCollageList(inviteId);
        CollageEntity collage = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        boolean hasRecord = false;
        String customerId = customerDetailVo.getCustomerId();
        if (list != null && list.size() >= 1) {
            boolean isCollager = customerId.equals(collage.getCustomerId());
            resultMap.put("startingPrice", collage.getStartingPrice());
            boolean canOperate = collage.getStatus() == 0;
            resultMap.put("starter", isCollager ? 1 : 0);
            resultMap.put("status", collage.getStatus());
            resultMap.put("cancelStatus", isCollager ? (StringUtils.isEmpty((String)collage.getOrderMainNo()) ? 1 : 0) : 0);
            BigDecimal total = new BigDecimal(0);
            BigDecimal cutAmout = new BigDecimal(0);
            for (Map<String, Object> map : list) {
                boolean isMe = customerId.equals(map.get("CUSTOMER_ID").toString());
                if (isMe) {
                    hasRecord = true;
                }
                map.put("me", isMe ? 1 : 0);
                map.put("operate_status", canOperate ? (isMe ? 1 : (isCollager ? 2 : 3)) : 3);
                CollageProductEntity collageProduct = new CollageProductEntity();
                collageProduct.setStatus(1);
                collageProduct.setCollageDetailId(map.get("ID").toString());
                List collageProductEntityList = this.collageProductMapper.getList(collageProduct);
                ArrayList productList = new ArrayList();
                ArrayList productMapList = new ArrayList();
                for (CollageProductEntity product : collageProductEntityList) {
                    HashMap<String, Object> productMap = new HashMap<String, Object>();
                    productMap.put("collageDetailId", product.getCollageDetailId());
                    productMap.put("num", product.getNum());
                    productMap.put("price", product.getPrice());
                    productMap.put("productId", product.getProductid());
                    productMap.put("type", product.getProductType());
                    if (product.getProductType() == 4) {
                        MallProductEntity productEntity = this.productInterface.getProduct(product.getProductid());
                        productMap.put("name", productEntity.getProName());
                    }
                    if (product.getProductType() == 1) {
                        MallPromotionEntity productGroupEntity = this.promotionInterface.getPromotion(product.getProductid());
                        productMap.put("name", productGroupEntity.getPromotionName());
                    }
                    productMapList.add(productMap);
                }
                cutAmout = cutAmout.add(new BigDecimal(map.get("CUT_AMOUT").toString()));
                total = total.add(new BigDecimal(map.get("PRICE").toString()));
                map.put("prductList", productMapList);
            }
            Map<String, Object> dissacountMap = this.getCollageDissacount(collage.getBindCode(), list.size());
            BigDecimal discount = (BigDecimal)dissacountMap.get("dissacount");
            discount = discount.divide(new BigDecimal(10));
            this.logger.info("\u62fc\u5355inviteId=" + inviteId + "\u6298\u6263\uff1a" + discount);
            if (dissacountMap.get("status").equals(1)) {
                resultMap.put("nextNum", dissacountMap.get("nextNum"));
                resultMap.put("nextDisscount", dissacountMap.get("nextDisscount"));
                resultMap.put("message", MessageFormat.format("\u5df2\u6253{0}\u6298\uff0c\u6ee1{1}\u4eba\u53ef\u6253{2}\u6298", dissacountMap.get("dissacount"), dissacountMap.get("nextNum"), dissacountMap.get("nextDisscount")));
            } else if (dissacountMap.get("status").equals(2)) {
                resultMap.put("message", MessageFormat.format("\u6ee1{0}\u4eba\u53ef\u6253{1}\u6298", dissacountMap.get("nextNum"), dissacountMap.get("nextDisscount")));
            } else if (dissacountMap.get("status").equals(3)) {
                resultMap.put("message", MessageFormat.format("\u5df2\u6253{0}\u6298", dissacountMap.get("dissacount")));
            } else {
                resultMap.put("message", "");
            }
            total = total.multiply(discount).subtract(cutAmout).setScale(2, 4);
            resultMap.put("total", total);
            resultMap.put("hasRecord", hasRecord);
            if (!hasRecord) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("NICK_NAME", customerDetailVo.getNickName());
                map.put("HEAD_IMAGE_URL", customerDetailVo.getHeadImageUrl());
                map.put("CUSTOMER_ID", customerDetailVo.getCustomerId());
                map.put("me", 1);
                list.add(0, map);
            }
            resultMap.put("list", list);
        }
        return BaseJsonVo.success(resultMap);
    }

    @Override
    public BaseJsonVo getCollageBillList(String inviteId, CustomerDetailVo customerDetailVo) {
        CollageEntity collage = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        BaseJsonVo baseJsonVo = this.getCollageList(inviteId, customerDetailVo);
        Map resultMap = (Map)baseJsonVo.getValue();
        List list = (List)resultMap.get("list");
        BigDecimal allDeliverAmout = collage.getDeliveryAmout();
        BigDecimal total = (BigDecimal)resultMap.get("total");
        for (Map map : list) {
            map.remove("me");
            map.remove("operate_status");
            BigDecimal orderAmout = (BigDecimal)map.get("FACT_PRICE");
            BigDecimal deliverAmout = new BigDecimal(0);
            if (allDeliverAmout.doubleValue() > 0.0) {
                deliverAmout = allDeliverAmout.multiply(orderAmout.divide(total, 2, 4)).setScale(2, 4);
            }
            map.put("deliverAmout", deliverAmout);
            map.put("amout", orderAmout.add(deliverAmout));
        }
        resultMap.put("total", total.add(allDeliverAmout));
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo getCollageBillListByOrder(String orderNo, CustomerDetailVo customerDetailVo) {
        CollageEntity collage = new CollageEntity();
        collage.setOrderMainNo(orderNo);
        collage = (CollageEntity)this.collageMapper.getSingle(collage);
        if (collage != null) {
            return this.getCollageBillList(collage.getId(), customerDetailVo);
        }
        return BaseJsonVo.error((String)"\u62fc\u5355\u8ba2\u5355\u53f7\u4e0d\u6b63\u786e");
    }

    @Override
    public BaseJsonVo clearCollageRecord(String collageDatailId, String customerId, Integer platFormId, String nickName, Integer type) {
        if (type == 1) {
            return this.deleteCollageRecord(collageDatailId, customerId, platFormId, nickName, type);
        }
        if (type == 2) {
            return this.cancelCollage(collageDatailId);
        }
        this.logger.error("\u5220\u9664\u62fc\u5355\u51fa\u9519:collageDatailId={},customerId={},\u7c7b\u578b:{}", new Object[]{collageDatailId, customerId, type});
        return BaseJsonVo.error((String)"\u5220\u9664\u62fc\u5355\u51fa\u9519");
    }

    @Override
    @Transactional
    public BaseJsonVo deleteCollageRecord(String collageDatailId, String customerId, Integer platFormId, String nickName, Integer type) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer deleteStatus = 0;
        CollageDetailEntity collageDetail = new CollageDetailEntity();
        collageDetail.setId(collageDatailId);
        CollageDetailEntity collageDetailEntity = (CollageDetailEntity)this.collageDetailMapper.selectByPrimaryKey((Serializable)((Object)collageDatailId));
        if (Integer.valueOf(2).equals(collageDetailEntity.getJoinType())) {
            if (!customerId.equals(collageDetailEntity.getCustomerId())) {
                String content = MessageFormat.format("\u60a8\u88ab\u3010{0}\u3011\u8e22\u51fa\u62fc\u5355,\u60a8\u4e5f\u53ef\u4ee5\u53d1\u8d77\u62fc\u5355", nickName);
                this.messageService.sendCustomerTextMessage4CustmoerIdAsync(collageDetailEntity.getCustomerId(), platFormId, content, 0);
            }
        } else if (customerId.equals(collageDetailEntity.getCustomerId())) {
            collageDetail = new CollageDetailEntity();
            collageDetail.setCollageId(collageDetailEntity.getCollageId());
            List list = this.collageDetailMapper.getList(collageDetail);
            if (list.size() == 1) {
                this.collageMapper.deleteByPrimaryKey((Serializable)((Object)collageDetailEntity.getCollageId()));
                this.logger.info("\u7528\u6237customerId={}\u62fc\u5355\u660e\u7ec6id={},\u62fc\u5355\u5df2\u5220\u9664", (Object)customerId, (Object)collageDatailId);
                deleteStatus = 1;
            }
        }
        this.collageDetailMapper.deleteByPrimaryKey((Serializable)((Object)collageDatailId));
        this.collageProductMapper.deleteCollageProduct(collageDatailId);
        this.logger.info("\u7528\u6237customerId={}\u62fc\u5355\u660e\u7ec6id={}\u53c2\u4e0e\u62fc\u5355\u5df2\u5220\u9664", (Object)customerId, (Object)collageDatailId);
        map.put("newCollage", deleteStatus);
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo checkCanJoinCollage(String inviteId, String customerId, String bindCode) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        baseJsonVo.setStatus(200);
        resultMap.put("status", 0);
        baseJsonVo.setValue(resultMap);
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null || !this.activeService.checkActiveEnable(activeEntity.getActiveNo()).isSuccess()) {
            resultMap.put("status", 2);
            this.logger.info("\u53c2\u4e0e\u62fc\u5355\u6d3b\u52a8{}\u5df2\u7ed3\u675f,\u6d3b\u52a8bindCode:{}", (Object)inviteId, (Object)bindCode);
            return baseJsonVo;
        }
        if (StringUtils.isNotEmpty((String)inviteId)) {
            CollageEntity resultCollage = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
            if (resultCollage != null && resultCollage.getStatus() >= 1) {
                resultMap.put("status", resultCollage.getStatus());
                this.logger.info("\u53c2\u4e0e\u62fc\u5355\u7528\u6237customerId={}\u62fc\u5355\u5df2\u7ecf\u7ed3\u675f\u3001\u7ed3\u7b97\u3001\u8fc7\u671f\uff0c\u62fc\u5355id={},\u62fc\u5355\u72b6\u6001:{}", new Object[]{customerId, inviteId, resultCollage.getStatus()});
                return baseJsonVo;
            }
            if (resultCollage == null) {
                resultMap.put("status", 6);
                this.logger.info("\u53c2\u4e0e\u62fc\u5355\u7528\u6237customerId={}\u62fc\u5355\u5df2\u7ecf\u5220\u9664\uff0c\u62fc\u5355id={}", (Object)customerId, (Object)inviteId);
                return baseJsonVo;
            }
        }
        CollageDetailEntity queryCollageDetail = new CollageDetailEntity();
        queryCollageDetail.setStatus(0);
        queryCollageDetail.setCustomerId(customerId);
        CollageDetailEntity collageDetail = (CollageDetailEntity)this.collageDetailMapper.getSingle(queryCollageDetail);
        if (collageDetail != null) {
            resultMap.put("status", 4);
            resultMap.put("inviteId", collageDetail.getCollageId());
            resultMap.put("bindCode", collageDetail.getBindCode());
            baseJsonVo.setValue(resultMap);
            this.logger.info("\u53c2\u4e0e\u62fc\u5355\u7528\u6237customerId={}\u6709\u672a\u5b8c\u6210\u7684\u62fc\u5355\uff0c\u62fc\u5355id={}", (Object)customerId, (Object)collageDetail.getCollageId());
            return baseJsonVo;
        }
        CollageEntity queryCollage = new CollageEntity();
        queryCollage.setCustomerId(customerId);
        List collageList = this.collageMapper.getList(queryCollage);
        if (collageList != null && collageList.size() >= 1) {
            for (CollageEntity collageEntity : collageList) {
                if (collageEntity.getStatus() != 1 && collageEntity.getStatus() != 0 || StringUtils.isNotEmpty((String)inviteId) && inviteId.equals(collageEntity.getId()) && collageEntity.getStatus() == 0) continue;
                resultMap.put("status", 4);
                resultMap.put("inviteId", collageEntity.getId());
                resultMap.put("bindCode", collageEntity.getBindCode());
                baseJsonVo.setValue(resultMap);
                this.logger.info("\u53d1\u8d77\u4ebacustomerId={}\u6709\u672a\u5b8c\u6210\u7684\u62fc\u5355\uff0c\u62fc\u5355id={}", (Object)customerId, (Object)collageEntity.getId());
                return baseJsonVo;
            }
        }
        CollageConfigEntity queryCollageConfig = new CollageConfigEntity();
        queryCollageConfig.setActiveNo(activeEntity.getActiveNo());
        queryCollageConfig = (CollageConfigEntity)this.collageConfigMapper.getSingle(queryCollageConfig);
        CollageDetailEntity queryDetail = new CollageDetailEntity();
        queryDetail.setCollageId(inviteId);
        List collageDetailEntityList = this.collageDetailMapper.getList(queryDetail);
        if (queryCollageConfig != null && collageDetailEntityList != null && collageDetailEntityList.size() >= queryCollageConfig.getNumHigh()) {
            resultMap.put("status", 5);
            this.logger.info("\u53d1\u8d77\u4ebacustomerId={},\u62fc\u5355\u6ee1\u5458\u4e86\uff0c\u62fc\u5355id={},\u914d\u7f6e\u6700\u5927\u4eba\u6570:{}\u5df2\u53c2\u4e0e\u62fc\u5355\u4eba\u6570:", new Object[]{customerId, inviteId, queryCollageConfig.getNumHigh(), collageDetailEntityList.size()});
            return baseJsonVo;
        }
        return baseJsonVo;
    }

    @Override
    public BigDecimal getCollageCutAmout(String customerId, String inviteId, String bindCode) {
        int num = this.orderMainInterface.getOrderNum(customerId);
        if (num == 0) {
            if (this.hasCollageRecord(customerId)) {
                ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
                CollageConfigEntity collageConfigEntity = new CollageConfigEntity();
                collageConfigEntity.setActiveNo(activeEntity.getActiveNo());
                CollageConfigEntity configEntity = (CollageConfigEntity)this.collageConfigMapper.getSingle(collageConfigEntity);
                return configEntity.getDiscountType() == 1 ? new BigDecimal(configEntity.getDiscount()) : new BigDecimal(0);
            }
            this.logger.info("\u7528\u6237\u5df2\u7ecf\u53c2\u4e0e\u8fc7\u62fc\u5355:customerId={},\u62fc\u5355inviteId={},\u65e0\u65b0\u4eba\u7acb\u51cf\u4f18\u60e0", (Object)customerId, (Object)inviteId);
        }
        return new BigDecimal(0);
    }

    private boolean hasCollageRecord(String customerId) {
        CollageDetailEntity queryDetail = new CollageDetailEntity();
        queryDetail.setCustomerId(customerId);
        queryDetail.setStatus(1);
        CollageDetailEntity collageDetail = (CollageDetailEntity)this.collageDetailMapper.getSingle(queryDetail);
        return collageDetail == null;
    }

    private Map<String, Object> getCollageDissacount(String bindCode, int num) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        CollageDiscountEntity queryCollageConfig = new CollageDiscountEntity();
        queryCollageConfig.setActiveNo(activeEntity.getActiveNo());
        List discountList = this.collageDiscountMapper.getList(queryCollageConfig);
        BigDecimal discount = new BigDecimal(10);
        if (discountList != null && discountList.size() >= 1) {
            discountList.sort((d1, d2) -> d1.getNum().compareTo(d2.getNum()));
            if (num < ((CollageDiscountEntity)discountList.get(0)).getNum()) {
                map.put("status", 2);
                map.put("nextNum", ((CollageDiscountEntity)discountList.get(0)).getNum());
                map.put("nextDisscount", ((CollageDiscountEntity)discountList.get(0)).getDiscountRate());
            } else if (num >= ((CollageDiscountEntity)discountList.get(discountList.size() - 1)).getNum()) {
                discount = ((CollageDiscountEntity)discountList.get(discountList.size() - 1)).getDiscountRate();
                map.put("num", num);
                map.put("status", 3);
            } else {
                for (int i = 0; i < discountList.size(); ++i) {
                    if (num < ((CollageDiscountEntity)discountList.get(i)).getNum() || num >= ((CollageDiscountEntity)discountList.get(i + 1)).getNum()) continue;
                    discount = ((CollageDiscountEntity)discountList.get(i)).getDiscountRate();
                    map.put("nextNum", ((CollageDiscountEntity)discountList.get(i + 1)).getNum());
                    map.put("nextDisscount", ((CollageDiscountEntity)discountList.get(i + 1)).getDiscountRate());
                    map.put("status", 1);
                    break;
                }
            }
        } else {
            map.put("status", 0);
        }
        map.put("dissacount", discount);
        map.put("num", num);
        return map;
    }

    @Override
    @Transactional
    public BaseJsonVo setCollageBalance(String inviteId, String bindCode) {
        CollageEntity queryCollage = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        if (queryCollage.getStatus() == 1) {
            return BaseJsonVo.success((Object)true);
        }
        CollageDetailEntity collageDetailEntity = new CollageDetailEntity();
        collageDetailEntity.setCollageId(inviteId);
        collageDetailEntity.setStatus(0);
        List list = this.collageDetailMapper.getList(collageDetailEntity);
        int num = list.size();
        Map<String, Object> map = this.getCollageDissacount(bindCode, num);
        BigDecimal discount = (BigDecimal)map.get("dissacount");
        discount = discount.divide(new BigDecimal(10));
        if (discount.intValue() == 1) {
            this.logger.info("\u65e0\u6298\u6263,inviteId=" + inviteId);
        }
        BigDecimal total = new BigDecimal(0);
        BigDecimal cutAmout = new BigDecimal(0);
        for (CollageDetailEntity detail : list) {
            CollageProductEntity queryProduct = new CollageProductEntity();
            queryProduct.setCollageDetailId(detail.getId());
            List productEntityList = this.collageProductMapper.getList(queryProduct);
            total = total.add(detail.getPrice()).add(detail.getCutAmout());
            cutAmout = cutAmout.add(detail.getCutAmout());
            CollageDetailEntity updateCollageDetailEntity = new CollageDetailEntity();
            updateCollageDetailEntity.setId(detail.getId());
            updateCollageDetailEntity.setFactPrice(detail.getPrice().multiply(discount).setScale(2, 4));
            this.collageDetailMapper.updateByPrimaryKeySelective(updateCollageDetailEntity);
            this.logger.info("\u6298\u6263\u8ba1\u7b97\u5b8c\u6210,\u62fc\u5355\u660e\u7ec6id={},\u7528\u6237customerId={}", (Object)detail.getId(), (Object)detail.getCustomerId());
        }
        BigDecimal discountTotal = total;
        if (discount.doubleValue() < 1.0 && discount.doubleValue() > 0.0) {
            discountTotal = total.multiply(discount);
        }
        discountTotal = discountTotal.subtract(cutAmout).setScale(2, 4);
        this.logger.info("\u62fc\u5355\u7ed3\u7b97\u6298\u6263\u4e3a\uff1a{}", (Object)discount);
        this.logger.info("\u62fc\u5355\u7ed3\u7b97\u6298\u540e\u4ef7\u4e3a\uff1a{}", (Object)discountTotal);
        CollageEntity collageEntity = new CollageEntity();
        collageEntity.setId(inviteId);
        collageEntity.setStatus(1);
        collageEntity.setPrice(total);
        collageEntity.setFactPrice(discountTotal);
        collageEntity.setDiscountRate(discount);
        int k = this.collageMapper.updateByPrimaryKeySelective(collageEntity);
        if (k >= 1) {
            this.logger.info("\u62fc\u5355\u8bbe\u7f6e\u4e3a\u5df2\u7ed3\u7b97inviteId={}", (Object)inviteId);
            return BaseJsonVo.success((Object)true);
        }
        this.logger.error("\u62fc\u5355\u7ed3\u7b97\u51fa\u9519inviteId={}", (Object)inviteId);
        return BaseJsonVo.error((String)"\u7ed3\u7b97\u51fa\u9519");
    }

    @Override
    public BaseJsonVo unlockCollage(String customerId, String inviteId, String bindCode) {
        Integer status = 0;
        CollageEntity queryCollage = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        if (queryCollage != null && queryCollage.getStatus() == 1) {
            if (customerId.equals(queryCollage.getCustomerId())) {
                boolean temp;
                CollageEntity collageEntity = new CollageEntity();
                collageEntity.setStatus(0);
                collageEntity.setId(inviteId);
                boolean bl = temp = this.collageMapper.updateByPrimaryKeySelective(collageEntity) >= 1;
                if (temp) {
                    status = 1;
                }
            } else {
                status = 2;
            }
        } else {
            this.logger.info("\u62fc\u5355\u672a\u89e3\u9501,\u62fc\u5355\u72b6\u6001\u4e3a:{}", (Object)queryCollage.getStatus());
        }
        return BaseJsonVo.success((Object)status);
    }

    @Override
    @Async
    public void setCollageOrderNo(String inviteId, String orderNo, BigDecimal freight) {
        boolean temp;
        CollageEntity collageEntity = new CollageEntity();
        collageEntity.setId(inviteId);
        collageEntity.setOrderMainNo(orderNo);
        collageEntity.setDeliveryAmout(freight);
        collageEntity.setEndTime(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)900));
        boolean bl = temp = this.collageMapper.updateByPrimaryKeySelective(collageEntity) >= 1;
        if (temp) {
            this.logger.info("\u56de\u5199\u62fc\u5355\u8ba2\u5355\u53f7\u5b8c\u6210:orderNo={} ", (Object)orderNo, (Object)collageEntity.toString());
        } else {
            this.logger.error("\u56de\u5199\u62fc\u5355{}\u8ba2\u5355\u53f7\u51fa\u9519 ", (Object)collageEntity.toString());
        }
    }

    @Override
    @Transactional
    @Async
    public void setCollageFinish(String orderNo) {
        CollageEntity collageEntity = new CollageEntity();
        collageEntity.setOrderMainNo(orderNo);
        collageEntity = (CollageEntity)this.collageMapper.getSingle(collageEntity);
        if (StringUtils.isNotEmpty((String)collageEntity.getId())) {
            CollageEntity updateCollage = new CollageEntity();
            updateCollage.setId(collageEntity.getId());
            updateCollage.setStatus(2);
            this.collageMapper.updateByPrimaryKeySelective(updateCollage);
            this.logger.info("\u8bbe\u7f6e\u62fc\u5355{}\u5df2\u5b8c\u6210", (Object)orderNo);
            CollageDetailEntity collageDetailEntity = new CollageDetailEntity();
            collageDetailEntity.setStatus(1);
            collageDetailEntity.setCollageId(collageEntity.getId());
            this.collageDetailMapper.updateCollageDetailStatus(collageDetailEntity);
            this.logger.info("\u5df2\u8bbe\u7f6e\u62fc\u5355\u8bb0\u5f55\u4e3a\u5df2\u5b8c\u6210,\u8ba2\u5355\u53f7:{}", (Object)orderNo);
        } else {
            this.logger.warn("\u672a\u77e5\u7684\u62fc\u5355\u8ba2\u5355\u53f7:{}", (Object)orderNo);
        }
    }

    @Override
    public PageInfo getCmsCollageActiveList(PageForm pageForm, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.collageConfigMapper.getCmsCollageList(platformGroupId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    @Transactional
    public BaseJsonVo saveCollageConfig(CollageConfigVo collageConfigVo) {
        this.logger.info(collageConfigVo.toString());
        boolean flag = false;
        CollageConfigEntity collageConfigEntity = new CollageConfigEntity();
        collageConfigEntity.setNumHigh(collageConfigVo.getNumHigh());
        collageConfigEntity.setProductType(collageConfigVo.getProductType());
        collageConfigEntity.setBanner(collageConfigVo.getBanner());
        collageConfigEntity.setDiscount(collageConfigVo.getDiscount());
        collageConfigEntity.setName(collageConfigVo.getName());
        collageConfigEntity.setNumLow(collageConfigVo.getNumLow());
        collageConfigEntity.setStartingPrice(collageConfigVo.getStartingPrice());
        if (StringUtils.isEmpty((String)collageConfigVo.getCollageId())) {
            ActiveEntity activeEntity = new ActiveEntity();
            activeEntity.setPayamount(new BigDecimal(0));
            activeEntity.setActiveName(collageConfigVo.getName() + "\u62fc\u5355");
            activeEntity.setActiveType(20);
            activeEntity.setBeginTime(collageConfigVo.getBeginTime());
            activeEntity.setEndTime(collageConfigVo.getEndTime());
            activeEntity.setCityId(0);
            activeEntity.setCreateTime(DateUtils.now());
            activeEntity.setDeptId(9);
            activeEntity.setInviteNum(0);
            activeEntity.setJoinNum(0);
            activeEntity.setKeywordId(0);
            activeEntity.setPayKeywordId(0);
            activeEntity.setPlatformId(1);
            activeEntity.setStatus(1);
            activeEntity.setTjType(1);
            activeEntity.setUseCoupon(1);
            BaseJsonVo baseJsonVo = this.activeService.saveActive(activeEntity);
            if (!baseJsonVo.isSuccess()) {
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
            }
            collageConfigVo.setActiveNo(((ActiveEntity)baseJsonVo.getValue()).getActiveNo());
            ActiveQrcodeEntity activeQrcodeEntity = new ActiveQrcodeEntity();
            activeQrcodeEntity.setActiveType(1);
            activeQrcodeEntity.setShareMedia("3232559339065810161");
            activeQrcodeEntity.setActiveNo(collageConfigVo.getActiveNo());
            activeQrcodeEntity.setKeywordId(1802);
            activeQrcodeEntity.setQrcodeName(collageConfigVo.getName() + "\u62fc\u5355\u4e8c\u7ef4\u7801");
            activeQrcodeEntity.setGiveShareCount(0);
            activeQrcodeEntity.setQrcodeType(3);
            activeQrcodeEntity.setPayType(1);
            activeQrcodeEntity.setQrcodeClass(2);
            baseJsonVo = this.activeQrcodeService.saveActiveQrcode(activeQrcodeEntity);
            CollageConfigEntity tempCollageConfigEntity = new CollageConfigEntity();
            tempCollageConfigEntity.setActiveNo(collageConfigVo.getActiveNo());
            if (this.collageConfigMapper.existsByEntity(tempCollageConfigEntity) >= 1) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ecf\u7ed1\u5b9a\u62fc\u5355\u4e86\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6d3b\u52a8");
            }
            collageConfigVo.setCollageId(String.valueOf(RandomUtils.generateId()));
            collageConfigEntity.setActiveNo(collageConfigVo.getActiveNo());
            collageConfigEntity.setCreateTime(DateUtils.now());
            collageConfigEntity.setCollageId(collageConfigVo.getCollageId());
            collageConfigEntity.setCollageId(collageConfigVo.getCollageId());
            flag = this.collageConfigMapper.insert(collageConfigEntity) >= 1;
        } else {
            collageConfigEntity.setCollageId(collageConfigVo.getCollageId());
            CollageConfigEntity tempCollageConfigEntity = new CollageConfigEntity();
            tempCollageConfigEntity.setCollageId(collageConfigVo.getCollageId());
            tempCollageConfigEntity = (CollageConfigEntity)this.collageConfigMapper.selectByPrimaryKey((Serializable)((Object)collageConfigVo.getCollageId()));
            if (!collageConfigVo.getActiveNo().equals(tempCollageConfigEntity.getActiveNo())) {
                tempCollageConfigEntity = new CollageConfigEntity();
                tempCollageConfigEntity.setActiveNo(collageConfigVo.getActiveNo());
                if (this.collageConfigMapper.existsByEntity(tempCollageConfigEntity) >= 1) {
                    return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ecf\u7ed1\u5b9a\u62fc\u5355\u4e86\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6d3b\u52a8");
                }
            }
            boolean bl = flag = this.collageConfigMapper.updateByPrimaryKeySelective(collageConfigEntity) >= 1;
            if (flag) {
                ActiveEntity activeEntity = new ActiveEntity();
                activeEntity.setActiveNo(collageConfigVo.getActiveNo());
                activeEntity.setBeginTime(collageConfigVo.getBeginTime());
                activeEntity.setEndTime(collageConfigVo.getEndTime());
                activeEntity.setActiveName(collageConfigVo.getName());
                this.activeService.updateActive(activeEntity);
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo setCollageConfigProduct(CollageConfigEntity configEntity) {
        if (Integer.valueOf(1).equals(configEntity.getProductType())) {
            this.collageConfigMapper.updateByPrimaryKeySelective(configEntity);
            CollageConfigProductEntity collageConfigProductEntity = new CollageConfigProductEntity();
            this.collageConfigProductMapper.deleteByActiveNo(configEntity.getActiveNo());
            return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        this.collageConfigMapper.updateByPrimaryKeySelective(configEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveCollageProductConfig(String productsItems) throws UnsupportedEncodingException {
        List list;
        String items = URLDecoder.decode(productsItems, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        if ((list = JsonUtils.getListByArray(CollageConfigProductEntity.class, (String)items)).size() >= 1) {
            String activeNo = ((CollageConfigProductEntity)list.get(0)).getActiveNo();
            CollageConfigEntity collageEntity = new CollageConfigEntity();
            collageEntity.setActiveNo(activeNo);
            collageEntity = (CollageConfigEntity)this.collageConfigMapper.getSingle(collageEntity);
            if (collageEntity.getProductType() == 1) {
                CollageConfigEntity updateCollageConfig = new CollageConfigEntity();
                updateCollageConfig.setCollageId(collageEntity.getCollageId());
                updateCollageConfig.setProductType(2);
                this.collageConfigMapper.updateByPrimaryKeySelective(updateCollageConfig);
            }
            for (CollageConfigProductEntity collageConfigProductEntity : list) {
                collageConfigProductEntity.setId(String.valueOf(RandomUtils.generateId()));
                collageConfigProductEntity.setStatus(1);
                this.logger.info("\u914d\u7f6e\u7684\u5546\u54c1:{}", (Object)collageConfigProductEntity.toString());
            }
            ActiveEntity active = this.activeService.getActiveEntityByActiveNo(activeNo);
            this.memcachedService.delete("CollageService.getCollageProductList", new String[]{activeNo, String.valueOf(active.getPlatformGroupId())});
            return BaseJsonVo.success((Object)this.collageConfigProductMapper.insertCollageConfigProduct(list));
        }
        return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u914d\u7f6e\u62fc\u5355\u5546\u54c1");
    }

    @Override
    public BaseJsonVo deleteCollageProductConfig(String id) {
        return BaseJsonVo.success((Object)this.collageConfigProductMapper.deleteByPrimaryKey((Serializable)((Object)id)));
    }

    @Override
    public BaseJsonVo saveCollageProductConfig(CollageConfigProductEntity collageConfigProduct) {
        if (StringUtils.isEmpty((String)collageConfigProduct.getId())) {
            collageConfigProduct.setId(String.valueOf(RandomUtils.generateId()));
            int result = this.collageConfigProductMapper.insert(collageConfigProduct);
            return BaseJsonVo.success((Object)result);
        }
        if (Integer.valueOf(2).equals(collageConfigProduct.getStatus())) {
            return BaseJsonVo.success((Object)this.collageConfigProductMapper.updateByPrimaryKeySelective(collageConfigProduct));
        }
        return BaseJsonVo.error((String)"\u914d\u7f6e\u9519\u8bef");
    }

    @Override
    public BaseJsonVo saveCollageDiscountConfig(List<CollageDiscountEntity> list) {
        return null;
    }

    @Override
    public BaseJsonVo saveCollageDiscountConfig(CollageDiscountEntity collageDiscount) {
        if (StringUtils.isEmpty((String)collageDiscount.getId())) {
            CollageDiscountEntity queryCollageDiscount = new CollageDiscountEntity();
            queryCollageDiscount.setNum(collageDiscount.getNum());
            queryCollageDiscount.setActiveNo(collageDiscount.getActiveNo());
            if (this.collageDiscountMapper.existsByEntity(queryCollageDiscount) >= 1) {
                return BaseJsonVo.error((String)MessageFormat.format("\u5df2\u5b58\u5728{0}\u4eba\u6298\u6263", collageDiscount.getNum()));
            }
            collageDiscount.setId(String.valueOf(RandomUtils.generateId()));
            collageDiscount.setCreateTime(DateUtils.now());
            return BaseJsonVo.success((Object)this.collageDiscountMapper.insert(collageDiscount));
        }
        return BaseJsonVo.success((Object)this.collageDiscountMapper.updateByPrimaryKeySelective(collageDiscount));
    }

    @Override
    public BaseJsonVo getCollageDiscountConfigList(String activeNo) {
        CollageDiscountEntity collageDiscountEntity = new CollageDiscountEntity();
        collageDiscountEntity.setActiveNo(activeNo);
        return BaseJsonVo.success((Object)this.collageDiscountMapper.getList(collageDiscountEntity));
    }

    @Override
    public List<CollageConfigProductVo> getCollageProductConfigList(String activeNo) {
        CollageConfigProductEntity collageProductConfig = new CollageConfigProductEntity();
        collageProductConfig.setActiveNo(activeNo);
        List list = this.collageConfigProductMapper.getList(collageProductConfig);
        ArrayList<CollageConfigProductVo> listVo = new ArrayList<CollageConfigProductVo>();
        for (CollageConfigProductEntity productConfig : list) {
            CollageConfigProductVo collageConfigProductVo = new CollageConfigProductVo();
            collageConfigProductVo.setId(productConfig.getId());
            collageConfigProductVo.setProductId(productConfig.getProductId());
            collageConfigProductVo.setProductType(productConfig.getProductType());
            collageConfigProductVo.setActiveNo(productConfig.getActiveNo());
            collageConfigProductVo.setProductName(productConfig.getProductName());
            listVo.add(collageConfigProductVo);
        }
        return listVo;
    }

    @Override
    public BaseJsonVo cancelCollage(String inviteId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer deleteStatus = 1;
        map.put("newCollage", deleteStatus);
        CollageEntity collageEntity = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        if (collageEntity == null) {
            this.logger.info("\u62fc\u5355\u4e0d\u5b58\u5728");
            return BaseJsonVo.success(map);
        }
        if (collageEntity.getStatus() == 2) {
            this.logger.info("\u62fc\u5355\u5df2\u5b8c\u6210\u4e0d\u80fd\u5220\u9664");
            return BaseJsonVo.success(map);
        }
        if (StringUtils.isNotEmpty((String)collageEntity.getOrderMainNo())) {
            this.logger.info("\u62fc\u5355\u8ba2\u5355\u5df2\u63d0\u4ea4\u4e0d\u80fd\u5220\u9664");
            return BaseJsonVo.success(map);
        }
        this.cancelCollage(collageEntity);
        return BaseJsonVo.success(map);
    }

    @Override
    @Transactional
    public void cancelCollage(CollageEntity collageEntity) {
        CollageEntity newCollageEntity;
        Integer platformId = this.activeService.getActiveEntityByActiveNo(collageEntity.getActiveNo()).getPlatformId();
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(collageEntity.getCustomerId(), platformId);
        CollageDetailEntity queryCollageDetail = new CollageDetailEntity();
        queryCollageDetail.setCollageId(collageEntity.getId());
        List list = this.collageDetailMapper.getList(queryCollageDetail);
        if (list != null && list.size() >= 1) {
            for (CollageDetailEntity collageDetailEntity : list) {
                this.deleteCollageRecord(collageDetailEntity.getId(), collageEntity.getCustomerId(), platformId, customerDetailVo.getNickName(), 1);
            }
        }
        if ((newCollageEntity = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)collageEntity.getId()))) != null) {
            this.collageMapper.deleteByPrimaryKey((Serializable)((Object)collageEntity.getId()));
        }
    }

    @Override
    public void setCollageExpired(Date date) {
        CollageEntity collageEntity = new CollageEntity();
        collageEntity.setEndTime(date);
        List<CollageEntity> collageList = this.collageMapper.getExpiredCollageList(collageEntity);
        String content = "\u60a8\u7684\u62fc\u5355\u8d85\u65f6\u88ab\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77";
        if (collageList != null && collageList.size() >= 1) {
            for (CollageEntity collage : collageList) {
                CollageEntity updatCollage = new CollageEntity();
                updatCollage.setStatus(3);
                updatCollage.setId(collage.getId());
                this.collageMapper.updateByPrimaryKeySelective(updatCollage);
                CollageDetailEntity collageDetailEntity = new CollageDetailEntity();
                collageDetailEntity.setStatus(2);
                collageDetailEntity.setCollageId(collage.getId());
                this.collageDetailMapper.updateCollageDetailStatus(collageDetailEntity);
                this.messageService.sendCustomerTextMessage4CustmoerIdAsync(collage.getCustomerId(), this.activeService.getActiveEntityByActiveNo(collage.getActiveNo()).getPlatformId(), content, 0);
            }
        }
    }

    @Override
    public BaseJsonVo deleteCollageDiscountConfig(String id) {
        return BaseJsonVo.success((Object)this.collageDiscountMapper.deleteByPrimaryKey((Serializable)((Object)id)));
    }

    @Override
    public BigDecimal getNewUserCollageOrderReductionVo(String inviteId) {
        BigDecimal reduction = new BigDecimal(0);
        CollageDetailEntity queryCollageDetail = new CollageDetailEntity();
        queryCollageDetail.setCollageId(inviteId);
        List detailEntityList = this.collageDetailMapper.getList(queryCollageDetail);
        if (detailEntityList != null && detailEntityList.size() >= 1) {
            reduction = detailEntityList.stream().map(CollageDetailEntity::getCutAmout).reduce(new BigDecimal(0), (a, b) -> a.add((BigDecimal)b));
        }
        return reduction;
    }

    @Override
    public BigDecimal getDiscountCollageOrderReductionVo(String inviteId) {
        CollageOrderReductionVo collageOrderReductionVo = new CollageOrderReductionVo();
        BigDecimal reduction = new BigDecimal(0);
        collageOrderReductionVo.setDiscount(reduction);
        collageOrderReductionVo.setType("\u65e0\u4f18\u60e0");
        CollageEntity collageEntity = (CollageEntity)this.collageMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        if (collageEntity != null) {
            if (collageEntity.getPrice().equals(collageEntity.getFactPrice())) {
                this.logger.info("\u62fc\u5355:inviteId={},\u65e0\u4f18\u60e0", (Object)inviteId);
            } else {
                collageOrderReductionVo.setReduction(collageEntity.getPrice().subtract(collageEntity.getFactPrice()));
                collageOrderReductionVo.setDiscount(collageEntity.getDiscountRate());
                collageOrderReductionVo.setType("\u62fc\u5355\u6298\u6263");
            }
        } else {
            this.logger.error("\u62fc\u5355\u6298\u6263\u91d1\u989d\u65f6\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5,inviteId={}", (Object)inviteId);
        }
        return collageOrderReductionVo.getReduction();
    }
}

