/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.tempqrcode;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImageMerge {
    @Autowired
    private OssService ossService;

    public String composePic(String bgsrc, String logosrc, String fileName, int x, int y) throws IOException {
        return this.composePic4Nick(bgsrc, logosrc, fileName, x, y, "", 0, 0);
    }

    public String composePic4Nick(String bgsrc, String logosrc, String fileName, int x, int y, String nickName, int xx, int yy) throws IOException {
        BufferedImage bg_src = ImageIO.read(new ByteArrayInputStream((byte[])this.ossService.getFile(bgsrc).get("FileBytes")));
        BufferedImage logo_src = ImageIO.read(new ByteArrayInputStream((byte[])this.ossService.getFile(logosrc).get("FileBytes")));
        int bg_width = ((Image)bg_src).getWidth(null);
        int bg_height = ((Image)bg_src).getHeight(null);
        int logo_width = ((Image)logo_src).getWidth(null);
        int logo_height = ((Image)logo_src).getHeight(null);
        BufferedImage tag = new BufferedImage(bg_width, bg_height, 1);
        Graphics2D g2d = tag.createGraphics();
        g2d.drawImage(bg_src, 0, 0, bg_width, bg_height, null);
        g2d.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g2d.drawImage(logo_src, x, y, logo_width, logo_height, null);
        g2d.setComposite(AlphaComposite.getInstance(3));
        if (!this.containsEmoji(nickName)) {
            Font f = new Font("fangzhengluanting", 1, 27);
            Color mycolor = new Color(108, 171, 122);
            g2d.setColor(mycolor);
            g2d.setFont(f);
            g2d.drawString("@" + nickName, xx, yy);
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
        ImageIO.write((RenderedImage)tag, "jpg", imOut);
        ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
        this.ossService.uploadFile(AliyunOSSDir.POSTER_IMG_STORAGE, fileName, is);
        return this.ossService.getImageResoure(AliyunOSSDir.POSTER_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + fileName);
    }

    public String composePic2(String bgsrc, String logosrc, String fileName, int x, int y, String message, int xx, int yy) throws IOException {
        String[] arr;
        BufferedImage bg_src = ImageIO.read(new ByteArrayInputStream((byte[])this.ossService.getFile(bgsrc).get("FileBytes")));
        BufferedImage logo_src = ImageIO.read(new ByteArrayInputStream((byte[])this.ossService.getFile(logosrc).get("FileBytes")));
        int bg_width = ((Image)bg_src).getWidth(null);
        int bg_height = ((Image)bg_src).getHeight(null);
        int logo_width = ((Image)logo_src).getWidth(null);
        int logo_height = ((Image)logo_src).getHeight(null);
        BufferedImage tag = new BufferedImage(bg_width, bg_height, 1);
        Graphics2D g2d = tag.createGraphics();
        g2d.drawImage(bg_src, 0, 0, bg_width, bg_height, null);
        g2d.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g2d.drawImage(logo_src, x, y, logo_width, logo_height, null);
        g2d.setComposite(AlphaComposite.getInstance(3));
        Font f = new Font("fangzhengluanting", 1, 25);
        Color mycolor = Color.white;
        g2d.setColor(mycolor);
        g2d.setFont(f);
        for (String str : arr = message.replace("\uff0c", ",").split(",")) {
            g2d.drawString(str, xx, yy);
            yy += 40;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
        ImageIO.write((RenderedImage)tag, "png", imOut);
        ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
        this.ossService.uploadFile(AliyunOSSDir.POSTER_IMG_STORAGE, fileName, is);
        return this.ossService.getImageResoure(AliyunOSSDir.POSTER_IMG_STORAGE.getPath() + fileName);
    }

    public String composePic4Url(String bgsrc, String logosrc, String fileName, int x, int y) throws IOException {
        return this.composePic4Base(bgsrc, logosrc, fileName, x, y);
    }

    private String composePic4Base(String bgsrc, String logosrc, String fileName, int x, int y) throws IOException {
        BufferedImage bgfile = ImageIO.read(new ByteArrayInputStream((byte[])this.ossService.getFile(bgsrc).get("FileBytes")));
        BufferedImage logo_src = ImageIO.read(new ByteArrayInputStream((byte[])this.ossService.getFile(logosrc).get("FileBytes")));
        int bg_width = ((Image)bgfile).getWidth(null);
        int bg_height = ((Image)bgfile).getHeight(null);
        int logo_width = ((Image)logo_src).getWidth(null);
        int logo_height = ((Image)logo_src).getHeight(null);
        BufferedImage tag = new BufferedImage(bg_width, bg_height, 1);
        Graphics2D g2d = tag.createGraphics();
        g2d.drawImage(bgfile, 0, 0, bg_width, bg_height, null);
        g2d.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g2d.drawImage(logo_src, x, y, logo_width, logo_height, null);
        g2d.setComposite(AlphaComposite.getInstance(3));
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
        ImageIO.write((RenderedImage)tag, "png", imOut);
        ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
        this.ossService.uploadFile(AliyunOSSDir.POSTER_IMG_STORAGE, fileName, is);
        return AliyunOSSDir.POSTER_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + fileName;
    }

    public String composePic4(String bgsrc, String logosrc, String fileName, int x, int y) throws IOException {
        BufferedImage bg_src = this.getUrlByBufferedImage(bgsrc);
        BufferedImage logo_src = this.getUrlByBufferedImage(logosrc);
        int bg_width = ((Image)bg_src).getWidth(null);
        int bg_height = ((Image)bg_src).getHeight(null);
        int logo_width = ((Image)logo_src).getWidth(null);
        int logo_height = ((Image)logo_src).getHeight(null);
        BufferedImage tag = new BufferedImage(bg_width, bg_height, 1);
        Graphics2D g2d = tag.createGraphics();
        g2d.drawImage(bg_src, 0, 0, bg_width, bg_height, null);
        g2d.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g2d.drawImage(logo_src, x, y, logo_width, logo_height, null);
        g2d.setComposite(AlphaComposite.getInstance(3));
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
        ImageIO.write((RenderedImage)tag, "png", imOut);
        ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
        this.ossService.uploadFile(AliyunOSSDir.POSTER_IMG_STORAGE, fileName, is);
        return this.ossService.getImageResoure(AliyunOSSDir.POSTER_IMG_STORAGE.getPath() + fileName);
    }

    public boolean containsEmoji(String source) {
        int len = source.length();
        boolean isEmoji = false;
        for (int i = 0; i < len; ++i) {
            char ls;
            char hs = source.charAt(i);
            if ('\ud800' <= hs && hs <= '\udbff') {
                int uc;
                if (source.length() <= 1 || 118784 > (uc = (hs - 55296) * 1024 + ((ls = source.charAt(i + 1)) - 56320) + 65536) || uc > 128895) continue;
                return true;
            }
            if ('\u2100' <= hs && hs <= '\u27ff' && hs != '\u263b') {
                return true;
            }
            if ('\u2b05' <= hs && hs <= '\u2b07') {
                return true;
            }
            if ('\u2934' <= hs && hs <= '\u2935') {
                return true;
            }
            if ('\u3297' <= hs && hs <= '\u3299') {
                return true;
            }
            if (hs == '\u00a9' || hs == '\u00ae' || hs == '\u303d' || hs == '\u3030' || hs == '\u2b55' || hs == '\u2b1c' || hs == '\u2b1b' || hs == '\u2b50' || hs == '\u231a') {
                return true;
            }
            if (isEmoji || source.length() <= 1 || i >= source.length() - 1 || (ls = source.charAt(i + 1)) != '\u20e3') continue;
            return true;
        }
        return isEmoji;
    }

    private boolean isEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public BufferedImage scaleByPercentage(BufferedImage inputImage, int newWidth, int newHeight) {
        int type = inputImage.getColorModel().getTransparency();
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        BufferedImage img = new BufferedImage(newWidth, newHeight, type);
        Graphics2D graphics2d = img.createGraphics();
        graphics2d.setRenderingHints(renderingHints);
        graphics2d.drawImage(inputImage, 0, 0, newWidth, newHeight, 0, 0, width, height, null);
        graphics2d.dispose();
        return img;
    }

    public BufferedImage getUrlByBufferedImage(String url) {
        try {
            URL urlObj = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)urlObj.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setConnectTimeout(25000);
            conn.setReadTimeout(25000);
            conn.setRequestMethod("GET");
            conn.addRequestProperty("Accept-Language", "zh-cn");
            conn.addRequestProperty("Content-type", "image/jpeg");
            conn.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727)");
            conn.connect();
            BufferedImage bufImg = ImageIO.read(conn.getInputStream());
            conn.disconnect();
            return bufImg;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public BufferedImage convertCircular(String url) throws IOException {
        BufferedImage bi1 = ImageIO.read(new File(url));
        BufferedImage bi2 = new BufferedImage(bi1.getWidth(), bi1.getHeight(), 1);
        bi2 = new BufferedImage(bi1.getWidth(), bi1.getHeight(), 6);
        Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, bi1.getWidth(), bi1.getHeight());
        Graphics2D g2 = bi2.createGraphics();
        g2.setClip(shape);
        g2.drawImage((Image)bi1, 0, 0, null);
        g2.setBackground(Color.green);
        g2.dispose();
        return bi2;
    }
}

