/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorMapper;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorGroupEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.entity.distribution.DistributorVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributorGroupInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class DistributorService
extends BaseService<DistributorEntity, Integer>
implements DistributorInterface {
    @Resource
    private DistributorMapper distributorMapper;
    @Autowired
    private DistributorGroupInterface distributorGroupInterface;
    @Autowired
    private DistributorRelationInterface distributorRelationInterface;
    @Autowired
    private CustomerInterface customerInterface;

    @Override
    public PageInfo<DistributorVo> getDistributorPageList(int pageNum, int pageSize, DistributorEntity distributorEntity) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        if (StringUtils.isNotEmpty((String)distributorEntity.getDistributorPhone())) {
            distributorEntity.setDistributorPhone(SqlUtils.sqlLike((String)distributorEntity.getDistributorPhone(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isNotEmpty((String)distributorEntity.getDistributorName())) {
            distributorEntity.setDistributorName(SqlUtils.sqlLike((String)distributorEntity.getDistributorName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        this.distributorMapper.getListVo(distributorEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveDistributor(DistributorVo distributorVo) {
        try {
            if (distributorVo.getGroupId() == null) {
                return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
            }
            DistributorGroupEntity groupEntity = (DistributorGroupEntity)this.distributorGroupInterface.selectByPrimaryKey(distributorVo.getGroupId());
            if (groupEntity == null) {
                return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
            }
            if (!StringUtils.checkPhone((String)distributorVo.getDistributorPhone()).booleanValue()) {
                return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e");
            }
            if (StringUtils.isEmpty((String)distributorVo.getRelationUserId())) {
                return BaseJsonVo.error((String)"\u5173\u8054\u5fae\u4fe1\u7528\u6237\u5fc5\u586b");
            }
            if (StringUtils.isEmpty((String)distributorVo.getDistributorName())) {
                return BaseJsonVo.error((String)"\u59d3\u540d\u5fc5\u586b");
            }
            if (this.customerInterface.getCustomer(distributorVo.getRelationUserId()) == null) {
                return BaseJsonVo.error((String)"\u5173\u8054\u5fae\u4fe1\u7528\u6237\u65e0\u6548");
            }
            distributorVo.setGroupName(groupEntity.getGroupName());
            BaseJsonVo jsonVo = this.validateRepeat(distributorVo, "distributorPhone", "\u624b\u673a\u53f7");
            if (!jsonVo.isSuccess()) {
                return jsonVo;
            }
            DistributorEntity distributorEntity = new DistributorEntity();
            BeanUtils.beanCopy((Object)distributorVo, (Object)distributorEntity);
            if (distributorEntity.getId() == null) {
                this.insert(distributorEntity);
            } else {
                this.updateByPrimaryKey(distributorEntity);
            }
            DistributorRelationEntity relationEntity = new DistributorRelationEntity();
            BeanUtils.beanCopy((Object)distributorVo, (Object)relationEntity);
            relationEntity.setDistributorId(distributorEntity.getId());
            jsonVo = this.distributorRelationInterface.saveDistributorRelation(relationEntity);
            if (jsonVo.isSuccess()) {
                return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return jsonVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }
}

