/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.service.cashticket.CashticketCustomerService;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="41_coupon")
public class CouponHandle
implements OrderHandleInterface {
    @Autowired
    private CashticketCustomerService cashticketCustomerService;
    @Autowired
    private PlatFormService platFormService;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        PlatFormAndGroupVo platFormAndGroupVo = this.platFormService.getPlatFormAndGroup(mallMainOrderVo.getPlatFormId());
        int couponCustomerId = 0;
        if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2 && (couponCustomerId = mallMainOrderVo.getOrderCacheVo().getTicketCustomerId()) == 0) {
            mallMainOrderVo.setUseCoupon(false);
            mallMainOrderVo.setCouponAmount(new BigDecimal(0));
            return BaseJsonVo.success((Object)"");
        }
        List<CashticketVo> mallCashticketVos = this.cashticketCustomerService.getEnabledCashticketList((int)platFormAndGroupVo.getPlatformGroupId(), couponCustomerId, mallMainOrderVo.getCustomerId(), mallMainOrderVo.getMallOrderVos());
        if (mallCashticketVos != null && mallCashticketVos.size() > 0) {
            CashticketVo cashticketVo = mallCashticketVos.get(0);
            if (cashticketVo.getEnable() == CashStatusEnum.yijihuo.getValue()) {
                mallMainOrderVo.setUseCoupon(true);
                mallMainOrderVo.setCouponAmount(cashticketVo.getEnableCashticketAmount());
            } else {
                mallMainOrderVo.setUseCoupon(false);
                mallMainOrderVo.setCouponAmount(new BigDecimal(0));
                if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2 && couponCustomerId != 0) {
                    return BaseJsonVo.error((String)("\u4f18\u60e0\u5238" + cashticketVo.getTicketBatchName() + "\u4e0d\u53ef\u7528"));
                }
            }
            BigDecimal orderCouponAmount = PriceUtils.format((BigDecimal)BigDecimal.valueOf(mallMainOrderVo.getMallOrderVos().stream().mapToDouble(c -> c.getCouponAmount().doubleValue()).sum()));
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2 && orderCouponAmount.compareTo(mallMainOrderVo.getCouponAmount()) != 0) {
                return BaseJsonVo.error((String)("\u4f18\u60e0\u5238\u91d1\u989d\u4e0d\u4e00\u81f4\uff1aMain(" + mallMainOrderVo.getCouponAmount() + "),order(" + orderCouponAmount + ")"));
            }
            mallMainOrderVo.setCashticketVos(mallCashticketVos);
        } else {
            mallMainOrderVo.setUseCoupon(false);
            mallMainOrderVo.setCouponAmount(new BigDecimal(0));
            mallMainOrderVo.setCashticketVos(mallCashticketVos);
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2 && couponCustomerId != 0) {
                return BaseJsonVo.error((String)"\u9009\u62e9\u7684\u4f18\u60e0\u5238\u4e0d\u53ef\u7528");
            }
        }
        return BaseJsonVo.success((Object)"");
    }
}

