/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.apiinvoke.mall.AccessTokenInvoke;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinBaseMapper;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseVo;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import com.github.pagehelper.PageHelper;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WeiXinBaseService
extends BaseService
implements WeiXinBaseInterface {
    @Autowired
    private WeiXinBaseMapper weiXinBaseMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallRedisLock redisLock;
    @Autowired
    private RedisService redisService;
    @Autowired
    private AccessTokenInvoke accessTokenInvoke;

    @Override
    @ReadThroughSingleCache(namespace="WeiXinBaseService.getWeiXinBase")
    public WeiXinBaseEntity getWeiXinBase(@ParameterValueKeyProvider Integer id) {
        return (WeiXinBaseEntity)this.weiXinBaseMapper.selectByPrimaryKey(id);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinBaseService.getWeiXinBasefromAppId")
    public WeiXinBaseEntity getWeiXinBasefromAppId(@ParameterValueKeyProvider String appId) {
        return this.weiXinBaseMapper.getAccessToken(appId);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinBaseService.getAccessToken")
    public WeiXinBaseEntity getAccessToken(@ParameterValueKeyProvider String appId) {
        WeiXinBaseEntity weiXinBase = this.getWeiXinBasefromAppId(appId);
        if (weiXinBase != null) {
            if (weiXinBase.getExpired().after(DateUtils.now())) {
                return weiXinBase;
            }
            weiXinBase.setAccessToken(this.getAccessTokenValueByPlatformId(weiXinBase.getPlatformId()));
        }
        return weiXinBase;
    }

    @Override
    public WeiXinBaseEntity getAccessTokenByPlatformId(Integer platformId) {
        WeiXinBaseEntity weiXinBase = this.weiXinBaseMapper.getAccessTokenByPlatformId(platformId);
        if (weiXinBase != null) {
            if (weiXinBase.getExpired().after(DateUtils.now())) {
                return weiXinBase;
            }
            weiXinBase.setAccessToken(this.getAccessTokenValueByPlatformId(platformId));
        }
        return weiXinBase;
    }

    @Override
    public String getAccessTokenValueByPlatformId(Integer platformId) {
        return (String)this.accessTokenInvoke.getAccessTokenValueByPlatformId(platformId).getValue();
    }

    public boolean updateAccessToken(WeiXinBaseEntity weiXinBase) {
        this.removCache(weiXinBase.getWeixinBaseId(), weiXinBase.getAppid(), weiXinBase.getPlatformId());
        return this.weiXinBaseMapper.updateAccessToken(weiXinBase) >= 1;
    }

    @Override
    public WeiXinBaseEntity getWeixinBaseByFlatformId(Integer platformId) {
        return this.getAccessTokenByPlatformId(platformId);
    }

    @Override
    public boolean saveWeiXinBase(WeiXinBaseEntity weiXinBaseEntity) {
        this.removCache(weiXinBaseEntity.getWeixinBaseId(), weiXinBaseEntity.getAppid(), weiXinBaseEntity.getPlatformId());
        if (weiXinBaseEntity.getWeixinBaseId() != null && weiXinBaseEntity.getWeixinBaseId() != 0) {
            return this.weiXinBaseMapper.updateByPrimaryKeySelective(weiXinBaseEntity) >= 1;
        }
        return this.weiXinBaseMapper.insertSelective(weiXinBaseEntity) >= 1;
    }

    @Override
    public List<WeiXinBaseVo> getWeiXinBaseList(Pageable pageable) {
        return PageHelper.startPage((int)pageable.getPageNumber(), (int)pageable.getPageSize()).doSelectPage(() -> this.weiXinBaseMapper.getPageList(new WeiXinBaseEntity()));
    }

    private void removCache(Integer id, String appId, int platformId) {
        this.memcachedService.delete("WeiXinBaseService.getWeiXinBase", String.valueOf(id == null ? 0 : id));
        this.memcachedService.delete("WeiXinBaseService.getWeiXinBasefromAppId", appId);
        this.memcachedService.delete("WeiXinBaseService.getAccessToken", appId);
        this.memcachedService.delete("WeiXinBaseService.getAccessTokenByPlatformId", String.valueOf(platformId));
        this.memcachedService.delete("WeiXinBaseService.getWeixinBaseByFlatformId", String.valueOf(platformId));
    }
}

