/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerRelationEntity;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperAnswerRelationDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgPaperAnswerRelationService
extends BaseService
implements IOrgPaperAnswerRelationService {
    @Autowired
    private IOrgPaperAnswerRelationDomain relationDomain;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgQuestionDomain questionDomain;
    @Autowired
    private IOrgPaperDomain paperDomain;
    @Autowired
    private IOrgPaperAnswerDomain paperAnswerDomain;

    @Override
    public BaseJsonVo savePaperAnswerRelation(Integer questionType, PaperAnswerEntity answerEntity, List<PaperAnswerRelationEntity> relationEntityList) {
        this.logger.info(">>>>>>>>savePaperAnswerRelation  param>>>>>>>questionType={},PaperAnswerEntity={},relationEntityList={}", new Object[]{questionType, JSON.toJSONString((Object)answerEntity), JSON.toJSONString(relationEntityList)});
        PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
        search.setAnswerId(answerEntity.getId());
        List<PaperAnswerRelationEntity> relationEntities = this.relationDomain.getList(search);
        if (this.questionDomain.select(answerEntity.getQuestionId()).getQuestionType() == 11 && relationEntities != null && relationEntities.size() > 0 && !relationEntities.get(0).getRelationUserId().equals(relationEntityList.get(0).getRelationUserId())) {
            PaperEntity paper = this.paperDomain.select(answerEntity.getPaperId());
            paper.setReportStatus(0);
            this.paperDomain.update(paper);
        }
        this.relationDomain.delete(answerEntity.getId());
        int i = 1;
        for (PaperAnswerRelationEntity r : relationEntityList) {
            Optional<PaperAnswerRelationEntity> entity;
            MallUserEntity userEntity;
            r.setSort(i);
            ++i;
            r.setAnswerId(answerEntity.getId());
            r.setQuestionId(answerEntity.getQuestionId());
            QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
            r.setQuestionName(questionEntity.getQuestionName());
            r.setCreateTime(new Date());
            r.setIsnew(1);
            r.setIsAnswer(0);
            if (r.getContent() != null) {
                r.setContent(r.getContent().replaceAll("[\\r]", "<br/>").replace("\n", "<br/>"));
            }
            if ((userEntity = this.userInterface.getMallUser(r.getRelationUserId())) != null) {
                r.setRelationUserName(userEntity.getUserNick());
            }
            if (relationEntities != null && relationEntities.size() > 0 && StringUtils.isNotEmpty((String)r.getRelationUserId()) && (entity = relationEntities.stream().filter(c -> StringUtils.isNotEmpty((String)c.getRelationUserId()) && c.getRelationUserId().equals(r.getRelationUserId())).findFirst()).isPresent()) {
                r.setAnswerContent(entity.get().getAnswerContent());
                r.setAnswerContent1(entity.get().getAnswerContent1());
                r.setAnswerTime(entity.get().getAnswerTime());
                r.setIsAnswer(entity.get().getIsAnswer());
                r.setIsDissent(entity.get().getIsDissent());
            }
            this.relationDomain.insert(r);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveAnswer(String userId, Integer relationId, String content, String content1) {
        PaperAnswerRelationEntity relationEntity = this.relationDomain.select(relationId);
        if (relationEntity == null) {
            return BaseJsonVo.error((String)"\u95ee\u9898\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u56de\u590d");
        }
        if (!userId.equals(relationEntity.getRelationUserId())) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u95ee\u9898\uff0c\u60a8\u65e0\u6743\u56de\u590d");
        }
        if (relationEntity.getIsAnswer() == 1) {
            return BaseJsonVo.error((String)"\u5df2\u7ecf\u56de\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u56de\u590d");
        }
        if (content.trim().isEmpty()) {
            return BaseJsonVo.error((String)"\u56de\u590d\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (content.length() > 5000) {
            return BaseJsonVo.error((String)"\u56de\u590d\u5185\u5bb9\u8d85\u957f");
        }
        PaperAnswerRelationEntity updateEntity = new PaperAnswerRelationEntity();
        updateEntity.setId(relationId);
        updateEntity.setIsAnswer(1);
        updateEntity.setAnswerContent(content);
        updateEntity.setAnswerContent1(content1);
        updateEntity.setAnswerTime(new Date());
        this.relationDomain.update(updateEntity);
        PaperEntity paper = this.paperDomain.select(this.paperAnswerDomain.select(relationEntity.getAnswerId()).getPaperId());
        if (paper.getQuestionClassId() == 12 || paper.getQuestionClassId() == 13) {
            paper.setReportStatus(1);
            this.paperDomain.update(paper);
        }
        return BaseJsonVo.success((Object)"\u56de\u590d\u6210\u529f");
    }

    @Override
    public PaperAnswerRelationEntity getPaperAnswerRelationEntityById(Integer id) {
        return this.relationDomain.select(id);
    }

    @Override
    public BaseJsonVo saveAnswer(Integer id, Integer finished) {
        PaperAnswerRelationEntity updateEntity = new PaperAnswerRelationEntity();
        updateEntity.setId(id);
        updateEntity.setFinished(finished);
        updateEntity.setAnswerTime(DateUtils.now());
        this.relationDomain.update(updateEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void modifyPaperAnswerRelationSort(Integer answerRelationId, Integer questionId, int sort, String userId, String paperId) {
        PaperAnswerEntity paperAnswerEntity = new PaperAnswerEntity();
        paperAnswerEntity.setQuestionId(questionId);
        paperAnswerEntity.setPaperId(paperId);
        List<PaperAnswerEntity> paperAnswerEntityList = this.paperAnswerDomain.queryPaperAnswer(paperAnswerEntity);
        if (paperAnswerEntityList != null && paperAnswerEntityList.size() > 0) {
            PaperAnswerRelationEntity paperAnswerRelationEntity = this.relationDomain.select(answerRelationId);
            if (paperAnswerRelationEntity != null) {
                int oldSort = paperAnswerRelationEntity.getSort();
                int i = oldSort - sort;
                if (i < 0) {
                    this.relationDomain.modifyOtherAnswerRelationSortDown(paperAnswerEntityList.get(0).getId(), sort, oldSort);
                }
                if (i > 0) {
                    this.relationDomain.modifyOtherAnswerRelationSortUp(paperAnswerEntityList.get(0).getId(), sort, oldSort);
                }
            }
            this.relationDomain.modifyAnswerRelationSort(answerRelationId, sort);
        }
    }

    @Override
    public BaseJsonVo modifyPaperAnswerRelationDissent(Integer id, Integer isDissent) {
        boolean flag = this.relationDomain.modifyPaperAnswerRelationDissent(id, isDissent);
        if (flag) {
            return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public BaseJsonVo modityRelationAnswer(Integer id, String userId, Integer isFinishLeader, Integer isFinishEmploye) {
        PaperAnswerRelationEntity relationEntity = this.getPaperAnswerRelationEntityById(id);
        if (relationEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        PaperAnswerEntity answerEntity = this.paperAnswerDomain.select(relationEntity.getAnswerId());
        if (answerEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
        if (questionEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        if (questionEntity.getQuestionClassId() != 9) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        PaperAnswerRelationEntity updateEntity = new PaperAnswerRelationEntity();
        updateEntity.setId(id);
        updateEntity.setIsFinishEmploye(isFinishEmploye);
        updateEntity.setIsFinishLeader(isFinishLeader);
        updateEntity.setAnswerTime(DateUtils.now());
        this.relationDomain.update(updateEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo delPaperAnswerRelation(Integer relationId, String paperId) {
        PaperAnswerRelationEntity paperAnswerRelationEntity = new PaperAnswerRelationEntity();
        paperAnswerRelationEntity.setId(relationId);
        paperAnswerRelationEntity = this.relationDomain.getSingle(paperAnswerRelationEntity);
        PaperAnswerEntity paperAnswerEntity = new PaperAnswerEntity();
        paperAnswerEntity.setPaperId(paperId);
        paperAnswerEntity = this.paperAnswerDomain.getSingle(paperAnswerEntity);
        List relationEntityList = JsonUtils.getListByArray(PaperAnswerRelationEntity.class, (String)paperAnswerEntity.getAnswer());
        Iterator iterator = relationEntityList.iterator();
        while (iterator.hasNext()) {
            PaperAnswerRelationEntity relationEntity = (PaperAnswerRelationEntity)iterator.next();
            if (!paperAnswerRelationEntity.getContent().equals(relationEntity.getContent())) continue;
            iterator.remove();
        }
        paperAnswerEntity.setAnswer(JSON.toJSONString((Object)relationEntityList));
        this.paperAnswerDomain.update(paperAnswerEntity);
        this.relationDomain.delete(relationId);
        return BaseJsonVo.success((Object)"");
    }
}

