/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.result.CodeNameVo;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.OrgQuestionClassTimeoutVO;
import cc.lechun.organization.entity.OrgTypeNumEntity;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerRelationEntity;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PaperPageListVo;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.entity.VoteEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassTimeoutDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.idomain.IOrgVoteDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgPaperService
extends BaseService<PaperEntity, String>
implements IOrgPaperService {
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgPermittedUsersService permittedUsersService;
    @Autowired
    private IOrgQuestionClassDomain classDomain;
    @Autowired
    @Lazy
    private IOrgPaperService paperService;
    @Autowired
    private IOrgQuestionDomain orgQuestionDomain;
    @Autowired
    private IOrgVoteDomain orgVoteService;
    @Autowired
    private IOrgPaperAnswerDomain orgPaperAnswerDomain;
    @Autowired
    IOrgQuestionClassTimeoutDomain timeoutDomain;
    @Autowired
    private IOrgPaperAnswerRelationService relationService;
    private BigDecimal bonuse = new BigDecimal(0);
    private final BigDecimal base = new BigDecimal(50);
    private final BigDecimal facor = new BigDecimal(25);

    @Override
    public BaseJsonVo setWeekAfterWeek(Integer id, String userId, Integer finished) {
        PaperAnswerRelationEntity relationEntity = this.relationService.getPaperAnswerRelationEntityById(id);
        if (relationEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        PaperAnswerEntity answerEntity = this.orgPaperAnswerDomain.select(relationEntity.getAnswerId());
        if (answerEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        QuestionEntity questionEntity = this.orgQuestionDomain.select(answerEntity.getQuestionId());
        if (questionEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        if (questionEntity.getQuestionClassId() != 9) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        if (!this.userInterface.isLeadership(userId, answerEntity.getUserId()).booleanValue()) {
            return BaseJsonVo.error((String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        return this.relationService.saveAnswer(id, finished);
    }

    private Date LocalDateTodate(LocalDate localDate) {
        if (localDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            return date;
        }
        return null;
    }

    @Override
    public BaseJsonVo savePaper(PaperEntity paperEntity) {
        boolean success = false;
        PaperEntity search = new PaperEntity();
        search.setPeriodId(paperEntity.getPeriodId());
        search.setUserId(paperEntity.getUserId());
        search.setQuestionClassId(paperEntity.getQuestionClassId());
        PaperEntity paperExists = this.orgPaperDomain.getSingle(search);
        if (StringUtils.isEmpty((String)paperEntity.getId())) {
            paperEntity.setId(IDGenerate.getUniqueIdStr());
        }
        if (paperExists == null) {
            success = this.orgPaperDomain.insert(paperEntity);
        }
        return success ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo buildPaper() {
        List<QuestionClassEntity> classEntities = this.classDomain.getQuestionClassEntityList(0);
        for (QuestionClassEntity c : classEntities) {
            if (c.getRoleId() == null) continue;
            List<MallUserEntity> userEntities = this.userInterface.getSysUserList4RoleId(c.getRoleId());
            for (MallUserEntity u : userEntities) {
                this.paperService.buildPaper(u.getUserId(), c.getClassId());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo buildPaper(Integer periodId) {
        List<QuestionClassEntity> classEntities = this.classDomain.getQuestionClassEntityList(0);
        for (QuestionClassEntity c : classEntities) {
            if (c.getRoleId() == null) continue;
            List<MallUserEntity> userEntities = this.userInterface.getSysUserList4RoleId(c.getRoleId());
            for (MallUserEntity u : userEntities) {
                try {
                    this.paperService.buildPaper(u.getUserId(), c.getClassId(), periodId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo buildPaper(String userId, Integer classId) {
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId);
        BaseJsonVo<PeriodEntity> periodEntity = this.periodService.currentPeriod(periodType);
        if (periodEntity.getValue() == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)userId) || classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(IDGenerate.getUniqueIdStr());
        paperEntity.setQuestionClassId(classId);
        paperEntity.setPeriodId(((PeriodEntity)periodEntity.getValue()).getId());
        paperEntity.setPeriodName(((PeriodEntity)periodEntity.getValue()).getPeriodDesc());
        paperEntity.setUserId(userId);
        paperEntity.setBonus(new BigDecimal(0));
        paperEntity.setReportStatus(0);
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        if (userEntity != null) {
            paperEntity.setUserName(userEntity.getUserNick());
        }
        paperEntity.setCreateTime(new Date());
        paperEntity.setStatus(0);
        return this.savePaper(paperEntity);
    }

    @Override
    public BaseJsonVo buildPaper(String userId, Integer classId, Integer periodId) {
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(periodId);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)userId) || classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId);
        if (!periodType.equals(periodEntity.getPeriodType())) {
            return BaseJsonVo.error((String)"\u8be5\u62a5\u544a\u7c7b\u578b\u548c\u671f\u6b21\u7c7b\u578b\u4e0d\u5bf9\u5e94");
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(IDGenerate.getUniqueIdStr());
        paperEntity.setQuestionClassId(classId);
        paperEntity.setPeriodId(periodEntity.getId());
        paperEntity.setPeriodName(periodEntity.getPeriodDesc());
        paperEntity.setUserId(userId);
        paperEntity.setBonus(new BigDecimal(0));
        paperEntity.setReportStatus(0);
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        if (userEntity != null) {
            paperEntity.setUserName(userEntity.getUserNick());
        }
        paperEntity.setCreateTime(new Date());
        paperEntity.setStatus(0);
        return this.savePaper(paperEntity);
    }

    @Override
    public BaseJsonVo getPaperPageList(PageForm pageForm, PaperEntity paperEntity, String userId) {
        List<MallUserEntity> userEntities;
        QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(paperEntity.getQuestionClassId());
        if (questionClassEntity != null && (userEntities = this.userInterface.getSysUserList4RoleId(questionClassEntity.getRoleId())).stream().filter(c -> c.getUserId().equals(userId)).count() > 0L) {
            this.buildPaper(userId, paperEntity.getQuestionClassId());
        }
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        Set<String> users1 = null;
        users.add(userId);
        if (Integer.valueOf(10).equals(paperEntity.getQuestionClassId()) && (users1 = this.userInterface.getFinancialSubordinate(userId)) != null && users1.size() > 0) {
            users.addAll(users1);
        }
        PageInfo pageInfo = this.orgPaperDomain.getPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), paperEntity, users, userId);
        List vo = pageInfo.getList();
        for (PaperPageListVo v : vo) {
            this.getStatus(paperEntity, userId, v, users1);
        }
        this.logger.info("----pagelist forEach end");
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public BaseJsonVo<OrgQuestionClassTimeoutVO> isEdit(PaperEntity paperEntity, String userId, Set<String> users1) {
        BaseJsonVo<OrgQuestionClassTimeoutVO> baseJsonVo = this.timeoutDomain.isEdit(paperEntity, userId, 1);
        if (baseJsonVo.isSuccess()) {
            if (Integer.valueOf(10).equals(paperEntity.getQuestionClassId())) {
                if (users1 != null && users1.contains(paperEntity.getUserId())) {
                    return baseJsonVo;
                }
                if (userId.equals(paperEntity.getUserId())) {
                    return baseJsonVo;
                }
            } else if (userId.equals(paperEntity.getUserId())) {
                return baseJsonVo;
            }
        }
        BaseJsonVo error = BaseJsonVo.error();
        error.setValue(baseJsonVo.getValue());
        return error;
    }

    public boolean isLeaderEdit(PaperEntity paperEntity, String userId) {
        return this.timeoutDomain.isEdit(paperEntity, userId, 2).isSuccess();
    }

    public boolean isDissentEdit(PaperEntity paperEntity, String userId) {
        return this.timeoutDomain.isEdit(paperEntity, userId, 3).isSuccess() && userId.equals(paperEntity.getUserId());
    }

    private boolean isVote(PaperEntity paperEntity, String userId) {
        return !userId.equals(paperEntity.getUserId());
    }

    @Override
    public BaseJsonVo getPublicPapers(PageForm pageForm, PaperEntity paperEntity, String userId) {
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        users.add(userId);
        PageInfo<Map<String, Object>> pageInfo = this.orgPaperDomain.getPublicPages(pageForm.getCurrentPage(), pageForm.getPageSize(), paperEntity, users, userId);
        HashSet<String> paperIds = new HashSet<String>();
        pageInfo.getList().forEach(vo -> paperIds.add((String)vo.get("paperId")));
        this.logger.info("*****" + JsonUtils.toJson(paperIds, (boolean)false));
        QuestionEntity param = new QuestionEntity();
        param.setQuestionClassId(paperEntity.getQuestionClassId());
        param.setIsPublicColumn(1);
        List<QuestionEntity> publicQuestions = this.orgQuestionDomain.getList(param);
        ArrayList<String> publicColumns = new ArrayList<String>();
        publicColumns.add("\u8bbf\u8c08\u4eba");
        publicColumns.add("\u8bbf\u8c08\u65f6\u95f4");
        publicColumns.add("\u83b7\u5f97\u8d5e\u6570");
        int from = 3;
        for (QuestionEntity entity : publicQuestions) {
            publicColumns.add(from - 1, entity.getQuestionName());
            if (paperIds.size() > 0) {
                List<PaperAnswerEntity> paperAnswers = this.orgPaperAnswerDomain.findPublicAnswers(paperIds, entity.getId());
                for (PaperAnswerEntity answerEntity : paperAnswers) {
                    Optional<Map> map = pageInfo.getList().stream().filter(paper -> paper.get("paperId").equals(answerEntity.getPaperId())).findAny();
                    if (!map.isPresent()) continue;
                    String content = answerEntity.getAnswer();
                    if ("0001".equals(answerEntity.getAnswer())) {
                        content = "\u5185\u90e8\u7528\u6237";
                    }
                    if ("0002".equals(answerEntity.getAnswer())) {
                        content = "\u6d88\u8d39\u8005";
                    }
                    map.get().put(from == 3 ? "customerType" : "customerPic", content);
                    map.get().put("createTime", answerEntity.getCreateTime());
                }
            }
            ++from;
        }
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        map.put("columns", publicColumns);
        map.put("data", (ArrayList<Object>)pageInfo);
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo modityPaperStatus(PaperEntity paperEntity, MallUserEntity userEntity) {
        String userId = this.orgPaperDomain.select(paperEntity.getId()).getUserId();
        if (!this.userInterface.isLeadership(userEntity.getUserId(), userId).booleanValue()) {
            return BaseJsonVo.error((String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        this.orgPaperDomain.update(paperEntity);
        return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    private void getStatus(PaperEntity paperEntity, String userId, PaperPageListVo c, Set<String> users1) {
        if (c.getReportStatus() == 3) {
            c.setReportStatus(1);
        }
        if (c.getStatus() == null || c.getStatus() == 0) {
            c.setStatus(0);
            c.setStatusName("\u672a\u586b\u5199");
            c.setIsVote(0);
            c.setCommit("");
            c.setVoteNum(0);
        }
        this.logger.info("getStatus.isEdit.begin");
        BaseJsonVo<OrgQuestionClassTimeoutVO> timeoutVOBaseJsonVo = this.isEdit(c, userId, users1);
        this.logger.info("getStatus.isEdit.end");
        OrgQuestionClassTimeoutVO timeoutVO = (OrgQuestionClassTimeoutVO)timeoutVOBaseJsonVo.getValue();
        if (timeoutVO != null) {
            Date s = timeoutVO.getStartTime();
            Date e = timeoutVO.getEndTime();
            c.setStartEditTime(s == null ? "" : DateUtils.formatDate((Date)s, (String)"yyyy-MM-dd HH:mm:ss"));
            c.setEndEditTime(e == null ? "" : DateUtils.formatDate((Date)e, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        c.setIsEdit(timeoutVOBaseJsonVo.isSuccess() ? 1 : 0);
        c.setIsLeaderEdit(this.isLeaderEdit(c, userId) ? 1 : 0);
        c.setIsDissentEdit(this.isDissentEdit(c, userId) ? 1 : 0);
        c.setIsLeader(0);
        if (users1 != null && users1.contains(c.getUserId())) {
            if (userId.equals(c.getUserId())) {
                c.setIsLeader(5);
            } else if (this.userInterface.isLeadershipRelationNew(userId, c.getUserId()).booleanValue()) {
                c.setIsLeader(6);
            } else {
                c.setIsLeader(4);
            }
        } else if (this.userInterface.isLeadershipRelationNew(userId, c.getUserId()).booleanValue()) {
            c.setIsLeader(2);
        } else if (this.userInterface.isLeadership(userId, c.getUserId()).booleanValue() && !userId.equals(c.getUserId())) {
            c.setIsLeader(1);
        } else if (!userId.equals(c.getUserId())) {
            c.setIsLeader(3);
        }
        this.logger.info("getStatus.isLeadershipRelation.end");
        if (!userId.equals(c.getUserId())) {
            if (c.getStatus() == 1) {
                c.setStatusName("\u5df2\u586b\u5199");
                VoteEntity queryVote = new VoteEntity();
                queryVote.setVoteUserId(userId);
                queryVote.setPeriodId(paperEntity.getPeriodId());
                queryVote.setQuestionClassId(paperEntity.getQuestionClassId());
                queryVote.setUserId(c.getUserId());
                queryVote.setVoteType(1);
                VoteEntity voteEntity = this.orgVoteService.getVoteEntity(queryVote);
                if (voteEntity != null) {
                    c.setIsVote(2);
                    c.setVoteNum(1);
                    c.setCommit(StringUtils.isNotEmpty((String)voteEntity.getCommit()) ? voteEntity.getCommit() : "\u672a\u8bc4\u8bba");
                } else {
                    BaseJsonVo<OrgQuestionClassTimeoutVO> baseJsonVo = this.timeoutDomain.isEdit(paperEntity, paperEntity.getUserId(), 2);
                    OrgQuestionClassTimeoutVO timeoutVO2 = (OrgQuestionClassTimeoutVO)timeoutVOBaseJsonVo.getValue();
                    boolean flag = false;
                    if (timeoutVO2 != null) {
                        Date e = timeoutVO2.getEndTime();
                        this.logger.info("\u5ba1\u6279\u7ed3\u675f\u65f6\u95f4:{}", (Object)timeoutVO2.getEndTime());
                        if (e != null && e.after(DateUtils.now())) {
                            flag = true;
                        }
                    } else {
                        this.logger.info("\u672a\u914d\u7f6e\u5ba1\u6279\u65f6\u95f4,\u53d6\u9ed8\u8ba4\u7684");
                        flag = this.periodService.checkCurrentPeriodOrLastPeriod(paperEntity.getPeriodId());
                    }
                    c.setIsVote(flag ? 1 : 0);
                    c.setCommit("");
                    c.setVoteNum(0);
                }
            } else {
                c.setIsVote(0);
            }
        } else {
            if (c.getStatus() == 1) {
                c.setStatusName("\u5df2\u586b\u5199");
            }
            c.setIsVote(0);
        }
    }

    @Override
    public List<String> getThankTwiceThisMonth(String userId) {
        String monthStart = DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM") + "-01 00:00:00";
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.now());
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        String monthEnd = DateUtils.formatDate((Date)cal.getTime(), (String)"yyyy-MM-dd") + " 00:00:00";
        List<String> thankTwiceThisMonth = this.orgPaperAnswerDomain.getThankTwiceThisMonth(userId, monthStart, monthEnd);
        return thankTwiceThisMonth;
    }

    @Override
    public List<PaperEntity> getPaperByPeriodId(List<Integer> periodIdList, String userId, Integer questionClassId) {
        return this.orgPaperDomain.getPaperByPeriodId(periodIdList, userId, questionClassId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfo(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.orgPaperDomain.getPaperNumInfo(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByWeek(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.orgPaperDomain.getPaperNumInfoByWeek(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByMonth(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.orgPaperDomain.getPaperNumInfoByMonth(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByStatus(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.orgPaperDomain.getPaperNumInfoByStatus(periodIdList, questionClassId, userId);
    }

    @Override
    public BaseJsonVo modityWeekAfterWeek(Integer id, String userId, Integer isFinishLeader, Integer isFinishEmploye) {
        return this.relationService.modityRelationAnswer(id, userId, isFinishLeader, isFinishEmploye);
    }

    @Override
    public List<LinkedHashMap<String, String>> getExportDataKpi(PaperEntity paperEntity) {
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(paperEntity.getUserId());
        users.add(paperEntity.getUserId());
        Set<String> users1 = this.userInterface.getFinancialSubordinate(paperEntity.getUserId());
        if (users1 != null) {
            users.addAll(users1);
        }
        List<LinkedHashMap<String, String>> lst = this.orgPaperDomain.getExportDataKpi(paperEntity.getPeriodId(), paperEntity.getQuestionClassId(), users);
        return lst;
    }

    @Override
    public List<LinkedHashMap<String, String>> getExportData(PaperEntity paperEntity) {
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(paperEntity.getUserId());
        users.add(paperEntity.getUserId());
        List<LinkedHashMap<String, String>> lst = this.orgPaperDomain.getExportData(paperEntity.getPeriodId(), paperEntity.getQuestionClassId(), users);
        HashedMap listMap = new HashedMap();
        int i = 0;
        for (LinkedHashMap<String, String> m : lst) {
            for (String k : m.keySet()) {
                Optional<CodeNameVo> optional;
                List codeNameVos1;
                QuestionEntity questionEntity;
                if (k.indexOf("#") < 0) continue;
                Integer id = Integer.valueOf(k.split("#")[0]);
                if (i == 0 && (questionEntity = this.orgQuestionDomain.select(id)) != null) {
                    List codeNameVos;
                    if (questionEntity.getQuestionType() == 2 && (codeNameVos = JsonUtils.getListByArray(CodeNameVo.class, (String)questionEntity.getQuestionOption())) != null) {
                        listMap.put(questionEntity.getId(), codeNameVos);
                    }
                    if (questionEntity.getQuestionType() == 9) {
                        listMap.put(questionEntity.getId(), questionEntity.getId());
                    }
                }
                if (listMap.get(id) instanceof List && (codeNameVos1 = (List)listMap.get(id)) != null && codeNameVos1.size() > 0 && (optional = codeNameVos1.stream().filter(c -> c.getCode().equals(m.get(k))).findFirst()).isPresent()) {
                    m.put(k, optional.get().getName());
                }
                if (!(listMap.get(id) instanceof Integer) || (Integer)listMap.get(id) != 42) continue;
                this.logger.info("codename:9");
                codeNameVos1 = JsonUtils.getListByArray(CodeNameVo.class, (String)m.get(k));
                this.logger.info("codename1:" + (codeNameVos1 == null ? "0" : JsonUtils.toJson((Object)codeNameVos1, (boolean)false)));
                if (codeNameVos1 == null) continue;
                Object[] os = codeNameVos1.stream().filter(c -> c.getCheck() == 1).map(c -> c.getName()).toArray();
                this.logger.info("codename2:" + JsonUtils.toJson((Object)os, (boolean)false));
                if (os == null) continue;
                StringBuilder sb = new StringBuilder();
                for (Object o : os) {
                    sb.append(o.toString());
                    sb.append(",");
                }
                m.put(k, sb.toString());
            }
            ++i;
        }
        return lst;
    }
}

