/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.enums.organization.OrgTypeNameEnum;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.dao.OrgTypeNumMapper;
import cc.lechun.organization.entity.OrgTypeNumEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IOrgVoteOperateService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.OrgTypeNumInterface;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTypeNumService
extends BaseService<OrgTypeNumEntity, Integer>
implements OrgTypeNumInterface {
    @Autowired
    private IPeriodService iPeriodService;
    @Autowired
    private IOrgPaperService iOrgPaperService;
    @Autowired
    private IOrgVoteOperateService iOrgVoteOperateService;
    @Autowired
    private SysUserInterface sysUserInterface;
    @Autowired
    private OrgTypeNumMapper orgTypeNumMapper;

    @Override
    public void saveOrgTypeNum(Boolean isCurrentPeriod) {
        Date date = new Date();
        BaseJsonVo<PeriodEntity> baseJsonVo = this.iPeriodService.getLastPeriodByType(2);
        if (isCurrentPeriod.booleanValue()) {
            baseJsonVo = this.iPeriodService.currentPeriod(2);
        }
        this.logger.info("+++++++++++++++++++++++++OrgTypeNumService=============baseJsonVo={}", (Object)JSON.toJSONString(baseJsonVo));
        if (baseJsonVo.isSuccess()) {
            PeriodEntity periodEntity = (PeriodEntity)baseJsonVo.getValue();
            this.getTypeNumInfo(periodEntity);
        }
    }

    public List<OrgTypeNumEntity> getTypeNumInfo(PeriodEntity periodEntity) {
        List<Object> orgTypeNumEntityList = new ArrayList();
        List<MallUserEntity> mallUserEntityList = this.sysUserInterface.getSysUserListByStatus();
        List<PeriodEntity> periodEntityVoList = this.iPeriodService.getPeriodInfoByDate(4, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        this.logger.info("=========periodEntityVoList={}", (Object)JSON.toJSONString(periodEntityVoList));
        if (periodEntityVoList != null && periodEntityVoList.size() > 0) {
            ArrayList<Integer> periodIdList = new ArrayList<Integer>();
            for (PeriodEntity periodEntity2 : periodEntityVoList) {
                periodIdList.add(periodEntity2.getId());
            }
            for (MallUserEntity mallUserEntity : mallUserEntityList) {
                orgTypeNumEntityList = this.iOrgPaperService.getPaperNumInfo(periodIdList, 11, mallUserEntity.getUserId());
                this.logger.info("=========orgTypeNumEntityList={}", (Object)JSON.toJSONString(orgTypeNumEntityList));
                if (orgTypeNumEntityList != null && orgTypeNumEntityList.size() > 0) {
                    for (OrgTypeNumEntity orgTypeNumEntity : orgTypeNumEntityList) {
                        orgTypeNumEntity.setOrgType(OrgTypeNameEnum.day_summary.getValue());
                        orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.day_summary.getName());
                        orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                        orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                        orgTypeNumEntity.setCreateTime(new Date());
                    }
                } else {
                    OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                    orgTypeNumEntity.setTypeNum(0);
                    orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                    orgTypeNumEntity.setOrgType(OrgTypeNameEnum.day_summary.getValue());
                    orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.day_summary.getName());
                    orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                    orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                    orgTypeNumEntity.setCreateTime(new Date());
                    orgTypeNumEntityList.add(orgTypeNumEntity);
                }
                OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                orgTypeNumEntity.setOrgType(OrgTypeNameEnum.day_summary.getValue());
                int n = this.orgTypeNumMapper.deleteOrgTypeNumInfo(orgTypeNumEntity);
                if (n < 0) continue;
                this.batchInsert(orgTypeNumEntityList);
            }
        }
        List<PeriodEntity> periodEntityVoList2 = this.iPeriodService.getPeriodInfoByDate(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        this.logger.info("=========periodEntityVoList2={}", (Object)JSON.toJSONString(periodEntityVoList2));
        if (periodEntityVoList2 != null && periodEntityVoList2.size() > 0) {
            ArrayList<Integer> periodIdList = new ArrayList<Integer>();
            for (PeriodEntity periodEntity3 : periodEntityVoList2) {
                periodIdList.add(periodEntity3.getId());
            }
            for (MallUserEntity mallUserEntity : mallUserEntityList) {
                orgTypeNumEntityList = this.iOrgPaperService.getPaperNumInfoByWeek(periodIdList, 3, mallUserEntity.getUserId());
                if (orgTypeNumEntityList != null && orgTypeNumEntityList.size() > 0) {
                    for (OrgTypeNumEntity orgTypeNumEntity : orgTypeNumEntityList) {
                        orgTypeNumEntity.setOrgType(OrgTypeNameEnum.week_review.getValue());
                        orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.week_review.getName());
                        orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                        orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                        orgTypeNumEntity.setCreateTime(new Date());
                    }
                } else {
                    OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                    orgTypeNumEntity.setTypeNum(0);
                    orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                    orgTypeNumEntity.setOrgType(OrgTypeNameEnum.week_review.getValue());
                    orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.week_review.getName());
                    orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                    orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                    orgTypeNumEntity.setCreateTime(new Date());
                    orgTypeNumEntityList.add(orgTypeNumEntity);
                }
                OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                orgTypeNumEntity.setOrgType(OrgTypeNameEnum.week_review.getValue());
                int n = this.orgTypeNumMapper.deleteOrgTypeNumInfo(orgTypeNumEntity);
                if (n < 0) continue;
                this.batchInsert(orgTypeNumEntityList);
            }
        }
        List<PeriodEntity> periodEntityVoList3 = this.iPeriodService.getPeriodInfoByDate(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        this.logger.info("=========periodEntityVoList3={}", (Object)JSON.toJSONString(periodEntityVoList3));
        if (periodEntityVoList3 != null && periodEntityVoList3.size() > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PeriodEntity periodEntity4 : periodEntityVoList3) {
                arrayList.add(periodEntity4.getId());
            }
            for (MallUserEntity mallUserEntity : mallUserEntityList) {
                orgTypeNumEntityList = this.iOrgPaperService.getPaperNumInfoByWeek(arrayList, 9, mallUserEntity.getUserId());
                if (orgTypeNumEntityList != null && orgTypeNumEntityList.size() > 0) {
                    for (OrgTypeNumEntity orgTypeNumEntity : orgTypeNumEntityList) {
                        orgTypeNumEntity.setOrgType(OrgTypeNameEnum.week_finsh.getValue());
                        orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.week_finsh.getName());
                        orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                        orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                        orgTypeNumEntity.setCreateTime(new Date());
                    }
                } else {
                    OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                    orgTypeNumEntity.setTypeNum(0);
                    orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                    orgTypeNumEntity.setOrgType(OrgTypeNameEnum.week_finsh.getValue());
                    orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.week_finsh.getName());
                    orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                    orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                    orgTypeNumEntity.setCreateTime(new Date());
                    orgTypeNumEntityList.add(orgTypeNumEntity);
                }
                OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                orgTypeNumEntity.setOrgType(OrgTypeNameEnum.week_finsh.getValue());
                int n = this.orgTypeNumMapper.deleteOrgTypeNumInfo(orgTypeNumEntity);
                if (n < 0) continue;
                this.batchInsert(orgTypeNumEntityList);
            }
        }
        List<PeriodEntity> list = this.iPeriodService.getPeriodInfoByDate(1, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        this.logger.info("=========periodEntityVoList4={}", (Object)JSON.toJSONString(list));
        if (list != null && list.size() > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PeriodEntity periodEntity5 : list) {
                arrayList.add(periodEntity5.getId());
            }
            for (MallUserEntity mallUserEntity : mallUserEntityList) {
                orgTypeNumEntityList = this.iOrgPaperService.getPaperNumInfoByMonth(arrayList, 8, mallUserEntity.getUserId());
                if (orgTypeNumEntityList != null && orgTypeNumEntityList.size() > 0) {
                    for (OrgTypeNumEntity orgTypeNumEntity : orgTypeNumEntityList) {
                        orgTypeNumEntity.setOrgType(OrgTypeNameEnum.month_review.getValue());
                        orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.month_review.getName());
                        orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                        orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                        orgTypeNumEntity.setCreateTime(new Date());
                    }
                } else {
                    OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                    orgTypeNumEntity.setTypeNum(0);
                    orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                    orgTypeNumEntity.setOrgType(OrgTypeNameEnum.month_review.getValue());
                    orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.month_review.getName());
                    orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                    orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                    orgTypeNumEntity.setCreateTime(new Date());
                    orgTypeNumEntityList.add(orgTypeNumEntity);
                }
                OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                orgTypeNumEntity.setOrgType(OrgTypeNameEnum.month_review.getValue());
                int n = this.orgTypeNumMapper.deleteOrgTypeNumInfo(orgTypeNumEntity);
                if (n < 0) continue;
                this.batchInsert(orgTypeNumEntityList);
            }
        }
        List<PeriodEntity> list2 = this.iPeriodService.getPeriodInfoByDate(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        this.logger.info("=========periodEntityVoList5={}", (Object)JSON.toJSONString(list2));
        if (list2 != null && list2.size() > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PeriodEntity periodEntity6 : list2) {
                arrayList.add(periodEntity6.getId());
            }
            for (MallUserEntity mallUserEntity : mallUserEntityList) {
                orgTypeNumEntityList = this.iOrgPaperService.getPaperNumInfoByStatus(arrayList, 1, mallUserEntity.getUserId());
                if (orgTypeNumEntityList != null && orgTypeNumEntityList.size() > 0) {
                    for (OrgTypeNumEntity orgTypeNumEntity : orgTypeNumEntityList) {
                        orgTypeNumEntity.setOrgType(OrgTypeNameEnum.user_interview.getValue());
                        orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.user_interview.getName());
                        orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                        orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                        orgTypeNumEntity.setCreateTime(new Date());
                    }
                } else {
                    OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                    orgTypeNumEntity.setTypeNum(0);
                    orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                    orgTypeNumEntity.setOrgType(OrgTypeNameEnum.user_interview.getValue());
                    orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.user_interview.getName());
                    orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                    orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                    orgTypeNumEntity.setCreateTime(new Date());
                    orgTypeNumEntityList.add(orgTypeNumEntity);
                }
                OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                orgTypeNumEntity.setOrgType(OrgTypeNameEnum.user_interview.getValue());
                int n = this.orgTypeNumMapper.deleteOrgTypeNumInfo(orgTypeNumEntity);
                if (n < 0) continue;
                this.batchInsert(orgTypeNumEntityList);
            }
        }
        List<PeriodEntity> list3 = this.iPeriodService.getPeriodInfoByDate(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        this.logger.info("=========periodEntityVoList6={}", (Object)JSON.toJSONString(list3));
        if (list3 != null && list3.size() > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PeriodEntity periodEntity7 : list3) {
                arrayList.add(periodEntity7.getId());
            }
            for (MallUserEntity mallUserEntity : mallUserEntityList) {
                orgTypeNumEntityList = this.iOrgPaperService.getPaperNumInfoByStatus(arrayList, 2, mallUserEntity.getUserId());
                if (orgTypeNumEntityList != null && orgTypeNumEntityList.size() > 0) {
                    for (OrgTypeNumEntity orgTypeNumEntity : orgTypeNumEntityList) {
                        orgTypeNumEntity.setOrgType(OrgTypeNameEnum.study_share.getValue());
                        orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.study_share.getName());
                        orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                        orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                        orgTypeNumEntity.setCreateTime(new Date());
                    }
                } else {
                    OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                    orgTypeNumEntity.setTypeNum(0);
                    orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                    orgTypeNumEntity.setOrgType(OrgTypeNameEnum.study_share.getValue());
                    orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.study_share.getName());
                    orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                    orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                    orgTypeNumEntity.setCreateTime(new Date());
                    orgTypeNumEntityList.add(orgTypeNumEntity);
                }
                OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                orgTypeNumEntity.setOrgType(OrgTypeNameEnum.study_share.getValue());
                int n = this.orgTypeNumMapper.deleteOrgTypeNumInfo(orgTypeNumEntity);
                if (n < 0) continue;
                this.batchInsert(orgTypeNumEntityList);
            }
        }
        List<PeriodEntity> list4 = this.iPeriodService.getPeriodInfoByDate(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        this.logger.info("=========periodEntityVoList7={}", (Object)JSON.toJSONString(list4));
        if (list4 != null && list4.size() > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PeriodEntity periodEntity8 : list4) {
                arrayList.add(periodEntity8.getId());
            }
            for (MallUserEntity mallUserEntity : mallUserEntityList) {
                orgTypeNumEntityList = this.iOrgVoteOperateService.getAcceptGratefulListByPeriodListUser(arrayList, 4, mallUserEntity.getUserId());
                if (orgTypeNumEntityList != null && orgTypeNumEntityList.size() > 0) {
                    for (OrgTypeNumEntity orgTypeNumEntity : orgTypeNumEntityList) {
                        orgTypeNumEntity.setOrgType(OrgTypeNameEnum.thank_from_other.getValue());
                        orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.thank_from_other.getName());
                        orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                        orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                        orgTypeNumEntity.setCreateTime(new Date());
                    }
                } else {
                    OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                    orgTypeNumEntity.setTypeNum(0);
                    orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                    orgTypeNumEntity.setOrgType(OrgTypeNameEnum.thank_from_other.getValue());
                    orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.thank_from_other.getName());
                    orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                    orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                    orgTypeNumEntity.setCreateTime(new Date());
                    orgTypeNumEntityList.add(orgTypeNumEntity);
                }
                OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                orgTypeNumEntity.setOrgType(OrgTypeNameEnum.thank_from_other.getValue());
                int n = this.orgTypeNumMapper.deleteOrgTypeNumInfo(orgTypeNumEntity);
                if (n < 0) continue;
                this.batchInsert(orgTypeNumEntityList);
            }
        }
        List<PeriodEntity> list5 = this.iPeriodService.getPeriodInfoByDate(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        this.logger.info("=========periodEntityVoList8={}", (Object)JSON.toJSONString(list5));
        if (list5 != null && list5.size() > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PeriodEntity periodEntity9 : list5) {
                arrayList.add(periodEntity9.getId());
            }
            for (MallUserEntity mallUserEntity : mallUserEntityList) {
                orgTypeNumEntityList = this.iOrgVoteOperateService.getGratefulListByPeriodListUser(arrayList, 5, mallUserEntity.getUserId());
                this.logger.info("=========orgTypeNumEntityList8={}", (Object)JSON.toJSONString(orgTypeNumEntityList));
                if (orgTypeNumEntityList != null && orgTypeNumEntityList.size() > 0) {
                    for (OrgTypeNumEntity orgTypeNumEntity : orgTypeNumEntityList) {
                        orgTypeNumEntity.setOrgType(OrgTypeNameEnum.thank_to_other.getValue());
                        orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.thank_to_other.getName());
                        orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                        orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                        orgTypeNumEntity.setCreateTime(new Date());
                    }
                } else {
                    OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                    orgTypeNumEntity.setTypeNum(0);
                    orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                    orgTypeNumEntity.setOrgType(OrgTypeNameEnum.thank_to_other.getValue());
                    orgTypeNumEntity.setOrgTypeName(OrgTypeNameEnum.thank_to_other.getName());
                    orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                    orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                    orgTypeNumEntity.setCreateTime(new Date());
                    orgTypeNumEntityList.add(orgTypeNumEntity);
                }
                OrgTypeNumEntity orgTypeNumEntity = new OrgTypeNumEntity();
                orgTypeNumEntity.setJoinQuarter(periodEntity.getHeadPeriod());
                orgTypeNumEntity.setJoinYear(periodEntity.getHeadYear());
                orgTypeNumEntity.setUserId(mallUserEntity.getUserId());
                orgTypeNumEntity.setOrgType(OrgTypeNameEnum.thank_to_other.getValue());
                int n = this.orgTypeNumMapper.deleteOrgTypeNumInfo(orgTypeNumEntity);
                if (n < 0) continue;
                this.batchInsert(orgTypeNumEntityList);
            }
        }
        return orgTypeNumEntityList;
    }
}

