/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.groupon;

import cc.lechun.active.dao.groupon.GrouponConfigMapper;
import cc.lechun.active.dao.groupon.GrouponDetailMapper;
import cc.lechun.active.dao.groupon.GrouponMapper;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.groupon.GrouponConfigEntity;
import cc.lechun.active.entity.groupon.GrouponDetailEntity;
import cc.lechun.active.entity.groupon.GrouponEntity;
import cc.lechun.active.entity.groupon.GrouponRefundOrderVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.groupon.GrouponMessageContext;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class GrouponService
extends ActiveBaseService
implements GrouponInterface {
    @Autowired
    private GrouponMapper grouponMapper;
    @Autowired
    private GrouponDetailMapper grouponDetailMapper;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MallOrderMainInterface mallOrderMainService;
    @Autowired
    private GrouponConfigMapper configMapper;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private GrouponMessageContext grouponMessageContext;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketService;

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponHourByBindCode")
    public Integer getGrouponHourByBindCode(@ParameterValueKeyProvider String bindCode) {
        String activeNo = this.activeQrcodeService.getActiveQrcode(bindCode).getActiveNo();
        GrouponConfigEntity grouponConfigEntity = this.getGrouponConfig(activeNo);
        return grouponConfigEntity == null ? null : Integer.valueOf(grouponConfigEntity.getGrouponHour() + 1);
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponConfig")
    public GrouponConfigEntity getGrouponConfig(@ParameterValueKeyProvider String activeNo) {
        GrouponConfigEntity grouponConfigEntity = new GrouponConfigEntity();
        grouponConfigEntity.setActiveNo(activeNo);
        return (GrouponConfigEntity)this.configMapper.getSingle(grouponConfigEntity);
    }

    @Override
    public Integer saveGrouponConfig(GrouponConfigEntity grouponConfigEntity) {
        this.removeCache(grouponConfigEntity);
        if (grouponConfigEntity.getId() == null) {
            return this.configMapper.insertSelective(grouponConfigEntity);
        }
        return this.configMapper.updateByPrimaryKeySelective(grouponConfigEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponType")
    public Integer getGrouponType(@ParameterValueKeyProvider String bindCode) {
        String activeNo = this.activeQrcodeService.getActiveNoQrcode(bindCode);
        return this.getGrouponConfig(activeNo).getGrouponType();
    }

    @Override
    public List<GrouponRefundOrderVo> getUnRefundApplyOrders(Date date) {
        List<GrouponRefundOrderVo> unknownList;
        List<GrouponRefundOrderVo> joinList;
        ArrayList<GrouponRefundOrderVo> orderList = new ArrayList<GrouponRefundOrderVo>();
        List<GrouponRefundOrderVo> startList = this.starerRefund(date);
        if (startList != null && startList.size() >= 1) {
            orderList.addAll(startList);
        }
        if ((joinList = this.joinRefund(date)) != null && joinList.size() >= 1) {
            orderList.addAll(joinList);
        }
        if ((unknownList = this.unknowRefund(date)) != null && unknownList.size() >= 1) {
            orderList.addAll(unknownList);
        }
        return orderList;
    }

    @Override
    public BaseJsonVo updateGrouponOrderStatus(GrouponRefundOrderVo grouponRefundOrderVo) {
        this.logger.info("\u8d85\u65f6\u8ba2\u5355\u4e3a:{}", (Object)grouponRefundOrderVo.toString());
        if (grouponRefundOrderVo.getGrouponRoleType() != null) {
            if (grouponRefundOrderVo.getGrouponRoleType() == 1) {
                GrouponEntity grouponEntity = new GrouponEntity();
                grouponEntity.setOrderMainNo(grouponRefundOrderVo.getOrderMainNo());
                grouponEntity.setIsPrize(2);
                int k = this.grouponMapper.updateGrouponOrderInfoByOrderNo(grouponEntity);
                this.logger.info("\u8bbe\u7f6e\u5f00\u56e2\u72b6\u6001\u4e3a\u62fc\u56e2\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={},\u8bbe\u7f6e\u72b6\u6001\uff1a{}", (Object)grouponRefundOrderVo.getOrderMainNo(), (Object)(k >= 1 ? 1 : 0));
            } else if (grouponRefundOrderVo.getGrouponRoleType() == 2) {
                GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
                grouponDetailEntity.setOrderMainNo(grouponRefundOrderVo.getOrderMainNo());
                grouponDetailEntity.setStatus(2);
                int k = this.grouponDetailMapper.updateGrouponOrderInfoByOrderNo(grouponDetailEntity);
                this.logger.info("\u8bbe\u7f6e\u62fc\u56e2\u72b6\u6001\u4e3a\u62fc\u56e2\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={},\u8bbe\u7f6e\u72b6\u6001\uff1a{}", (Object)grouponRefundOrderVo.getOrderMainNo(), (Object)(k >= 1 ? 1 : 0));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<String> getUnRefundOrders() {
        List<String> tt;
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setOrderSource(OrderSourceEnum.TEAM_BUY.getValue());
        orderMainEntity.setStatus(OrderStatusEnum.REFUND_APPLY.getValue());
        List<MallOrderMainEntity> list = this.mallOrderMainService.getOrderMainList(orderMainEntity);
        if (list != null && list.size() >= 1 && (tt = list.stream().filter(c -> c.getCreateTime().after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-25))).map(MallOrderMainEntity::getOrderMainNo).collect(Collectors.toList())) != null && tt.size() >= 1) {
            return tt;
        }
        return null;
    }

    private List<GrouponRefundOrderVo> starerRefund(Date date) {
        List<GrouponEntity> list = this.grouponMapper.getUnrefundStartOrder(date);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(g -> g.getIsPrize() == 0).map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setGrouponRoleType(1);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private List<GrouponRefundOrderVo> joinRefund(Date date) {
        List<GrouponDetailEntity> list = this.grouponDetailMapper.getUnrefundJoinOrder(date);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(g -> g.getStatus() == 0).map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setCustomerId(c.getAcceptCustomerId());
                grouponRefundOrderVo.setGrouponRoleType(2);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private List<GrouponRefundOrderVo> unknowRefund(Date date) {
        List<MallOrderMainEntity> list = this.mallOrderMainService.getTeamSaleOrderList(date);
        if (list != null && list.size() >= 1) {
            return list.stream().map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setGrouponRoleType(3);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private void removeCache(GrouponConfigEntity grouponConfigEntity) {
        if (grouponConfigEntity != null) {
            this.memcachedService.delete("GrouponService.getGrouponConfig", grouponConfigEntity.getActiveNo());
            List<ActiveQrcodeEntity> list = this.activeQrcodeService.getQrcodeListByActiveNo(grouponConfigEntity.getActiveNo());
            if (list != null && list.size() >= 1) {
                list.forEach(q -> {
                    this.memcachedService.delete("GrouponService.getGrouponHourByBindCode", q.getBindCode());
                    this.memcachedService.delete("GrouponService.getGrouponConfigByBindCode", q.getBindCode());
                    this.memcachedService.delete("GrouponService.getGrouponType", q.getBindCode());
                });
            }
        }
    }
}

