/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.reserve;

import cc.lechun.active.dao.active.ActiveReserveMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveReserveEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ReserveService
extends ActiveBaseService
implements ReserveInterface {
    @Autowired
    private ActiveReserveMapper reserveMapper;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    private ActiveCashticketInterface activeCashticketServcie;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionInterface mallPromotionInterface;

    @Override
    public BaseJsonVo sendReserveCoupon(String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        ActiveReserveEntity activeReserveEntity = new ActiveReserveEntity();
        activeReserveEntity.setProType("5");
        activeReserveEntity.setProId(bindCode);
        List list = this.reserveMapper.getList(activeReserveEntity);
        if (list == null || list.size() == 0) {
            return BaseJsonVo.error((String)"\u65e0\u9884\u7ea6\u7528\u6237");
        }
        list.forEach(r -> {
            try {
                this.logger.info("\u9884\u7ea6\u7528\u6237:{}", (Object)r.toString());
                this.activeCashticketServcie.sendTicket4BaseAsynchronous(r.getCustomerId(), activeEntity.getBindCode(), "", activeEntity.getPlatformId(), true, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return BaseJsonVo.success((Object)"\u4f18\u60e0\u5238\u53d1\u9001\u4e2d...\u8bf7\u7a0d\u540e");
    }

    @Override
    public PageInfo reserveList(int pageNum, int pageSize, String activeNo, String nickName) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        List<Map<String, Object>> list = this.reserveMapper.getReserveList();
        for (Map<String, Object> map : list) {
            map.put("PRO_NAME", map.get("PRO_ID") != null ? this.getProName(map.get("PRO_ID").toString(), map.get("PRO_TYPE").toString()) : "");
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    private String getProName(String proId, String proType) {
        if (proType.equals("\u6d3b\u52a8")) {
            ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(proId);
            return activeEntity != null ? (StringUtils.isNotEmpty((String)activeEntity.getActiveName()) ? activeEntity.getActiveName() : "\u672a\u77e5") : "";
        }
        if (proType.equals("\u5355\u54c1")) {
            MallProductEntity productEntity = this.productInterface.getProduct(proId);
            return productEntity != null ? (StringUtils.isNotEmpty((String)productEntity.getProName()) ? productEntity.getProName() : "") : "";
        }
        if (proType.equals("\u5957\u88c5")) {
            MallProductGroupEntity productGroupEntity = this.groupInterface.getGroup(proId);
            return productGroupEntity != null ? (StringUtils.isNotEmpty((String)productGroupEntity.getGroupName()) ? productGroupEntity.getGroupName() : "") : "";
        }
        if (proType.equals("\u4fc3\u9500")) {
            MallPromotionEntity promotion = this.mallPromotionInterface.getPromotion(proId);
            return promotion != null ? (StringUtils.isNotEmpty((String)promotion.getPromotionName()) ? promotion.getPromotionName() : "") : "";
        }
        return "\u7c7b\u578b\u9519\u8bef";
    }

    @Override
    public BaseJsonVo sendReserveMessage(String bindCode, String type) {
        List<Map<String, Object>> customers = this.reserveMapper.findUnsend(bindCode);
        HashSet<Map<String, Object>> customersSet = new HashSet<Map<String, Object>>(customers);
        this.logger.info("\u8981\u53d1\u9001\u9884\u7ea6\u63d0\u9192\u4e86 : " + customers.size());
        ExecutorService pool = Executors.newCachedThreadPool();
        customersSet.forEach(customer -> pool.execute(() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("proName", (String)customer.get("PRO_NAME"));
            CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(customer.get("CUSTOMER_ID").toString(), (Integer)customer.get("PLATFORM_ID"));
            map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "");
            String operationId = customerDetailVo.getPlatformId() == 1 ? (type.equals("\u4fc3\u9500") ? "arrival_of_goods_wx" : "\u9884\u7ea6\u63d0\u9192\u6a21\u677f") : (customerDetailVo.getPlatformId() == 4 ? "reserve_notice" : "\u672a\u914d\u7f6e");
            map.put("createTime", customer.get("CREATE_TIME") == null ? DateUtils.date() : DateUtils.formatDate((Date)((Date)customer.get("CREATE_TIME")), (String)"yyyy-MM-dd"));
            BaseJsonVo result = this.messageService.sendWechatMessage((int)customerDetailVo.getPlatformId(), operationId, customerDetailVo.getOpenId(), map);
            this.logger.info("\u63a8\u9001\u9884\u7ea6\u63d0\u9192\uff1a[" + customer.get("CUSTOMER_ID").toString() + "]\u7ed3\u679c \uff1a " + (result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25[" + result.getError_msg() + "]"));
        }));
        pool.shutdown();
        this.reserveMapper.updateSendStatus(bindCode);
        return BaseJsonVo.success((Object)"\u53d1\u9001\u5b8c\u6210");
    }
}

