/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.api;

import cc.lechun.cms.api.CsmsOrderProductAPi;
import cc.lechun.cms.dto.MallProductResInfoDto;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CsmsOrderProductApiImpl
implements CsmsOrderProductAPi {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface mallGroupInterface;

    public BaseJsonVo getProductsAll(String productType) {
        this.logger.info("+++\u8fdb\u5165CsmsOrderProductApiImpl\u67e5\u8be2getProductsAll\u65b9\u6cd5");
        int platFormGroupId = 1000;
        if ("0".equals(productType)) {
            List<MallProductEntity> list = this.productInterface.getOnProductList(platFormGroupId);
            if (list != null) {
                return BaseJsonVo.success(list);
            }
            return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        List<MallProductGroupEntity> list = this.mallGroupInterface.getOnProductGroupList();
        if (list != null) {
            return BaseJsonVo.success(list);
        }
        return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
    }

    public BaseJsonVo<MallProductResInfoDto> getProductInfoById(String proId) {
        MallProductResInfoDto mallProductResInfoDto = this.productInterface.getProductInfoById(proId);
        if (mallProductResInfoDto != null) {
            return BaseJsonVo.success((Object)mallProductResInfoDto);
        }
        return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
    }

    public BaseJsonVo<List<MallProductResInfoDto>> getPromotionInfoById(String promotionId, int groupNum) {
        this.logger.info("==============getPromotionInfoById=====promotionId={},groupNum={}", (Object)promotionId, (Object)groupNum);
        List<MallGroupProductEntity> mallGroupProductEntityList = this.mallGroupInterface.getGroupProducts(promotionId);
        this.logger.info("==============mallGroupProductEntityList={}", (Object)JSON.toJSONString(mallGroupProductEntityList));
        ArrayList<MallProductResInfoDto> mallProductResInfoDtoList = new ArrayList<MallProductResInfoDto>();
        if (mallGroupProductEntityList != null && mallGroupProductEntityList.size() > 0) {
            for (MallGroupProductEntity mallGroupProductEntity : mallGroupProductEntityList) {
                MallProductResInfoDto mallProductResInfoDto = this.productInterface.getProductInfoById(mallGroupProductEntity.getProId());
                this.logger.info("==============mallProductResInfoDto={}", (Object)JSON.toJSONString((Object)mallProductResInfoDto));
                int proNum = mallGroupProductEntity.getProCount() * groupNum;
                this.logger.info("==============proNum={}", (Object)proNum);
                if (mallProductResInfoDto == null) continue;
                mallProductResInfoDto.setProNum(proNum);
                mallProductResInfoDto.setPromotionName(mallGroupProductEntity.getGroupName());
                mallProductResInfoDto.setGroupId(mallGroupProductEntity.getGroupId());
                mallProductResInfoDtoList.add(mallProductResInfoDto);
            }
        }
        return BaseJsonVo.success(mallProductResInfoDtoList);
    }
}

