/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketSendLogMapper;
import cc.lechun.mall.entity.cashticket.CashSendStatusEnum;
import cc.lechun.mall.entity.cashticket.CashticketSendImportVo;
import cc.lechun.mall.entity.cashticket.CashticketSendLogEntity;
import cc.lechun.mall.entity.cashticket.CashticketSendLogVo;
import cc.lechun.mall.entity.cashticket.CashticketSendQueryVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.cashticket.CashticketSendLogInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketSendLogService
extends BaseService
implements CashticketSendLogInterface {
    @Autowired
    private CashticketSendLogMapper cashticketSendLogMapper;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private CustomerInterface customerInterface;

    @Override
    public PageInfo<CashticketSendLogVo> getCashLogList(CashticketSendQueryVo cashticketSendQueryVo) {
        this.logger.info("\u67e5\u8be2\u4f18\u60e0\u5238\u65e5\u5fd7\u8bb0\u5f55:{}", (Object)cashticketSendQueryVo.toString());
        Page page = PageHelper.startPage((int)cashticketSendQueryVo.getCurrentPage(), (int)cashticketSendQueryVo.getPageSize());
        page.setOrderBy("ID desc");
        CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
        if (StringUtils.isNotEmpty((String)cashticketSendQueryVo.getBindCode())) {
            cashticketSendLogEntity.setBindCode(cashticketSendQueryVo.getBindCode());
        }
        if (StringUtils.isNotEmpty((String)cashticketSendQueryVo.getCustomerId())) {
            cashticketSendLogEntity.setCustomerId(cashticketSendQueryVo.getCustomerId());
        }
        if (cashticketSendQueryVo.getStatus() != null) {
            cashticketSendLogEntity.setStatus(cashticketSendQueryVo.getStatus());
        }
        List list = this.cashticketSendLogMapper.getList(cashticketSendLogEntity);
        ArrayList<CashticketSendLogVo> cashLogVoList = new ArrayList<CashticketSendLogVo>();
        for (CashticketSendLogEntity cashLog : list) {
            CashticketSendLogVo cashLogVo = new CashticketSendLogVo();
            BeanUtils.copyProperties((Object)cashLog, (Object)cashLogVo);
            cashLogVo.setActiveName(StringUtils.isNotEmpty((String)cashLog.getBindCode()) ? this.activeInterface.getActiveEntityByQrcode(cashLog.getBindCode()).getActiveName() : "");
            cashLogVo.setSendStatusName(CashSendStatusEnum.getName(cashLog.getStatus()));
            CustomerEntity customerEntity = this.customerInterface.getCustomer(cashLog.getCustomerId());
            cashLogVo.setNickName(customerEntity != null ? customerEntity.getNickName() : "");
            cashLogVo.setHeadImageUrl(customerEntity != null ? customerEntity.getHeadImageUrl() : "");
            cashLogVoList.add(cashLogVo);
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(cashLogVoList);
        return pg;
    }

    @Override
    public boolean importCashSendLog(List<CashticketSendImportVo> list) {
        ArrayList<CashticketSendLogEntity> result = new ArrayList<CashticketSendLogEntity>();
        for (CashticketSendImportVo cashticketSendImportVo : list) {
            CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
            cashticketSendLogEntity.setStatus(0);
            cashticketSendLogEntity.setCustomerId(cashticketSendImportVo.getCustomerId());
            cashticketSendLogEntity.setBindCode(cashticketSendImportVo.getBindCode());
            cashticketSendLogEntity.setMessageStatus(cashticketSendImportVo.getMessageStatus() == 1);
            cashticketSendLogEntity.setCreateTime(DateUtils.now());
            cashticketSendLogEntity.setTicketBatchId("");
            result.add(cashticketSendLogEntity);
        }
        return this.cashticketSendLogMapper.batchInsert(result) >= 1;
    }

    @Override
    public List<CashticketSendLogEntity> getLogList(Date date) {
        Page page = PageHelper.startPage((int)1, (int)3000);
        page.setOrderBy("ID desc");
        CashticketSendLogEntity temp = new CashticketSendLogEntity();
        temp.setStatus(0);
        List list = this.cashticketSendLogMapper.getList(temp);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(t -> t.getCreateTime().after(DateUtils.currentDate()) && StringUtils.isNotEmpty((String)t.getBindCode()) && (StringUtils.isEmpty((String)t.getMessage()) || t.getMessage().indexOf("\u53ef\u7528\u4f18\u60e0\u52b5\u4e0d\u8db3") >= 0 || t.getMessage().indexOf("\u4f18\u60e0\u52b5\u53d1\u653e\u5f02\u5e38") >= 0 || t.getMessage().indexOf("\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25") >= 0)).collect(Collectors.toList());
        }
        return new ArrayList<CashticketSendLogEntity>();
    }

    @Override
    public int deleteLog(int day) {
        int k = this.cashticketSendLogMapper.deleteBeforeDays(day);
        this.logger.info("\u5df2\u6210\u529f\u5220\u9664{}\u5929\u524d\u7684\u65e5\u5fd7\u8bb0\u5f55:{}", (Object)day, (Object)k);
        return k;
    }

    @Override
    public BaseJsonVo setSendLogSuccess(int id) {
        CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
        cashticketSendLogEntity.setStatus(1);
        cashticketSendLogEntity.setId(id);
        return this.cashticketSendLogMapper.updateByPrimaryKeySelective(cashticketSendLogEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }
}

