/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.CollectionUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketUserInfoMapper;
import cc.lechun.mall.entity.cashticket.CashticketUserInfoEntity;
import cc.lechun.mall.entity.cashticket.CashticketUserInfoVo;
import cc.lechun.mall.iservice.cashticket.CashticketUserInfoInterface;
import cc.lechun.mall.service.user.SysUserService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketUserInfoService
extends BaseService
implements CashticketUserInfoInterface {
    @Autowired
    private CashticketUserInfoMapper cashticketUserInfoMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private SysUserService sysUserService;

    @Override
    public CashticketUserInfoEntity getCashticketUserInfo(@ParameterValueKeyProvider String userId) {
        CashticketUserInfoEntity cashticketUserInfoEntity = new CashticketUserInfoEntity();
        cashticketUserInfoEntity.setUserId(userId);
        return (CashticketUserInfoEntity)CollectionUtils.listToEntiy((List)this.cashticketUserInfoMapper.getList(cashticketUserInfoEntity));
    }

    @Override
    public BaseJsonVo saveCashticketUserInfo(CashticketUserInfoEntity cashticketUserInfoEntity) {
        cashticketUserInfoEntity.setCreateTime(DateUtils.now());
        this.cashticketUserInfoMapper.insertSelective(cashticketUserInfoEntity);
        this.removeCache(cashticketUserInfoEntity.getUserId());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateCashticketUserInfo(CashticketUserInfoEntity cashticketUserInfoEntity) {
        this.cashticketUserInfoMapper.updateByPrimaryKeySelective(cashticketUserInfoEntity);
        this.removeCache(cashticketUserInfoEntity.getUserId());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getCashticketUserInfoList(int pageNum, int pageSize, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        CashticketUserInfoEntity cashticketUserInfoEntity = new CashticketUserInfoEntity();
        if (!StringUtil.isEmpty((String)userId)) {
            cashticketUserInfoEntity.setUserId(userId);
        }
        this.cashticketUserInfoMapper.getList(cashticketUserInfoEntity);
        PageInfo pg = page.toPageInfo();
        PageInfo pg2 = new PageInfo();
        pg2.setTotal(page.getTotal());
        ArrayList list = new ArrayList();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(o -> {
                CashticketUserInfoVo cashticketUserInfoVo = new CashticketUserInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)cashticketUserInfoVo);
                cashticketUserInfoVo.setCreateName(this.sysUserService.getMallUserNickName(o.getUserId()));
                list.add(cashticketUserInfoVo);
            });
        }
        pg2.setList(list);
        return pg2;
    }

    private void removeCache(String userId) {
        this.memcachedService.delete("getCashticketUserInfo", userId);
    }
}

